/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

class ImageFilter {
    BufferedImage filteredImage;
    BufferedImage tempImage;

    ImageFilter() {
    }

    void setSourceImage(BufferedImage bufferedImage) {
        if (this.filteredImage == null || this.filteredImage.getWidth(null) != bufferedImage.getWidth(null) || this.filteredImage.getHeight(null) != bufferedImage.getHeight(null)) {
            if (this.filteredImage != null) {
                this.filteredImage.flush();
            }
            this.filteredImage = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 2);
        }
        this.filteredImage.getRaster().setDataElements(0, 0, bufferedImage.getData());
    }

    BufferedImage makeOutputImage(BufferedImage bufferedImage) {
        if (this.tempImage == null || this.tempImage.getWidth(null) != bufferedImage.getWidth(null) || this.tempImage.getHeight(null) != bufferedImage.getHeight(null)) {
            if (this.tempImage != null) {
                this.tempImage.flush();
            }
            this.tempImage = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 2);
        }
        return this.tempImage;
    }

    void applyHueShift(int n) {
        BufferedImage bufferedImage = this.filteredImage;
        BufferedImage bufferedImage2 = this.makeOutputImage(bufferedImage);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = bufferedImage.getRGB(i, j);
                int n5 = n4;
                int n6 = n5 & 0xFF000000;
                if (n6 != 0) {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11 = n5 >> 16 & 0xFF;
                    int n12 = n5 >> 8 & 0xFF;
                    int n13 = n5 & 0xFF;
                    int n14 = n10 = n11 < n12 ? n11 : n12;
                    if (n13 < n10) {
                        n10 = n13;
                    }
                    int n15 = n9 = n11 > n12 ? n11 : n12;
                    if (n13 > n9) {
                        n9 = n13;
                    }
                    if ((n8 = n9 * 1000 / 255) < 150) {
                        n8 = 150;
                    }
                    int n16 = n7 = n9 == 0 ? 0 : (n9 - n10) * 1000 / n9;
                    if (n7 < 150) {
                        n7 = 150;
                    }
                    int n17 = this.rgb2hue(n11, n12, n13, n10, n9) + 180 * n / 100;
                    n4 = n6 | this.hsv2rgb(n17, n7, n8);
                }
                bufferedImage2.setRGB(i, j, n4);
            }
        }
        this.tempImage = this.filteredImage;
        this.filteredImage = bufferedImage2;
    }

    void applyBrightnessShift(int n) {
        BufferedImage bufferedImage = this.filteredImage;
        BufferedImage bufferedImage2 = this.makeOutputImage(bufferedImage);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = bufferedImage.getRGB(i, j);
                int n5 = n4;
                int n6 = n5 & 0xFF000000;
                if (n6 != 0) {
                    int n7;
                    int n8;
                    int n9 = n5 >> 16 & 0xFF;
                    int n10 = n5 >> 8 & 0xFF;
                    int n11 = n5 & 0xFF;
                    int n12 = n8 = n9 < n10 ? n9 : n10;
                    if (n11 < n8) {
                        n8 = n11;
                    }
                    int n13 = n7 = n9 > n10 ? n9 : n10;
                    if (n11 > n7) {
                        n7 = n11;
                    }
                    int n14 = this.rgb2hue(n9, n10, n11, n8, n7);
                    int n15 = n7 == 0 ? 0 : (n7 - n8) * 1000 / n7;
                    int n16 = n7 * 1000 / 255 + 10 * n;
                    if (n16 > 1000) {
                        n16 = 1000;
                    }
                    if (n16 < 0) {
                        n16 = 0;
                    }
                    n4 = n6 | this.hsv2rgb(n14, n15, n16);
                }
                bufferedImage2.setRGB(i, j, n4);
            }
        }
        this.tempImage = this.filteredImage;
        this.filteredImage = bufferedImage2;
    }

    int rgb2hue(int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 - n4;
        if (n6 == 0) {
            return 0;
        }
        if (n == n5) {
            return 60 * (n2 - n3) / n6;
        }
        if (n2 == n5) {
            return 120 + 60 * (n3 - n) / n6;
        }
        return 240 + 60 * (n - n2) / n6;
    }

    int hsv2rgb(int n, int n2, int n3) {
        int n4 = n % 360;
        if (n4 < 0) {
            n4 += 360;
        }
        int n5 = n4 / 60;
        int n6 = n4 % 60;
        int n7 = (1000 - n2) * n3 / 3922;
        int n8 = (1000 - n2 * n6 / 60) * n3 / 3922;
        int n9 = (1000 - n2 * (60 - n6) / 60) * n3 / 3922;
        int n10 = n3 * 1000 / 3922;
        switch (n5) {
            case 0: {
                return n10 << 16 | n9 << 8 | n7;
            }
            case 1: {
                return n8 << 16 | n10 << 8 | n7;
            }
            case 2: {
                return n7 << 16 | n10 << 8 | n9;
            }
            case 3: {
                return n7 << 16 | n8 << 8 | n10;
            }
            case 4: {
                return n9 << 16 | n7 << 8 | n10;
            }
            case 5: {
                return n10 << 16 | n7 << 8 | n8;
            }
        }
        return 0;
    }

    void applyFisheye(double d) {
        BufferedImage bufferedImage = this.filteredImage;
        BufferedImage bufferedImage2 = this.makeOutputImage(bufferedImage);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        double d2 = n / 2;
        double d3 = n2 / 2;
        double d4 = (d + 100.0) / 100.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d5;
                double d6;
                double d7 = ((double)i - d2) / d2;
                double d8 = ((double)j - d3) / d3;
                double d9 = Math.pow(Math.sqrt(d7 * d7 + d8 * d8), d4);
                if (d9 <= 1.0) {
                    double d10 = Math.atan2(d8, d7);
                    d6 = d2 + d9 * Math.cos(d10) * d2;
                    d5 = d3 + d9 * Math.sin(d10) * d3;
                } else {
                    d6 = i;
                    d5 = j;
                }
                bufferedImage2.setRGB(i, j, this.interpolate(bufferedImage, d6, d5));
            }
        }
        this.tempImage = this.filteredImage;
        this.filteredImage = bufferedImage2;
    }

    int interpolate(BufferedImage bufferedImage, double d, double d2) {
        int n;
        int n2 = (int)Math.round(d);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= bufferedImage.getWidth(null)) {
            n2 = bufferedImage.getWidth(null) - 1;
        }
        if ((n = (int)Math.round(d2)) < 0) {
            n = 0;
        }
        if (n >= bufferedImage.getHeight(null)) {
            n = bufferedImage.getHeight(null) - 1;
        }
        return bufferedImage.getRGB(n2, n);
    }

    void applyWhirl(double d) {
        double d2;
        double d3;
        double d4;
        int n;
        double d5;
        BufferedImage bufferedImage = this.filteredImage;
        BufferedImage bufferedImage2 = this.makeOutputImage(bufferedImage);
        double d6 = Math.toRadians(-d);
        int n2 = bufferedImage.getWidth();
        double d7 = n2 / 2;
        if (d7 < (d5 = (double)((n = bufferedImage.getHeight()) / 2))) {
            d4 = d7;
            d3 = d5 / d7;
            d2 = 1.0;
        } else {
            d4 = d5;
            d3 = 1.0;
            d2 = d5 < d7 ? d7 / d5 : 1.0;
        }
        double d8 = d4 * d4;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d9 = d3 * ((double)i - d7);
                double d10 = d2 * ((double)j - d5);
                double d11 = d9 * d9 + d10 * d10;
                if (d11 < d8) {
                    double d12 = 1.0 - Math.sqrt(d11) / d4;
                    double d13 = d6 * (d12 * d12);
                    double d14 = Math.sin(d13);
                    double d15 = Math.cos(d13);
                    double d16 = (d15 * d9 - d14 * d10) / d3 + d7;
                    double d17 = (d14 * d9 + d15 * d10) / d2 + d5;
                    bufferedImage2.setRGB(i, j, bufferedImage.getRGB((int)d16, (int)d17));
                    continue;
                }
                bufferedImage2.setRGB(i, j, bufferedImage.getRGB(i, j));
            }
        }
        this.tempImage = this.filteredImage;
        this.filteredImage = bufferedImage2;
    }

    void applyMosaic(double d) {
        BufferedImage bufferedImage = this.filteredImage;
        int n = (int)(Math.abs(d) + 10.0) / 10;
        if ((n = Math.min(n, Math.min(bufferedImage.getWidth(null), bufferedImage.getHeight(null)) - 1)) <= 1) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0 / (double)n, 1.0 / (double)n);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        int n2 = n * bufferedImage2.getWidth(null);
        int n3 = n * bufferedImage2.getHeight(null);
        BufferedImage bufferedImage3 = new BufferedImage(n2, n3, 2);
        bufferedImage3.getRaster();
        Graphics graphics = bufferedImage3.getGraphics();
        int n4 = bufferedImage2.getWidth(null);
        int n5 = bufferedImage2.getHeight(null);
        for (int i = 0; i < bufferedImage3.getHeight(null); i += n5) {
            for (int j = 0; j < bufferedImage3.getWidth(null); j += n4) {
                graphics.drawImage(bufferedImage2, j, i, null);
            }
        }
        graphics.dispose();
        bufferedImage2.flush();
        if (this.filteredImage != null) {
            this.filteredImage.flush();
        }
        affineTransform = AffineTransform.getScaleInstance((double)bufferedImage.getWidth(null) / (double)bufferedImage3.getWidth(null), (double)bufferedImage.getHeight(null) / (double)bufferedImage3.getHeight(null));
        affineTransformOp = new AffineTransformOp(affineTransform, 1);
        this.filteredImage = affineTransformOp.filter(bufferedImage3, null);
        bufferedImage3.flush();
    }

    void applyPixelate(double d) {
        BufferedImage bufferedImage = this.filteredImage;
        double d2 = (Math.abs(d) + 10.0) / 10.0;
        if ((d2 = Math.min(d2, (double)Math.min(bufferedImage.getWidth(null), bufferedImage.getHeight(null)))) <= 1.0) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0 / d2, 1.0 / d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        affineTransform = AffineTransform.getScaleInstance(d2, d2);
        affineTransformOp = new AffineTransformOp(affineTransform, 1);
        this.filteredImage = affineTransformOp.filter(bufferedImage2, this.filteredImage);
        bufferedImage2.flush();
    }
}

