/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.BoxBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public abstract class AbstractBox
extends Rectangle2D.Double
implements Cloneable {
    private AbstractBox parent;
    private JComponent container;
    private BoxBase boxBase;
    protected boolean border;
    protected Shape shape;
    protected boolean specialShape;
    private boolean visible;
    private boolean temporaryHidden;
    private boolean inactive;
    private boolean inverted;
    private boolean alternative;
    private boolean marked;
    private boolean focused;
    private Component hostedComponent;

    public AbstractBox(AbstractBox abstractBox, JComponent jComponent, BoxBase boxBase) {
        this.parent = abstractBox;
        this.container = jComponent;
        this.shape = this;
        this.specialShape = false;
        this.boxBase = boxBase;
        this.visible = true;
    }

    public Object clone() {
        AbstractBox abstractBox = (AbstractBox)super.clone();
        abstractBox.shape = this.specialShape ? new Area(this.shape) : abstractBox;
        if (this.hostedComponent != null) {
            if (this.hostedComponent instanceof JLabel) {
                JLabel jLabel = (JLabel)this.hostedComponent;
                abstractBox.hostedComponent = new JLabel(jLabel.getText(), jLabel.getIcon(), jLabel.getHorizontalAlignment());
                JComponent jComponent = abstractBox.getContainerResolve();
                if (jComponent != null) {
                    jComponent.add(this.hostedComponent);
                }
            } else {
                abstractBox.hostedComponent = null;
            }
        }
        return abstractBox;
    }

    public void setParent(AbstractBox abstractBox) {
        this.parent = abstractBox;
    }

    public AbstractBox getParent() {
        return this.parent;
    }

    public void end() {
        this.setHostedComponent(null);
    }

    public void finalize() throws Throwable {
        this.end();
        super.finalize();
    }

    public void setContainer(JComponent jComponent) {
        this.container = jComponent;
        if (this.hostedComponent != null) {
            if (this.hostedComponent.getParent() != null) {
                this.hostedComponent.getParent().remove(this.hostedComponent);
            }
            if (this.container != null) {
                this.container.add(this.hostedComponent);
            }
        }
    }

    public JComponent getContainerX() {
        return this.container;
    }

    public JComponent getContainerResolve() {
        AbstractBox abstractBox = this;
        while (abstractBox.container == null && abstractBox.parent != null) {
            abstractBox = abstractBox.parent;
        }
        return abstractBox.container;
    }

    public void setBoxBase(BoxBase boxBase) {
        this.boxBase = boxBase;
        this.repaint();
        this.setHostedComponentColors();
        this.setHostedComponentBorder();
    }

    public BoxBase getBoxBaseResolve() {
        AbstractBox abstractBox = this;
        while (abstractBox.boxBase == null && abstractBox.parent != null) {
            abstractBox = abstractBox.parent;
        }
        return abstractBox.boxBase == null ? BoxBase.DEFAULT_BOX_BASE : abstractBox.boxBase;
    }

    public BoxBase getBoxBaseX() {
        return this.boxBase;
    }

    public void setHostedComponent(Component component) {
        if (this.hostedComponent != null && this.hostedComponent.getParent() != null) {
            this.hostedComponent.getParent().remove(this.hostedComponent);
        }
        this.hostedComponent = component;
        if (this.hostedComponent != null) {
            this.hostedComponent.setVisible(false);
            JComponent jComponent = this.getContainerResolve();
            if (jComponent != null) {
                jComponent.add(component);
            }
            this.setHostedComponentColors();
            this.setHostedComponentBorder();
            this.setHostedComponentBounds();
            this.hostedComponent.setVisible(this.visible);
        }
    }

    public Component getHostedComponent() {
        return this.hostedComponent;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.specialShape = true;
        this.repaint();
        super.setRect(this.shape.getBounds2D());
        this.setHostedComponentBounds();
        this.repaint();
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean contains(Point2D point2D) {
        return this.shape == this ? super.contains(point2D) : this.shape.contains(point2D);
    }

    public boolean update(Graphics2D graphics2D, Rectangle rectangle, ImageObserver imageObserver) {
        if (this.hostedComponent != null) {
            return false;
        }
        if (this.isEmpty() || !this.isVisible() || this.isTemporaryHidden()) {
            return false;
        }
        if (rectangle != null && !this.shape.intersects(rectangle)) {
            return false;
        }
        Area area = new Area(graphics2D.getClip());
        Area area2 = new Area(area);
        area2.intersect(new Area(this.shape));
        graphics2D.setClip(area2);
        BoxBase boxBase = this.getBoxBaseResolve();
        if (!boxBase.transparent) {
            if (boxBase.bgGradient == null || boxBase.bgGradient.hasTransparency()) {
                graphics2D.setColor(this.inactive ? boxBase.inactiveColor : (this.inverted ? boxBase.textColor : boxBase.backColor));
                graphics2D.fill(this.shape);
                graphics2D.setColor(Color.black);
            }
            if (boxBase.bgGradient != null) {
                boxBase.bgGradient.paint(graphics2D, this.shape);
            }
        }
        this.updateContent(graphics2D, rectangle, imageObserver);
        graphics2D.setClip(area);
        this.drawBorder(graphics2D);
        return true;
    }

    public abstract boolean updateContent(Graphics2D var1, Rectangle var2, ImageObserver var3);

    protected void drawBorder(Graphics2D graphics2D) {
        if (this.border || this.marked || this.focused) {
            BoxBase boxBase = this.getBoxBaseResolve();
            graphics2D.setColor(boxBase.borderColor);
            graphics2D.setStroke(this.marked || this.focused ? boxBase.getMarker() : boxBase.getBorder());
            if (this.marked || this.focused) {
                graphics2D.setXORMode(Color.white);
            }
            graphics2D.draw(this.shape);
            if (this.marked || this.focused) {
                graphics2D.setPaintMode();
            }
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(BoxBase.DEFAULT_STROKE);
        }
    }

    public Rectangle getBorderBounds() {
        if (!(this.border || this.marked || this.focused)) {
            return this.getBounds();
        }
        BoxBase boxBase = this.getBoxBaseResolve();
        Stroke stroke = this.marked || this.focused ? boxBase.getMarker() : boxBase.getBorder();
        return stroke.createStrokedShape(this.shape).getBounds();
    }

    public boolean hasBorder() {
        return this.border;
    }

    public void setBorder(boolean bl) {
        if (!bl) {
            this.repaint();
        }
        this.border = bl;
        this.setHostedComponentBorder();
        if (bl) {
            this.repaint();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        if (this.hostedComponent != null) {
            this.hostedComponent.setVisible(bl);
        }
        this.repaint();
    }

    public boolean isTemporaryHidden() {
        return this.temporaryHidden;
    }

    public void setTemporaryHidden(boolean bl) {
        this.temporaryHidden = bl;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean bl) {
        this.inactive = bl;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        this.repaint();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        this.inverted = bl;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        this.repaint();
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean bl) {
        if (!bl) {
            this.repaint();
        }
        this.marked = bl;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        if (bl) {
            this.repaint();
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        if (!bl) {
            this.repaint();
        }
        this.focused = bl;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        if (bl) {
            this.repaint();
        }
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public void setAlternative(boolean bl) {
        this.alternative = bl;
        this.checkHostedComponent();
        this.setHostedComponentColors();
        this.repaint();
    }

    private void setHostedComponentColors() {
        if (this.hostedComponent != null) {
            BoxBase boxBase = this.getBoxBaseResolve();
            this.hostedComponent.setFont(boxBase.getFont());
            this.hostedComponent.setBackground(this.inactive ? boxBase.inactiveColor : (this.inverted ? boxBase.textColor : boxBase.backColor));
            this.hostedComponent.setForeground(this.inverted ? boxBase.backColor : (this.alternative ? boxBase.alternativeColor : boxBase.textColor));
            if (this.hostedComponent instanceof JComponent) {
                ((JComponent)this.hostedComponent).setOpaque(true);
                if (this.hostedComponent instanceof JTextComponent) {
                    ((JTextComponent)this.hostedComponent).setCaretColor(boxBase.textColor);
                }
            }
        }
    }

    private void setHostedComponentBorder() {
        if (this.hostedComponent != null && this.hostedComponent instanceof JComponent) {
            ((JComponent)this.hostedComponent).setBorder(this.border ? BorderFactory.createLineBorder(this.getBoxBaseResolve().borderColor, 1) : BorderFactory.createEmptyBorder());
        }
    }

    private void setHostedComponentBounds() {
        if (this.hostedComponent != null) {
            Rectangle rectangle = this.getBounds();
            this.hostedComponent.setBounds(rectangle);
            if (this.hostedComponent instanceof JComponent) {
                ((JComponent)this.hostedComponent).setPreferredSize(rectangle.getSize());
            }
        }
    }

    public void repaint() {
        JComponent jComponent = this.getContainerResolve();
        if (jComponent != null) {
            jComponent.repaint(this.getBorderBounds());
        }
        if (this.hostedComponent != null) {
            this.hostedComponent.repaint();
        }
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.equals(this)) {
            return;
        }
        if (this.specialShape) {
            AffineTransform affineTransform = null;
            if (this.getWidth() != rectangle2D.getWidth() || this.getHeight() != rectangle2D.getHeight()) {
                affineTransform = AffineTransform.getTranslateInstance(-this.getX(), -this.getY());
                this.shape = affineTransform.createTransformedShape(this.shape);
                affineTransform = AffineTransform.getScaleInstance(rectangle2D.getWidth() / this.getWidth(), rectangle2D.getHeight() / this.getHeight());
                this.shape = affineTransform.createTransformedShape(this.shape);
                affineTransform = AffineTransform.getTranslateInstance(this.getX(), this.getY());
                this.shape = affineTransform.createTransformedShape(this.shape);
            }
            if (this.getX() != rectangle2D.getX() || this.getY() != rectangle2D.getY()) {
                affineTransform = AffineTransform.getTranslateInstance(rectangle2D.getX() - this.getX(), rectangle2D.getY() - this.getY());
                this.shape = affineTransform.createTransformedShape(this.shape);
            }
            if (affineTransform != null) {
                this.setShape(this.shape);
            }
        } else {
            this.repaint();
            this.setRect(rectangle2D);
            this.repaint();
        }
        this.setHostedComponentBounds();
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.setBounds(new Rectangle2D.Double(d, d2, d3, d4));
        this.setHostedComponentBounds();
    }

    public void setLocation(Point2D point2D) {
        this.setBounds(point2D.getX(), point2D.getY(), this.width, this.height);
    }

    public void setLocation(double d, double d2) {
        this.setBounds(d, d2, this.width, this.height);
    }

    public void translate(double d, double d2) {
        this.setBounds(this.x + d, this.y + d2, this.width, this.height);
    }

    public void setSize(Dimension2D dimension2D) {
        this.setBounds(this.x, this.y, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setSize(double d, double d2) {
        this.setBounds(this.x, this.y, d, d2);
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.x, this.y);
    }

    protected void checkHostedComponent() {
    }

    public Point2D getAbsoluteLocation() {
        Point point = null;
        JComponent jComponent = this.getContainerResolve();
        if (jComponent != null) {
            point = new Point(jComponent.getLocationOnScreen());
            ((Point2D)point).setLocation(((Point2D)point).getX() + this.getX(), ((Point2D)point).getY() + this.getY());
        }
        return point;
    }

    public Point2D getAbsoulteMiddleLocation() {
        Point2D point2D = this.getAbsoluteLocation();
        if (point2D != null) {
            point2D.setLocation(point2D.getX() + this.getWidth() / 2.0, point2D.getY() + this.getHeight() / 2.0);
        }
        return point2D;
    }
}

