/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextTarget;
import java.awt.Rectangle;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TargetMarker {
    public int begOffset = 0;
    public int endOffset = 0;
    public Position begPos = null;
    public Position endPos = null;
    public TextTarget target = null;
    public TextActivityDocument doc;
    public boolean hasFocus;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("h: ").append(this.hashCode());
        stringBuffer.append(" [").append(this.begOffset).append("-").append(this.endOffset).append("]");
        stringBuffer.append(" target: ").append(this.target);
        return stringBuffer.substring(0);
    }

    public TargetMarker(TextActivityDocument textActivityDocument) {
        this.doc = textActivityDocument;
        this.hasFocus = false;
    }

    public void reset() {
        this.hasFocus = false;
        if (this.target != null) {
            this.target.reset();
        }
    }

    public void setPositions() {
        try {
            this.begPos = this.doc.createPosition(this.begOffset);
            this.endPos = this.doc.createPosition(this.endOffset);
        }
        catch (Exception exception) {
            System.err.println("Target marker error:\n" + exception);
        }
    }

    public void requestFocus(TextActivityBase.Panel panel) {
        this.hasFocus = true;
        if (this.target != null) {
            this.target.requestFocus(panel, this);
        }
    }

    public void lostFocus(TextActivityBase.Panel panel) {
        this.hasFocus = false;
        if (this.target != null) {
            this.target.lostFocus(panel, this);
        }
    }

    public void updateOffsets() {
        if (this.begPos != null) {
            this.begOffset = this.begPos.getOffset();
        }
        if (this.endPos != null) {
            this.endOffset = this.endPos.getOffset();
        }
    }

    public Rectangle getBegRect(JTextComponent jTextComponent) {
        if (this.begPos != null) {
            this.begOffset = this.begPos.getOffset();
            try {
                return jTextComponent.modelToView(this.begOffset);
            }
            catch (Exception exception) {
                System.err.println("Error calling modelToView:\n" + exception);
            }
        }
        return null;
    }

    public String getCurrentText() {
        String string = null;
        if (this.target != null && this.target.comboList != null) {
            string = (String)this.target.comboList.getSelectedItem();
        } else {
            try {
                string = this.doc.getText(this.begPos.getOffset(), this.endPos.getOffset() - this.begPos.getOffset());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string == null ? new String() : string;
    }

    public String getCurrentText(String string) {
        if (string == null || this.target != null && this.target.comboList != null) {
            return this.getCurrentText();
        }
        this.updateOffsets();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.begOffset; i < this.endOffset; ++i) {
            if (this.doc.checkBooleanAttribute(i, string)) continue;
            try {
                stringBuffer.append(this.doc.getText(i, 1));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error getting text answer:\n" + exception);
                break;
            }
        }
        return stringBuffer.substring(0);
    }

    public boolean checkText(Evaluator evaluator) {
        if (this.target == null) {
            return false;
        }
        return this.target.checkText(this.getCurrentText(), evaluator);
    }

    public boolean contains(int n, boolean bl) {
        this.updateOffsets();
        return n >= this.begOffset && (bl ? n <= this.endOffset : n < this.endOffset);
    }

    public int getLength() {
        return this.endOffset - this.begOffset;
    }

    public int getParagraphBegOffset() {
        this.updateOffsets();
        return this.doc.getParagraphElement(this.begOffset).getStartOffset();
    }
}

