/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.puzzles;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jdom.Element;

public class DoublePuzzle
extends Activity
implements ActiveBagContentKit.Compatible {
    public DoublePuzzle(JClicProject jClicProject) {
        super(jClicProject);
        this.abc = new ActiveBagContent[1];
        this.boxGridPos = 0;
        this.dragCells = true;
    }

    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    public Element getJDomElement() {
        Element element = null;
        if (this.abc[0] == null) {
            return null;
        }
        Element element2 = super.getJDomElement();
        element2.addContent(this.abc[0].getJDomElement());
        element = new Element("scramble");
        element.setAttribute("times", Integer.toString(this.shuffles));
        element2.addContent(element);
        element = new Element("layout");
        element.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        element2.addContent(element);
        return element2;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        Element element2 = element.getChild("cells");
        if (element2 != null) {
            this.abc[0] = ActiveBagContent.getActiveBagContent(element2, this.project.mediaBag);
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Puzzle without data!");
        }
        element2 = element.getChild("scramble");
        if (element2 != null) {
            this.shuffles = JDomUtility.getIntAttr(element2, "times", this.shuffles);
        }
        if ((element2 = element.getChild("layout")) != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(element2, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.abc[0] = clic3Activity.createActiveBagContent(0);
        this.boxGridPos = clic3Activity.graPos;
        this.abc[0].setBoxBase(clic3Activity.getBoxBase(0));
        this.dragCells = true;
    }

    public int getMinNumActions() {
        if (this.abc[0] == null) {
            return 0;
        }
        return this.abc[0].getNumCells();
    }

    public boolean hasRandom() {
        return true;
    }

    public boolean shuffleAlways() {
        return true;
    }

    public boolean helpSolutionAllowed() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxBag bgA;
        ActiveBoxBag bgB;

        protected Panel(PlayStation playStation) {
            super(playStation);
            this.bc = new BoxConnector(this);
        }

        public void clear() {
            if (this.bgA != null) {
                this.bgA.end();
                this.bgA = null;
            }
            if (this.bgB != null) {
                this.bgB.end();
                this.bgB = null;
            }
        }

        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (DoublePuzzle.this.abc[0] != null) {
                if (DoublePuzzle.this.acp != null) {
                    DoublePuzzle.this.acp.generateContent(new ActiveBagContentKit(DoublePuzzle.this.abc[0].nch, DoublePuzzle.this.abc[0].ncw, DoublePuzzle.this.abc, false), this.ps);
                }
                this.bgA = ActiveBoxGrid.createEmptyGrid(null, this, DoublePuzzle.this.margin, DoublePuzzle.this.margin, DoublePuzzle.this.abc[0]);
                this.bgB = ActiveBoxGrid.createEmptyGrid(null, this, DoublePuzzle.this.margin, DoublePuzzle.this.margin, DoublePuzzle.this.abc[0]);
                this.bgA.setContent(DoublePuzzle.this.abc[0]);
                this.bgA.setVisible(true);
                this.bgB.setVisible(true);
                ActiveBox activeBox = this.bgA.getBackgroundActiveBox();
                ActiveBox activeBox2 = this.bgB.getBackgroundActiveBox();
                if (activeBox != null && activeBox2 != null) {
                    activeBox2.exchangeContent(activeBox);
                }
                this.invalidate();
            }
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.bgA != null && this.bgB != null) {
                this.shuffle(new ActiveBoxBag[]{this.bgA}, true, true);
                if (DoublePuzzle.this.useOrder) {
                    this.currentItem = this.bgA.getNextItem(-1);
                }
                this.playing = true;
            }
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
            if (this.bgA != null) {
                this.bgA.update(graphics2D, rectangle, this);
            }
            if (this.bgB != null) {
                this.bgB.update(graphics2D, rectangle, this);
            }
            if (this.bc.active) {
                this.bc.update(graphics2D, rectangle, this);
            }
        }

        public Dimension setDimension(Dimension dimension) {
            if (this.bgA == null || this.bgB == null || this.getSize().equals(dimension)) {
                return dimension;
            }
            return BoxBag.layoutDouble(dimension, this.bgA, this.bgB, DoublePuzzle.this.boxGridPos, DoublePuzzle.this.margin);
        }

        public void processMouse(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            boolean bl = false;
            if (this.playing) {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            ActiveBox activeBox = DoublePuzzle.this.dragCells ? this.bc.getBox() : this.bgA.findActiveBox(this.bc.origin);
                            this.bc.end();
                            ActiveBox activeBox2 = this.bgB.findActiveBox(point);
                            if (activeBox != null && activeBox2 != null && activeBox2.isInactive()) {
                                boolean bl2 = false;
                                String string = activeBox.getDescription() + " (" + activeBox.idOrder + ")";
                                String string2 = "(" + activeBox2.idOrder + ")";
                                if (activeBox.getContent().isEquivalent(DoublePuzzle.this.abc[0].getActiveBoxContent(activeBox2.idOrder), true)) {
                                    bl2 = true;
                                    activeBox.exchangeContent(activeBox2);
                                    activeBox.setVisible(false);
                                    if (DoublePuzzle.this.useOrder) {
                                        this.currentItem = this.bgA.getNextItem(this.currentItem);
                                    }
                                }
                                int n = this.bgA.countInactiveCells();
                                this.ps.reportNewAction(DoublePuzzle.this, "PLACE", string, string2, bl2, n);
                                if (bl2 && n == this.bgA.getNumCells()) {
                                    this.finishActivity(true);
                                } else {
                                    this.playEvent(bl2 ? 3 : 2);
                                }
                            }
                            this.repaint();
                            break;
                        }
                        ActiveBox activeBox = this.bgA.findActiveBox(point);
                        if (activeBox == null || activeBox.isInactive() || DoublePuzzle.this.useOrder && activeBox.idOrder != this.currentItem) break;
                        if (DoublePuzzle.this.dragCells) {
                            this.bc.begin(point, activeBox);
                        } else {
                            this.bc.begin(point);
                        }
                        bl = activeBox.playMedia(this.ps);
                        if (bl) break;
                        this.playEvent(1);
                        break;
                    }
                    case 503: 
                    case 506: {
                        this.bc.moveTo(point);
                    }
                }
            }
        }

        public void showHelp() {
            if (!DoublePuzzle.this.helpWindowAllowed() || this.bgA == null) {
                return;
            }
            HelpActivityComponent helpActivityComponent = null;
            if (DoublePuzzle.this.showSolution) {
                helpActivityComponent = new HelpActivityComponent(this){
                    ActiveBoxBag abb;
                    {
                        this.abb = null;
                    }

                    public void render(Graphics2D graphics2D, Rectangle rectangle) {
                        if (this.abb != null) {
                            this.abb.update(graphics2D, rectangle, this);
                        }
                    }

                    public void init() {
                        this.abb = ActiveBoxGrid.createEmptyGrid(null, this, 8.0, 8.0, ((Panel)Panel.this).DoublePuzzle.this.abc[0]);
                        this.abb.setContent(((Panel)Panel.this).DoublePuzzle.this.abc[0]);
                        this.abb.setVisible(true);
                        Dimension dimension = Panel.this.bgA.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, dimension.width, dimension.height);
                        dimension.width += 16;
                        dimension.height += 16;
                        this.setPreferredSize(dimension);
                        this.setMaximumSize(dimension);
                        this.setMinimumSize(dimension);
                        Point point = (Point)this.getClientProperty("prefLoc");
                        if (point != null) {
                            point.translate((int)Panel.this.bgA.x - 8, (int)Panel.this.bgA.y - 8);
                        }
                    }

                    public void processMouse(MouseEvent mouseEvent) {
                        boolean bl = false;
                        if (this.abb != null) {
                            switch (mouseEvent.getID()) {
                                case 501: {
                                    ActiveBox activeBox = this.abb.findActiveBox(mouseEvent.getPoint());
                                    if (activeBox == null) break;
                                    bl = activeBox.playMedia(Panel.this.ps);
                                    this.markBox(Panel.this.bgB.getActiveBox(activeBox.idLoc), false);
                                    if (bl) break;
                                    Panel.this.playEvent(1);
                                    break;
                                }
                                case 502: {
                                    this.unmarkBox();
                                }
                            }
                        }
                    }
                };
                helpActivityComponent.init();
            }
            if (this.ps.showHelp(helpActivityComponent, DoublePuzzle.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bgA.countInactiveCells());
            }
            if (helpActivityComponent != null) {
                helpActivityComponent.end();
            }
        }
    }
}

