/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import javax.swing.ImageIcon;
import org.jdom.Element;

public class MenuElement
implements Editable,
Cloneable,
Domable {
    public String caption;
    public String icon = "@ico00.png";
    public String projectPath;
    public String sequence;
    public String description;
    public static final String ELEMENT_NAME = "menuElement";
    public static final String CAPTION = "caption";
    public static final String ICON = "icon";
    public static final String PATH = "path";
    public static final String SEQUENCE = "sequence";
    public static final String DESCRIPTION = "description";
    public static final String RETURN_TAG = "@RETURN";
    public static final String DEFAULT_ICON = "@ico00.png";
    public static final String DEFAULT_FOLDER_ICON = "@icofolder.png";
    public static final int MAX_ICON_WIDTH = 32;
    public static final int MAX_ICON_HEIGHT = 32;

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        if (this.caption != null) {
            element.setAttribute(CAPTION, this.caption);
        }
        if (this.icon != null && !this.icon.equals(DEFAULT_ICON)) {
            element.setAttribute(ICON, this.icon);
        }
        if (this.projectPath != null) {
            element.setAttribute(PATH, this.projectPath);
        }
        if (this.sequence != null) {
            element.setAttribute(SEQUENCE, this.sequence);
        }
        if (this.description != null) {
            element.setAttribute(DESCRIPTION, this.description);
        }
        return element;
    }

    public ImageIcon getIcon(MediaBag mediaBag) {
        ImageIcon imageIcon = null;
        if (this.icon.startsWith("@")) {
            String string = this.icon.substring(1);
            if (string.endsWith(".gif") && string.startsWith("ico")) {
                string = string.substring(0, string.length() - 4) + ".png";
            }
            imageIcon = ResourceManager.getImageIcon("icons/" + string);
        } else {
            try {
                imageIcon = new ImageIcon(mediaBag.getImageElement(this.icon).getImage());
                if (imageIcon != null) {
                    imageIcon.setDescription(this.icon);
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading image " + this.icon + "\n" + exception);
            }
        }
        if (imageIcon == null) {
            imageIcon = ResourceManager.getImageIcon("icons/ico00.png");
        }
        return imageIcon;
    }

    public static MenuElement getMenuElement(Element element) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        MenuElement menuElement = new MenuElement();
        menuElement.setProperties(element, null);
        return menuElement;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.caption = JDomUtility.getStringAttr(element, CAPTION, this.caption, false);
        this.sequence = JDomUtility.getStringAttr(element, SEQUENCE, this.sequence, false);
        this.description = JDomUtility.getStringAttr(element, DESCRIPTION, this.description, false);
        this.projectPath = FileSystem.stdFn(JDomUtility.getStringAttr(element, PATH, this.projectPath, false));
        this.icon = this.projectPath == null ? DEFAULT_FOLDER_ICON : DEFAULT_ICON;
        this.icon = FileSystem.stdFn(JDomUtility.getStringAttr(element, ICON, this.icon, false));
    }

    public Editor getEditor(Editor editor) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, editor);
    }
}

