/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GlueSettingsParser {
    private final Map a;
    private final Map b;
    private Glue[] a;
    private final Map c;
    private Element a = new HashMap();

    public GlueSettingsParser() {
        this.b = new HashMap();
        this.c = new HashMap();
        try {
            this.setTypeMappings();
            this.setStyleMappings();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            this.a = documentBuilderFactory.newDocumentBuilder().parse(GlueSettingsParser.class.getResourceAsStream("GlueSettings.xml")).getDocumentElement();
            this.parseGlueTypes();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException("GlueSettings.xml", exception);
        }
    }

    private void setStyleMappings() {
        this.c.put("display", 0);
        this.c.put("text", 1);
        this.c.put("script", 2);
        this.c.put("script_script", 3);
    }

    private void parseGlueTypes() {
        Object object;
        ArrayList<Glue> arrayList = new ArrayList<Glue>();
        Element element = (Element)this.a.getElementsByTagName("GlueTypes").item(0);
        int n = -1;
        int n2 = 0;
        if (element != null) {
            object = element.getElementsByTagName("GlueType");
            for (int i = 0; i < object.getLength(); ++i) {
                Element element2 = (Element)object.item(i);
                String string = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", element2);
                Glue glue = this.createGlue(element2, string);
                if (string.equalsIgnoreCase("default")) {
                    n = n2;
                }
                arrayList.add(glue);
                ++n2;
            }
        }
        if (n < 0) {
            n = n2;
            arrayList.add(new Glue(0.0f, 0.0f, 0.0f, "default"));
        }
        this.a = arrayList.toArray(new Glue[arrayList.size()]);
        if (n > 0) {
            object = this.a[n];
            this.a[n] = this.a[0];
            this.a[0] = object;
        }
        for (int i = 0; i < this.a.length; ++i) {
            this.b.put(this.a[i].getName(), i);
        }
    }

    private Glue createGlue(Element element, String string) {
        String[] stringArray = new String[]{"space", "stretch", "shrink"};
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            double d = 0.0;
            String string2 = null;
            try {
                string2 = element.getAttribute(stringArray[i]);
                if (!string2.equals("")) {
                    d = Double.parseDouble(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException("GlueSettings.xml", "GlueType", stringArray[i], "has an invalid real value '" + string2 + "'!");
            }
            fArray[i] = (float)d;
        }
        return new Glue(fArray[0], fArray[1], fArray[2], string);
    }

    private void setTypeMappings() {
        this.a.put("ord", 0);
        this.a.put("op", 1);
        this.a.put("bin", 2);
        this.a.put("rel", 3);
        this.a.put("open", 4);
        this.a.put("close", 5);
        this.a.put("punct", 6);
        this.a.put("inner", 7);
    }

    public Glue[] getGlueTypes() {
        return this.a;
    }

    public int[][][] createGlueTable() {
        int n = this.a.size();
        int[][][] nArray = new int[n][n][this.c.size()];
        Element element = (Element)this.a.getElementsByTagName("GlueTable").item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName("Glue");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = GlueSettingsParser.getAttrValueAndCheckIfNotNull("lefttype", element2);
                String string2 = GlueSettingsParser.getAttrValueAndCheckIfNotNull("righttype", element2);
                String string3 = GlueSettingsParser.getAttrValueAndCheckIfNotNull("gluetype", element2);
                NodeList nodeList2 = element2.getElementsByTagName("Style");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string4 = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", element3);
                    Object v = this.a.get(string);
                    Object v2 = this.a.get(string2);
                    Object v3 = this.c.get(string4);
                    Object v4 = this.b.get(string3);
                    GlueSettingsParser.checkMapping(v, "Glue", "lefttype", string);
                    GlueSettingsParser.checkMapping(v2, "Glue", "righttype", string2);
                    GlueSettingsParser.checkMapping(v4, "Glue", "gluetype", string3);
                    GlueSettingsParser.checkMapping(v3, "Style", "name", string4);
                    nArray[((Integer)v).intValue()][((Integer)v2).intValue()][((Integer)v3).intValue()] = (Integer)v4;
                }
            }
        }
        return nArray;
    }

    private static void checkMapping(Object object, String string, String string2, String string3) {
        if (object == null) {
            throw new XMLResourceParseException("GlueSettings.xml", string, string2, "has an unknown value '" + string3 + "'!");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException("GlueSettings.xml", element.getTagName(), string, null);
        }
        return string2;
    }
}

