/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import org.jdom.Attribute;
import org.jdom.DefaultJDOMFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: DOMBuilder.java,v $ $Revision: 1.59 $ $Date: 2004/09/03 06:03:41 $ $Name: jdom_1_0 $";
    private String adapterClass;
    private JDOMFactory factory = new DefaultJDOMFactory();

    public DOMBuilder() {
    }

    public DOMBuilder(String string) {
        this.adapterClass = string;
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public Document build(org.w3c.dom.Document document) {
        Document document2 = this.factory.document(null);
        this.buildTree(document, document2, null, true);
        return document2;
    }

    public Element build(org.w3c.dom.Element element) {
        Document document = this.factory.document(null);
        this.buildTree(element, document, null, true);
        return document.getRootElement();
    }

    private void buildTree(Node node, Document document, Element element, boolean bl) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    this.buildTree(nodeList.item(i), document, element, true);
                }
                break;
            }
            case 1: {
                Object object;
                String string;
                Object object2;
                String string2;
                Attr attr;
                int n;
                String string3 = node.getNodeName();
                String string4 = "";
                String string5 = string3;
                int n2 = string3.indexOf(58);
                if (n2 >= 0) {
                    string4 = string3.substring(0, n2);
                    string5 = string3.substring(n2 + 1);
                }
                Namespace namespace = null;
                String string6 = node.getNamespaceURI();
                namespace = string6 == null ? (element == null ? Namespace.NO_NAMESPACE : element.getNamespace(string4)) : Namespace.getNamespace(string4, string6);
                Element element2 = this.factory.element(string5, namespace);
                if (bl) {
                    document.setRootElement(element2);
                } else {
                    this.factory.addContent(element, element2);
                }
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n3 = namedNodeMap.getLength();
                for (n = 0; n < n3; ++n) {
                    attr = (Attr)namedNodeMap.item(n);
                    string2 = attr.getName();
                    if (!string2.startsWith("xmlns")) continue;
                    object2 = "";
                    n2 = string2.indexOf(58);
                    if (n2 >= 0) {
                        object2 = string2.substring(n2 + 1);
                    }
                    string = attr.getValue();
                    object = Namespace.getNamespace((String)object2, string);
                    if (string4.equals(object2)) {
                        element2.setNamespace((Namespace)object);
                        continue;
                    }
                    this.factory.addNamespaceDeclaration(element2, (Namespace)object);
                }
                for (n = 0; n < n3; ++n) {
                    attr = (Attr)namedNodeMap.item(n);
                    string2 = attr.getName();
                    if (string2.startsWith("xmlns")) continue;
                    object2 = "";
                    string = string2;
                    n2 = string2.indexOf(58);
                    if (n2 >= 0) {
                        object2 = string2.substring(0, n2);
                        string = string2.substring(n2 + 1);
                    }
                    object = attr.getValue();
                    Namespace namespace2 = null;
                    namespace2 = "".equals(object2) ? Namespace.NO_NAMESPACE : element2.getNamespace((String)object2);
                    Attribute attribute = this.factory.attribute(string, (String)object, namespace2);
                    this.factory.setAttribute(element2, attribute);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    object2 = nodeList.item(i);
                    if (object2 == null) continue;
                    this.buildTree((Node)object2, document, element2, false);
                }
                break;
            }
            case 3: {
                String string = node.getNodeValue();
                this.factory.addContent(element, this.factory.text(string));
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                this.factory.addContent(element, this.factory.cdata(string));
                break;
            }
            case 7: {
                if (bl) {
                    this.factory.addContent(document, this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                    break;
                }
                this.factory.addContent(element, this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                if (bl) {
                    this.factory.addContent(document, this.factory.comment(node.getNodeValue()));
                    break;
                }
                this.factory.addContent(element, this.factory.comment(node.getNodeValue()));
                break;
            }
            case 5: {
                EntityRef entityRef = this.factory.entityRef(node.getNodeName());
                this.factory.addContent(element, entityRef);
                break;
            }
            case 6: {
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                String string = documentType.getPublicId();
                String string7 = documentType.getSystemId();
                String string8 = documentType.getInternalSubset();
                DocType docType = this.factory.docType(documentType.getName());
                docType.setPublicID(string);
                docType.setSystemID(string7);
                docType.setInternalSubset(string8);
                this.factory.addContent(document, docType);
            }
        }
    }
}

