/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.misc.Gradient;
import edu.xtec.util.Domable;
import edu.xtec.util.FontCheck;
import edu.xtec.util.JDomUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import org.jdom.Element;

public class BoxBase
implements Cloneable,
Domable {
    private Font originalFont;
    public Color backColor;
    public Gradient bgGradient;
    public Color textColor;
    public Color shadowColor;
    public Color borderColor;
    public Color inactiveColor;
    public Color alternativeColor;
    public boolean shadow;
    public boolean transparent;
    public int textMargin;
    protected BasicStroke borderStroke;
    protected BasicStroke markerStroke;
    private Font font;
    private float dynFontSize;
    private static final float REDUCE_FONT_STEP = 1.0f;
    public static final float MIN_FONT_SIZE = 8.0f;
    private static int resetAllFontsCounter = 0;
    public static boolean flagFontReduced = false;
    private int resetFontCounter;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Color DEFAULT_BACK_COLOR = Color.lightGray;
    public static final Color DEFAULT_TEXT_COLOR = Color.black;
    public static final Color DEFAULT_SHADOW_COLOR = Color.gray;
    public static final Color DEFAULT_INACTIVE_COLOR = Color.gray;
    public static final Color DEFAULT_ALTERNATIVE_COLOR = Color.gray;
    public static final Color DEFAULT_BORDER_COLOR = Color.black;
    public static final float DEFAULT_BORDER_STROKE_WIDTH = 0.75f;
    public static final BasicStroke DEFAULT_BORDER_STROKE = new BasicStroke(0.75f);
    public static final float DEFAULT_MARKER_STROKE_WIDTH = 2.75f;
    public static final BasicStroke DEFAULT_MARKER_STROKE = new BasicStroke(2.75f);
    private static Font DEFAULT_FONT = null;
    public static BoxBase DEFAULT_BOX_BASE = new BoxBase();
    public static final String ELEMENT_NAME = "style";
    public static final String COLOR = "color";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String SHADOW = "shadow";
    public static final String INACTIVE = "inactive";
    public static final String ALTERNATIVE = "alternative";
    public static final String BORDER = "border";
    public static final String TRANSPARENT = "transparent";
    public static final String MARGIN = "margin";
    public static final String BORDER_STROKE = "borderStroke";
    public static final String MARKER_STROKE = "markerStroke";

    public BoxBase() {
        this.setFont(BoxBase.getDefaultFont());
        this.dynFontSize = this.font.getSize2D();
        this.backColor = DEFAULT_BACK_COLOR;
        this.bgGradient = null;
        this.textColor = DEFAULT_TEXT_COLOR;
        this.shadowColor = DEFAULT_SHADOW_COLOR;
        this.inactiveColor = DEFAULT_INACTIVE_COLOR;
        this.alternativeColor = DEFAULT_ALTERNATIVE_COLOR;
        this.borderColor = DEFAULT_BORDER_COLOR;
        this.shadow = false;
        this.transparent = false;
        this.textMargin = 6;
        this.resetFontCounter = resetAllFontsCounter;
        this.borderStroke = DEFAULT_BORDER_STROKE;
        this.markerStroke = DEFAULT_MARKER_STROKE;
    }

    public Object clone() {
        BoxBase boxBase = null;
        try {
            boxBase = (BoxBase)super.clone();
            if (this.bgGradient != null) {
                boxBase.bgGradient = (Gradient)this.bgGradient.clone();
            }
            boxBase.setFont(this.originalFont);
        }
        catch (Exception exception) {
            System.err.println("Unexpected error cloning BoxBase!");
        }
        return boxBase;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        boolean bl2 = bl = object == this;
        if (!bl && object instanceof BoxBase) {
            BoxBase boxBase = (BoxBase)object;
            bl = this.originalFont.equals(boxBase.originalFont) && this.backColor.equals(boxBase.backColor) && (this.bgGradient == null && boxBase.bgGradient == null || this.bgGradient != null && this.bgGradient.equals(boxBase.bgGradient)) && this.textColor.equals(boxBase.textColor) && this.shadowColor.equals(boxBase.shadowColor) && this.borderColor.equals(boxBase.borderColor) && this.inactiveColor.equals(boxBase.inactiveColor) && this.alternativeColor.equals(boxBase.alternativeColor) && this.shadow == boxBase.shadow && this.transparent == boxBase.transparent && this.textMargin == boxBase.textMargin && this.borderStroke.equals(boxBase.borderStroke) && this.markerStroke.equals(boxBase.markerStroke);
        }
        return bl;
    }

    public static final Font getDefaultFont() {
        if (DEFAULT_FONT == null) {
            DEFAULT_FONT = FontCheck.getValidFont("Arial", 0, 17);
        }
        return DEFAULT_FONT;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        if (!BoxBase.getDefaultFont().equals(this.originalFont)) {
            element.addContent(JDomUtility.fontToElement(this.originalFont));
        }
        Element element2 = new Element(COLOR);
        if (!this.textColor.equals(DEFAULT_TEXT_COLOR)) {
            element2.setAttribute(FOREGROUND, JDomUtility.colorToString(this.textColor));
        }
        if (!this.backColor.equals(DEFAULT_BACK_COLOR)) {
            element2.setAttribute(BACKGROUND, JDomUtility.colorToString(this.backColor));
        }
        if (!this.shadowColor.equals(DEFAULT_SHADOW_COLOR)) {
            element2.setAttribute(SHADOW, JDomUtility.colorToString(this.shadowColor));
        }
        if (!this.inactiveColor.equals(DEFAULT_INACTIVE_COLOR)) {
            element2.setAttribute(INACTIVE, JDomUtility.colorToString(this.inactiveColor));
        }
        if (!this.alternativeColor.equals(DEFAULT_ALTERNATIVE_COLOR)) {
            element2.setAttribute(ALTERNATIVE, JDomUtility.colorToString(this.alternativeColor));
        }
        if (!this.borderColor.equals(DEFAULT_BORDER_COLOR)) {
            element2.setAttribute(BORDER, JDomUtility.colorToString(this.borderColor));
        }
        if (!element2.getAttributes().isEmpty()) {
            element.addContent(element2);
        }
        if (this.bgGradient != null) {
            element.addContent(this.bgGradient.getJDomElement());
        }
        if (this.shadow) {
            element.setAttribute(SHADOW, JDomUtility.boolString(this.shadow));
        }
        if (this.transparent) {
            element.setAttribute(TRANSPARENT, JDomUtility.boolString(this.transparent));
        }
        if (this.textMargin != 6) {
            element.setAttribute(MARGIN, Integer.toString(this.textMargin));
        }
        if (this.borderStroke.getLineWidth() != 0.75f) {
            element.setAttribute(BORDER_STROKE, Float.toString(this.borderStroke.getLineWidth()));
        }
        if (this.markerStroke.getLineWidth() != 2.75f) {
            element.setAttribute(MARKER_STROKE, Float.toString(this.markerStroke.getLineWidth()));
        }
        return element;
    }

    public static BoxBase getBoxBase(Element element) throws Exception {
        BoxBase boxBase = new BoxBase();
        boxBase.setProperties(element, null);
        return boxBase;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        Element element2 = element.getChild("font");
        if (element2 != null) {
            this.setFont(JDomUtility.elementToFont(element2));
        }
        if ((element2 = element.getChild(COLOR)) != null) {
            this.textColor = JDomUtility.getColorAttr(element2, FOREGROUND, this.textColor);
            this.backColor = JDomUtility.getColorAttr(element2, BACKGROUND, this.backColor);
            this.shadowColor = JDomUtility.getColorAttr(element2, SHADOW, this.shadowColor);
            this.inactiveColor = JDomUtility.getColorAttr(element2, INACTIVE, this.inactiveColor);
            this.alternativeColor = JDomUtility.getColorAttr(element2, ALTERNATIVE, this.alternativeColor);
            this.borderColor = JDomUtility.getColorAttr(element2, BORDER, this.borderColor);
        }
        this.shadow = JDomUtility.getBoolAttr(element, SHADOW, this.shadow);
        this.transparent = JDomUtility.getBoolAttr(element, TRANSPARENT, this.transparent);
        this.textMargin = JDomUtility.getIntAttr(element, MARGIN, this.textMargin);
        String string = element.getAttributeValue(BORDER_STROKE);
        if (string != null) {
            this.setBorderWidth(Float.parseFloat(string));
        }
        if ((string = element.getAttributeValue(MARKER_STROKE)) != null) {
            this.setMarkerWidth(Float.parseFloat(string));
        }
        if ((element2 = element.getChild("gradient")) != null) {
            this.bgGradient = Gradient.getGradient(element2);
        }
    }

    public Stroke getBorder() {
        return this.borderStroke;
    }

    public float getBorderWidth() {
        return this.borderStroke.getLineWidth();
    }

    public void setBorderWidth(float f) {
        this.borderStroke = new BasicStroke(f);
    }

    public Stroke getMarker() {
        return this.markerStroke;
    }

    public float getMarkerWidth() {
        return this.markerStroke.getLineWidth();
    }

    public void setMarkerWidth(float f) {
        this.markerStroke = new BasicStroke(f);
    }

    public static void resetAllFonts() {
        ++resetAllFontsCounter;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            this.dynFontSize = this.font.getSize();
            this.originalFont = this.font.deriveFont(new AffineTransform());
        }
    }

    public void resetFont() {
        this.resetFontCounter = resetAllFontsCounter - 1;
    }

    public Font getFont() {
        if (this.resetFontCounter < resetAllFontsCounter) {
            this.resetFontCounter = resetAllFontsCounter;
            this.font = this.originalFont.deriveFont(new AffineTransform());
            this.dynFontSize = this.font.getSize();
        }
        return this.font;
    }

    public Font getOriginalFont() {
        return this.originalFont;
    }

    public float getDynFontSize() {
        return this.dynFontSize;
    }

    public boolean reduceFont() {
        if (this.dynFontSize <= 8.0f) {
            return false;
        }
        flagFontReduced = true;
        this.dynFontSize -= 1.0f;
        this.font = this.font.deriveFont(this.dynFontSize);
        return true;
    }
}

