/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;

class WatcherReadout {
    int x;
    int y;
    int w = 40;
    int h = 14;
    Color color = new Color(100, 60, 20);
    String contents = "123";
    boolean isLarge = false;
    static final Font smallFont = new Font("Arial Unicode MS", 1, 10);
    static final Font bigFont = new Font("Arial Unicode MS", 1, 14);

    WatcherReadout(boolean bl) {
        this.beLarge(bl);
    }

    void beLarge(boolean bl) {
        if (this.isLarge == bl) {
            return;
        }
        this.isLarge = bl;
        this.w = this.isLarge ? 50 : 40;
        this.h = this.isLarge ? 23 : 14;
    }

    void adjustWidth(Graphics graphics) {
        Font font = this.isLarge ? bigFont : smallFont;
        this.w = Math.max(this.w, WatcherReadout.stringWidth(this.contents, font, graphics) + 12);
    }

    void paint(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(this.x + 2, this.y, this.w - 4, 1);
        graphics.fillRect(this.x + 2, this.y + this.h - 1, this.w - 4, 1);
        graphics.fillRect(this.x, this.y + 2, 1, this.h - 4);
        graphics.fillRect(this.x + this.w - 1, this.y + 2, 1, this.h - 4);
        graphics.fillRect(this.x + 1, this.y + 1, 1, 1);
        graphics.fillRect(this.x + this.w - 2, this.y + 1, 1, 1);
        graphics.fillRect(this.x + 1, this.y + this.h - 2, 1, 1);
        graphics.fillRect(this.x + this.w - 2, this.y + this.h - 2, 1, 1);
        graphics.setColor(WatcherReadout.darker(WatcherReadout.darker(this.color)));
        graphics.fillRect(this.x + 2, this.y + 1, this.w - 4, 1);
        graphics.fillRect(this.x + 1, this.y + 2, 1, this.h - 4);
        graphics.setColor(WatcherReadout.darker(this.color));
        graphics.fillRect(this.x + 2, this.y + 2, this.w - 4, 1);
        graphics.fillRect(this.x + 2, this.y + this.h - 2, this.w - 4, 1);
        graphics.fillRect(this.x + 2, this.y + 2, 1, this.h - 3);
        graphics.fillRect(this.x + this.w - 2, this.y + 2, 1, this.h - 4);
        graphics.setColor(this.color);
        graphics.fillRect(this.x + 3, this.y + 3, this.w - 5, this.h - 5);
        Font font = this.isLarge ? bigFont : smallFont;
        int n = this.isLarge ? 17 : 11;
        graphics.setColor(Color.WHITE);
        graphics.setFont(font);
        graphics.drawString(this.contents, this.x + (this.w - WatcherReadout.stringWidth(this.contents, font, graphics)) / 2 - 1, this.y + n);
    }

    public static int stringWidth(String string, Font font, Graphics graphics) {
        if (string.length() == 0) {
            return 0;
        }
        TextLayout textLayout = new TextLayout(string, font, ((Graphics2D)graphics).getFontRenderContext());
        return (int)textLayout.getBounds().getBounds().getWidth();
    }

    public static Color darker(Color color) {
        double d = 0.8333;
        return new Color((int)(d * (double)color.getRed()), (int)(d * (double)color.getGreen()), (int)(d * (double)color.getBlue()));
    }
}

