/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.Icon;
import org.jdom.Element;

public class LibraryManagerElement
implements Domable {
    protected String name;
    protected String path;
    protected Options options;
    protected boolean exists;
    protected boolean editable;
    protected boolean isUrl;
    public static final String ELEMENT_NAME = "library";
    public static final String NAME = "name";
    public static final String PATH = "path";

    public LibraryManagerElement(Options options) {
        this.options = options;
        this.name = options.getMsg("UNNAMED");
        this.path = null;
        this.exists = false;
        this.editable = false;
        this.isUrl = false;
    }

    public LibraryManagerElement(String string, String string2, Options options) {
        this.name = string;
        this.path = string2;
        this.options = options;
        this.checkAttributes();
    }

    public static LibraryManagerElement getLibraryManagerElement(Element element, Options options) throws Exception {
        LibraryManagerElement libraryManagerElement = new LibraryManagerElement(options);
        libraryManagerElement.setProperties(element, null);
        return libraryManagerElement;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(element, NAME, this.name, false);
        this.path = JDomUtility.getStringAttr(element, PATH, this.path, false);
        this.checkAttributes();
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(NAME, this.name);
        element.setAttribute(PATH, this.path);
        return element;
    }

    public Icon getIcon() {
        String string = "icons/database";
        if (this.exists) {
            if (!this.editable) {
                string = string + "_locked";
            }
        } else {
            string = string + "_unavailable";
        }
        return ResourceManager.getImageIcon(string + ".gif");
    }

    protected void checkAttributes() {
        this.exists = false;
        this.editable = false;
        this.isUrl = false;
        if (this.path != null) {
            if (this.path.startsWith("http:") || this.path.startsWith("https:")) {
                this.isUrl = true;
                try {
                    URL uRL = new URL(this.path);
                    URLConnection uRLConnection = uRL.openConnection();
                    this.exists = uRLConnection != null;
                }
                catch (Exception exception) {}
            } else {
                File file = new File(this.path);
                boolean bl = this.exists = file.exists() && !file.isDirectory() && file.canRead();
                if (this.exists) {
                    this.editable = file.canWrite();
                }
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

