/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.RunnableComponent;
import edu.xtec.util.Check;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import edu.xtec.util.SwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SingleInstanceJFrame
extends JFrame
implements Constants {
    public static final String OK = "OK";
    public static final String CANCEL = "CANCEL";
    public static final int DEFAULT_TIMEOUT = 1000;
    RunnableComponent rc;
    JLabel splashLabel;
    String project;
    Options options;
    boolean trace;
    String playerClass;
    SocketThread socketThread;
    boolean initializing = true;
    boolean armed;
    static /* synthetic */ Class class$edu$xtec$util$Options;

    public SingleInstanceJFrame(String string, String[] stringArray, String string2, String string3, String string4, int n) {
        this.setDefaultCloseOperation(0);
        this.playerClass = string;
        this.options = new Options(this);
        this.project = SingleInstanceJFrame.loadArgs(stringArray, this.options);
        if (!this.checkOtherInstance(n)) {
            this.build(string, stringArray, string2, string4, string3);
            this.armed = true;
        }
    }

    public boolean isArmed() {
        return this.armed;
    }

    public static String loadArgs(String[] stringArray, Options options) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            if (stringArray[i].startsWith("-")) {
                String string2 = null;
                String string3 = null;
                int n = stringArray[i].indexOf(61);
                if (n > 0) {
                    string2 = stringArray[i].substring(1, n);
                    string3 = stringArray[i].substring(n + 1);
                } else {
                    string2 = stringArray[i].substring(1);
                }
                options.put(string2, string3);
                continue;
            }
            string = stringArray[i];
        }
        return string;
    }

    protected void build(String string, String[] stringArray, String string2, String string3, String string4) {
        this.trace = this.options.getBoolean("trace");
        if (this.trace) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
        this.initComponents();
        this.setTitle(string2);
        if (string3 != null) {
            this.setIconImage(ResourceManager.getImageIcon(string3).getImage());
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        this.splashLabel = new JLabel(" ", ResourceManager.getImageIcon(string4), 0);
        this.splashLabel.setVerticalTextPosition(3);
        this.splashLabel.setHorizontalTextPosition(0);
        this.splashLabel.setBackground(BG_COLOR);
        this.splashLabel.setOpaque(true);
        this.getContentPane().add((Component)this.splashLabel, "Center");
        this.pack();
        this.setBounds((n - this.getWidth()) / 2, (n2 - this.getHeight()) / 3, n - 40, n2 - 80);
        this.setLocation((n - this.getWidth()) / 2, (n2 - this.getHeight()) / 3);
        if (Check.checkSignature(this.options, true)) {
            this.init();
        } else {
            System.exit(0);
        }
    }

    protected void init() {
        final SingleInstanceJFrame singleInstanceJFrame = this;
        SwingWorker swingWorker = new SwingWorker(){
            final StringBuffer sb = new StringBuffer();

            public Object construct() {
                try {
                    Messages messages = PersistentSettings.getMessages(SingleInstanceJFrame.this.options, "messages.JClicMessages");
                    messages.addBundle("commonSettings");
                    if (SingleInstanceJFrame.this.splashLabel != null) {
                        SingleInstanceJFrame.this.splashLabel.setText(messages.get("LOADING"));
                    }
                    Class<?> clazz = Class.forName(SingleInstanceJFrame.this.playerClass);
                    Constructor<?> constructor = clazz.getConstructor(class$edu$xtec$util$Options == null ? (class$edu$xtec$util$Options = SingleInstanceJFrame.class$("edu.xtec.util.Options")) : class$edu$xtec$util$Options);
                    SingleInstanceJFrame.this.rc = (RunnableComponent)constructor.newInstance(SingleInstanceJFrame.this.options);
                }
                catch (Exception exception) {
                    this.sb.append("ERROR: Unable to start!\n").append(exception);
                    exception.printStackTrace();
                }
                return SingleInstanceJFrame.this.rc;
            }

            public void finished() {
                if (this.getValue() == null) {
                    if (SingleInstanceJFrame.this.splashLabel != null) {
                        String string = this.sb.substring(0);
                        SingleInstanceJFrame.this.splashLabel.setText(string);
                        System.err.println(string);
                    }
                } else {
                    SingleInstanceJFrame.this.getContentPane().removeAll();
                    SingleInstanceJFrame.this.splashLabel = null;
                    SingleInstanceJFrame.this.rc.addTo(singleInstanceJFrame, "Center");
                    SingleInstanceJFrame.this.getRootPane().revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            (this).SingleInstanceJFrame.this.rc.start((this).SingleInstanceJFrame.this.project, null);
                            (this).SingleInstanceJFrame.this.initializing = false;
                        }
                    });
                }
            }
        };
        if (this.trace) {
            System.out.println(">>> initializing...");
        }
        swingWorker.start();
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (SingleInstanceJFrame.this.rc == null || SingleInstanceJFrame.this.rc.windowCloseRequested()) {
                    if (SingleInstanceJFrame.this.socketThread != null) {
                        SingleInstanceJFrame.this.socketThread.stopSocketThread();
                    }
                    if (SingleInstanceJFrame.this.rc != null) {
                        SingleInstanceJFrame.this.rc.end();
                        SingleInstanceJFrame.this.rc = null;
                    }
                    SingleInstanceJFrame.this.dispose();
                }
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (SingleInstanceJFrame.this.rc != null) {
                    SingleInstanceJFrame.this.rc.activate();
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
                SingleInstanceJFrame.this.exitForm(windowEvent);
            }
        });
    }

    private void exitForm(WindowEvent windowEvent) {
        if (this.socketThread != null) {
            this.socketThread.stopSocketThread();
        }
        if (this.rc != null) {
            this.rc.end();
            this.rc = null;
        }
        while (this.socketThread != null) {
            Thread.currentThread();
            Thread.yield();
        }
        System.exit(0);
    }

    protected boolean checkOtherInstance(int n) {
        boolean bl = false;
        try {
            this.socketThread = new SocketThread(n, 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.socketThread == null) {
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), n);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                printWriter.println(this.playerClass);
                printWriter.println(StrUtils.secureString(this.project));
                printWriter.println("");
                printWriter.flush();
                String string = bufferedReader.readLine();
                bl = OK.equals(string);
                socket.close();
            }
            catch (Exception exception) {
                System.err.println("Socket error: " + exception);
            }
        } else {
            bl = false;
            this.socketThread.start();
        }
        return bl;
    }

    protected class SocketThread
    extends Thread {
        boolean running;
        boolean inService;
        boolean forceSocketClose;
        ServerSocket ss;
        int socketTimeOut;

        SocketThread(int n, int n2) throws IOException {
            this.ss = new ServerSocket(n);
            this.socketTimeOut = n2;
            this.running = false;
        }

        public void run() {
            block7: {
                try {
                    this.running = true;
                    this.ss.setSoTimeout(1000);
                    while (this.running) {
                        try {
                            this.inService = false;
                            Socket socket = this.ss.accept();
                            this.inService = true;
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                            String string = StrUtils.secureString(bufferedReader.readLine());
                            String string2 = StrUtils.nullableString(bufferedReader.readLine());
                            String string3 = StrUtils.nullableString(bufferedReader.readLine());
                            boolean bl = SingleInstanceJFrame.this.rc != null && !SingleInstanceJFrame.this.initializing && string.equals(SingleInstanceJFrame.this.playerClass) && string2 != null;
                            printWriter.println(bl ? SingleInstanceJFrame.OK : SingleInstanceJFrame.CANCEL);
                            printWriter.flush();
                            socket.close();
                            if (!bl) continue;
                            SingleInstanceJFrame.this.rc.newInstanceRequest(string2, string3);
                        }
                        catch (InterruptedIOException interruptedIOException) {
                        }
                        catch (Exception exception) {
                            if (!this.forceSocketClose) {
                                System.err.println("Socket error: " + exception);
                            }
                            this.running = false;
                        }
                    }
                    this.forceSocketClose = true;
                    this.ss.close();
                }
                catch (IOException iOException) {
                    if (this.forceSocketClose) break block7;
                    System.err.println("Server socket error: " + iOException);
                }
            }
            this.running = false;
            this.inService = false;
            SingleInstanceJFrame.this.socketThread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopSocketThread() {
            if (this.inService) {
                this.running = false;
            } else {
                try {
                    this.forceSocketClose = true;
                    this.ss.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    SingleInstanceJFrame.this.socketThread = null;
                    this.running = false;
                }
            }
        }
    }
}

