/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;

class ListWatcher
implements Drawable {
    public static final Font LABEL_FONT = new Font("Arial Unicode MS", 1, 10);
    public static final Font LABEL_FONT_SMALL = new Font("Arial Unicode MS", 0, 10);
    public static final Font CELL_NUM_FONT = new Font("Arial Unicode MS", 0, 9);
    public static final int TOP_MARGIN = 23;
    public static final int BOTTOM_MARGIN = 20;
    public static final int LEFT_MARGIN = 5;
    public static final int RIGHT_MARGIN = 5;
    LContext lc;
    PlayerCanvas canvas;
    StretchyBox box;
    ListWatcherPane pane;
    ListWatcherScrollBar scrollBar;
    String listTitle = "listTitle";
    Object[] list = null;
    ArrayList highlightedIndices = new ArrayList();
    int mouseOffset = 0;
    int paneHeight = 0;
    int scroll = 0;
    int scrollForIndex = 0;
    int scrollBarHeight = 0;
    float scrollRatio = 0.0f;
    boolean isShowing = true;
    boolean useScrollForIndex = false;

    ListWatcher(LContext lContext) {
        if (lContext != null) {
            this.canvas = lContext.canvas;
            this.lc = lContext;
        }
        this.box = new StretchyBox();
        this.box.setFrameImage(Skin.listWatcherOuterFrame);
        this.pane = new ListWatcherPane(this);
    }

    public void setList(Object[] objectArray) {
        this.list = objectArray;
        this.pane.setList(this.list);
        this.paneHeight = this.pane.totalHeight;
        this.initScrollBar();
    }

    public void initScrollBar() {
        this.scrollBarHeight = this.box.h - 23 - 20;
        this.scrollRatio = (float)this.paneHeight / (float)this.scrollBarHeight;
        if ((double)this.scrollRatio < 1.0) {
            this.scrollRatio = 0.0f;
            this.scrollBar = null;
            return;
        }
        if (this.scrollBar == null) {
            this.scrollBar = new ListWatcherScrollBar();
        }
        this.scrollBar.nubBox.h = (int)((float)this.scrollBarHeight / this.scrollRatio);
        if (this.scrollBar.nubBox.h < 23) {
            this.scrollBar.nubBox.h = 23;
            this.scrollRatio = (float)((double)this.paneHeight / ((double)this.scrollBarHeight - 23.0));
        }
    }

    void show() {
        this.isShowing = true;
        this.inval();
    }

    void hide() {
        this.isShowing = false;
        this.inval();
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public Rectangle rect() {
        return new Rectangle(this.box.x, this.box.y, this.box.w, this.box.h);
    }

    public Rectangle fullRect() {
        return this.rect();
    }

    void inval() {
        this.canvas.inval(this.rect());
    }

    public void paintBubble(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        this.box.paint(graphics);
        graphics.setColor(Color.BLACK);
        graphics.setFont(LABEL_FONT);
        graphics.drawString(this.listTitle, this.box.x + (this.box.w - WatcherReadout.stringWidth(this.listTitle, LABEL_FONT, graphics)) / 2, this.box.y + 23 - 8);
        if (this.scrollBar != null) {
            this.scrollBar.paint(graphics, this.box.x + this.box.w, this.box.y + 23, this.scrollBarHeight, this.box.y + 23 + this.scroll);
        }
        Graphics graphics2 = graphics.create();
        this.pane.paint(graphics2, this.box.x + 5, this.useScrollForIndex ? this.scrollForIndex : (int)((float)this.scroll * this.scrollRatio), this.box.y + 23, this.scrollBarHeight);
        graphics.setColor(Color.BLACK);
        graphics.setFont(LABEL_FONT_SMALL);
        String string = "length: " + this.list.length;
        graphics.drawString(string, this.box.x + (this.box.w - WatcherReadout.stringWidth(string, LABEL_FONT_SMALL, graphics)) / 2, this.box.y + this.box.h - 5);
    }

    boolean inScrollbar(int n, int n2) {
        if (this.scrollBar != null) {
            if (n < this.box.x + this.box.w - 20 || n > this.box.x + this.box.w) {
                return false;
            }
            return n2 >= this.box.y + 23 + this.scroll && n2 <= this.box.y + 23 + this.scroll + this.scrollBar.nubBox.h;
        }
        return false;
    }

    public void mouseDown(int n, int n2) {
        if (this.scrollBar != null) {
            this.mouseOffset = n2 - (this.box.y + 23) - this.scroll;
        }
    }

    public void dragTo(int n, int n2) {
        if (this.scrollBar != null) {
            this.setScroll(n2 - this.mouseOffset - (this.box.y + 23));
        }
    }

    void setScroll(int n) {
        if (this.scrollBar != null) {
            this.scroll = n < 0 ? 0 : (n > this.scrollBarHeight - this.scrollBar.nubBox.h ? this.scrollBarHeight - this.scrollBar.nubBox.h : n);
            this.useScrollForIndex = false;
            this.inval();
        }
    }

    void setScrollForHighlightIndex(int n) {
        if (this.scrollBar != null) {
            this.scrollForIndex = this.pane.getYPositionAtIndex(n) - this.scrollBarHeight / 2;
            this.useScrollForIndex = true;
            int n2 = (int)((float)this.scrollForIndex / this.scrollRatio);
            this.scroll = n2 < 0 ? 0 : (n2 > this.scrollBarHeight - this.scrollBar.nubBox.h ? this.scrollBarHeight - this.scrollBar.nubBox.h : n2);
            this.inval();
        }
    }

    void highlightIndex(int n) {
        if (n < 1 || n > this.list.length) {
            this.box.setFrameImage(Skin.listWatcherOuterFrameError);
        } else {
            this.setScrollForHighlightIndex(n);
            this.highlightedIndices.add(new Integer(n));
            this.box.setFrameImage(Skin.listWatcherOuterFrame);
        }
    }

    void clearHighlights() {
        this.highlightedIndices = new ArrayList();
        this.box.setFrameImage(Skin.listWatcherOuterFrame);
    }
}

