/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Color;
import java.util.Iterator;
import org.jdom.Element;

public class TextGridContent
implements Domable {
    public static final char DEFAULT_WILD = '*';
    public static final String DEFAULT_RANDOM_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public int ncw = 1;
    public int nch = 1;
    public double w = 20.0;
    public double h = 20.0;
    public boolean border = false;
    public BoxBase bb = null;
    public String[] text = new String[1];
    public char wild = (char)42;
    public String randomChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ELEMENT_NAME = "textGrid";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String CELL_WIDTH = "cellWidth";
    public static final String CELL_HEIGHT = "cellHeight";
    public static final String BORDER = "border";
    public static final String ROW = "row";
    public static final String TEXT = "text";
    public static final String WILD = "wild";
    public static final String RANDOM_CHARS = "randomChars";

    public static TextGridContent initNew(int n, int n2, char c) {
        TextGridContent textGridContent = new TextGridContent();
        textGridContent.ncw = n;
        textGridContent.nch = n2;
        textGridContent.text = new String[n2];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.setLength(0);
            for (int j = 0; j < n; ++j) {
                char c2 = c;
                c = (char)(c + '\u0001');
                stringBuffer.append(c2);
            }
            textGridContent.text[i] = new String(stringBuffer.toString());
        }
        textGridContent.bb = new BoxBase();
        textGridContent.bb.backColor = Color.white;
        textGridContent.border = true;
        return textGridContent;
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(ROWS, Integer.toString(this.ncw));
        element.setAttribute(COLUMNS, Integer.toString(this.nch));
        element.setAttribute(CELL_WIDTH, Double.toString(this.w));
        element.setAttribute(CELL_HEIGHT, Double.toString(this.h));
        element.setAttribute(BORDER, JDomUtility.boolString(this.border));
        if (this.wild != '*') {
            new String();
            element.setAttribute(WILD, String.copyValueOf(new char[]{this.wild}));
        }
        if (this.randomChars != DEFAULT_RANDOM_CHARS) {
            element.setAttribute(RANDOM_CHARS, this.randomChars);
        }
        if (this.bb != null) {
            element.addContent(this.bb.getJDomElement());
        }
        Element element2 = new Element(TEXT);
        for (int i = 0; i < this.nch; ++i) {
            if (i >= this.text.length) continue;
            element2.addContent(new Element(ROW).setText(this.text[i]));
        }
        element.addContent(element2);
        return element;
    }

    public static TextGridContent getTextGridContent(Element element) throws Exception {
        TextGridContent textGridContent = new TextGridContent();
        textGridContent.setProperties(element, null);
        return textGridContent;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.ncw = JDomUtility.getIntAttr(element, ROWS, this.ncw);
        this.nch = JDomUtility.getIntAttr(element, COLUMNS, this.nch);
        this.w = JDomUtility.getDoubleAttr(element, CELL_WIDTH, this.w);
        this.h = JDomUtility.getDoubleAttr(element, CELL_HEIGHT, this.h);
        if (this.ncw < 1 || this.nch < 1 || this.w < 1.0 || this.h < 1.0) {
            throw new IllegalArgumentException("Invalid TextGridContent attributes!");
        }
        String string = element.getAttributeValue(WILD);
        if (string != null && string.length() > 0) {
            this.wild = string.charAt(0);
        }
        this.randomChars = JDomUtility.getStringAttr(element, RANDOM_CHARS, this.randomChars, false);
        this.border = JDomUtility.getBoolAttr(element, BORDER, this.border);
        Element element2 = element.getChild("style");
        if (element2 != null) {
            this.bb = BoxBase.getBoxBase(element2);
        }
        if ((element2 = element.getChild(TEXT)) != null) {
            this.text = new String[this.nch];
            Iterator iterator = element2.getChildren(ROW).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                this.text[n++] = element3.getText();
            }
            while (n < this.nch) {
                this.text[n] = "";
                ++n;
            }
        }
    }

    public void completeText() {
        int n;
        String[] stringArray = null;
        char[] cArray = new char[this.ncw];
        for (n = 0; n < this.ncw; ++n) {
            cArray[n] = this.wild;
        }
        stringArray = new String[this.nch];
        for (n = 0; n < this.nch; ++n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n < this.text.length) {
                char[] cArray2 = this.text[n].toCharArray();
                stringBuffer.append(cArray2, 0, Math.min(cArray2.length, this.ncw));
                int n2 = stringBuffer.length();
                if (n2 < this.ncw) {
                    stringBuffer.append(cArray, 0, this.ncw - n2);
                }
                stringArray[n] = stringBuffer.substring(0);
                continue;
            }
            stringArray[n] = String.copyValueOf(cArray);
        }
        this.text = stringArray;
    }

    public int countWildChars() {
        int n = 0;
        this.completeText();
        if (this.text != null) {
            for (int i = 0; i < this.nch; ++i) {
                for (int j = 0; j < this.ncw; ++j) {
                    if (this.text[i].charAt(j) != this.wild) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNumChars() {
        return this.ncw * this.nch;
    }

    public void setCharAt(int n, int n2, char c) {
        if (n >= 0 && n < this.ncw && n2 >= 0 && n2 < this.nch) {
            StringBuffer stringBuffer = new StringBuffer(this.text[n2]);
            stringBuffer.setCharAt(n, c);
            this.text[n2] = stringBuffer.substring(0);
        }
    }

    public void copyStyleTo(TextGridContent textGridContent) {
        if (textGridContent != null) {
            textGridContent.w = this.w;
            textGridContent.h = this.h;
            textGridContent.border = this.border;
            textGridContent.bb = this.bb;
        }
    }
}

