// Inicialización del plugin
console.log("Plugin AutoSkipMessage cargado.");

var Imported = Imported || {};
Imported.POR_AutoSkipMessage = true;

var PORParameters = PORParameters || {};
PORParameters.autoSkipMessage = {};
var PORParams = PluginManager.parameters("POR_AutoSkipMessage");
PORParameters.autoSkipMessage.charTime = Number(PORParams.charTime);
PORParameters.autoSkipMessage.spaceTime = Number(PORParams.spaceTime);
PORParameters.autoSkipMessage.minTime = Number(PORParams.minTime);
PORParameters.autoSkipMessage.fcTime = Number(PORParams.fcTime);
PORParameters.autoSkipMessage.active = PORParams.active === "true";

console.log("Plugin AutoSkipMessage activo:", PORParameters.autoSkipMessage.active);

// Modificación del intérprete
POR_asm_gi_pc = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function (command, args) {
    POR_asm_gi_pc.call(this, command, args);
    if (command === "por_chartime") PORParameters.autoSkipMessage.charTime = Number(args[0]);
    if (command === "por_spacetime") PORParameters.autoSkipMessage.spaceTime = Number(args[0]);
    if (command === "por_mintime") PORParameters.autoSkipMessage.minTime = Number(args[0]);
    if (command === "por_fctime") PORParameters.autoSkipMessage.fcTime = Number(args[0]);
    if (command === "por_asmset") PORParameters.autoSkipMessage.active = Boolean(Number(args[0]));
};

// Modificación de la ventana de mensajes
POR_asm_wm_i = Window_Message.prototype.initialize;
Window_Message.prototype.initialize = function (rect) {
    rect = rect || new Rectangle(0, 0, Graphics.boxWidth, this.windowHeight());
    POR_asm_wm_i.call(this, rect);
    this._currentTimestamp = null;
    this._charTime = null;
    this._spaceTime = null;
    this._closeTime = 0;
    this._textLength = 0;
    this._spaces = 0;
};

POR_asm_wm_sm = Window_Message.prototype.startMessage;
Window_Message.prototype.startMessage = function () {
    if (PORParameters.autoSkipMessage.active && !this.containsFrct()) {
        for (var i in $gameMessage._texts) {
            var data = this.processDataEscapeCharacters($gameMessage._texts[i]);
            this._textLength += data[0];
            this._spaces += data[1];
        }
        this.calculateCloseTime();
        console.log("Tiempo calculado para mensaje:", this._closeTime);
    }
    POR_asm_wm_sm.call(this);
};

Window_Message.prototype.containsChrt = function () {
    return /\\\\CHRT\\[/.test($gameMessage._texts[0]?.substring(0, 6) || "");
};

Window_Message.prototype.containsFrct = function () {
    return /\\\\Frct\\[/.test($gameMessage._texts[0]?.substring(0, 6) || "");
};

Window_Message.prototype.calculateCloseTime = function () {
    this._closeTime = 0;
    this._closeTime += (this._charTime || PORParameters.autoSkipMessage.charTime) * this._textLength;
    this._closeTime += (this._spaceTime || PORParameters.autoSkipMessage.spaceTime) * this._spaces;
    if (this._closeTime < PORParameters.autoSkipMessage.minTime) {
        this._closeTime = PORParameters.autoSkipMessage.minTime;
    }
    this._currentTimestamp = Date.now();
    console.log("Tiempo calculado para cerrar mensaje:", this._closeTime);
};

POR_asm_wm_u = Window_Message.prototype.update;
Window_Message.prototype.update = function () {
    if (this._currentTimestamp && Date.now() - this._currentTimestamp >= this._closeTime) {
        console.log("AutoSkip: Cerrando mensaje automáticamente.");
        this.pause = false;
        this.terminateMessage();
    }
    POR_asm_wm_u.call(this);
};

// Procesamiento de caracteres
Window_Base.prototype.processDataEscapeCharacters = function (basetext) {
    var text = basetext.replace(/\\\\/g, "\\x1b");
    text = text.replace(/\\x1bCHRT\\[(\\d+)\\]/gi, "");
    text = text.replace(/\\x1bSPCT\\[(\\d+)\\]/gi, "");
    text = text.replace(/\\x1b.+?\\[.*?\\]/gi, "");
    var spaces = (text.match(/ /g) || []).length;
    return [text.length - spaces, spaces];
};
