/*

Javascript to make exeLearning idevice work.

gameId is the prefix that is used for this hangman game which will
come from the idevice id
*/

var numChances = new Array();
var chanceImgs = new Array();
var lettersGuessed = new Array();
var currentWord = new Array();
var currentChance = new Array();
var playerMessages = new Array();


/*
These variables to be filled in by script generated by exe learning
*/
var hangman_words = new Array();
var hangman_alphabet = new Array();
var hangman_chanceimgids = new Array();

var hangman_letterCounts = new Array();

var HANGMAN_BEFORE_GUESS = 0;
var HANGMAN_CORRECT_GUESS = 1;
var HANGMAN_WRONG_GUESS = 2;

var hangman_buttonStyles = new Array();


function setChance(gameId, chanceIndex) {      
        currentChance[gameId] = chanceIndex;
        var clonedChanceDiv = document.getElementById(
                hangman_chanceimgids[gameId][chanceIndex]).cloneNode(true);
        var imgArea = document.getElementById(gameId + "_imgarea");

        for (var childCounter = (imgArea.childNodes.length - 1); childCounter >= 0; childCounter--) {
                imgArea.removeChild(imgArea.childNodes[childCounter]);
        }

        imgArea.appendChild(clonedChanceDiv);
        clonedChanceDiv.style.display = '';
        clonedChanceDiv.style.position = 'absolute';
}

function setupGame(gameId) {
        populateLetters(gameId);
        currentWord[gameId] = 0;
        startGame(gameId, 0);
}

function populateLetters(gameId) {
        var letterAreaHTML = "";
        var letterCounter = 0;
        for (var i = 0; i < hangman_alphabet[gameId].length; i++) {
                var domId = gameId + "letter" + i;
                letterAreaHTML += "<input type='button' "
                        + " id='" + domId +  "' "
                        + " style='" + hangman_buttonStyles[gameId][HANGMAN_BEFORE_GUESS] + "' "
                        + " onclick=\"guess('" + gameId + "', '" + hangman_alphabet[gameId][i] + "', '" + domId + "')\""
                        + " value='" + hangman_alphabet[gameId][i] + "'/>";
                letterCounter = i;
        }
        hangman_letterCounts[gameId] = letterCounter;
        document.getElementById(gameId + "_letterarea").innerHTML = letterAreaHTML;
}

/*
Make the word for display in the box with - in place of those letters unknown
*/
function makeDisplayWord(gameId) {
        var actualWord = hangman_words[gameId][currentWord[gameId]][0];
        var wordForDisplay = "";
        for (var i = 0; i < actualWord.length; i++) {
                var currentLetter = actualWord.charAt(i);
                if(currentLetter == ' ' || lettersGuessed[gameId].indexOf(currentLetter) != -1) {
                        wordForDisplay += currentLetter;
                }else {
                        wordForDisplay += '-';
                }
        }

        return wordForDisplay;
}

/*
Win the level - if this is the last level show that the player wins the game
otherwise advance to the next word.
*/
function winLevel(gameId) {
        if(currentWord[gameId] < hangman_words[gameId].length -1) {
                showAlert(gameId, playerMessages[gameId]['levelpassed'], 5000);
                var nextWordId = currentWord[gameId] + 1;
                setTimeout("startGame('" + gameId + "',  " + nextWordId + ")", 5000);
        }else {
                showAlert(gameId, playerMessages[gameId]['gamewon'], -1);
        }
}

function updateWordArea(gameId) {
        var wordToDisplay = makeDisplayWord(gameId);
        document.getElementById(gameId + "_wordarea").value
                 = wordToDisplay;

        if(wordToDisplay == hangman_words[gameId][currentWord[gameId]][0]) {
                winLevel(gameId);
        }
}

/*
This starts the game for a given word index
*/
function startGame(gameId, wordIndex) {
        lettersGuessed[gameId] = "";
        setChance(gameId, 0);
        for(var i = 0; i < hangman_letterCounts[gameId]; i++) {
            document.getElementById(gameId + "letter" + i).setAttribute("style", 
                hangman_buttonStyles[gameId][HANGMAN_BEFORE_GUESS]);
        }
        currentWord[gameId] = wordIndex;
        updateWordArea(gameId);
        document.getElementById(gameId + "_hintarea").value 
                 = hangman_words[gameId][currentWord[gameId]][1];
        currentChance[gameId] = 0;        
}

function wrongGuess(gameId) {
        var numChances = hangman_chanceimgids[gameId].length;
        if(currentChance[gameId] + 1 >= numChances) {
                //loose
                showAlert(playerMessages[gameId]['lostlevel'], 4000);
                setTimeout("restartLevel('" + gameId + "')", 5000);
        }else {
                setChance(gameId, currentChance[gameId] + 1);
        }
}

function restartLevel(gameId) {
        startGame(gameId, currentWord[gameId]);
}

function guess(gameId, letter, domId) {
        var buttonDomElement = document.getElementById(domId);
        var newStyle = "";
        if(hangman_words[gameId][currentWord[gameId]][0].indexOf(letter) != -1) {
                //correct guess
                lettersGuessed[gameId] += letter;
                updateWordArea(gameId);
                newStyle = hangman_buttonStyles[gameId][HANGMAN_CORRECT_GUESS];
        }else {
                showAlert(gameId, playerMessages[gameId]['wrongguess'], 3000);
                wrongGuess(gameId);
                newStyle = hangman_buttonStyles[gameId][HANGMAN_WRONG_GUESS];
        }
        buttonDomElement.setAttribute("style", newStyle);
}

/*
Show a message to the user for a short time
gameId - id of game
msg - message to show in the alert area
delayToShow - how long to show the message.  -1 to show forever
*/
function showAlert(gameId, msg, delayToShow) {
        var alertAreaElement = document.getElementById(gameId + "_alertarea");
        alertAreaElement.innerHTML = msg;
        alertAreaElement.style.visibility = '';
        if(delayToShow > 0) {
                setTimeout('document.getElementById("' + gameId + 
                        '_alertarea").style.visibility = "hidden"', delayToShow);
        }
}

function playLevelCompleteSound() {
    //does nothing
}
