#include "WiFi.h"
#include "PubSubClient.h"

const char espwifi_ssid[]="ATuaSSID";
const char espwifi_pass[]="OTeuContrasinal";
IPAddress espwifi_ip_local(192,168,1,32);
IPAddress espwifi_ip_sn(255,255,255,0);
IPAddress espwifi_ip_gw(192,168,1,1);
IPAddress espwifi_ip_dnsa(8,8,8,8);
IPAddress espwifi_ip_dnsb(8,8,4,4);
const char espmqtt_broker[]="192.168.1.101";
const int espmqtt_port=1883;
const char espmqtt_user[]="";
const char espmqtt_pass[]="";
const char espmqtt_clientid[]="";
WiFiClient espmqtt_wifiClient;
PubSubClient espmqtt_client(espmqtt_wifiClient);
String espmqtt_topic="";
String espmqtt_msg_str="";
double espmqtt_msg_number=0;
char espmqtt_payload[128];

void espwifi_setup(){
	WiFi.mode(WIFI_STA);
	WiFi.begin(espwifi_ssid,espwifi_pass);
	while (WiFi.status() != WL_CONNECTED) delay(500);
}

void espwifi_config(){
	WiFi.mode(WIFI_STA);
	if( !WiFi.config(espwifi_ip_local, espwifi_ip_gw, espwifi_ip_sn, espwifi_ip_dnsa, espwifi_ip_dnsb) ) { Serial.println("WiFi config error!"); };
}

void espmqtt_onreceive(){};

void espmqtt_setup(){
	delay(10);;
	randomSeed(micros());
	espmqtt_client.setServer(espmqtt_broker, espmqtt_port);
	espmqtt_client.setCallback(espmqtt_callback);
	espmqtt_subscribe();
}

void espmqtt_loop(){
	if (!espmqtt_client.connected()) {
		espmqtt_client.connect(espmqtt_clientid,espmqtt_user,espmqtt_pass);
		espmqtt_subscribe();
	}
	if (espmqtt_client.connected()) {
		espmqtt_client.loop();
	}
}

double espmqtt_payload2double(unsigned char *_payload, int _length){
	int i;
	for (i = 0; i<_length && i<128; i++){
		espmqtt_payload[i] = _payload[i];
	}
	espmqtt_payload[i] = 0;
	return atof(espmqtt_payload);
}

String espmqtt_payload2string(unsigned char *_payload, int _length){
	int i;
	for (i = 0; i<_length && i<128; i++){
		espmqtt_payload[i] = _payload[i];
	}
	espmqtt_payload[i] = 0;
	return String(espmqtt_payload);
}

void espmqtt_callback(char* _topic, unsigned char* _payload, unsigned int _payloadlength){
	espmqtt_topic=String(_topic);
	espmqtt_msg_str=espmqtt_payload2string(_payload,_payloadlength);
	espmqtt_msg_number=espmqtt_payload2double(_payload,_payloadlength);
	espmqtt_onreceive();
}

void espmqtt_subscribe(){
}

void setup()
{


	Serial.begin(115200);
	Serial.flush();
	while(Serial.available()>0)Serial.read();

	Serial.println(String("Conectando a Wifi"));
	espwifi_setup();
	espwifi_config();
	Serial.println(String("Conectado a IP ")+String(WiFi.localIP().toString()));
	Serial.println(String("Conectando a Raspberry MQTT"));
	espmqtt_setup();
	if (espmqtt_client.connected()) {
		Serial.println(String("Conectado a Raspberry MQTT"));
	}
	else {
		Serial.println(String("Reintentando conexión a Raspberry MQTT"));
	}


}


void loop()
{
	yield();

	espmqtt_loop();

}