
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////  PROGRAMA CONTROL ACCESO PORTA HALL  //////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/* Neste programa controlaremos o acceso á vivenda pola porta principal. Empregaremos un lector RFID-RC552, semellante ó que se emprega por exemplo nas portas dos hoteis.
Ademáis de avisar no monitor serie se a tarxeta é valida para abrir a a porta ou inválida, encenderase un led verde cando a tarxeta sexa válida, e outro vermello cando sexa inválida*/

// Para poder empregar os lectores de tarxetas RFID temos que incluir as seguintes librerías
 

#include <SPI.h>
#include <MFRC522.h>
#include <deprecated.h>
#include <MFRC522.h>
#include <require_cpp11.h>
#include <MFRC522Extended.h>

/*Para os arduinos UNO e NANO xa veñen definidos na librería os pins a empregar para conectar cada un dos sinais de comunicación
RST co pin D9
SS ou SDA  co pin D10
MOSI co pin D11
MISO co pin D12
SCK co pin D13
*/

//No noso curso empregaremos un arduino Mega, polo tanto conectaremos os seguintes pins dixitais

//RST D9
//SS (SDA) D53
//MOSI D51
//MISO D50
//SCK D52

//Poderíanse modificar os pins anteriormente definidos, neste caso mantémolos

const int RST_PIN = 9; // Pin 9 para el reset del RC522
const int SS_PIN = 53; // Pin 53 para el SS (SDA) del RC522

//Definimos os leds a empregar como sinalización de acceso

int ledverde = 23;
int ledvermello = 24;

//Definimos o funcionamento do lector cos seus pins

MFRC522 mfrc522(SS_PIN, RST_PIN);

byte readUID[4]; // Almacena o tag lido

byte validKey1[4] = { 0xD3, 0x8E, 0xFB, 0x1A}; //Estes son os datos da nosa tarxeta que comprobamos nunha leitura anterior. Aportase tamén ese programa. Cada tarxeta ten un código que a define 
bool isEqualArray(byte arrayA[], byte arrayB[], int length)
{
for (int index = 0; index < length; index++)
{
if (arrayA[index] != arrayB[index]) return false;
}
return true;
}


void setup() 
{
Serial.begin(9600); // Inicializamos a comunicación serie
SPI.begin(); // Inicializamos o SPI
mfrc522.PCD_Init(); // Inicializamos o lector RFID MFRC522

//Declaramos os leds como saídas
pinMode(ledverde, OUTPUT);
pinMode(ledvermello, OUTPUT);
}


void loop() 
{
//Soamente se encenderan os leds os mostrarán mensaxes de tarxerta válida ou inválida cando aproximemos unha tarxeta RFID ó lector

if (mfrc522.PICC_IsNewCardPresent())

//leremos o código de identificación da tarxeta 

{if (mfrc522.PICC_ReadCardSerial())
{
if (isEqualArray(mfrc522.uid.uidByte, validKey1, 4)) // Se o código da tarxeta é o mesmo que o da tarxeta que temos asignada diranos que é válida e prenderá o led verde

 {Serial.println("Tarjeta valida");
 digitalWrite(ledverde, HIGH);}

else

 {Serial.println("Tarjeta invalida");// Se o código da tarxeta non é o mesmo que o da tarxeta que temos asignada diranos que é inválida e prenderá o led vermello
 digitalWrite(ledvermello, HIGH);}

mfrc522.PICC_HaltA(); // Finalizamos o lector
}
}
delay(250); 

digitalWrite(ledverde, LOW); // Antes de comezar o ciclo apagamos os leds para evitar erros con lecturas de tarxetas posteriores
digitalWrite(ledvermello, LOW);
}
