
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////   PROGAMA IDENTIFICACIÓN TARXETA RFID   //////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Con este programa identificamos o código da tarxeta que queremos empregar para o control de accesos á vivenda

// O módulo RFID-RC522 sirve para ler tarxetas RFID con Arduino, e tamén para escribir nelas

/* Este módulo leva un chip dixital minúsculo de memoria, que pode conter unha identificación en forma de código e incluso información de diferentes cuestións grabados nel. 

Son como un pendrive pero pequerrecho e por radio, para entendernos.

Ademais teñen unha antena que permite dúas cuosas pouco frecuentes, unha identificalos por Radio Frecuencia (ou RF)  sen contacto a distancias de entre uns poucos centímetros 

e varios metros, mediante un receptor adecuado, e a outra é que o propio sinal de RF que empregamos para identificarlos é capaz de alimentar o chip da etiqueta RFID 

sen necesidade de batería.

Cando a etiqueta RFID (Ou Tag segúndo a lingua de Albión) non leva batería, chámanse pasivas e son as máis baratas, ainda que tamén as hai con batería e chamanse activas, 

pero ignoraremos estas últimas no noso caso.

Normalmente os tags RFID son una especie de pegatina que leva diseños máis ou menos extravagantes de pistas metálicas moi finas que fan ás veces de antena, 

vense na roupo ropa e otros productos.*/

//Os pins do módulo RFID conectanse cos seguintes pins dixitais, válido tanto para arduino uno como para arduino nano:

//RST D9
//SS (SDA) D10
//MOSI D11
//MISO D12
//SCK D13

//No noso curso empregaremos un arduino Mega, polo tanto conectaremos os seguintes pins dixitais

//RST D9
//SS (SDA) D53
//MOSI D51
//MISO D50
//SCK D52

/* Debemos ter en conta algunhas consideracións:

O pin IRQ non se conecta
O voltaxe é 3.3v e NON 5v (OLLO)*/

#include <SPI.h>
#include <MFRC522.h>

const int RST_PIN = 9; // Pin 9 para el reset
const int SS_PIN = 53; // Pin 53 para el SS


MFRC522 mfrc522(SS_PIN, RST_PIN);// Crear instancia

void printArray(byte *buffer, byte bufferSize) {
for (byte i = 0; i < bufferSize; i++)
{
Serial.print(buffer[i] < 0x10 ? " 0" : " ");
Serial.print(buffer[i], HEX);
}
}

void setup() {
 {
Serial.begin(9600); //Inicializa Serie
SPI.begin(); //Función que inicializa SPI
mfrc522.PCD_Init(); //Función que inicializa RFID
}

}

void loop() 
 {
// Detectamos a tarjeta

if (mfrc522.PICC_IsNewCardPresent())
{
if (mfrc522.PICC_ReadCardSerial())
{
Serial.print(F("UID Tarjeta:"));
printArray(mfrc522.uid.uidByte,mfrc522.uid.size);

// Mostramos o código da tarxeta no monitor serie
Serial.println();
mfrc522.PICC_HaltA(); //Finalizamos a lectura actual
}
}
delay(250);
}
