
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////// Programa de control de interruptores, radiadores e sensores con avisos mediante protocolo MQTT ////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////  Arduino mega - shield ethernet - raspberry pi   /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//----- Librerías -----------------------------------------------------------------------------------------------------------//

//#include <SPI.h>
#include <PubSubClient.h>  // Esta librería precisamola para a comunicación co protocolo mqtt 
#include <Ethernet.h>      // Esta librería precisámola para conectar a shield de ethernet

//Os sensores de humidade e temperatura DHT11 e DHT22 precisan da librería DHT

#include "DHT.h"
#define DHTPINVivenda1 5// Temos que darlle un nome o noso sensor. Que neste caso conectamos no pin 5
#define DHTTYPE2 DHT11   //Definimos o tipo de sensor DHT que empregaremos para as habitacións
DHT dht1(DHTPINVivenda1, DHTTYPE2);//Inicializamos os sensores dht


//----- Comentarios sobre a montaxe da shield ethernet-----------------------------------------------------------------------//

//Cando empregamos un arduino uno ou un nano non podemos empregar os pins 10, 11, 12 e 13 porque os precisa para a comunicación coa shield ethernet.
//Cando empregamos un arduino mega non podemos empregar os pins 10, 50, 51, 52 e 53 on the porque os precisa para a comunicación coa shield ethernet.
//O pin 4, empregao para a tarxeta SD.
//O pin 2, empregao para as notificacións.


//----- Variables para inicializar a rede e MQTT ----------------------------------------------------------------------------//

byte mac[] = { 0x90, 0xAD, 0xDA, 0x0D, 0x96, 0xFE };                            // MAC asignada á shield
//IPAddress ip(192, 168, 15, 150);     // Na rede do Politécnico        // IP local da shield Arduino
IPAddress ip(192, 168, 1, 150);     // Na rede do Politécnico        // IP local da shield Arduino
IPAddress subnet(255, 255, 255, 0);
//IPAddress gateway(192, 168, 15, 1);
IPAddress gateway(192, 168, 1, 1);
//IPAddress dnServer(192, 168, 15, 1);
IPAddress dnServer(192, 168, 1, 1);

//const char* mqttServer = "192.168.15.144";                                        // A ip do servidor MQTT no Politécnico
const char* mqttServer = "192.168.1.144";                                        // A ip do servidor MQTT na casa
const char* MQTT_CLIENT_ID = "ArduinoMega";                                     // O identificador de cliente MQTT
//----------------------------------------------------------------------------------------------------------------------------------//
const char* topic_radiadoracceso = "calefaccion/radiadoracceso";               // Os topics MQTT onde se van publicar as mensaxes

const char* topic_sensortemp = "calefaccion/temperatura";



//----------------------------------------------------------------------------------------------------------------------------------//

const int in_radiadoracceso = A6;                                                 // Asignación de variables dos pins input/output.
const int ou_radiadoracceso = 42;


const int sensortemp = 5;





//-----------------------------------------------------------------------------------------------------------------------------------//
bool value_radiadoracceso = true;                 // Variables empregadas polas funcións para controlar o estado dos interruptores.
bool lastvalue_radiadoracceso = true;             // Nos nosos vinilos temos relés para calefacción con disparo baixo por iso inicializamos esas saídas en 1

int value_sensortemp = false;
int lastvalue_sensortemp = false;




////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//----- SETUP ----------------------------------------------------------------------------------------------------------------//

EthernetClient ethClient;                                         // Inicializamos a rede
PubSubClient mqttClient(mqttServer,1883,ethClient);      // Inicializamos a conexión co servidor MQTT

void setup() {
  Ethernet.begin(mac, ip, subnet, gateway, dnServer);     // Activamos a rede cos parámetros previamente declarados
  Serial.begin(9600);
  Serial.print("A ip configurada é: ");                   // Amosamos a IP local configurada polo porto serie
  Serial.println(Ethernet.localIP());
  mqttClient.setServer(mqttServer, 1883);
  mqttClient.setCallback(callback);

  pinMode(in_radiadoracceso, INPUT_PULLUP);
  pinMode(ou_radiadoracceso, OUTPUT);  
  
 

 
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//----- Función callback ----------------------------------------------------------------------------------------------------//

void callback(char* topic, byte* payload, unsigned int length) {
  if (strcmp(topic, "calefaccion/radiadoracceso") == 0) {
    String mensaxe = func_payloadtostring(payload, length);
    //Serial.println(mensaxe);
    if (mensaxe == "ON")
      digitalWrite(ou_radiadoracceso, LOW);
    if (mensaxe == "OFF")
      digitalWrite(ou_radiadoracceso, HIGH); 
  }
 
}

//----- función payloadtostring -------------------------------//  // Esta función existe para ser chamada á súa vez por callback

String func_payloadtostring (byte* payload, unsigned int length) {
  int i = 0;
  char buff[length + 1];
  for (i = 0; i < length; i++) {
    buff[i] = payload[i];
  }
  buff[i] = '\0';
  String mensaxe = String(buff);
  return mensaxe;
}

//----- Función reconectar --------------------------------------------------------------------------------------------------//

bool reconectar() {
  Serial.println("Reconectando...");
  if (mqttClient.connect(MQTT_CLIENT_ID)) {
    Serial.println("Conectado correctamente ao servidor MQTT");
    mqttClient.subscribe("calefaccion/radiadoracceso");
    
    Serial.println("Suscrito aos topics");
    delay(2000);
    return mqttClient.connected();
  }
}


//----- Función radiadoracceso --------------------------------------------------------------------------------------------//

void func_radiadoracceso() {
  value_radiadoracceso = digitalRead(in_radiadoracceso);
  if (value_radiadoracceso != lastvalue_radiadoracceso) {
    if (value_radiadoracceso == HIGH) {
      digitalWrite(ou_radiadoracceso, LOW);
      mqttClient.publish(topic_radiadoracceso,"OFF");
      Serial.println("Radiador do acceso apagado");
    } else {
        digitalWrite(ou_radiadoracceso, HIGH);
        mqttClient.publish(topic_radiadoracceso,"ON");
        Serial.println("Radiador do acceso encendido");
      }
      delay(50);
  } 
    lastvalue_radiadoracceso = value_radiadoracceso;
}


//----- Función sensortemp -----------------------------------------------------------------------------------------------------//

void func_sensortemp() {
  value_sensortemp = analogRead(sensortemp);
  //if (value_sensortemp != lastvalue_sensortemp) {
    //Obtemos o valor de humidade da Vivenda 1
    int h = dht1.readHumidity();
    // Obtemos o valor de temperatura en graos Celsius da Vivenda 1
    int temp = dht1.readTemperature();
    char buffer[10];
    dtostrf(temp,0, 0, buffer);
    value_sensortemp = buffer;
    Serial.println("lectura sensortemp");
    Serial.println(temp);
    mqttClient.publish(topic_sensortemp, buffer);
    Serial.print("A temperatura é: ");   
    Serial.println(temp);
  //}
  lastvalue_sensortemp = value_sensortemp;
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//----- LOOP ----------------------------------------------------------------------------------------------------------------//

void loop() {
  
  func_radiadoracceso();
  delay(10);
  func_sensortemp();
  delay(10);

  
  if (!mqttClient.connected()) {
    reconectar();
  }
  mqttClient.loop();
  delay (1000);
}
