
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////  PROGRAMA CONTROL TEMPERATURAS E HUMIDADES RELATIVAS EN DISPLAY I2C/////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Neste programa poderíamos integrar 4 modelos de sensor de temperatura diferentes: Os DHT11, os DHT22, os TMP36 e os LM35DZ
/*

Os sensores da familia DHT proporcionan de forma dixital a temperatura e a humidade relativa

As características do DHT11 son:

Bastante barato, sobre 3€
Funciona con 3,3 e 5V de alimentación
Rango de temperatura: de 0º a 50º con 5% de precisión (pero só mide por grados, non fraccións)
Rango de humidade: do 20% ó 80% con 5% de precisión
1 Mostra por segundo
Baixo consumo
Devolve a medida en ºC


En canto ó DHT22:

Barato, entre 6 e 7 €
Funciona con 3,3 e 5V de alimentación
Rango de temperatura: de -40º a 125º ±0.5°C
Rango de humidade: do 0% ó 100% con 5% de precisión.
Le 2 veces por segundo.
Baixo consumo.
Devuelva a medida en ºC


Os sensores TMP36 e LM35DZ:

Miden a temperatura en graos centígrados.
Funcionan entre -50º C e 125ºC para o TMP36.
Funciona entre 0º C y 100ºC para o LM35DZ .
Non son especialmente precisos, xa que teñen ± 1ºC de incertidume, pero normalmente sobrannos para proxectos sinxelos e son os máis económicos.
O encapsulado é semellante ó dun transistor e tamén ten tres patas, así que moito ollo non confundirlos. Intentade ler as letras que leva serigrafiadas.

*/



//Para empregar un display con I2C temos que usar os pins A4 para sda e A5 para scl, si se trata dun arduino uno ou dun arduino nano, si fose o arduino mega serían D20 e D21 
//Se se trata dun modelo non orixianl buscar os pins que indiquen sda e scl

// A librería Wire.h é para I2C
#include <Wire.h> 

// A librería para o LCD 16x2 I2C. Deste modo só necesitamos 2 cables para comunicar o display, empregamos o interfaz I2C. Esta librería descargámola dos tutoriais de Arduino hobby. Se temos varias librerías que dan problemas é mellor desinstalalas
#include <LiquidCrystal_I2C.h>

// O noso LCD comunícase na dirección 27, e inicializamos a librería para 16x2. Na maioría dos tutoriais empregan a dirección 27. Na páxina de tutoriais de Prometec atopamos un programa para escanear as direccións I2C
LiquidCrystal_I2C lcd(0x27, 16, 2);


//Os sensores de humidade e temperatura DHT11 e DHT22 precisan da librería DHT

#include "DHT.h"


#define DHTPINHabitacion1 5  // Definimos os pins que van empregar os sensores tipo DHT

 
#define DHTTYPE1 DHT22   //Definimos o tipo de sensor DHT que empregaremos para a cociña e o salón
#define DHTTYPE2 DHT11   //Definimos o tipo de sensor DHT que empregaremos para as habitacións


DHT dht3(DHTPINHabitacion1, DHTTYPE2);  //Inicializamos os sensores dht




// Podemos empregar unha temperatura umbral a partir da cal xerar un aviso para cortar a calefacción por exemplo
int umbral = 25 ; 

// E tamén un pin para avisos desa temperatura excesiva ou corte da caldeira

int ledvermello = 6;



void setup() 
{
  //Arrancamos o monitor serie, e indicamos os sensores que empregaremos
  Serial.begin(9600); 
  Serial.println("Deteccion de temperaturas e humidades con sensores DTH22, DHT11, TMP36, LM35DZ. Veremos as temperaturas de cada estancia con diferentes sensores");


  // Inicializamos o display como saída
  lcd.begin();
  // Encendemos a pantalla
  lcd.backlight();
  // Mostramos texto na liña 1
  lcd.print("Detectando");
  // Mostramos texto na liña 2
  lcd.setCursor(0, 1);
  lcd.print("temperaturas");
  delay(1000);
  // Borramos o texto anterior do display para que non se superpoñan o anterior e o siguinte
  //lcd.clear();
  
  //Declaramos como saída o pin 6, que o podemos empregar para unha alarma de temperatura excesiva por exemplo o mesmo tempo que cortamos a calefacción
  pinMode(ledvermello, OUTPUT);
}


// Facemos o ciclo de traballo

  void loop()
       {

            //Os sensores DHT precisan 2 segundos conectados aprox para sacar o valor de temperatura e humidade
            

            // Obtemos o valor de temperatura en graos Celsius da Habitación 1
            int temp3 = dht3.readTemperature();
            //Obtemos o valor de humidade da Habitación 1
            int h3 = dht3.readHumidity();
           


            
         

            // Mostramos as temperaturas e humidades no monitor serie
            
            Serial.println("temperatura Habitacion 1") ; 
            Serial.println(temp3) ; 
            Serial.println("humidade Habitacion 1") ; 
            Serial.println(h3) ; 
            

            // Cortamos a calefacción se a temperatura é maior do umbral establecido por exemplo e encendemos un led de aviso

            if (temp3>umbral){
            digitalWrite(ledvermello, HIGH);}

            // Se a temperatura non supera o umbral desactivamos o aviso
            
            if (temp3<=umbral){
            digitalWrite(ledvermello, LOW);}
            
           
            //Mostramos a temperatura de cada estancia no display, e a humidade relativa nos casos en que a coñecemos

            lcd.clear(); // Borramos o display para non sobrescribir os diferentes textos

           

            //Habitación 1
            lcd.setCursor(2,0);       //colocamos o cursor
            lcd.print("HABITACION 1");  //texto que queremos mostrar
            lcd.setCursor(0,1); 
            lcd.print("TEMP: "); 
            lcd.setCursor(5,1); 
            lcd.print(temp3);
            lcd.setCursor(7,1); 
            lcd.print("C");
            lcd.setCursor(10,1); 
            lcd.print("HUM:");
            lcd.setCursor(14,1); 
            lcd.print(h3);
            delay(2000); //Mantemos o texto durante 2 segundos
            //lcd.clear(); //Borramos o display



            
            
            }
