
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////  PROGRAMA CONTROL TEMPERATURAS E HUMIDADES RELATIVAS  //////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Neste programa poderíamos integrar 4 modelos de sensor de temperatura diferentes: Os DHT11, os DHT22, os TMP36 e os LM35DZ
/*

Os sensores da familia DHT proporcionan de forma dixital a temperatura e a humidade relativa

As características do DHT11 son:

Bastante barato, sobre 3€
Funciona con 3,3 e 5V de alimentación
Rango de temperatura: de 0º a 50º con 5% de precisión (pero só mide por grados, non fraccións)
Rango de humidade: do 20% ó 80% con 5% de precisión
1 Mostra por segundo
Baixo consumo
Devolve a medida en ºC


En canto ó DHT22:

Barato, entre 6 e 7 €
Funciona con 3,3 e 5V de alimentación
Rango de temperatura: de -40º a 125º ±0.5°C
Rango de humidade: do 0% ó 100% con 5% de precisión.
Le 2 veces por segundo.
Baixo consumo.
Devuelva a medida en ºC


Os sensores TMP36 e LM35DZ:

Miden a temperatura en graos centígrados.
Funcionan entre -50º C e 125ºC para o TMP36.
Funciona entre 0º C y 100ºC para o LM35DZ .
Non son especialmente precisos, xa que teñen ± 1ºC de incertidume, pero normalmente sobrannos para proxectos sinxelos e son os máis económicos.
O encapsulado é semellante ó dun transistor e tamén ten tres patas, así que moito ollo non confundirlos. Intentade ler as letras que leva serigrafiadas.

*/



//Os sensores de humidade e temperatura DHT11 e DHT22 precisan da librería DHT

#include "DHT.h"


#define DHTPINHabitacion1 5  // Definimos os pins que van empregar os sensores tipo DHT, neste caso o pin 5

 
#define DHTTYPE1 DHT22   //Definimos o tipo de sensor DHT que empregaremos para a cociña e o salón por exemplo
#define DHTTYPE2 DHT11   //Definimos o tipo de sensor DHT que empregaremos para as habitacións


DHT dht3(DHTPINHabitacion1, DHTTYPE2);  //Inicializamos os sensores dht




// Podemos empregar unha temperatura umbral a partir da cal xerar un aviso para cortar a calefacción por exemplo
int umbral = 25 ; 

// E tamén un pin para avisos desa temperatura excesiva ou corte da caldeira

int ledvermello = 6;

void setup() 
{
  //Arrancamos o monitor serie, e indicamos os sensores que empregaremos
  Serial.begin(9600); 
  Serial.println("Deteccion de temperaturas e humidades con sensores DTH22, DHT11, TMP36, LM35DZ. Veremos as temperaturas de cada estancia con diferentes sensores");


  
  //Declaramos como saída o pin 6, que o podemos empregar para unha alarma de temperatura excesiva por exemplo o mesmo tempo que cortamos a calefacción
  pinMode(ledvermello, OUTPUT);
}


// Facemos o ciclo de traballo

  void loop()
       {

            //Os sensores DHT precisan 2 segundos conectados aprox para sacar o valor de temperatura e humidade
            

            // Obtemos o valor de temperatura en graos Celsius da Habitación 1
            int temp3 = dht3.readTemperature();
            // Obtemos o valor de humidade da Habitación 1
            int h3 = dht3.readHumidity();

            // Cortamos a calefacción se a temperatura é maior do umbral establecido por exemplo e encendemos un led de aviso

            if (temp3>umbral){
            digitalWrite(ledvermello, HIGH);}

            // Se a temperatura non supera o umbral desactivamos o aviso
            
            if (temp3<=umbral){
            digitalWrite(ledvermello, LOW);}

            // Mostramos as temperaturas e humidades no monitor serie
            
            Serial.println("temperatura Habitacion 1") ; 
            Serial.println(temp3) ; 
            Serial.println("humidade Habitacion 1") ; 
            Serial.println(h3) ; 

            delay(2000);
            
            }
