
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////   PROGRAMA CONTROL REGO XARDÍN E RECOLLIDA TOLDO EXTERIOR  //////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

/*Neste programa controlaremos o funcionamento da bomba de rego do xardín en función dun sensor de humidade do chan que nos informará se 
está seco ou húmido, e o funcionamento dun motor paso a paso que recollería o toldo exterior controlado cun sensor de choiva e un final 
de carreira que indica se está totalmente recollido*/

//definición dos pins de arduino que conectamos ós sensores
const int pinsensorhumidadechanxardin = A0; //Conectamos o pin dixital deste sensor. Se quixésemos empregar o analóxico teríamos que modificar no loop a lectura
const int pinsensorchoiva = A1; //Conectamos o pin dixital deste sensor. Se quixésemos empregar o analóxico teríamos que modificar no loop a lectura
const int pinfinaldecarreira = A2;

//definición dos valores dos sensores como enteiros
int valor1=0;
int valor2=0;
int valor3=0;


//definición do pin de arduino que conectamos á bomba de auga
//en realidade non conectamos a bomba directamente ó arduino, senón que o facemos a través do contacto NO de cadanseu relé
const int pinbombarego = 7;


//definicion dos pins de arduino que conectamos ós pins da controladora do motor paso a paso que moverá o toldo exterior
const int motorPin1 = 3;     // 28BYJ48 In1
const int motorPin2 = 4;     // 28BYJ48 In2
const int motorPin3 = 5;    // 28BYJ48 In3
const int motorPin4 = 6;    // 28BYJ48 In4

//definicion variables motores paso a paso
int motorSpeed1 = 1200;   //variable para fixar a velocidade
int stepCounter1 = 0;     // contador para os pasos
int stepsPerRev1 = 1000;  // pasos para unha volta pequena para poder apreciala ben
//int stepsPerRev = 4076;  // pasos para unha volta completa
 
//tablas coa secuencia de encendido (descomentamos a que necesitemos)
//secuencia 1-fase
//const int numSteps = 4;
//const int stepsLookup[4] = { B1000, B0100, B0010, B0001 };
 
//secuencia 2-fases
//const int numSteps = 4;
//const int stepsLookup[4] = { B1100, B0110, B0011, B1001 };
 
//secuencia media fase. Esta é a que mellor nos vai para o noso modelo de motor
const int numSteps1 = 8;
const int stepsLookup1[8] = { B1000, B1100, B0100, B0110, B0010, B0011, B0001, B1001 };


// Declaramos o bucle de inicio do programa
void setup() {
  Serial.begin(9600);   //inicializamos o porto serie
  pinMode(pinsensorhumidadechanxardin, INPUT);  //definimos o pin do sensor de humidade do chan do xardín como entrada
  pinMode(pinsensorchoiva, INPUT);  //definimos o pin do sensor de choiva do xardín como entrada
  pinMode(pinfinaldecarreira, INPUT_PULLUP);  //definimos o pin do final de carreira do toldo como entrada

  //declaramos o pin da bomba de rego como saída
  pinMode(pinbombarego, OUTPUT);
 
  
  //declaramos os pins dos motores paso a paso como saídas
  pinMode(motorPin1, OUTPUT);
  pinMode(motorPin2, OUTPUT);
  pinMode(motorPin3, OUTPUT);
  pinMode(motorPin4, OUTPUT);
 
}


// Inicializamos o bucle de traballo 

void loop(){

  // Recollemos o toldo sempre que chova e non esté previamente recollido
  
  valor1 = digitalRead(pinsensorchoiva);  //lectura digital do pin do sensor da choiva
  valor2 = digitalRead(pinfinaldecarreira);  //lectura digital do pin do final de carreira que indicaría toldo recollido
 
  //mandamos unha mensaxe ó porto serie en función do valor lido
  if ((valor1 == LOW) && (valor2 == HIGH)) {
    Serial.println("Esta chovendo e o toldo sen recoller, recollemolo");
      // Normalmente os motores de toldo levan un final de carreira para non seguir traballando cando cando fixeron o ciclo completo
      // Comprobamos tamén que o final de carreira non esté activo, nese caso indicaría que o toldo xa está recollido  
      //Activamos o motor paso a paso do toldo para simular que o recollemos
    for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    clockwise1();
    delayMicroseconds(motorSpeed1);
  }
    for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    anticlockwise1();
    delayMicroseconds(motorSpeed1);
  }
  }
  
  else if ((valor1 == LOW) && (valor2 == LOW)) {
    Serial.println("Esta chovendo e o toldo recollido");
      // Normalmente os motores de toldo levan un final de carreira para non seguir traballando cando cando fixeron o ciclo completo
      // Comprobamos tamén que o final de carreira non esté activo. Se xa está activo indicará que o toldo xa está recollido  
     
  }
  
  else  {
    
    Serial.println("Non chove");
  }
   // Repetimos 1 vez por segundo (cada 1000ms)
  delay(1000);
  


  // Comprobamos o valor de humidade do chan no xardín. Se está seco regamos, e se está húmido non regamos

  valor3 = digitalRead(pinsensorhumidadechanxardin);  //lectura digital do pin do sensor de humidade do chan

  //mandamos unha mensaxe ó porto serie en función do valor lido
  if (valor3 == HIGH) {
      Serial.println("O xardin esta seco, temos que regalo");
      
    //Activamos a bomba de rego
   digitalWrite(pinbombarego, HIGH);   
   delay(1000);               // mantémola encendida un segundo
  }
  else  {
    
    Serial.println("O xardin esta humido, non fai falla regar");
    digitalWrite(pinbombarego, LOW);  
  }
   // Repetimos 1 vez por segundo (cada 1000ms)
  delay(1000);   
}



/*
Definimos o traballo do motor paso a paso do toldo exterior. 
Nesta práctica básica non distinquimos o sentido correcto do movemento, se fose un toldo real empregaríamos 
o sentido horario para recoller o toldo e o sentido antihorario para desplegar o toldo
*/

void clockwise1()
{
  stepCounter1++;
  if (stepCounter1 >= numSteps1) stepCounter1 = 0;
  setOutput1(stepCounter1);
}
 
void anticlockwise1()
{
  stepCounter1--;
  if (stepCounter1 < 0) stepCounter1 = numSteps1 - 1;
  setOutput1(stepCounter1);
}
 
void setOutput1(int step)
{
  digitalWrite(motorPin1, bitRead(stepsLookup1[step], 0));
  digitalWrite(motorPin2, bitRead(stepsLookup1[step], 1));
  digitalWrite(motorPin3, bitRead(stepsLookup1[step], 2));
  digitalWrite(motorPin4, bitRead(stepsLookup1[step], 3));
}
