
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////  PROGRAMA CONTROL DE GASES   /////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*Neste programa controlaremos dous sensores de gases diferentes, moveremos as lamas de ventilación da cociña ou do garaxe dependendo do tipo de gas detectado.
A práctica facémola co gas inflamable dun chisqueiro, pero valería para a realizade do gas butano, propano, metano e monóxido de carbono*/



// Pins de Arduino onde conectamos a patilla D0 (dixital) dos módulos detectores de gases
#define GAS_METANO  A1
#define GAS_MONOXIDO A2


//definicion dos pins motor paso a paso cociña
const int motorPin1 = 3;    // 28BYJ48 In1
const int motorPin2 = 4;    // 28BYJ48 In2
const int motorPin3 = 5;   // 28BYJ48 In3
const int motorPin4 = 6;   // 28BYJ48 In4

//definicion dos pins motor paso a paso garaxe
const int motorPin5 = 7;    // 28BYJ48 In1
const int motorPin6 = 8;    // 28BYJ48 In2
const int motorPin7 = 10;   // 28BYJ48 In3
const int motorPin8 = 11;   // 28BYJ48 In4
                   
//definicion variables motores paso a paso
int motorSpeed1 = 1200;   //variable para fixar a velocidade
int motorSpeed2 = 1200;   //variable para fixar a velocidade
int stepCounter1 = 0;     // contador para os pasos
int stepCounter2 = 0;     // contador para os pasos
int stepsPerRev1 = 800;  // pasos para unha volta pequena
int stepsPerRev2 = 800;  // pasos para unha volta pequena
//int stepsPerRev = 4076;  // pasos para unha volta completa
 
//tablas coa secuencia de encendido (descomentamos a que necesitemos)
//secuencia 1-fase
//const int numSteps = 4;
//const int stepsLookup[4] = { B1000, B0100, B0010, B0001 };
 
//secuencia 2-fases
//const int numSteps = 4;
//const int stepsLookup[4] = { B1100, B0110, B0011, B1001 };
 
//secuencia media fase. Esta é a que mellor nos vai para o noso modelo de motor
const int numSteps1 = 8;
const int stepsLookup1[8] = { B1000, B1100, B0100, B0110, B0010, B0011, B0001, B1001 };
const int numSteps2 = 8;
const int stepsLookup2[8] = { B1000, B1100, B0100, B0110, B0010, B0011, B0001, B1001 };




void setup() {
  
  // Inicializamos o pin de cada detector de gases como entrada
  pinMode(GAS_METANO, INPUT);
  pinMode(GAS_MONOXIDO, INPUT);

  //Mostramos no monitor serie os detectores que se empregan
  Serial.begin(9600);
  Serial.println("Deteccion de gases con sensores MQ. O sensor MQ-2 indícanos a presenza de butano ou propano. O sensor MQ-9 indícanos a presenza de monóxido de carbono");


  
  //declaramos os pins dos motores paso a paso como saídas
  pinMode(motorPin1, OUTPUT);
  pinMode(motorPin2, OUTPUT);
  pinMode(motorPin3, OUTPUT);
  pinMode(motorPin4, OUTPUT);
  pinMode(motorPin5, OUTPUT);
  pinMode(motorPin6, OUTPUT);
  pinMode(motorPin7, OUTPUT);
  pinMode(motorPin8, OUTPUT);

}


void loop() {
  

 
   // Lemos o estado do módulo detector de gas metano ou gas cidade
   int digitalNew2 = digitalRead(GAS_METANO);

  // Si o estado do módulo es =0 implica que detecta gas, o estado normal es =1
  if (digitalNew2 == 0) {
    
   
    Serial.println("GAS CIDADE");  //texto que queremos mostrar
    Serial.println("PERIGO");  //texto que queremos mostrar
    
   
    
    //Activamos o motor paso a paso da  cociña por existir gas cidade
    for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    clockwise1();
    delayMicroseconds(motorSpeed1);
  }
  for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    anticlockwise1();
    delayMicroseconds(motorSpeed1);
  }
  delay(10);
  
  }
  else  {
   
    Serial.println("Detectando gases con sensores MQ");
  }
   // Repetimos 1 vez por segundo (cada 1000ms)
  delay(1000);
  
   
    // Lemos o estado do módulo detector de gas monóxido de carbono
    int digitalNew3 = digitalRead(GAS_MONOXIDO);

  // Se o estado do módulo é =0 implica que detecta gas, o estado normal é =1
  if (digitalNew3 == 0) {
   
    
    Serial.println("GAS CO");  //texto que queremos mostrar
    Serial.println("PELIGRO");  //texto que queremos mostrar
    
   

    //Activamos o motor paso a paso da porta do garage por existir monóxido
    for (int i = 0; i < stepsPerRev2 * 1; i++)
  {
    clockwise2();
    delayMicroseconds(motorSpeed2);
  }
  for (int i = 0; i < stepsPerRev2 * 1; i++)
  {
    anticlockwise2();
    delayMicroseconds(motorSpeed2);
  }
  delay(10);
  
  }
  else  {
    
    Serial.println("Detectando gases con sensores MQ");
  }
  // Repetimos 1 vez por segundo (cada 1000ms)
  delay(1000);
  




}

//Definimos o traballo do motor paso a paso da cociña
void clockwise1()
{
  stepCounter1++;
  if (stepCounter1 >= numSteps1) stepCounter1 = 0;
  setOutput1(stepCounter1);
}
 
void anticlockwise1()
{
  stepCounter1--;
  if (stepCounter1 < 0) stepCounter1 = numSteps1 - 1;
  setOutput1(stepCounter1);
}

//Definimos o traballo do motor paso a paso do garaxe
void clockwise2()
{
  stepCounter2++;
  if (stepCounter2 >= numSteps2) stepCounter2 = 0;
  setOutput2(stepCounter2);
}
 
void anticlockwise2()
{
  stepCounter2--;
  if (stepCounter2 < 0) stepCounter2 = numSteps2 - 1;
  setOutput2(stepCounter2);
}
 
void setOutput1(int step)
{
  digitalWrite(motorPin1, bitRead(stepsLookup1[step], 0));
  digitalWrite(motorPin2, bitRead(stepsLookup1[step], 1));
  digitalWrite(motorPin3, bitRead(stepsLookup1[step], 2));
  digitalWrite(motorPin4, bitRead(stepsLookup1[step], 3));
  
}

void setOutput2(int step)
{
 
  digitalWrite(motorPin5, bitRead(stepsLookup2[step], 0));
  digitalWrite(motorPin6, bitRead(stepsLookup2[step], 1));
  digitalWrite(motorPin7, bitRead(stepsLookup2[step], 2));
  digitalWrite(motorPin8, bitRead(stepsLookup2[step], 3));
}
