
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////   PROGRAMA CONTROL PORTÓN GARAXE   ///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/* Neste programa controlaremos o acceso ó garaxe. Empregaremos un lector RFID-RC552, semellante ó que se emprega por exemplo nas portas dos hoteis.
Cun motor paso a paso abriremos a porta do garaxe sempre que a tarxeta de acceso sexa a válida.
Ademáis dispomos dun sensor de infravermellos para medir distancias que parará o movemento da porta do garaxe, se detecta obstáculos no seu campo de medición.
E tamén dun final de carreira que paralizará o funcionamento do motor da porta no sentido de apertura cando se atope totalmente aberta, e iniciará o movemento
no sentido contrario para pechala*/

// Para poder empregar os lectores de tarxetas RFID temos que incluir as seguintes librerías
 

#include <SPI.h>
#include <MFRC522.h>
#include <deprecated.h>
#include <MFRC522.h>
#include <require_cpp11.h>
#include <MFRC522Extended.h>

/*Para os arduinos UNO e NANO xa veñen definidos na librería os pins a empregar para conectar cada un dos sinais de comunicación
RST co pin D9
SS ou SDA  co pin D10
MOSI co pin D11
MISO co pin D12
SCK co pin D13
*/

//Poderíanse modificar os pins anteriormente definidos, neste caso temos que facelo xa que empregamos un arduino mega

const int RST_PIN = 7; // Pin 7 para o reset do RC522, poderíamos poñer outro
const int SS_PIN = 53; // Pin 53 para o SS (SDA) do RC522
const int MOSI_PIN = 51; // Pin 51 para o MOSI do RC522
const int MISO_PIN = 50; // Pin 50 para o MISO do RC522
const int SCK_PIN = 52; // Pin 52 para o SCK do RC522




//Definimos o funcionamento do lector cos seus pins

MFRC522 mfrc522(SS_PIN, RST_PIN);

byte readUID[4]; // Almacena o tag lido   

byte validKey1[4] = { 0x5B, 0xDE, 0xB6, 0x15}; //Estes son os datos da nosa tarxeta que comprobamos nunha leitura anterior. 

// Xa se viu tamén ese programa de lectura previa. Cada tarxeta ten un código que a define. Neste caso para o garaxe empregaremos a tarxeta de tipo chaveiro

bool isEqualArray(byte arrayA[], byte arrayB[], int length)
{
for (int index = 0; index < length; index++)
{
if (arrayA[index] != arrayB[index]) return false;
}
return true;
}



//Definimos os leds a empregar como sinalización de acceso. Neste caso non resultan imprescindibles, pero servennos de axuda para facer probas 
//Polo que collemos 2 pins que están libres na distrubución feita 

int ledverde = 3;
int ledvermello = 4;

//Definimos os pins motor paso a paso que abrirá o portón do garaxe
const int motorPin1 = 23;    // 28BYJ48 In1
const int motorPin2 = 25;    // 28BYJ48 In2
const int motorPin3 = 27;   // 28BYJ48 In3
const int motorPin4 = 29;   // 28BYJ48 In4. Nestes pins temos que ter coidado de non empregar ningún dos que 
//trae previstos a librería RFID para os sinais MOSI, MISI e SCK posto que nese caso non funcionará o motor e por iso non empregaremos o 11 

//definicion variables motores paso a paso

int motorSpeed1 = 1200;   //variable para fixar a velocidade, nas fiestras puxemos 1200, pero ó tratarse dun portón de garaxe baixamos ata 800
int stepCounter1 = 0;     // contador para os pasos
int stepsPerRev1 = 2000;  // pasos para unha volta intermedia, evitando así chegar a volta completa
//int stepsPerRev = 4076;  // pasos para unha volta completa
 
//tablas coa secuencia de encendido (descomentamos a que necesitemos)
//secuencia 1-fase
//const int numSteps1 = 4;
//const int stepsLookup1[4] = { B1000, B0100, B0010, B0001 };
 
//secuencia 2-fases
//const int numSteps1 = 4;
//const int stepsLookup1[4] = { B1100, B0110, B0011, B1001 };
 
//secuencia media fase. Esta é a que mellor nos vai para o noso modelo de motor
const int numSteps1 = 8;
const int stepsLookup1[8] = { B1000, B1100, B0100, B0110, B0010, B0011, B0001, B1001 };



//Definimos o final de carreira que paralizará o motor da porta do garaxe cando esté rematado o recorrido desta

const int fc = 5;

//Definimos o valor do sensor fc como enteiro

int valor1=0;


//Definimos o sensor de infravermellos que paralizará o motor da porta do garaxe cando detecte algún obxecto

int infravermellos = 6;

//Definimos o valor do sensor infravermellos como enteiro

int valor2=0;





void setup() 
{
Serial.begin(9600); // Inicializamos a comunicación serie
SPI.begin(); // Inicializamos o SPI
mfrc522.PCD_Init(); // Inicializamos o lector RFID MFRC522
Serial.println("Inicializamos lector");

//Declaramos os leds como saídas
pinMode(ledverde, OUTPUT);
pinMode(ledvermello, OUTPUT);

//Declaramos o final de carreira como entrada pull-up

pinMode(fc, INPUT_PULLUP);

//Declaramos o sensor de infravermellos como entrada pull-up

pinMode(infravermellos, INPUT);


//declaramos os pins dos motores paso a paso como saídas
  pinMode(motorPin1, OUTPUT);
  pinMode(motorPin2, OUTPUT);
  pinMode(motorPin3, OUTPUT);
  pinMode(motorPin4, OUTPUT);


}



void loop() 
{


//Indicamos que valor1 será a lectura do final de carreira

valor1 = digitalRead(fc);

//Indicamos que valor2 será a lectura do sensor de infravermellos

valor2 = digitalRead(infravermellos);

//Soamente se encenderan os leds, mostraranse as mensaxes de tarxerta válida ou inválida, ou arrancará o motor do portón cando aproximemos unha tarxeta RFID ó lector

if (mfrc522.PICC_IsNewCardPresent())

 Serial.println("Tarjeta detectada");
  

//leremos o código de identificación da tarxeta 

{
  if (mfrc522.PICC_ReadCardSerial())
{
if ((isEqualArray(mfrc522.uid.uidByte, validKey1, 4))&&(valor1==HIGH)&&(valor2==HIGH))
// Se o código da tarxeta é o mesmo que o da tarxeta que temos asignada, e non se activa o final de carreira, nin o sensor de infravermellos; 
// entón diranos que é válida, activarase o motor e prenderá o led verde

{ 

  Serial.println("Tarjeta valida");
  Serial.println("E sensores correctos, hai que abrir o portón");
  digitalWrite(ledverde, HIGH);

 //Activamos o motor paso a paso para abrir o portón do garaxe por ser a tarxeta de acceso válida
 //e non estar acitivos nin o final de carreira, nin o sensor de infravermellos
    
    for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    clockwise1();
    delayMicroseconds(motorSpeed1);
  }

}

 
else if 
((isEqualArray(mfrc522.uid.uidByte, validKey1, 4))&&(valor1==LOW)&&(valor2==HIGH))
// Se o código da tarxeta é o mesmo que o da tarxeta que temos asignada, e se activa o final de carreira, pero non o sensor infravermellos;
// entón diranos que é válida,  prenderá o led verde, e arrancará o motor no sentido de baixada

{
  Serial.println("Tarjeta valida");
  Serial.println("O final de carreira está activo, hai que cerrar o portón");
  digitalWrite(ledverde, HIGH);

    for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    anticlockwise1();
    delayMicroseconds(motorSpeed1);
  }
}

else if 
((isEqualArray(mfrc522.uid.uidByte, validKey1, 4))&&(valor1==HIGH)&&(valor2==LOW))
// Se o código da tarxeta é o mesmo que o da tarxeta que temos asignada, se activa o sensor de infravermellos, e non o fai o 
// final de carreira; entón diranos que é válida,  prenderá o led vermello, pero non se moverá o motor

{
  Serial.println("Tarjeta valida");
  Serial.println("O sensor de infravermellos está activo, hai que parar o motor");
  digitalWrite(ledvermello, HIGH);

}


else {

 {Serial.println("Tarjeta invalida");// Se o código da tarxeta non é o mesmo que o da tarxeta que temos asignada diranos que é inválida e prenderá o led vermello
 digitalWrite(ledvermello, HIGH);}

mfrc522.PICC_HaltA(); // Finalizamos o lector
}
}
}
delay(300); 

digitalWrite(ledverde, LOW); // Antes de rematar o ciclo apagamos os leds para evitar erros con lecturas de tarxetas posteriores
digitalWrite(ledvermello, LOW);



}






//Definimos o traballo do motor paso a paso do portón do garaxe
void clockwise1()
{
  stepCounter1++;
  if (stepCounter1 >= numSteps1) stepCounter1 = 0;
  setOutput1(stepCounter1);
}
 
void anticlockwise1()
{
  stepCounter1--;
  if (stepCounter1 < 0) stepCounter1 = numSteps1 - 1;
  setOutput1(stepCounter1);
}

void setOutput1(int step)
{
  digitalWrite(motorPin1, bitRead(stepsLookup1[step], 0));
  digitalWrite(motorPin2, bitRead(stepsLookup1[step], 1));
  digitalWrite(motorPin3, bitRead(stepsLookup1[step], 2));
  digitalWrite(motorPin4, bitRead(stepsLookup1[step], 3));
  
}
