
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////   PROGRAMA CONTROL MOTOR PASO A PASO  /////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



//Definimos os pins motor paso a paso para abrir un portón de garaxe por exemplo
const int motorPin1 = 8;    // 28BYJ48 In1
const int motorPin2 = 9;    // 28BYJ48 In2
const int motorPin3 = 10;   // 28BYJ48 In3
const int motorPin4 = 11;   // 28BYJ48 In4

//definicion variables motores paso a paso

int motorSpeed1 = 1200;   // variable para fixar a velocidade, ó tratarse dun portón de garaxe supoñemos ata 800
int stepCounter1 = 0;     // contador para os pasos
int stepsPerRev1 = 700;  // pasos para unha volta pequeña, evidenciando así o movemento

//int stepsPerRev = 4076;  // pasos para unha volta completa
 
//tablas coa secuencia de encendido (descomentamos a que necesitemos)
//secuencia 1-fase
//const int numSteps1 = 4;
//const int stepsLookup1[4] = { B1000, B0100, B0010, B0001 };
 
//secuencia 2-fases
//const int numSteps1 = 4;
//const int stepsLookup1[4] = { B1100, B0110, B0011, B1001 };
 
//secuencia media fase. Esta é a que mellor nos vai para o noso modelo de motor
const int numSteps1 = 8;
const int stepsLookup1[8] = { B1000, B1100, B0100, B0110, B0010, B0011, B0001, B1001 };




void setup() 
{
Serial.begin(9600); // Inicializamos a comunicación serie


//declaramos os pins dos motores paso a paso como saídas
  pinMode(motorPin1, OUTPUT);
  pinMode(motorPin2, OUTPUT);
  pinMode(motorPin3, OUTPUT);
  pinMode(motorPin4, OUTPUT);

}


void loop() 
{    
    for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    clockwise1();
    delayMicroseconds(motorSpeed1);
  }
  for (int i = 0; i < stepsPerRev1 * 1; i++)
  {
    anticlockwise1();
    delayMicroseconds(motorSpeed1);
  }
delay(300); 

}




//Definimos o traballo do motor paso a paso 

void clockwise1()
{
  stepCounter1++;
  if (stepCounter1 >= numSteps1) stepCounter1 = 0;
  setOutput1(stepCounter1);
}
 
void anticlockwise1()
{
  stepCounter1--;
  if (stepCounter1 < 0) stepCounter1 = numSteps1 - 1;
  setOutput1(stepCounter1);
}

void setOutput1(int step)
{
  digitalWrite(motorPin1, bitRead(stepsLookup1[step], 0));
  digitalWrite(motorPin2, bitRead(stepsLookup1[step], 1));
  digitalWrite(motorPin3, bitRead(stepsLookup1[step], 2));
  digitalWrite(motorPin4, bitRead(stepsLookup1[step], 3));
  
}
