////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////  Programa control iluminación exterior co luxómetro  ///////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////


//----------------------Engadimos as librerías-------------------------//

// Os sensores de luminosidade TSL2560, TSL2561, GY-302 e semellantes traballan no bus I2C, 
// e polo tanto precisan a librería Wire

// No noso curso temos o modelo BH1750 en concreto, por iso temos que engadir unha libreria para el
#include <Wire.h>
#include <BH1750.h>

BH1750 Luxometro; // Damoslle o nome de luxómetro, sensor,... ou como queiramos denominar o noso dispositivo

//--------- Tomamos unhas referencias para a luminosidade de día e de noite ---------//

int Lux_noite=20;
int Lux_dia=30;

//--------- Indicamos que saída tomaremos para controlar o alumeado exterior---------//

int pinFoco=13;

// Bucle de inicio, precisamos inicializar a comunicación serie e o sensor neste bucle e declarar como saída o pin para o alumeado

void setup(){
  Serial.begin(9600);
  Wire.begin();
  Serial.println("Inicializando sensor...");
  Luxometro.begin(); //inicializamos o sensor
  pinMode(pinFoco, OUTPUT);
  digitalWrite(pinFoco, LOW);
}

// Bucle de traballo, creamos unha función coa lectura do sensor e mostramola no monitor serie
// E a continuación facemos unha comparativa para encender ou apagar os focos do alumeado exterior só de noite

void loop() {
  int lux = Luxometro.readLightLevel();//Realizamos unha lectura do sensor
  Serial.print("Luz(iluminancia):  ");
  Serial.print(lux);
  Serial.println(" lx");
   if(lux<Lux_noite) 
  {
      digitalWrite(pinFoco, HIGH);
      Serial.println(" Noite  - Alumeado Encendido");
  }
  else if(lux>Lux_dia)
  {
      digitalWrite(pinFoco, LOW);
      Serial.println(" Dia - Alumeado Apagado");
  }
  delay(500);
}
  
