/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.appinventor.ble;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.ParcelUuid;
import android.text.TextUtils;
import android.util.Log;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.errors.IllegalArgumentError;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;
import edu.mit.appinventor.ble.BLEUtil;
import edu.mit.appinventor.ble.BluetoothLE;
import edu.mit.appinventor.ble.BluetoothLEGattAttributes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BluetoothLEint {
    BluetoothLE outer;
    ComponentContainer container;
    private static final String LOG_TAG = "BluetoothLEint";
    private static final Map<Integer, String> errorMessages = new HashMap<Integer, String>();
    private static final int ERROR_BLUETOOTH_LE_NOT_SUPPORTED = 9001;
    private static final int ERROR_BLUETOOTH_LE_NOT_ENABLED = 9002;
    private static final int ERROR_API_LEVEL_TOO_LOW = 9003;
    private static final int ERROR_NO_DEVICE_SCAN_IN_PROGRESS = 9004;
    private static final int ERROR_NOT_CURRENTLY_CONNECTED = 9005;
    private static final int ERROR_INDEX_OUT_OF_BOUNDS = 9006;
    private static final int ERROR_DEVICE_LIST_EMPTY = 9007;
    private static final int ERROR_INVALID_UUID_CHARACTERS = 9008;
    private static final int ERROR_INVALID_UUID_FORMAT = 9009;
    private static final int ERROR_ADVERTISEMENTS_NOT_SUPPORTED = 9010;
    private static final String BLUETOOTH_BASE_UUID_SUFFIX = "-0000-1000-8000-00805F9B34FB";
    private static final String UNKNOWN_SERVICE_NAME = "Unknown Service";
    private static final String UNKNOWN_CHAR_NAME = "Unknown Characteristic";
    private static final int GATT_LINK_LOSS = 8;
    private final Activity activity;
    private BluetoothLeScanner mBluetoothLeDeviceScanner = null;
    private BluetoothGatt mBluetoothGatt;
    private int device_rssi = 0;
    private final Handler uiThread;
    private volatile int connectionTimeout = 10;
    private boolean autoReconnect = false;
    private final Map<UUID, List<BLEOperation>> pendingOperationsByUuid = new HashMap<UUID, List<BLEOperation>>();
    private final Queue<BLEOperation> pendingOperations = new LinkedList<BLEOperation>();
    private ScanCallback mDeviceScanCallback;
    private BluetoothGattCallback mGattCallback;
    private ScanCallback mAdvertisementScanCallback;
    private AdvertiseCallback mAdvertiseCallback;
    private HashMap<String, BluetoothGatt> gattMap;
    private String deviceInfoList = "";
    private List<BluetoothDevice> mLeDevices;
    private List<BluetoothGattService> mGattService;
    private ArrayList<BluetoothGattCharacteristic> gattChars;
    private String serviceUUIDList;
    private String charUUIDList;
    private BluetoothGattCharacteristic mGattChar;
    private HashMap<BluetoothDevice, Integer> mLeDeviceRssi;
    private boolean isScanning = false;
    private volatile boolean isConnected = false;
    private volatile boolean isUserDisconnect = false;
    private boolean isCharRead = false;
    private boolean isCharWritten = false;
    private boolean isServiceRead = false;
    private int battery = -1;
    private int txPower = -1;
    private byte[] data;
    private byte[] descriptorValue;
    private int intValue = 0;
    private float floatValue = 0.0f;
    private String stringValue = "";
    private String byteValue = "";
    private int intOffset = 0;
    private int strOffset = 0;
    private int floatOffset = 0;
    private CharType charType = CharType.BYTE;
    private BluetoothLeScanner mBluetoothLeAdvertisementScanner;
    private Handler mHandler = new Handler();
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private long SCAN_PERIOD = 5000L;
    private String advertisementScanResult = "";
    private List<String> scannedAdvertiserNames = new ArrayList<String>();
    private HashMap<String, ScanResult> scannedAdvertisers = new HashMap();
    private List<String> advertiserAddresses = new ArrayList<String>();
    private HashMap<String, String> nameToAddress = new HashMap();
    private boolean isAdvertising = false;

    BluetoothLEint(BluetoothLE outer, Activity activity, ComponentContainer container) {
        this.outer = outer;
        this.activity = activity;
        this.container = container;
        this.mLeDevices = new ArrayList<BluetoothDevice>();
        this.mGattService = new ArrayList<BluetoothGattService>();
        this.gattChars = new ArrayList();
        this.mLeDeviceRssi = new HashMap();
        this.gattMap = new HashMap();
        this.uiThread = new Handler();
        this.mDeviceScanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, final ScanResult scanResult) {
                super.onScanResult(callbackType, scanResult);
                if (scanResult == null || scanResult.getDevice() == null) {
                    return;
                }
                BluetoothLEint.this.uiThread.post(new Runnable(){

                    public void run() {
                        BluetoothLEint.this.isScanning = true;
                        BluetoothLEint.this.addDevice(scanResult.getDevice(), scanResult.getRssi());
                    }
                });
            }

            public void onBatchScanResults(List<ScanResult> results) {
                super.onBatchScanResults(results);
            }

            public void onScanFailed(int errorCode) {
                switch (errorCode) {
                    case 1: {
                        Log.e((String)BluetoothLEint.LOG_TAG, (String)"Device Scan failed. There is already a scan in progress.");
                        break;
                    }
                    default: {
                        BluetoothLEint.this.isScanning = false;
                        Log.e((String)BluetoothLEint.LOG_TAG, (String)("Device Scan failed due to an internal error. Error Code: " + errorCode));
                    }
                }
                super.onScanFailed(errorCode);
            }
        };
        this.mGattCallback = new BluetoothGattCallback(){

            public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                if (gatt != BluetoothLEint.this.mBluetoothGatt) {
                    return;
                }
                if (newState == 2) {
                    gatt.discoverServices();
                    gatt.readRemoteRssi();
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Connect successful.");
                } else if (newState == 0) {
                    BluetoothLEint.this.isConnected = false;
                    if (!BluetoothLEint.this.autoReconnect || BluetoothLEint.this.isUserDisconnect) {
                        BluetoothLEint.this.mBluetoothGatt.close();
                        BluetoothLEint.this.mBluetoothGatt = null;
                        BluetoothLEint.this.isUserDisconnect = false;
                    } else {
                        BluetoothLEint.this.mBluetoothGatt.connect();
                    }
                    BluetoothLEint.this.Disconnected();
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Disconnect successful.");
                }
                if (!(status == 0 || BluetoothLEint.this.isConnected || status == 8 && BluetoothLEint.this.autoReconnect)) {
                    BluetoothLEint.this.outer.ConnectionFailed("Connection status was set to OS code " + status);
                }
                Log.i((String)BluetoothLEint.LOG_TAG, (String)("onConnectionStateChange fired with status: " + status));
                Log.i((String)BluetoothLEint.LOG_TAG, (String)("onConnectionStateChange fired with newState: " + newState));
            }

            public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                if (status == 0) {
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Services Discovered!");
                    BluetoothLEint.this.mGattService = gatt.getServices();
                    BluetoothLEint.this.isServiceRead = true;
                    BluetoothLEint.this.isConnected = true;
                    BluetoothLEint.this.pendingOperationsByUuid.clear();
                    BluetoothLEint.this.pendingOperations.clear();
                    BluetoothLEint.this.Connected();
                } else {
                    BluetoothLEint.this.outer.ConnectionFailed("Service discovery failed with OS code " + status);
                }
                Log.i((String)BluetoothLEint.LOG_TAG, (String)("onServicesDiscovered fired with status: " + status));
            }

            public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                if (BluetoothLEint.this.pendingOperationsByUuid.containsKey(characteristic.getUuid())) {
                    Log.d((String)BluetoothLEint.LOG_TAG, (String)("onCharacteristicRead: " + characteristic.getUuid()));
                    ArrayList operations = new ArrayList((Collection)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid()));
                    for (BLEOperation operation : operations) {
                        operation.onCharacteristicRead(gatt, characteristic, status);
                    }
                }
            }

            public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                if (BluetoothLEint.this.pendingOperationsByUuid.containsKey(characteristic.getUuid())) {
                    Log.d((String)BluetoothLEint.LOG_TAG, (String)"onCharacteristicRead");
                    ArrayList operations = new ArrayList((Collection)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid()));
                    for (BLEOperation operation : operations) {
                        operation.onCharacteristicChanged(gatt, characteristic);
                    }
                }
            }

            public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                if (BluetoothLEint.this.pendingOperationsByUuid.containsKey(characteristic.getUuid())) {
                    ArrayList operations = new ArrayList((Collection)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid()));
                    for (BLEOperation operation : operations) {
                        operation.onCharacteristicWrite(gatt, characteristic, status);
                    }
                }
            }

            public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
                BluetoothLEint.access$2002(BluetoothLEint.this, descriptor.getValue());
                BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
                if (BluetoothLEint.this.pendingOperationsByUuid.containsKey(characteristic.getUuid())) {
                    Log.d((String)BluetoothLEint.LOG_TAG, (String)"onDescriptorRead");
                    ArrayList operations = new ArrayList((Collection)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid()));
                    for (BLEOperation operation : operations) {
                        operation.onDescriptorRead(gatt, descriptor, status);
                    }
                    return;
                }
            }

            public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
                Log.i((String)BluetoothLEint.LOG_TAG, (String)"Write Descriptor Successfully.");
                BluetoothGattCharacteristic characteristic = descriptor.getCharacteristic();
                if (BluetoothLEint.this.pendingOperationsByUuid.containsKey(characteristic.getUuid())) {
                    Log.d((String)BluetoothLEint.LOG_TAG, (String)"onDescriptorWrite");
                    ArrayList operations = new ArrayList((Collection)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid()));
                    for (BLEOperation operation : operations) {
                        operation.onDescriptorWrite(gatt, descriptor, status);
                    }
                    return;
                }
            }

            public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
                BluetoothLEint.this.device_rssi = rssi;
                BluetoothLEint.this.RssiChanged(BluetoothLEint.this.device_rssi);
            }
        };
        this.mAdvertisementScanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                super.onScanResult(callbackType, result);
                if (result == null || result.getDevice() == null || TextUtils.isEmpty((CharSequence)result.getDevice().getName())) {
                    return;
                }
                String advertiserAddress = result.getDevice().getAddress();
                String advertiserName = result.getDevice().getName();
                BluetoothLEint.this.advertiserAddresses.add(advertiserAddress);
                BluetoothLEint.this.scannedAdvertisers.put(advertiserAddress, result);
                BluetoothLEint.this.scannedAdvertiserNames.add(advertiserName);
                BluetoothLEint.this.nameToAddress.put(advertiserName, advertiserAddress);
            }

            public void onBatchScanResults(List<ScanResult> results) {
                super.onBatchScanResults(results);
            }

            public void onScanFailed(int errorCode) {
                Log.e((String)BluetoothLEint.LOG_TAG, (String)("Advertisement onScanFailed: " + errorCode));
                super.onScanFailed(errorCode);
            }
        };
    }

    boolean isScanning() {
        return this.isScanning;
    }

    void StartScanning() {
        new BLEAction<Void>("StartScanning"){

            @Override
            public Void action() {
                BluetoothAdapter btAdapter;
                if (!BluetoothLEint.this.mLeDevices.isEmpty()) {
                    BluetoothLEint.this.mLeDevices.clear();
                    BluetoothLEint.this.mLeDeviceRssi.clear();
                }
                if ((btAdapter = this.obtainBluetoothAdapter()) != null) {
                    BluetoothLEint.this.mBluetoothLeDeviceScanner = btAdapter.getBluetoothLeScanner();
                    ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
                    ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                    ScanFilter filter = new ScanFilter.Builder().build();
                    filters.add(filter);
                    BluetoothLEint.this.mBluetoothLeDeviceScanner.startScan(filters, settings, BluetoothLEint.this.mDeviceScanCallback);
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"StartScanning successful.");
                }
                return null;
            }
        }.run();
    }

    void StopScanning() {
        new BLEAction<Void>("StopScanning"){

            @Override
            public Void action() {
                if (BluetoothLEint.this.mBluetoothLeDeviceScanner != null) {
                    BluetoothLEint.this.mBluetoothLeDeviceScanner.stopScan(BluetoothLEint.this.mDeviceScanCallback);
                    BluetoothLEint.this.isScanning = false;
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"StopScanning successful.");
                } else {
                    BluetoothLEint.this.signalError("StopScanning", 9004, new Object[0]);
                }
                return null;
            }
        }.run();
    }

    void Connect(final int index) {
        if (index < 1 || index > this.mLeDevices.size()) {
            this.outer.ConnectionFailed("Invalid index provided to Connect");
            throw new IndexOutOfBoundsException("Expected device index between 1 and " + this.mLeDevices.size());
        }
        new BLEAction<Void>("Connect"){

            @Override
            public Void action() {
                try {
                    if (BluetoothLEint.this.mBluetoothLeAdvertisementScanner != null) {
                        BluetoothLEint.this.mBluetoothLeAdvertisementScanner.stopScan(BluetoothLEint.this.mDeviceScanCallback);
                        BluetoothLEint.this.isScanning = false;
                    }
                    if (!BluetoothLEint.this.mLeDevices.isEmpty()) {
                        BluetoothLEint.this.forceDisconnect();
                        BluetoothLEint.this.mBluetoothGatt = ((BluetoothDevice)BluetoothLEint.this.mLeDevices.get(index - 1)).connectGatt((Context)BluetoothLEint.this.activity, BluetoothLEint.this.autoReconnect, BluetoothLEint.this.mGattCallback);
                        if (BluetoothLEint.this.mBluetoothGatt != null) {
                            BluetoothLEint.this.gattMap.put(((BluetoothDevice)BluetoothLEint.this.mLeDevices.get(index - 1)).toString(), BluetoothLEint.this.mBluetoothGatt);
                            BluetoothLEint.this.scheduleConnectionTimeoutMessage();
                        } else {
                            BluetoothLEint.this.outer.ConnectionFailed("Connect failed to return a BluetoothGatt object");
                            Log.e((String)BluetoothLEint.LOG_TAG, (String)"Connect failed.");
                        }
                    } else {
                        BluetoothLEint.this.outer.ConnectionFailed("Device list was empty");
                        BluetoothLEint.this.signalError("Connect", 9007, new Object[0]);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    BluetoothLEint.this.outer.ConnectionFailed(e.getMessage());
                    BluetoothLEint.this.signalError("Connect", 9006, new Object[]{"Connect", "DeviceList"});
                }
                return null;
            }
        }.run();
    }

    void ConnectWithAddress(final String address) {
        new BLEAction<Void>("ConnectWithAddress"){

            @Override
            public Void action() {
                try {
                    if (BluetoothLEint.this.mBluetoothLeAdvertisementScanner != null) {
                        BluetoothLEint.this.mBluetoothLeAdvertisementScanner.stopScan(BluetoothLEint.this.mDeviceScanCallback);
                        BluetoothLEint.this.isScanning = false;
                    }
                    if (!BluetoothLEint.this.mLeDevices.isEmpty()) {
                        for (BluetoothDevice bluetoothDevice : BluetoothLEint.this.mLeDevices) {
                            if (!bluetoothDevice.getAddress().equals(address)) continue;
                            BluetoothLEint.this.forceDisconnect();
                            BluetoothLEint.this.mBluetoothGatt = bluetoothDevice.connectGatt((Context)BluetoothLEint.this.activity, BluetoothLEint.this.autoReconnect, BluetoothLEint.this.mGattCallback);
                            if (BluetoothLEint.this.mBluetoothGatt != null) {
                                BluetoothLEint.this.gattMap.put(bluetoothDevice.getAddress(), BluetoothLEint.this.mBluetoothGatt);
                                BluetoothLEint.this.scheduleConnectionTimeoutMessage();
                                Log.i((String)BluetoothLEint.LOG_TAG, (String)"ConnectWithAddress successful.");
                                return null;
                            }
                            BluetoothLEint.this.outer.ConnectionFailed("Connect failed to return a BluetoothGatt object");
                            Log.e((String)BluetoothLEint.LOG_TAG, (String)"ConnectWithAddress failed.");
                        }
                        BluetoothLEint.this.outer.ConnectionFailed("No device found with address " + address);
                    } else {
                        BluetoothLEint.this.outer.ConnectionFailed("Device list was empty");
                        BluetoothLEint.this.signalError("ConnectWithAddress", 9007, new Object[0]);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    BluetoothLEint.this.outer.ConnectionFailed(e.getMessage());
                    BluetoothLEint.this.signalError("ConnectWithAddress", 9006, new Object[]{"ConnectWithAddress", "DeviceList"});
                }
                return null;
            }
        }.run();
    }

    void Disconnect() {
        new BLEAction<Void>("Disconnect"){

            @Override
            public Void action() {
                if (BluetoothLEint.this.mBluetoothGatt != null) {
                    BluetoothLEint.this.isUserDisconnect = true;
                    BluetoothLEint.this.mBluetoothGatt.disconnect();
                } else {
                    BluetoothLEint.this.signalError("Disconnect", 9005, new Object[0]);
                }
                return null;
            }
        }.run();
    }

    void DisconnectWithAddress(final String address) {
        new BLEAction<Void>("DisconnectWithAddress"){

            @Override
            public Void action() {
                if (BluetoothLEint.this.gattMap.containsKey(address)) {
                    BluetoothGatt addressedGatt = (BluetoothGatt)BluetoothLEint.this.gattMap.get(address);
                    addressedGatt.disconnect();
                    BluetoothLEint.this.gattMap.remove(address);
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Disconnect successful.");
                } else {
                    Log.e((String)BluetoothLEint.LOG_TAG, (String)"Disconnect failed. No such address in the list.");
                }
                return null;
            }
        }.run();
    }

    void ReadByteValues(String serviceUuid, String characteristicUuid, boolean signed) {
        this.ReadByteValues(serviceUuid, characteristicUuid, signed, null);
    }

    void ReadByteValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final BluetoothLE.BLEResponseHandler<Integer> callback) {
        String METHOD = "ReadByteValues";
        new BLEAction<Void>("ReadByteValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "ReadByteValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "ReadByteValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadByteOperation(characteristic, signed, callback));
                return null;
            }
        }.run();
    }

    void RegisterForByteValues(String serviceUuid, String characteristicUuid, boolean signed) {
        this.RegisterForByteValues(serviceUuid, characteristicUuid, signed, null);
    }

    void RegisterForByteValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final BluetoothLE.BLEResponseHandler<Integer> callback) {
        String METHOD = "RegisterForByteValues";
        this.mHandler.postDelayed(new Runnable(){

            public void run() {
                new BLEAction<Void>("RegisterForByteValues"){

                    @Override
                    public Void action() {
                        if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "RegisterForByteValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "RegisterForByteValues")) {
                            return null;
                        }
                        BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                        BluetoothLEint.this.schedulePendingOperation(new BLEReadByteOperation(characteristic, signed, callback, true));
                        return null;
                    }
                }.run();
            }
        }, 1L);
    }

    void WriteByteValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final List<Integer> values) {
        String METHOD = "WriteByteValues";
        new BLEAction<Void>("WriteByteValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteByteValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteByteValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteBytesOperation(characteristic, signed, values, 1));
                return null;
            }
        }.run();
    }

    void WriteByteValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, List<Integer> values) {
        this.WriteByteValuesWithResponse(serviceUuid, characteristicUuid, signed, values, null);
    }

    void WriteByteValuesWithResponse(final String serviceUuid, final String characteristicUuid, final boolean signed, final List<Integer> values, BluetoothLE.BLEResponseHandler<Integer> callback) {
        String METHOD = "WriteByteValuesWithResponse";
        Log.d((String)LOG_TAG, (String)("WriteByteValuesWithResponse: " + values));
        new BLEAction<Void>("WriteByteValuesWithResponse"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteByteValuesWithResponse") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteByteValuesWithResponse")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteBytesOperation(characteristic, signed, values, 2));
                return null;
            }
        }.run();
    }

    void ReadShortValues(String serviceUuid, String characteristicUuid, boolean signed) {
        this.ReadShortValues(serviceUuid, characteristicUuid, signed, null);
    }

    void ReadShortValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final BluetoothLE.BLEResponseHandler<Integer> callback) {
        String METHOD = "ReadShortValues";
        new BLEAction<Void>("ReadShortValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "ReadShortValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "ReadShortValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadShortOperation(characteristic, signed, callback));
                return null;
            }
        }.run();
    }

    void RegisterForShortValues(String serviceUuid, String characteristicUuid, boolean signed) {
        this.RegisterForShortValues(serviceUuid, characteristicUuid, signed, null);
    }

    void RegisterForShortValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final BluetoothLE.BLEResponseHandler<Integer> callback) {
        String METHOD = "RegisterForShortValues";
        new BLEAction<Void>("RegisterForShortValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "RegisterForShortValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "RegisterForShortValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadShortOperation(characteristic, signed, callback, true));
                return null;
            }
        }.run();
    }

    void WriteShortValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final List<Integer> values) {
        String METHOD = "WriteShortValues";
        new BLEAction<Void>("WriteShortValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteShortValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteShortValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteShortsOperation(characteristic, signed, values, 1));
                return null;
            }
        }.run();
    }

    void WriteShortValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, List<Integer> values) {
        this.WriteShortValuesWithResponse(serviceUuid, characteristicUuid, signed, values, null);
    }

    void WriteShortValuesWithResponse(final String serviceUuid, final String characteristicUuid, final boolean signed, final List<Integer> values, BluetoothLE.BLEResponseHandler<Integer> handler) {
        String METHOD = "WriteShortValuesWithResponse";
        new BLEAction<Void>("WriteShortValuesWithResponse"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteShortValuesWithResponse") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteShortValuesWithResponse")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteShortsOperation(characteristic, signed, values, 2));
                return null;
            }
        }.run();
    }

    void ReadIntegerValues(String serviceUuid, String characteristicUuid, boolean signed) {
        this.ReadIntegerValues(serviceUuid, characteristicUuid, signed, null);
    }

    void ReadIntegerValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final BluetoothLE.BLEResponseHandler<Long> handler) {
        String METHOD = "ReadIntegerValues";
        new BLEAction<Void>("ReadIntegerValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "ReadIntegerValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "ReadIntegerValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadIntegerOperation(characteristic, signed, handler));
                return null;
            }
        }.run();
    }

    void RegisterForIntegerValues(String serviceUuid, String characteristicUuid, boolean signed) {
        this.RegisterForIntegerValues(serviceUuid, characteristicUuid, signed, null);
    }

    void RegisterForIntegerValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final BluetoothLE.BLEResponseHandler<Long> handler) {
        String METHOD = "RegisterForIntegerValues";
        new BLEAction<Void>("RegisterForIntegerValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "RegisterForIntegerValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "RegisterForIntegerValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadIntegerOperation(characteristic, signed, handler, true));
                return null;
            }
        }.run();
    }

    void WriteIntegerValues(final String serviceUuid, final String characteristicUuid, final boolean signed, final List<Long> values) {
        String METHOD = "WriteIntegerValuesWithResponse";
        new BLEAction<Void>("WriteIntegerValuesWithResponse"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteIntegerValuesWithResponse") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteIntegerValuesWithResponse")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteIntegersOperation(characteristic, signed, values, 1));
                return null;
            }
        }.run();
    }

    void WriteIntegerValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, List<Long> values) {
        this.WriteIntegerValuesWithResponse(serviceUuid, characteristicUuid, signed, values, null);
    }

    void WriteIntegerValuesWithResponse(final String serviceUuid, final String characteristicUuid, final boolean signed, final List<Long> values, BluetoothLE.BLEResponseHandler<Long> handler) {
        String METHOD = "WriteIntegerValuesWithResponse";
        new BLEAction<Void>("WriteIntegerValuesWithResponse"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteIntegerValuesWithResponse") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteIntegerValuesWithResponse")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteIntegersOperation(characteristic, signed, values, 2));
                return null;
            }
        }.run();
    }

    void ReadFloatValues(String serviceUuid, String characteristicUuid, boolean shortFloat) {
        this.ReadFloatValues(serviceUuid, characteristicUuid, shortFloat, null);
    }

    void ReadFloatValues(final String serviceUuid, final String characteristicUuid, final boolean shortFloat, final BluetoothLE.BLEResponseHandler<Float> callback) {
        String METHOD = "ReadFloatValues";
        new BLEAction<Void>("ReadFloatValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "ReadFloatValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "ReadFloatValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadFloatOperation(characteristic, shortFloat, callback));
                return null;
            }
        }.run();
    }

    void RegisterForFloatValues(String serviceUuid, String characteristicUuid, boolean shortFloat) {
        this.RegisterForFloatValues(serviceUuid, characteristicUuid, shortFloat, null);
    }

    void RegisterForFloatValues(final String serviceUuid, final String characteristicUuid, final boolean shortFloat, final BluetoothLE.BLEResponseHandler<Float> callback) {
        String METHOD = "RegisterForFloatValues";
        new BLEAction<Void>("RegisterForFloatValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "RegisterForFloatValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "RegisterForFloatValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadFloatOperation(characteristic, shortFloat, callback, true));
                return null;
            }
        }.run();
    }

    void WriteFloatValues(final String serviceUuid, final String characteristicUuid, final boolean shortFloat, final List<Float> values) {
        String METHOD = "WriteFloatValues";
        new BLEAction<Void>("WriteFloatValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteFloatValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteFloatValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteFloatsOperation(characteristic, shortFloat, values, 1));
                return null;
            }
        }.run();
    }

    void WriteFloatValuesWithResponse(String serviceUuid, String characteristicUuid, boolean shortFloat, List<Float> values) {
        this.WriteFloatValuesWithResponse(serviceUuid, characteristicUuid, shortFloat, values, null);
    }

    void WriteFloatValuesWithResponse(final String serviceUuid, final String characteristicUuid, final boolean shortFloat, final List<Float> values, BluetoothLE.BLEResponseHandler<Float> callback) {
        String METHOD = "WriteFloatValuesWithResponse";
        new BLEAction<Void>("WriteFloatValuesWithResponse"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteFloatValuesWithResponse") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteFloatValuesWithResponse")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteFloatsOperation(characteristic, shortFloat, values, 2));
                return null;
            }
        }.run();
    }

    void ReadStringValues(String serviceUuid, String characteristicUuid, boolean utf16) {
        this.ReadStringValues(serviceUuid, characteristicUuid, utf16, null);
    }

    void ReadStringValues(final String serviceUuid, final String characteristicUuid, final boolean utf16, final BluetoothLE.BLEResponseHandler<String> handler) {
        String METHOD = "ReadStringValues";
        new BLEAction<Void>("ReadStringValues"){

            @Override
            public Void action() {
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(BluetoothLEint.bleStringToUuid(serviceUuid), BluetoothLEint.bleStringToUuid(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadStringOperation(characteristic, utf16, handler));
                return null;
            }
        }.run();
    }

    void RegisterForStringValues(String serviceUuid, String characteristicUuid, boolean utf16) {
        this.RegisterForStringValues(serviceUuid, characteristicUuid, utf16, null);
    }

    void RegisterForStringValues(final String serviceUuid, final String characteristicUuid, final boolean utf16, final BluetoothLE.BLEResponseHandler<String> handler) {
        String METHOD = "RegisterForStringValues";
        new BLEAction<Void>("RegisterForStringValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "RegisterForStringValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "RegisterForStringValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEReadStringOperation(characteristic, utf16, handler, true));
                return null;
            }
        }.run();
    }

    void WriteStringValues(final String serviceUuid, final String characteristicUuid, final boolean utf16, final List<String> values) {
        String METHOD = "WriteStringValues";
        new BLEAction<Void>("WriteStringValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteStringValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteStringValues")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteStringsOperation(characteristic, utf16, values, 1));
                return null;
            }
        }.run();
    }

    void WriteStringValuesWithResponse(String serviceUuid, String characteristicUuid, boolean utf16, List<String> values) {
        this.WriteStringValuesWithResponse(serviceUuid, characteristicUuid, utf16, values, null);
    }

    void WriteStringValuesWithResponse(final String serviceUuid, final String characteristicUuid, final boolean utf16, final List<String> values, BluetoothLE.BLEResponseHandler<String> handler) {
        String METHOD = "WriteStringValuesWithResponse";
        new BLEAction<Void>("WriteStringValuesWithResponse"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "WriteStringValuesWithResponse") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "WriteStringValuesWithResponse")) {
                    return null;
                }
                BluetoothGattCharacteristic characteristic = BluetoothLEint.this.findMGattChar(UUID.fromString(serviceUuid), UUID.fromString(characteristicUuid));
                BluetoothLEint.this.schedulePendingOperation(new BLEWriteStringsOperation(characteristic, utf16, values, 2));
                return null;
            }
        }.run();
    }

    void UnregisterForValues(String serviceUuid, String characteristicUuid) {
        this.UnregisterForValues(serviceUuid, characteristicUuid, null);
    }

    void UnregisterForValues(final String serviceUuid, final String characteristicUuid, BluetoothLE.BLEResponseHandler<?> handler) {
        String METHOD = "UnsubscribeForValues";
        new BLEAction<Void>("UnsubscribeForValues"){

            @Override
            public Void action() {
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "UnsubscribeForValues") || !BluetoothLEint.this.validateUUID(characteristicUuid, "Characteristic", "UnsubscribeForValues")) {
                    return null;
                }
                UUID characteristic = UUID.fromString(characteristicUuid);
                List operations = (List)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic);
                if (operations != null) {
                    ArrayList readOnlyList = new ArrayList(operations);
                    for (BLEOperation operation : readOnlyList) {
                        if (!operation.isNotify()) continue;
                        operation.unsubscribe(BluetoothLEint.this.mBluetoothGatt);
                    }
                }
                return null;
            }
        }.run();
    }

    int FoundDeviceRssi(final int index) {
        if (index < 1 || index > this.mLeDevices.size()) {
            throw new IllegalArgumentException("Expected device index between 1 and " + this.mLeDevices.size());
        }
        Integer result = (Integer)new BLEAction<Integer>("FoundDeviceRssi"){

            @Override
            public Integer action() {
                if (index <= BluetoothLEint.this.mLeDevices.size()) {
                    try {
                        if (!BluetoothLEint.this.mLeDevices.isEmpty()) {
                            return (Integer)BluetoothLEint.this.mLeDeviceRssi.get(BluetoothLEint.this.mLeDevices.get(index - 1));
                        }
                        BluetoothLEint.this.signalError("FoundDeviceRssi", 9007, new Object[0]);
                    }
                    catch (IndexOutOfBoundsException e) {
                        BluetoothLEint.this.signalError("FoundDeviceRssi", 9006, new Object[]{"FoundDeviceRssi", "DeviceList"});
                    }
                }
                return null;
            }
        }.run();
        return result != null ? result : -1;
    }

    String FoundDeviceName(int index) {
        if (index < 1 || index > this.mLeDevices.size()) {
            throw new IllegalArgumentException("Expected device index between 1 and " + this.mLeDevices.size());
        }
        if (index <= this.mLeDevices.size()) {
            Log.i((String)LOG_TAG, (String)"Device Name is found");
            return this.mLeDevices.get(index - 1).getName();
        }
        Log.e((String)LOG_TAG, (String)"Device Name isn't found");
        return null;
    }

    String FoundDeviceAddress(int index) {
        if (index < 1 || index > this.mLeDevices.size()) {
            throw new IllegalArgumentException("Expected device index between 1 and " + this.mLeDevices.size());
        }
        if (index <= this.mLeDevices.size()) {
            Log.i((String)LOG_TAG, (String)"Device Address is found");
            return this.mLeDevices.get(index - 1).getAddress();
        }
        Log.e((String)LOG_TAG, (String)"Device Address is found");
        return "";
    }

    String ConnectedDeviceName() {
        BluetoothDevice device;
        if (this.isConnected && this.mBluetoothGatt != null && (device = this.mBluetoothGatt.getDevice()) != null) {
            return device.getName();
        }
        return "";
    }

    void StartAdvertising(final String inData, final String serviceUuid) {
        new BLEAction<Void>("StartAdvertising"){

            @Override
            public Void action() {
                BluetoothAdapter btAdapter = this.obtainBluetoothAdapter();
                if (!btAdapter.isMultipleAdvertisementSupported()) {
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Adapter does not support Bluetooth Advertisements.");
                    BluetoothLEint.this.signalError("StartAdvertising", 9010, new Object[0]);
                    return null;
                }
                if (!BluetoothLEint.this.validateUUID(serviceUuid, "Service", "StartAdvertising")) {
                    return null;
                }
                BluetoothLEint.this.mBluetoothLeAdvertiser = btAdapter.getBluetoothLeAdvertiser();
                AdvertiseCallback advertisingCallback = new AdvertiseCallback(){

                    public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                        BluetoothLEint.this.isAdvertising = true;
                        super.onStartSuccess(settingsInEffect);
                    }

                    public void onStartFailure(int errorCode) {
                        Log.e((String)BluetoothLEint.LOG_TAG, (String)("Advertising onStartFailure: " + errorCode));
                        super.onStartFailure(errorCode);
                    }
                };
                AdvertiseSettings advSettings = new AdvertiseSettings.Builder().setAdvertiseMode(2).setTxPowerLevel(3).setConnectable(false).build();
                ParcelUuid pUuid = new ParcelUuid(UUID.fromString(serviceUuid));
                AdvertiseData advData = new AdvertiseData.Builder().setIncludeDeviceName(true).addServiceUuid(pUuid).addServiceData(pUuid, inData.getBytes(Charset.forName("UTF-8"))).build();
                if (BluetoothLEint.this.mAdvertiseCallback == null) {
                    BluetoothLEint.this.mAdvertiseCallback = advertisingCallback;
                    if (BluetoothLEint.this.mBluetoothLeAdvertiser != null) {
                        BluetoothLEint.this.mBluetoothLeAdvertiser.startAdvertising(advSettings, advData, BluetoothLEint.this.mAdvertiseCallback);
                    }
                }
                Log.i((String)BluetoothLEint.LOG_TAG, (String)"StartScanningAdvertisements Successfully.");
                return null;
            }
        }.run();
    }

    void StopAdvertising() {
        new BLEAction<Void>("StopAdvertising"){

            @Override
            public Void action() {
                Log.i((String)BluetoothLEint.LOG_TAG, (String)"Stopping BLE Advertising");
                if (BluetoothLEint.this.mBluetoothLeAdvertiser != null) {
                    BluetoothLEint.this.mBluetoothLeAdvertiser.stopAdvertising(BluetoothLEint.this.mAdvertiseCallback);
                    BluetoothLEint.this.isAdvertising = false;
                    BluetoothLEint.this.mAdvertiseCallback = null;
                }
                return null;
            }
        }.run();
    }

    void ScanAdvertisements(final long scanPeriod) {
        new BLEAction<Void>("ScanAdvertisements"){

            @Override
            public Void action() {
                BluetoothLEint.this.SCAN_PERIOD = scanPeriod;
                BluetoothLEint.this.advertiserAddresses = new ArrayList();
                BluetoothLEint.this.scannedAdvertisers = new HashMap();
                BluetoothLEint.this.scannedAdvertiserNames = new ArrayList();
                BluetoothLEint.this.nameToAddress = new HashMap();
                BluetoothLEint.this.uiThread.postDelayed(new Runnable(){

                    public void run() {
                        BluetoothLEint.this.StopScanningAdvertisements();
                    }
                }, scanPeriod);
                BluetoothAdapter btAdapter = this.obtainBluetoothAdapter();
                if (btAdapter != null) {
                    BluetoothLEint.this.mBluetoothLeAdvertisementScanner = btAdapter.getBluetoothLeScanner();
                    if (BluetoothLEint.this.mAdvertisementScanCallback != null) {
                        if (BluetoothLEint.this.mBluetoothLeAdvertisementScanner != null) {
                            ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
                            ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                            ScanFilter filter = new ScanFilter.Builder().build();
                            filters.add(filter);
                            if (settings != null) {
                                BluetoothLEint.this.mBluetoothLeAdvertisementScanner.startScan(filters, settings, BluetoothLEint.this.mAdvertisementScanCallback);
                            } else {
                                Log.i((String)BluetoothLEint.LOG_TAG, (String)"settings or filters are null.");
                            }
                        } else {
                            Log.i((String)BluetoothLEint.LOG_TAG, (String)"Bluetooth LE scanner is null.");
                        }
                    } else {
                        Log.i((String)BluetoothLEint.LOG_TAG, (String)"mAdvertisementScanCallback is null.");
                    }
                } else {
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"No bluetooth adapter found.");
                }
                return null;
            }
        }.run();
    }

    void StopScanningAdvertisements() {
        new BLEAction<Void>("StopScanningAdvertisements"){

            @Override
            public Void action() {
                Log.i((String)BluetoothLEint.LOG_TAG, (String)"Stopping BLE Advertisement Scan.");
                BluetoothLEint.this.mBluetoothLeAdvertisementScanner.stopScan(BluetoothLEint.this.mAdvertisementScanCallback);
                return null;
            }
        }.run();
    }

    String GetAdvertisementData(String deviceAddress, String serviceUuid) {
        if (!this.validateUUID(serviceUuid, "Service", "GetAdvertisementData")) {
            return "";
        }
        return "" + Arrays.toString((byte[])this.scannedAdvertisers.get(deviceAddress).getScanRecord().getServiceData().get(ParcelUuid.fromString((String)serviceUuid)));
    }

    String GetAdvertiserAddress(String deviceName) {
        return this.nameToAddress.get(deviceName);
    }

    List<String> GetAdvertiserServiceUuids(String deviceAddress) {
        return BLEUtil.stringifyParcelUuids(this.scannedAdvertisers.get(deviceAddress).getScanRecord().getServiceUuids());
    }

    String BatteryValue() {
        if (this.isCharRead) {
            return Integer.toString(this.battery);
        }
        return "Cannot Read Battery Level";
    }

    int TxPower() {
        return this.txPower;
    }

    boolean IsDeviceConnected() {
        return this.isConnected;
    }

    String DeviceList() {
        this.deviceInfoList = "";
        this.mLeDevices = this.sortDeviceList(this.mLeDevices);
        if (!this.mLeDevices.isEmpty()) {
            for (int i = 0; i < this.mLeDevices.size(); ++i) {
                this.deviceInfoList = i != this.mLeDevices.size() - 1 ? this.deviceInfoList + this.mLeDevices.get(i).getAddress() + " " + this.mLeDevices.get(i).getName() + " " + Integer.toString(this.mLeDeviceRssi.get(this.mLeDevices.get(i))) + "," : this.deviceInfoList + this.mLeDevices.get(i).getAddress() + " " + this.mLeDevices.get(i).getName() + " " + Integer.toString(this.mLeDeviceRssi.get(this.mLeDevices.get(i)));
            }
        }
        return this.deviceInfoList;
    }

    int ConnectedDeviceRssi() {
        return this.device_rssi;
    }

    long AdvertisementScanPeriod() {
        return this.SCAN_PERIOD;
    }

    List<String> GetAdvertiserNames() {
        return this.scannedAdvertiserNames;
    }

    List<String> GetAdvertiserAddresses() {
        return this.advertiserAddresses;
    }

    boolean IsDeviceAdvertising() {
        return this.isAdvertising;
    }

    private void Connected() {
        this.uiThread.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent((Component)BluetoothLEint.this.outer, (String)"Connected", (Object[])new Object[0]);
                HashSet<BluetoothLE.BluetoothConnectionListener> listeners = new HashSet<BluetoothLE.BluetoothConnectionListener>(BluetoothLEint.this.outer.connectionListeners);
                for (BluetoothLE.BluetoothConnectionListener listener : listeners) {
                    listener.onConnected(BluetoothLEint.this.outer);
                }
            }
        });
    }

    private void Disconnected() {
        this.uiThread.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    HashSet<BluetoothLE.BluetoothConnectionListener> listeners = new HashSet<BluetoothLE.BluetoothConnectionListener>(BluetoothLEint.this.outer.connectionListeners);
                    for (BluetoothLE.BluetoothConnectionListener listener : listeners) {
                        listener.onDisconnected(BluetoothLEint.this.outer);
                    }
                }
                finally {
                    EventDispatcher.dispatchEvent((Component)BluetoothLEint.this.outer, (String)"Disconnected", (Object[])new Object[0]);
                }
            }
        });
    }

    private void RssiChanged(final int device_rssi) {
        this.uiThread.postDelayed(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent((Component)BluetoothLEint.this.outer, (String)"RssiChanged", (Object[])new Object[]{device_rssi});
            }
        }, 1000L);
    }

    private void DeviceFound() {
        this.uiThread.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent((Component)BluetoothLEint.this.outer, (String)"DeviceFound", (Object[])new Object[0]);
            }
        });
    }

    String GetSupportedServices() {
        if (this.mGattService == null) {
            return ",";
        }
        this.serviceUUIDList = ", ";
        for (int i = 0; i < this.mGattService.size(); ++i) {
            if (i == 0) {
                this.serviceUUIDList = "";
            }
            UUID serviceUUID = this.mGattService.get(i).getUuid();
            String unknownServiceString = UNKNOWN_SERVICE_NAME;
            String serviceName = BluetoothLEGattAttributes.lookup(serviceUUID, unknownServiceString);
            this.serviceUUIDList = this.serviceUUIDList + serviceUUID + " " + serviceName + ",";
        }
        return this.serviceUUIDList;
    }

    YailList getSupportedServicesList() {
        if (this.mGattService == null) {
            return YailList.makeEmptyList();
        }
        YailList result = YailList.makeEmptyList();
        for (BluetoothGattService service : this.mGattService) {
            UUID serviceUuid = service.getUuid();
            YailList pair = YailList.makeList((Object[])new Object[]{serviceUuid.toString(), BluetoothLEGattAttributes.lookup(serviceUuid, UNKNOWN_SERVICE_NAME)});
            result.add((Object)pair);
        }
        return result;
    }

    String GetServiceByIndex(int index) {
        if (index < 1 || index > this.mGattService.size()) {
            throw new IndexOutOfBoundsException("Expected service index between 1 and " + this.mGattService.size());
        }
        return this.mGattService.get(index - 1).getUuid().toString();
    }

    String GetSupportedCharacteristics() {
        if (this.mGattService == null) {
            return ",";
        }
        this.charUUIDList = ", ";
        for (int i = 0; i < this.mGattService.size(); ++i) {
            if (i == 0) {
                this.charUUIDList = "";
            }
            for (BluetoothGattCharacteristic characteristic : this.mGattService.get(i).getCharacteristics()) {
                this.gattChars.add(characteristic);
            }
        }
        String unknownCharString = UNKNOWN_CHAR_NAME;
        for (BluetoothGattCharacteristic gattChar : this.gattChars) {
            UUID charUUID = gattChar.getUuid();
            String charName = BluetoothLEGattAttributes.lookup(charUUID, unknownCharString);
            this.charUUIDList = this.charUUIDList + charUUID + " " + charName + ",";
        }
        return this.charUUIDList;
    }

    YailList getSupportedCharacteristicsList() {
        if (this.mGattService == null) {
            return YailList.makeEmptyList();
        }
        YailList result = YailList.makeEmptyList();
        for (BluetoothGattService service : this.mGattService) {
            for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                UUID serviceUuid = service.getUuid();
                UUID characteristicUuid = characteristic.getUuid();
                YailList triple = YailList.makeList((Object[])new Object[]{serviceUuid.toString(), characteristicUuid.toString(), BluetoothLEGattAttributes.lookup(characteristicUuid, UNKNOWN_CHAR_NAME)});
                result.add((Object)triple);
            }
        }
        return result;
    }

    YailList GetCharacteristicsForService(String serviceUuid) {
        if (this.mGattService == null) {
            return YailList.makeEmptyList();
        }
        ArrayList<YailList> result = new ArrayList<YailList>();
        String unknownCharString = UNKNOWN_CHAR_NAME;
        try {
            BluetoothGattService service = this.mBluetoothGatt.getService(UUID.fromString(serviceUuid));
            if (service == null) {
                throw new IllegalArgumentException("Device does not advertise service " + serviceUuid);
            }
            for (BluetoothGattCharacteristic c : service.getCharacteristics()) {
                result.add(YailList.makeList((Object[])new Object[]{c.getUuid().toString().toUpperCase(), BluetoothLEGattAttributes.lookup(c.getUuid(), UNKNOWN_CHAR_NAME)}));
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Exception while looking up BluetoothLE service", (Throwable)e);
            throw new RuntimeException("Exception while looking up BluetoothLE service: " + e.getMessage(), e);
        }
        return YailList.makeList(result);
    }

    String GetCharacteristicByIndex(int index) {
        if (index < 1 || index > this.gattChars.size()) {
            throw new IndexOutOfBoundsException("Expected characteristic index between 1 and " + this.gattChars.size());
        }
        return this.gattChars.get(index - 1).getUuid().toString();
    }

    boolean isServicePublished(String serviceUuid) {
        UUID service = BluetoothLEint.bleStringToUuid(serviceUuid);
        return this.mBluetoothGatt != null && this.mBluetoothGatt.getService(service) != null;
    }

    boolean isCharacteristicPublished(String serviceUuid, String characteristicUuid) {
        BluetoothGattService gattService;
        UUID service = BluetoothLEint.bleStringToUuid(serviceUuid);
        UUID characteristic = BluetoothLEint.bleStringToUuid(characteristicUuid);
        if (this.mBluetoothGatt != null && (gattService = this.mBluetoothGatt.getService(service)) != null) {
            return gattService.getCharacteristic(characteristic) != null;
        }
        return false;
    }

    void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    private void signalError(final String functionName, final int errorNumber, Object ... messageArgs) {
        final String errorMessage = String.format(errorMessages.get(errorNumber), messageArgs);
        Log.e((String)LOG_TAG, (String)errorMessage);
        this.activity.runOnUiThread(new Runnable(){

            public void run() {
                BluetoothLEint.this.container.$form().dispatchErrorOccurredEvent((Component)BluetoothLEint.this.outer, functionName, 3300, new Object[]{errorNumber, "BluetoothLE", errorMessage});
            }
        });
    }

    private boolean validateUUID(String UUID2, String type, String callerBlock) {
        if (BLEUtil.hasValidUUIDFormat(UUID2)) {
            return true;
        }
        if (BLEUtil.hasInvalidUUIDChars(UUID2)) {
            this.signalError(callerBlock, 9008, type, callerBlock);
            return false;
        }
        this.signalError(callerBlock, 9009, type, callerBlock);
        return false;
    }

    private List<BluetoothDevice> sortDeviceList(List<BluetoothDevice> deviceList) {
        Collections.sort(deviceList, new Comparator<BluetoothDevice>(){

            @Override
            public int compare(BluetoothDevice device1, BluetoothDevice device2) {
                return (Integer)BluetoothLEint.this.mLeDeviceRssi.get(device2) - (Integer)BluetoothLEint.this.mLeDeviceRssi.get(device1);
            }
        });
        return deviceList;
    }

    private void addDevice(BluetoothDevice device, int rssi) {
        if (!this.mLeDevices.contains(device)) {
            this.mLeDevices.add(device);
            this.mLeDeviceRssi.put(device, rssi);
            this.DeviceFound();
        } else {
            this.mLeDeviceRssi.put(device, rssi);
        }
        this.RssiChanged(rssi);
    }

    private BluetoothGattCharacteristic findMGattChar(UUID ser_uuid, UUID char_uuid) {
        Log.i((String)LOG_TAG, (String)("isServiceRead: " + this.isServiceRead));
        Log.i((String)LOG_TAG, (String)("mGattService.isEmpty(): " + this.mGattService.isEmpty()));
        if (!this.isServiceRead) {
            throw new IllegalStateException("Not connected to a Bluetooth low energy device.");
        }
        if (!this.mGattService.isEmpty()) {
            for (BluetoothGattService aMGattService : this.mGattService) {
                if (!aMGattService.getUuid().equals(ser_uuid)) continue;
                return aMGattService.getCharacteristic(char_uuid);
            }
        }
        throw new IllegalStateException("Service " + ser_uuid + ", characteristic " + char_uuid + " are not published by the connected device.");
    }

    private void readChar(UUID ser_uuid, UUID char_uuid) {
        this.mGattChar = this.findMGattChar(ser_uuid, char_uuid);
        if (this.mGattChar != null) {
            Log.i((String)LOG_TAG, (String)("mGattChar initialized to " + this.mGattChar.getUuid().toString()));
            BluetoothGattDescriptor desc = this.mGattChar.getDescriptor(BluetoothLEGattAttributes.CLIENT_CHARACTERISTIC_CONFIGURATION);
            if (desc != null) {
                if ((this.mGattChar.getProperties() & 0x20) != 0) {
                    desc.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                } else {
                    desc.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                }
                this.mBluetoothGatt.writeDescriptor(desc);
            }
            this.mBluetoothGatt.setCharacteristicNotification(this.mGattChar, true);
            this.isCharRead = this.mBluetoothGatt.readCharacteristic(this.mGattChar);
        } else {
            Log.i((String)LOG_TAG, (String)"mGattChar is null!");
        }
        if (this.isCharRead) {
            Log.i((String)LOG_TAG, (String)"Read Character Successfully.");
        } else {
            Log.e((String)LOG_TAG, (String)"Read Character Fail.");
        }
    }

    private void writeChar(UUID ser_uuid, UUID char_uuid, Object payload) {
        this.mGattChar = this.findMGattChar(ser_uuid, char_uuid);
        if (this.mGattChar != null && payload != null) {
            Log.i((String)LOG_TAG, (String)("mGattChar initialized to " + this.mGattChar.getUuid().toString()));
            if (payload instanceof int[]) {
                int[] args = (int[])payload;
                this.mGattChar.setValue(args[0], args[1], args[2]);
            } else if (payload instanceof byte[]) {
                this.mGattChar.setValue((byte[])payload);
            } else if (payload instanceof String) {
                this.mGattChar.setValue((String)payload);
            } else {
                throw new IllegalArgumentError("Attempted to write to characteristic with unsupported data type.");
            }
            this.isCharWritten = this.mBluetoothGatt.writeCharacteristic(this.mGattChar);
        } else {
            Log.i((String)LOG_TAG, (String)"mGattChar is null!");
        }
        if (this.isCharWritten) {
            Log.i((String)LOG_TAG, (String)"Write Gatt Characteristic Successfully");
        } else {
            Log.e((String)LOG_TAG, (String)"Write Gatt Characteristic Fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePendingOperation(BLEOperation operation) {
        Queue<BLEOperation> queue = this.pendingOperations;
        synchronized (queue) {
            this.pendingOperations.add(operation);
            if (this.pendingOperations.size() == 1) {
                this.mHandler.post((Runnable)operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runPendingOperation(BLEOperation after) {
        Queue<BLEOperation> queue = this.pendingOperations;
        synchronized (queue) {
            boolean removed = false;
            BLEOperation operation = this.pendingOperations.peek();
            if (operation == after) {
                this.pendingOperations.poll();
                removed = true;
                operation = this.pendingOperations.peek();
                Log.d((String)LOG_TAG, (String)("running next operation " + operation));
                if (operation != null) {
                    this.mHandler.post((Runnable)operation);
                }
            } else {
                Log.d((String)LOG_TAG, (String)("after operation = " + after));
                Log.d((String)LOG_TAG, (String)("pending operation = " + operation));
            }
            return removed;
        }
    }

    private void scheduleConnectionTimeoutMessage() {
        this.uiThread.postDelayed(new Runnable(){

            public void run() {
                if (!BluetoothLEint.this.isConnected && BluetoothLEint.this.mBluetoothGatt != null) {
                    BluetoothLEint.this.mBluetoothGatt.disconnect();
                    BluetoothLEint.this.outer.ConnectionFailed("Connection timeout reached");
                }
            }
        }, (long)(this.connectionTimeout * 1000));
    }

    private void forceDisconnect() {
        if (this.mBluetoothGatt != null) {
            if (this.isConnected) {
                this.mBluetoothGatt.disconnect();
                this.mBluetoothGatt.close();
                this.mBluetoothGatt = null;
            } else if (this.autoReconnect) {
                this.mBluetoothGatt.disconnect();
                this.mBluetoothGatt.close();
                this.mBluetoothGatt = null;
            }
            this.isConnected = false;
            this.isUserDisconnect = true;
        }
        this.mBluetoothGatt = null;
    }

    private static UUID bleStringToUuid(String uuid) {
        if ((uuid = uuid.toLowerCase()).length() == 4) {
            uuid = "0000" + uuid + BLUETOOTH_BASE_UUID_SUFFIX;
        } else if (uuid.length() == 8) {
            uuid = uuid + BLUETOOTH_BASE_UUID_SUFFIX;
        } else if (uuid.length() == 32) {
            uuid = uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20);
        } else if (!BLEUtil.hasValidUUIDFormat(uuid)) {
            throw new IllegalArgumentException("Invalid UUID: " + uuid);
        }
        return UUID.fromString(uuid);
    }

    static /* synthetic */ byte[] access$2002(BluetoothLEint x0, byte[] x1) {
        x0.descriptorValue = x1;
        return x1;
    }

    static {
        errorMessages.put(9001, "BluetoothLE is not supported on your phone's hardware!");
        errorMessages.put(9002, "BluetoothLE is not enabled!");
        errorMessages.put(9003, "BluetoothLE requires Android 5.0 or newer!");
        errorMessages.put(9004, "StopScan cannot be called before StartScan! There is no scan currently in progress.");
        errorMessages.put(9005, "Disconnect cannot be called before you are connected! There is no Bluetooth LE device currently connected.");
        errorMessages.put(9006, "Block %1s attempted to access %2s with an invalid index. Index out of bounds!");
        errorMessages.put(9007, "You cannot connect to a device when the device list is empty! Try scanning again.");
        errorMessages.put(9008, "%1s UUID string in block %2s contains invalid characters! Try typing it in again and rebuilding your app.");
        errorMessages.put(9009, "%1s UUID string in block %2s does not use the proper format! Try typing it in again and rebuilding your app.");
        errorMessages.put(9010, "Bluetooth Advertisements not supported!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CharType {
        BYTE,
        INT,
        STRING,
        FLOAT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEWriteStringsOperation
    extends BLEWriteOperation<String> {
        BLEWriteStringsOperation(BluetoothGattCharacteristic characteristic, boolean utf16, List<String> values, int writeType) {
            super(String.class, characteristic, utf16 ? 2 : 1, values, writeType);
        }

        @Override
        public void onWrite(List<String> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.StringsWritten(BLEWriteStringsOperation.this.characteristic.getService().getUuid().toString(), BLEWriteStringsOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEWriteFloatsOperation
    extends BLEWriteOperation<Float> {
        BLEWriteFloatsOperation(BluetoothGattCharacteristic characteristic, boolean shortFloats, List<Float> values, int writeType) {
            super(Float.class, characteristic, shortFloats ? 50 : 52, values, writeType);
        }

        @Override
        public void onWrite(List<Float> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.FloatsWritten(BLEWriteFloatsOperation.this.characteristic.getService().getUuid().toString(), BLEWriteFloatsOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEWriteIntegersOperation
    extends BLEWriteOperation<Long> {
        BLEWriteIntegersOperation(BluetoothGattCharacteristic characteristic, boolean signed, List<Long> values, int writeType) {
            super(Long.class, characteristic, signed ? 36 : 20, values, writeType);
        }

        @Override
        public void onWrite(List<Long> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.IntegersWritten(BLEWriteIntegersOperation.this.characteristic.getService().getUuid().toString(), BLEWriteIntegersOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEWriteShortsOperation
    extends BLEWriteOperation<Integer> {
        BLEWriteShortsOperation(BluetoothGattCharacteristic characteristic, boolean signed, List<Integer> values, int writeType) {
            super(Integer.class, characteristic, signed ? 34 : 18, values, writeType);
        }

        @Override
        public void onWrite(List<Integer> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.ShortsWritten(BLEWriteShortsOperation.this.characteristic.getService().getUuid().toString(), BLEWriteShortsOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEWriteBytesOperation
    extends BLEWriteOperation<Integer> {
        BLEWriteBytesOperation(BluetoothGattCharacteristic characteristic, boolean signed, List<Integer> values, int writeType) {
            super(Integer.class, characteristic, signed ? 33 : 17, values, writeType);
        }

        @Override
        public void onWrite(List<Integer> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.BytesWritten(BLEWriteBytesOperation.this.characteristic.getService().getUuid().toString(), BLEWriteBytesOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEReadStringOperation
    extends BLEReadOperation<String> {
        BLEReadStringOperation(BluetoothGattCharacteristic characteristic, boolean utf16, BluetoothLE.BLEResponseHandler<String> handler) {
            this(characteristic, utf16, handler, false);
        }

        BLEReadStringOperation(BluetoothGattCharacteristic characteristic, boolean utf16, BluetoothLE.BLEResponseHandler<String> handler, boolean notify) {
            super(String.class, characteristic, utf16 ? 2 : 1, handler, notify);
        }

        @Override
        public void onReceive(List<String> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.StringsReceived(BLEReadStringOperation.this.characteristic.getService().getUuid().toString(), BLEReadStringOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEReadFloatOperation
    extends BLEReadOperation<Float> {
        BLEReadFloatOperation(BluetoothGattCharacteristic characteristic, boolean shortFloat, BluetoothLE.BLEResponseHandler<Float> handler) {
            this(characteristic, shortFloat, handler, false);
        }

        BLEReadFloatOperation(BluetoothGattCharacteristic characteristic, boolean shortFloat, BluetoothLE.BLEResponseHandler<Float> handler, boolean notify) {
            super(Float.class, characteristic, shortFloat ? 50 : 52, handler, notify);
        }

        @Override
        public void onReceive(List<Float> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.FloatsReceived(BLEReadFloatOperation.this.characteristic.getService().getUuid().toString(), BLEReadFloatOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEReadIntegerOperation
    extends BLEReadOperation<Long> {
        BLEReadIntegerOperation(BluetoothGattCharacteristic characteristic, boolean signed, BluetoothLE.BLEResponseHandler<Long> handler) {
            this(characteristic, signed, handler, false);
        }

        BLEReadIntegerOperation(BluetoothGattCharacteristic characteristic, boolean signed, BluetoothLE.BLEResponseHandler<Long> handler, boolean notify) {
            super(Long.class, characteristic, signed ? 36 : 20, handler, notify);
        }

        @Override
        protected void onReceive(List<Long> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.IntegersReceived(BLEReadIntegerOperation.this.characteristic.getService().getUuid().toString(), BLEReadIntegerOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEReadShortOperation
    extends BLEReadOperation<Integer> {
        BLEReadShortOperation(BluetoothGattCharacteristic characteristic, boolean signed, BluetoothLE.BLEResponseHandler<Integer> handler) {
            this(characteristic, signed, handler, false);
        }

        BLEReadShortOperation(BluetoothGattCharacteristic characteristic, boolean signed, BluetoothLE.BLEResponseHandler<Integer> handler, boolean notify) {
            super(Integer.class, characteristic, signed ? 34 : 18, handler, notify);
        }

        @Override
        protected void onReceive(List<Integer> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.ShortsReceived(BLEReadShortOperation.this.characteristic.getService().getUuid().toString(), BLEReadShortOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BLEReadByteOperation
    extends BLEReadOperation<Integer> {
        BLEReadByteOperation(BluetoothGattCharacteristic characteristic, boolean signed, BluetoothLE.BLEResponseHandler<Integer> handler) {
            this(characteristic, signed, handler, false);
        }

        BLEReadByteOperation(BluetoothGattCharacteristic characteristic, boolean signed, BluetoothLE.BLEResponseHandler<Integer> handler, boolean notify) {
            super(Integer.class, characteristic, signed ? 33 : 17, handler, notify);
        }

        @Override
        protected void onReceive(List<Integer> values) {
            final YailList yailList = YailList.makeList(values);
            BluetoothLEint.this.mHandler.post(new Runnable(){

                public void run() {
                    BluetoothLEint.this.outer.BytesReceived(BLEReadByteOperation.this.characteristic.getService().getUuid().toString(), BLEReadByteOperation.this.characteristic.getUuid().toString(), yailList);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BLEWriteOperation<T>
    extends BLEOperation {
        private final Class<T> mClass;
        private List<T> data;
        private BluetoothLE.BLEResponseHandler<T> handler;
        private final int writeType;

        BLEWriteOperation(Class<T> aClass, BluetoothGattCharacteristic characteristic, int type, List<T> data, int writeType) {
            super(characteristic, type);
            this.mClass = aClass;
            this.data = data;
            this.writeType = writeType;
        }

        @Override
        public boolean isRead() {
            return false;
        }

        @Override
        public boolean isNotify() {
            return false;
        }

        @Override
        public boolean isWrite() {
            return true;
        }

        @Override
        public void run() {
            this.write(BluetoothLEint.this.mBluetoothGatt, this.writeType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCharacteristicWrite(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, int status) {
            if (this.characteristic != characteristic) return;
            try {
                switch (status) {
                    case 0: {
                        this.onWrite(this.data);
                        if (this.handler == null) return;
                        BluetoothLEint.this.mHandler.post(new Runnable(){

                            public void run() {
                                BLEWriteOperation.this.handler.onWrite(characteristic.getService().getUuid().toString(), characteristic.getUuid().toString(), BLEWriteOperation.this.data);
                            }
                        });
                        return;
                    }
                    default: {
                        Log.e((String)BluetoothLEint.LOG_TAG, (String)("Error code " + status + " from characteristic " + characteristic.getUuid()));
                        return;
                    }
                }
            }
            finally {
                ((List)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid())).remove(this);
                if (this.needsRemoval && BluetoothLEint.this.runPendingOperation(this)) {
                    this.needsRemoval = false;
                }
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("pendingOperations.size() = " + BluetoothLEint.this.pendingOperations.size()));
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("pendingOperationsByUuid.size() = " + BluetoothLEint.this.pendingOperationsByUuid.size()));
            }
        }

        private void write(BluetoothGatt gatt, int writeType) {
            this.registerPendingOperation();
            this.characteristic.setWriteType(writeType);
            if (this.mClass == String.class) {
                byte[] str = ((String)this.data.get(0)).getBytes();
                int len = str.length > 22 ? 23 : str.length + 1;
                byte[] buffer = new byte[len];
                for (int i = 0; i < len - 1; ++i) {
                    buffer[i] = str[i];
                }
                buffer[len - 1] = 0;
                this.characteristic.setValue(buffer);
            } else if (this.mClass == Float.class) {
                byte[] contents = new byte[this.size * this.data.size()];
                int i = 0;
                if (this.size == 4) {
                    for (Float f : this.data) {
                        int value = Float.floatToIntBits(f.floatValue());
                        contents[i++] = (byte)(value & 0xFF);
                        contents[i++] = (byte)(value >> 8 & 0xFF);
                        contents[i++] = (byte)(value >> 16 & 0xFF);
                        contents[i++] = (byte)(value >> 24 & 0xFF);
                    }
                } else {
                    for (Float f : this.data) {
                        int value = Float.floatToIntBits(f.floatValue());
                        value = (value & Integer.MIN_VALUE) >> 16 | (((value & 0x7F800000) >> 23) + 127 - 15 & 0x1F) << 11 | (value & 0x7FF000) >> 13;
                        contents[i++] = (byte)(value & 0xFF);
                        contents[i++] = (byte)(value >> 8 & 0xFF);
                    }
                }
                this.characteristic.setValue(contents);
            } else {
                byte[] contents = new byte[this.size * this.data.size()];
                int i = 0;
                for (Number n : this.data) {
                    long value = n.longValue();
                    for (int j = 0; j < this.size; ++j) {
                        contents[i++] = (byte)(value & 0xFFL);
                        value >>= 8;
                    }
                }
                this.characteristic.setValue(contents);
            }
            gatt.writeCharacteristic(this.characteristic);
        }

        public void write(BluetoothGatt gatt) {
            this.write(gatt, 1);
        }

        public void writeWithResponse(BluetoothGatt gatt, BluetoothLE.BLEResponseHandler<T> handler) {
            this.handler = handler;
            this.write(gatt, 1);
        }

        protected abstract void onWrite(List<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BLEReadOperation<T>
    extends BLEOperation {
        private final Class<T> mClass;
        private boolean notify;
        private final BluetoothLE.BLEResponseHandler<T> handler;
        private int delay;

        BLEReadOperation(Class<T> aClass, BluetoothGattCharacteristic characteristic, int type, BluetoothLE.BLEResponseHandler<T> handler, boolean notify) {
            super(characteristic, type);
            this.notify = false;
            this.delay = 1;
            this.mClass = aClass;
            this.handler = handler;
            this.notify = notify;
        }

        @Override
        public boolean isRead() {
            return true;
        }

        @Override
        public boolean isNotify() {
            return this.notify;
        }

        @Override
        public boolean isWrite() {
            return false;
        }

        @Override
        public void run() {
            if (this.isNotify()) {
                this.subscribe(BluetoothLEint.this.mBluetoothGatt);
            } else {
                this.read(BluetoothLEint.this.mBluetoothGatt);
            }
        }

        @Override
        public void read(final BluetoothGatt gatt) {
            if (gatt.readCharacteristic(this.characteristic)) {
                this.registerPendingOperation();
            } else if (this.delay > 2000) {
                Log.i((String)BluetoothLEint.LOG_TAG, (String)"Took too long to schedule read. Treating this as failure.");
            } else {
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("Unable to read characteristic " + this.characteristic.getUuid() + ". Deferring operation by " + this.delay + "ms."));
                BluetoothLEint.this.mHandler.postDelayed(new Runnable(){

                    public void run() {
                        BLEReadOperation.this.read(gatt);
                    }
                }, (long)this.delay);
                this.delay *= 2;
            }
        }

        public void subscribe(final BluetoothGatt gatt) {
            this.notify = true;
            this.registerPendingOperation();
            BluetoothGattDescriptor desc = this.characteristic.getDescriptor(BluetoothLEGattAttributes.CLIENT_CHARACTERISTIC_CONFIGURATION);
            boolean wroteDescriptor = false;
            if (desc != null) {
                if ((this.characteristic.getProperties() & 0x10) != 0) {
                    desc.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                } else {
                    desc.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                }
                gatt.writeDescriptor(desc);
                wroteDescriptor = true;
            }
            if (!gatt.setCharacteristicNotification(this.characteristic, true)) {
                if (this.delay > 2000) {
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Took too long to subscribe. Treating this as failure.");
                    return;
                }
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("Unable to set characteristic notification for " + this.characteristic.getUuid() + ". Deferring operation by " + this.delay + "ms."));
                BluetoothLEint.this.mHandler.postDelayed(new Runnable(){

                    public void run() {
                        BLEReadOperation.this.subscribe(gatt);
                    }
                }, (long)this.delay);
                this.delay *= 2;
            } else {
                if (!wroteDescriptor && BluetoothLEint.this.runPendingOperation(this)) {
                    this.needsRemoval = false;
                }
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("Subscribed for UUID: " + this.characteristic.getUuid()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe(final BluetoothGatt gatt) {
            Map map = BluetoothLEint.this.pendingOperationsByUuid;
            synchronized (map) {
                if (gatt.setCharacteristicNotification(this.characteristic, false)) {
                    ((List)BluetoothLEint.this.pendingOperationsByUuid.get(this.characteristic.getUuid())).remove(this);
                    this.notify = false;
                } else if (this.delay > 2000) {
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Took too long to unsubscribe. Treating this as failure.");
                } else {
                    Log.d((String)BluetoothLEint.LOG_TAG, (String)("setCharacteristicNotification returned false. Deferring operation by " + this.delay + "ms."));
                    BluetoothLEint.this.mHandler.postDelayed(new Runnable(){

                        public void run() {
                            BLEReadOperation.this.unsubscribe(gatt);
                        }
                    }, (long)this.delay);
                    this.delay *= 2;
                }
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic) {
            if (this.characteristic == characteristic) {
                final List<T> data = this.readCharacteristic();
                this.onReceive(data);
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("handler = " + this.handler));
                if (this.handler != null) {
                    Log.d((String)BluetoothLEint.LOG_TAG, (String)"Posting handler's onReceive to UI thread");
                    BluetoothLEint.this.mHandler.post(new Runnable(){

                        public void run() {
                            BLEReadOperation.this.handler.onReceive(characteristic.getService().getUuid().toString(), characteristic.getUuid().toString(), data);
                        }
                    });
                }
                if (this.needsRemoval && BluetoothLEint.this.runPendingOperation(this)) {
                    this.needsRemoval = false;
                }
            } else {
                Log.d((String)BluetoothLEint.LOG_TAG, (String)"Characteristic did not match");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCharacteristicRead(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, int status) {
            if (this.characteristic != characteristic) return;
            try {
                switch (status) {
                    case 0: {
                        final List<T> data = this.readCharacteristic();
                        this.onReceive(data);
                        Log.d((String)BluetoothLEint.LOG_TAG, (String)("handler = " + this.handler));
                        if (this.handler == null) return;
                        Log.d((String)BluetoothLEint.LOG_TAG, (String)"Posting handler's onReceive to UI thread");
                        BluetoothLEint.this.mHandler.post(new Runnable(){

                            public void run() {
                                BLEReadOperation.this.handler.onReceive(characteristic.getService().getUuid().toString(), characteristic.getUuid().toString(), data);
                            }
                        });
                        return;
                    }
                    default: {
                        Log.e((String)BluetoothLEint.LOG_TAG, (String)("Error code " + status + " from characteristic " + characteristic.getUuid()));
                        return;
                    }
                }
            }
            finally {
                ((List)BluetoothLEint.this.pendingOperationsByUuid.get(characteristic.getUuid())).remove(this);
                if (this.needsRemoval && BluetoothLEint.this.runPendingOperation(this)) {
                    this.needsRemoval = false;
                }
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("pendingOperations.size() = " + BluetoothLEint.this.pendingOperations.size()));
                Log.d((String)BluetoothLEint.LOG_TAG, (String)("pendingOperationsByUuid.size() = " + BluetoothLEint.this.pendingOperationsByUuid.size()));
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.d((String)BluetoothLEint.LOG_TAG, (String)("onDescriptorRead: " + descriptor.getCharacteristic().getUuid()));
            if (this.needsRemoval && BluetoothLEint.this.runPendingOperation(this)) {
                this.needsRemoval = false;
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.d((String)BluetoothLEint.LOG_TAG, (String)("onDescriptorWrite: " + descriptor.getCharacteristic().getUuid()));
            if (this.needsRemoval && BluetoothLEint.this.runPendingOperation(this)) {
                this.needsRemoval = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<T> readCharacteristic() {
            Log.d((String)BluetoothLEint.LOG_TAG, (String)("Received bytes = " + Arrays.toString(this.characteristic.getValue())));
            if (this.type == 1 || this.type == 2) {
                Reader reader = null;
                ArrayList<T> result = new ArrayList<T>();
                try {
                    int c;
                    reader = new InputStreamReader((InputStream)new ByteArrayInputStream(this.characteristic.getValue()), this.type == 1 ? "UTF-8" : "UTF-16LE");
                    StringBuilder sb = new StringBuilder();
                    while ((c = reader.read()) >= 0) {
                        if (c != 0) {
                            sb.append(Character.toChars(c));
                            continue;
                        }
                        if (sb.length() > 0) {
                            result.add(this.mClass.cast(sb.toString()));
                        }
                        sb.setLength(0);
                    }
                    if (sb.length() > 0) {
                        result.add(this.mClass.cast(sb.toString()));
                    }
                }
                catch (IOException e) {
                    Log.e((String)BluetoothLEint.LOG_TAG, (String)"Unable to read UTF-8 string from byte array.");
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            Log.wtf((String)BluetoothLEint.LOG_TAG, (String)"Unable to close stream after IOException.");
                        }
                    }
                }
                return result;
            }
            if (this.type == 52 || this.type == 50) {
                int elements = this.characteristic.getValue().length / this.size;
                ArrayList<T> values = new ArrayList<T>(elements);
                if (this.size == 4) {
                    ByteBuffer buffer = ByteBuffer.wrap(this.characteristic.getValue()).order(ByteOrder.LITTLE_ENDIAN);
                    for (int i = 0; i < elements; ++i) {
                        values.add(this.mClass.cast(Float.valueOf(buffer.getFloat(this.size * i))));
                    }
                } else {
                    for (int i = 0; i < elements; ++i) {
                        Float value = this.characteristic.getFloatValue(this.type, i * this.size);
                        if (value != null) {
                            values.add(this.mClass.cast(value));
                            continue;
                        }
                        values.add(this.mClass.cast(Float.valueOf(Float.NaN)));
                    }
                }
                return values;
            }
            int elements = this.characteristic.getValue().length / this.size;
            Log.d((String)BluetoothLEint.LOG_TAG, (String)("Reading " + elements + " elements of size " + this.size));
            ArrayList<T> values = new ArrayList<T>(elements);
            for (int i = 0; i < elements; ++i) {
                Integer value = this.characteristic.getIntValue(this.type, i * this.size);
                if (value != null) {
                    values.add(this.mClass.cast(value));
                    continue;
                }
                values.add(this.mClass.cast(0));
            }
            return values;
        }

        protected abstract void onReceive(List<T> var1);
    }

    public abstract class BLEOperation
    extends BluetoothGattCallback
    implements Runnable {
        static final int FORMAT_UTF8S = 1;
        static final int FORMAT_UTF16S = 2;
        protected final BluetoothGattCharacteristic characteristic;
        protected final int type;
        protected final int size;
        protected boolean needsRemoval = false;

        BLEOperation(BluetoothGattCharacteristic characteristic, int type) {
            this.characteristic = characteristic;
            this.type = type;
            this.size = this.sizeofT(type);
        }

        public abstract boolean isRead();

        public abstract boolean isNotify();

        public abstract boolean isWrite();

        public void read(BluetoothGatt gatt) {
        }

        public void unsubscribe(BluetoothGatt gatt) {
        }

        protected final int sizeofT(int type) {
            switch (type) {
                case 17: 
                case 33: {
                    return 1;
                }
                case 18: 
                case 34: 
                case 50: {
                    return 2;
                }
                case 20: 
                case 36: 
                case 52: {
                    return 4;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void registerPendingOperation() {
            Map map = BluetoothLEint.this.pendingOperationsByUuid;
            synchronized (map) {
                UUID uuid = this.characteristic.getUuid();
                if (!BluetoothLEint.this.pendingOperationsByUuid.containsKey(uuid)) {
                    BluetoothLEint.this.pendingOperationsByUuid.put(uuid, new ArrayList());
                }
                if (!((List)BluetoothLEint.this.pendingOperationsByUuid.get(uuid)).contains(this)) {
                    ((List)BluetoothLEint.this.pendingOperationsByUuid.get(uuid)).add(this);
                    this.needsRemoval = true;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BLEAction<T>
    implements ActivityResultListener {
        private final int requestEnableBT;
        private final String functionName;

        BLEAction(String functionName) {
            this.requestEnableBT = BluetoothLEint.this.container.$form().registerForActivityResult((ActivityResultListener)this);
            this.functionName = functionName;
        }

        public abstract T action();

        public final T run() {
            if (!BluetoothLEint.this.container.$form().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                BluetoothLEint.this.signalError(this.functionName, 9001, new Object[0]);
                return null;
            }
            if (SdkLevel.getLevel() < 21) {
                BluetoothLEint.this.signalError(this.functionName, 9003, new Object[0]);
                return null;
            }
            return this.action();
        }

        final BluetoothAdapter obtainBluetoothAdapter() {
            BluetoothManager bluetoothManager = (BluetoothManager)BluetoothLEint.this.activity.getSystemService("bluetooth");
            BluetoothAdapter bluetoothAdapter = bluetoothManager.getAdapter();
            if (bluetoothAdapter != null) {
                if (!bluetoothAdapter.isEnabled()) {
                    Log.i((String)BluetoothLEint.LOG_TAG, (String)"Bluetooth is not enabled, attempting to enable now...");
                    BluetoothLEint.this.activity.startActivityForResult(new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE"), this.requestEnableBT);
                }
            } else {
                BluetoothLEint.this.signalError(this.functionName, 9001, new Object[0]);
            }
            return bluetoothAdapter;
        }

        public void resultReturned(int requestCode, int resultCode, Intent data) {
            if (requestCode == this.requestEnableBT) {
                if (resultCode == -1) {
                    this.run();
                } else if (resultCode == 0) {
                    BluetoothLEint.this.signalError(this.functionName, 9002, new Object[0]);
                }
            }
        }
    }
}

