/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.appinventor.ble;

import android.app.Activity;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;
import com.google.common.collect.Lists;
import edu.mit.appinventor.ble.BluetoothLEint;
import gnu.lists.FString;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=2, description="Bluetooth Low Energy, also referred to as Bluetooth LE or simply BLE, is a new communication protocol similar to classic Bluetooth except that it is designed to consume less power while maintaining comparable functionality. For this reason, Bluetooth LE is the preferred choice of communication with IoT devices that have limited power resources. Starting with Android 4.3, Google introduced built-in support for Bluetooth Low Energy. The BluetoothLE extension requires Android 5.0 or higher to avoid known issues with Google's Bluetooth LE support prior to Android 5.0.", category=ComponentCategory.EXTENSION, nonVisible=true, iconName="images/bluetooth.png")
@SimpleObject(external=true)
@UsesPermissions(permissionNames="android.permission.BLUETOOTH, android.permission.BLUETOOTH_ADMIN,android.permission.ACCESS_COARSE_LOCATION")
public class BluetoothLE
extends AndroidNonvisibleComponent
implements Component,
Deleteable {
    public static final int ERROR_DEVICE_INDEX_OOB = 9101;
    public static final int ERROR_SERVICE_INDEX_OOB = 9102;
    public static final int ERROR_SERVICE_INVALID_UUID = 9103;
    public static final int ERROR_CHARACTERISTIC_INDEX_OOB = 9104;
    private static final String LOG_TAG = "BluetoothLE";
    private final Activity activity;
    private BluetoothLEint inner;
    Set<BluetoothConnectionListener> connectionListeners = new HashSet<BluetoothConnectionListener>();

    public void onDelete() {
        if (this.inner != null) {
            this.inner.Disconnect();
            this.inner = null;
        }
    }

    public BluetoothLE(ComponentContainer container) {
        super(container.$form());
        this.activity = container.$context();
        if (!container.$form().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            Log.e((String)LOG_TAG, (String)"Bluetooth LE is unsupported on this hardware. Any subsequent function calls will complain.");
        } else if (SdkLevel.getLevel() < 21) {
            Log.e((String)LOG_TAG, (String)"The BluetoothLE extension is unsupported at this API Level. Any subsequent function calls will complain.");
        } else {
            Log.d((String)LOG_TAG, (String)"Appear to have Bluetooth LE support, continuing...");
        }
        this.inner = new BluetoothLEint(this, this.activity, container);
    }

    public Form getForm() {
        return this.form;
    }

    public void addConnectionListener(BluetoothConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(BluetoothConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @DesignerProperty(editorType="boolean", defaultValue="false")
    @SimpleProperty
    public void AutoReconnect(boolean autoReconnect) {
        this.inner.setAutoReconnect(autoReconnect);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="If true, the application will attempt to reestablish a lost connection to a device due to link loss (e.g., moving out of range). This will not apply to connections that are disconnected by a call to the <a href='#Disconnect'><code>Disconnect</code></a> method. Such disconnects will need to be reconnected via a call to <a href='#Connect'><code>Connect</code></a> or <a href='#ConnectWithAddress'><code>ConnectWithAddress</code></a>.")
    public boolean AutoReconnect() {
        return this.inner.getAutoReconnect();
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="10")
    @SimpleProperty
    public void ConnectionTimeout(int timeout) {
        this.inner.setConnectionTimeout(timeout);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The amount of time, in seconds, that the BluetoothLE component will wait for a connection to be established with a device after a call to <a href='#Connect'><code>Connect</code></a> or <a href='#ConnectWithAddress'><code>ConnectWithAddress</code></a>. If a connection is not established in the given amount of time, the attempt will be aborted and the <a href='#ConnectionFailed'><code>ConnectionFailed</code></a> event will be run.")
    public int ConnectionTimeout() {
        return this.inner.getConnectionTimeout();
    }

    @SimpleFunction
    public void StartScanning() {
        if (this.inner != null) {
            this.inner.StartScanning();
        }
    }

    @SimpleFunction
    public void StopScanning() {
        if (this.inner != null) {
            this.inner.StopScanning();
        }
    }

    @SimpleProperty(description="The scanning state of the Bluetooth low energy component.")
    public boolean Scanning() {
        if (this.inner != null) {
            return this.inner.isScanning();
        }
        return false;
    }

    @SimpleFunction
    public void Connect(int index) {
        if (this.inner != null) {
            try {
                this.inner.Connect(index);
            }
            catch (IndexOutOfBoundsException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "Connect", 3300, new Object[]{9101, LOG_TAG, e.getMessage()});
            }
        }
    }

    @SimpleFunction
    public void ConnectWithAddress(String address) {
        if (this.inner != null) {
            this.inner.ConnectWithAddress(address);
        }
    }

    @SimpleFunction
    public void Disconnect() {
        if (this.inner != null) {
            this.inner.Disconnect();
        }
    }

    @SimpleFunction
    public void DisconnectWithAddress(String address) {
        if (this.inner != null) {
            this.inner.DisconnectWithAddress(address);
        }
    }

    @SimpleFunction
    public void ReadBytes(String serviceUuid, String characteristicUuid, boolean signed) {
        if (this.inner != null) {
            this.inner.ReadByteValues(serviceUuid, characteristicUuid, signed);
        }
    }

    @SimpleFunction
    public void RegisterForBytes(String serviceUuid, String characteristicUuid, boolean signed) {
        if (this.inner != null) {
            this.inner.RegisterForByteValues(serviceUuid, characteristicUuid, signed);
        }
    }

    @SimpleFunction
    public void WriteBytes(String serviceUuid, String characteristicUuid, boolean signed, Object values) {
        if (this.inner != null) {
            this.inner.WriteByteValues(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Integer.class, values, 1));
        }
    }

    @SimpleFunction
    public void WriteBytesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, Object values) {
        if (this.inner != null) {
            this.inner.WriteByteValuesWithResponse(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Integer.class, values, 1));
        }
    }

    @SimpleFunction
    public void ReadShorts(String serviceUuid, String characteristicUuid, boolean signed) {
        if (this.inner != null) {
            this.inner.ReadShortValues(serviceUuid, characteristicUuid, signed);
        }
    }

    @SimpleFunction
    public void RegisterForShorts(String serviceUuid, String characteristicUuid, boolean signed) {
        if (this.inner != null) {
            this.inner.RegisterForShortValues(serviceUuid, characteristicUuid, signed);
        }
    }

    @SimpleFunction
    public void WriteShorts(String serviceUuid, String characteristicUuid, boolean signed, Object values) {
        if (this.inner != null) {
            this.inner.WriteShortValues(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Integer.class, values, 2));
        }
    }

    @SimpleFunction
    public void WriteShortsWithResponse(String serviceUuid, String characteristicUuid, boolean signed, Object values) {
        if (this.inner != null) {
            this.inner.WriteShortValuesWithResponse(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Integer.class, values, 2));
        }
    }

    @SimpleFunction
    public void ReadIntegers(String serviceUuid, String characteristicUuid, boolean signed) {
        if (this.inner != null) {
            this.inner.ReadIntegerValues(serviceUuid, characteristicUuid, signed);
        }
    }

    @SimpleFunction
    public void RegisterForIntegers(String serviceUuid, String characteristicUuid, boolean signed) {
        if (this.inner != null) {
            this.inner.RegisterForIntegerValues(serviceUuid, characteristicUuid, signed);
        }
    }

    @SimpleFunction
    public void WriteIntegers(String serviceUuid, String characteristicUuid, boolean signed, Object values) {
        if (this.inner != null) {
            this.inner.WriteIntegerValues(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Long.class, values, 4));
        }
    }

    @SimpleFunction
    public void WriteIntegersWithResponse(String serviceUuid, String characteristicUuid, boolean signed, Object values) {
        if (this.inner != null) {
            this.inner.WriteIntegerValuesWithResponse(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Long.class, values, 4));
        }
    }

    @SimpleFunction
    public void ReadFloats(String serviceUuid, String characteristicUuid, boolean shortFloat) {
        if (this.inner != null) {
            this.inner.ReadFloatValues(serviceUuid, characteristicUuid, shortFloat);
        }
    }

    @SimpleFunction
    public void RegisterForFloats(String serviceUuid, String characteristicUuid, boolean shortFloat) {
        if (this.inner != null) {
            this.inner.RegisterForFloatValues(serviceUuid, characteristicUuid, shortFloat);
        }
    }

    @SimpleFunction
    public void WriteFloats(String serviceUuid, String characteristicUuid, boolean shortFloat, Object values) {
        if (this.inner != null) {
            this.inner.WriteFloatValues(serviceUuid, characteristicUuid, shortFloat, BluetoothLE.toList(Float.class, values, shortFloat ? 2 : 4));
        }
    }

    @SimpleFunction
    public void WriteFloatsWithResponse(String serviceUuid, String characteristicUuid, boolean shortFloat, Object values) {
        if (this.inner != null) {
            this.inner.WriteFloatValuesWithResponse(serviceUuid, characteristicUuid, shortFloat, BluetoothLE.toList(Float.class, values, shortFloat ? 2 : 4));
        }
    }

    @SimpleFunction
    public void ReadStrings(String serviceUuid, String characteristicUuid, boolean utf16) {
        if (this.inner != null) {
            this.inner.ReadStringValues(serviceUuid, characteristicUuid, utf16);
        }
    }

    @SimpleFunction
    public void RegisterForStrings(String serviceUuid, String characteristicUuid, boolean utf16) {
        if (this.inner != null) {
            this.inner.RegisterForStringValues(serviceUuid, characteristicUuid, utf16);
        }
    }

    @SimpleFunction
    public void WriteStrings(String serviceUuid, String characteristicUuid, boolean utf16, Object values) {
        if (this.inner != null) {
            this.inner.WriteStringValues(serviceUuid, characteristicUuid, utf16, BluetoothLE.toList(String.class, values, utf16 ? 2 : 1));
        }
    }

    @SimpleFunction
    public void WriteStringsWithResponse(String serviceUuid, String characteristicUuid, boolean utf16, Object values) {
        if (this.inner != null) {
            this.inner.WriteStringValuesWithResponse(serviceUuid, characteristicUuid, utf16, BluetoothLE.toList(String.class, values, utf16 ? 2 : 1));
        }
    }

    @SimpleFunction
    public void UnregisterForValues(String service_uuid, String characteristic_uuid) {
        if (this.inner != null) {
            this.inner.UnregisterForValues(service_uuid, characteristic_uuid);
        }
    }

    @SimpleFunction
    public int FoundDeviceRssi(int index) {
        if (this.inner != null) {
            try {
                return this.inner.FoundDeviceRssi(index);
            }
            catch (IndexOutOfBoundsException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "FoundDeviceRssi", 3300, new Object[]{9101, LOG_TAG, e.getMessage()});
            }
        }
        return 0;
    }

    @SimpleFunction
    public String FoundDeviceName(int index) {
        if (this.inner != null) {
            try {
                String result = this.inner.FoundDeviceName(index);
                return result == null ? "" : result;
            }
            catch (IllegalArgumentException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "FoundDeviceName", 3300, new Object[]{9101, LOG_TAG, e.getMessage()});
            }
        }
        return "";
    }

    @SimpleFunction
    public String FoundDeviceAddress(int index) {
        if (this.inner != null) {
            try {
                String result = this.inner.FoundDeviceAddress(index);
                return result == null ? "" : result;
            }
            catch (IllegalArgumentException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "FoundDeviceAddress", 3300, new Object[]{9101, LOG_TAG, e.getMessage()});
            }
        }
        return "";
    }

    @SimpleFunction
    public void StartAdvertising(String inData, String serviceUuid) {
        if (this.inner != null) {
            this.inner.StartAdvertising(inData, serviceUuid);
        }
    }

    @SimpleFunction
    public void StopAdvertising() {
        if (this.inner != null) {
            this.inner.StopAdvertising();
        }
    }

    @SimpleFunction
    public void ScanAdvertisements(long scanPeriod) {
        if (this.inner != null) {
            this.inner.ScanAdvertisements(scanPeriod);
        }
    }

    @SimpleFunction
    public void StopScanningAdvertisements() {
        if (this.inner != null) {
            this.inner.StopScanningAdvertisements();
        }
    }

    @SimpleFunction
    public String AdvertisementData(String deviceAddress, String serviceUuid) {
        if (this.inner != null) {
            return this.inner.GetAdvertisementData(deviceAddress, serviceUuid);
        }
        return "";
    }

    @SimpleFunction
    public String AdvertiserAddress(String deviceName) {
        if (this.inner != null) {
            return this.inner.GetAdvertiserAddress(deviceName);
        }
        return "";
    }

    @SimpleFunction
    public List<String> AdvertiserServiceUuids(String deviceAddress) {
        if (this.inner != null) {
            return this.inner.GetAdvertiserServiceUuids(deviceAddress);
        }
        return YailList.makeEmptyList();
    }

    @SimpleProperty(description="Returns the battery level.", category=PropertyCategory.BEHAVIOR)
    public String BatteryValue() {
        if (this.inner != null) {
            return this.inner.BatteryValue();
        }
        return "";
    }

    @SimpleProperty(description="Returns the transmission power.", category=PropertyCategory.BEHAVIOR)
    public int TxPower() {
        if (this.inner != null) {
            return this.inner.TxPower();
        }
        return -1;
    }

    @SimpleProperty(description="Returns true if a BluetoothLE device is connected; Otherwise, returns false.", category=PropertyCategory.BEHAVIOR)
    public boolean IsDeviceConnected() {
        if (this.inner != null) {
            return this.inner.IsDeviceConnected();
        }
        return false;
    }

    @SimpleProperty(description="Returns a sorted list of BluetoothLE devices as a String.", category=PropertyCategory.BEHAVIOR)
    public String DeviceList() {
        if (this.inner != null) {
            return this.inner.DeviceList();
        }
        return "";
    }

    @SimpleProperty(description="Returns the RSSI (Received Signal Strength Indicator) of connected device.", category=PropertyCategory.BEHAVIOR)
    public int ConnectedDeviceRssi() {
        if (this.inner != null) {
            return this.inner.ConnectedDeviceRssi();
        }
        return Integer.MIN_VALUE;
    }

    @SimpleProperty(description="Returns the value of ScanPeriod.")
    public long AdvertisementScanPeriod() {
        if (this.inner != null) {
            return this.inner.AdvertisementScanPeriod();
        }
        return 0L;
    }

    @SimpleProperty(description="Returns a list of the names of the devices found during Advertisment scanning.")
    public List<String> AdvertiserNames() {
        if (this.inner != null) {
            return this.inner.GetAdvertiserNames();
        }
        return Collections.emptyList();
    }

    @SimpleProperty(description="Returns a list of the addresses of devices found during Advertisement scanning.")
    public List<String> AdvertiserAddresses() {
        if (this.inner != null) {
            return this.inner.GetAdvertiserAddresses();
        }
        return Collections.emptyList();
    }

    @SimpleProperty(description="Returns true if the device is currently advertising, false otherwise.")
    public boolean IsDeviceAdvertising() {
        if (this.inner != null) {
            return this.inner.IsDeviceAdvertising();
        }
        return false;
    }

    @SimpleEvent
    public void Connected() {
    }

    @SimpleEvent
    public void ConnectionFailed(final String reason) {
        this.form.runOnUiThread(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent((Component)BluetoothLE.this, (String)"ConnectionFailed", (Object[])new Object[]{reason});
            }
        });
    }

    @SimpleEvent
    public void Disconnected() {
    }

    @SimpleEvent(description="Trigger event when RSSI (Received Signal Strength Indicator) of found BluetoothLE device changes")
    public void RssiChanged(int rssi) {
    }

    @SimpleEvent
    public void DeviceFound() {
    }

    @SimpleEvent
    public void BytesReceived(String serviceUuid, String characteristicUuid, YailList byteValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"BytesReceived", (Object[])new Object[]{serviceUuid, characteristicUuid, byteValues});
    }

    @SimpleEvent
    public void BytesWritten(String serviceUuid, String characteristicUuid, YailList byteValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"BytesWritten", (Object[])new Object[]{serviceUuid, characteristicUuid, byteValues});
    }

    @SimpleEvent
    public void ShortsReceived(String serviceUuid, String characteristicUuid, YailList shortValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"ShortsReceived", (Object[])new Object[]{serviceUuid, characteristicUuid, shortValues});
    }

    @SimpleEvent
    public void ShortsWritten(String serviceUuid, String characteristicUuid, YailList shortValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"ShortsWritten", (Object[])new Object[]{serviceUuid, characteristicUuid, shortValues});
    }

    @SimpleEvent
    public void IntegersReceived(String serviceUuid, String characteristicUuid, YailList intValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"IntegersReceived", (Object[])new Object[]{serviceUuid, characteristicUuid, intValues});
    }

    @SimpleEvent
    public void IntegersWritten(String serviceUuid, String characteristicUuid, YailList intValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"IntegersWritten", (Object[])new Object[]{serviceUuid, characteristicUuid, intValues});
    }

    @SimpleEvent
    public void FloatsReceived(String serviceUuid, String characteristicUuid, YailList floatValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"FloatsReceived", (Object[])new Object[]{serviceUuid, characteristicUuid, floatValues});
    }

    @SimpleEvent
    public void FloatsWritten(String serviceUuid, String characteristicUuid, YailList floatValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"FloatsWritten", (Object[])new Object[]{serviceUuid, characteristicUuid, floatValues});
    }

    @SimpleEvent
    public void StringsReceived(String serviceUuid, String characteristicUuid, YailList stringValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"StringsReceived", (Object[])new Object[]{serviceUuid, characteristicUuid, stringValues});
    }

    @SimpleEvent
    public void StringsWritten(String serviceUuid, String characteristicUuid, YailList stringValues) {
        EventDispatcher.dispatchEvent((Component)this, (String)"StringsWritten", (Object[])new Object[]{serviceUuid, characteristicUuid, stringValues});
    }

    @SimpleFunction
    public String SupportedServices() {
        if (this.inner != null) {
            return this.inner.GetSupportedServices();
        }
        return "";
    }

    @SimpleProperty(description="A list of pairs, one for each advertised service, indicating the service's UUID and its name, if known. The format of the list will be ((uuid1 name1) (uuid2 name2) ...). If no device is connected or Bluetooth low energy is not supported, then an empty list will be returned.")
    public YailList DeviceServices() {
        if (this.inner != null) {
            return this.inner.getSupportedServicesList();
        }
        return YailList.makeEmptyList();
    }

    @SimpleFunction
    public String ServiceByIndex(int index) {
        if (this.inner != null) {
            try {
                String result = this.inner.GetServiceByIndex(index);
                return result == null ? "" : result;
            }
            catch (IndexOutOfBoundsException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "ServiceByIndex", 3300, new Object[]{9102, LOG_TAG, e.getMessage()});
            }
        }
        return "";
    }

    @SimpleFunction
    public String SupportedCharacteristics() {
        if (this.inner != null) {
            return this.inner.GetSupportedCharacteristics();
        }
        return "";
    }

    @SimpleProperty(description="A list of triples, one for each characteristic advertised by the connected device, containing the service UUID, characteristic UUID, and the characteristic's name, if known. The format of the list will be ((service1 characteristic1 name1) (service2 characteristic2 name2) ...). If no device is connected or Bluetooth low energy is not supported, then an empty list will be returned.")
    public YailList DeviceCharacteristics() {
        if (this.inner != null) {
            return this.inner.getSupportedCharacteristicsList();
        }
        return YailList.makeEmptyList();
    }

    @SimpleProperty(description="The advertised name of the connected device. If no device is connected or Bluetooth low energy is not supported, this will return the empty string.")
    public String ConnectedDeviceName() {
        if (this.inner != null) {
            return this.inner.ConnectedDeviceName();
        }
        return "";
    }

    @SimpleFunction
    public YailList GetCharacteristicsForService(String serviceUuid) {
        if (this.inner != null) {
            try {
                return this.inner.GetCharacteristicsForService(serviceUuid);
            }
            catch (RuntimeException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "GetCharacteristicsForService", 3300, new Object[]{9103, LOG_TAG, e.getMessage()});
            }
        }
        return YailList.makeEmptyList();
    }

    @SimpleFunction
    public String CharacteristicByIndex(int index) {
        if (this.inner != null) {
            try {
                String result = this.inner.GetCharacteristicByIndex(index);
                return result == null ? "" : result;
            }
            catch (IndexOutOfBoundsException e) {
                this.form.dispatchErrorOccurredEvent((Component)this, "CharacteristicByIndex", 3300, new Object[]{9104, LOG_TAG, e.getMessage()});
            }
        }
        return "";
    }

    public void ExReadByteValues(String serviceUuid, String characteristicUuid, boolean signed, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.ReadByteValues(serviceUuid, characteristicUuid, signed, callback);
        }
    }

    public void ExRegisterForByteValues(String serviceUuid, String characteristicUuid, boolean signed, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.RegisterForByteValues(serviceUuid, characteristicUuid, signed, callback);
        }
    }

    public void ExWriteByteValues(String serviceUuid, String characteristicUuid, boolean signed, List<Integer> values) {
        if (this.inner != null) {
            this.inner.WriteByteValues(serviceUuid, characteristicUuid, signed, values);
        }
    }

    public void ExWriteByteValues(String serviceUuid, String characteristicUuid, boolean signed, Object value) {
        if (this.inner != null) {
            this.inner.WriteByteValues(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Integer.class, value, 1));
        }
    }

    public void ExWriteByteValues(String serviceUuid, String characteristicUuid, boolean signed, int value) {
        this.ExWriteByteValues(serviceUuid, characteristicUuid, signed, Collections.singletonList(value));
    }

    public void ExWriteByteValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, List<Integer> values, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.WriteByteValuesWithResponse(serviceUuid, characteristicUuid, signed, values, callback);
        }
    }

    public void ExWriteByteValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, Object value, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.WriteByteValuesWithResponse(serviceUuid, characteristicUuid, signed, BluetoothLE.toList(Integer.class, value, 1), callback);
        }
    }

    public void ExWriteByteValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, int value, BLEResponseHandler<Integer> callback) {
        this.ExWriteByteValuesWithResponse(serviceUuid, characteristicUuid, signed, Collections.singletonList(value), callback);
    }

    public void ExReadShortValues(String serviceUuid, String characteristicUuid, boolean signed, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.ReadShortValues(serviceUuid, characteristicUuid, signed, callback);
        }
    }

    public void ExRegisterForShortValues(String serviceUuid, String characteristicUuid, boolean signed, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.RegisterForShortValues(serviceUuid, characteristicUuid, signed, callback);
        }
    }

    public void ExWriteShortValues(String serviceUuid, String characteristicUuid, boolean signed, List<Integer> values) {
        if (this.inner != null) {
            this.inner.WriteShortValues(serviceUuid, characteristicUuid, signed, values);
        }
    }

    public void ExWriteShortValues(String serviceUuid, String characteristicUuid, boolean signed, int value) {
        this.ExWriteShortValues(serviceUuid, characteristicUuid, signed, Collections.singletonList(value));
    }

    public void ExWriteShortValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, List<Integer> values, BLEResponseHandler<Integer> callback) {
        if (this.inner != null) {
            this.inner.WriteShortValuesWithResponse(serviceUuid, characteristicUuid, signed, values, callback);
        }
    }

    public void ExWriteShortValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, int value, BLEResponseHandler<Integer> callback) {
        this.ExWriteShortValuesWithResponse(serviceUuid, characteristicUuid, signed, Collections.singletonList(value), callback);
    }

    public void ExReadIntegerValues(String serviceUuid, String characteristicUuid, boolean signed, BLEResponseHandler<Long> callback) {
        if (this.inner != null) {
            this.inner.ReadIntegerValues(serviceUuid, characteristicUuid, signed, callback);
        }
    }

    public void ExRegisterForIntegerValues(String serviceUuid, String characteristicUuid, boolean signed, BLEResponseHandler<Long> callback) {
        if (this.inner != null) {
            this.inner.ReadIntegerValues(serviceUuid, characteristicUuid, signed, callback);
        }
    }

    public void ExWriteIntegerValues(String serviceUuid, String characteristicUuid, boolean signed, List<Long> values) {
        if (this.inner != null) {
            this.inner.WriteIntegerValues(serviceUuid, characteristicUuid, signed, values);
        }
    }

    public void ExWriteIntegerValues(String serviceUuid, String characteristicUuid, boolean signed, long value) {
        this.ExWriteIntegerValues(serviceUuid, characteristicUuid, signed, Collections.singletonList(value));
    }

    public void ExWriteIntegerValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, List<Long> values, BLEResponseHandler<Long> callback) {
        if (this.inner != null) {
            this.inner.WriteIntegerValuesWithResponse(serviceUuid, characteristicUuid, signed, values, callback);
        }
    }

    public void ExWriteIntegerValuesWithResponse(String serviceUuid, String characteristicUuid, boolean signed, long value, BLEResponseHandler<Long> callback) {
        this.ExWriteIntegerValuesWithResponse(serviceUuid, characteristicUuid, signed, Collections.singletonList(value), callback);
    }

    public void ExReadFloatValues(String serviceUuid, String characteristicUuid, boolean shortFloats, BLEResponseHandler<Float> callback) {
        if (this.inner != null) {
            this.inner.ReadFloatValues(serviceUuid, characteristicUuid, shortFloats, callback);
        }
    }

    public void ExRegisterForFloatValues(String serviceUuid, String characteristicUuid, boolean shortFloats, BLEResponseHandler<Float> callback) {
        if (this.inner != null) {
            this.inner.RegisterForFloatValues(serviceUuid, characteristicUuid, shortFloats, callback);
        }
    }

    public void ExWriteFloatValues(String serviceUuid, String characteristicUuid, boolean shortFloats, List<Float> values) {
        if (this.inner != null) {
            this.inner.WriteFloatValues(serviceUuid, characteristicUuid, shortFloats, values);
        }
    }

    public void ExWriteFloatValues(String serviceUuid, String characteristicUuid, boolean shortFloats, float value) {
        this.ExWriteFloatValues(serviceUuid, characteristicUuid, shortFloats, Collections.singletonList(Float.valueOf(value)));
    }

    public void ExWriteFloatValuesWithResponse(String serviceUuid, String characteristicUuid, boolean shortFloats, List<Float> values, BLEResponseHandler<Float> callback) {
        if (this.inner != null) {
            this.inner.WriteFloatValuesWithResponse(serviceUuid, characteristicUuid, shortFloats, values, callback);
        }
    }

    public void ExWriteFloatValuesWithResponse(String serviceUuid, String characteristicUuid, boolean shortFloats, float value, BLEResponseHandler<Float> callback) {
        this.ExWriteFloatValuesWithResponse(serviceUuid, characteristicUuid, shortFloats, Collections.singletonList(Float.valueOf(value)), callback);
    }

    public void ExReadStringValues(String serviceUuid, String characteristicUuid, boolean utf16, BLEResponseHandler<String> callback) {
        if (this.inner != null) {
            this.inner.ReadStringValues(serviceUuid, characteristicUuid, utf16, callback);
        }
    }

    public void ExRegisterForStringValues(String serviceUuid, String characteristicUuid, boolean utf16, BLEResponseHandler<String> callback) {
        if (this.inner != null) {
            this.inner.RegisterForStringValues(serviceUuid, characteristicUuid, utf16, callback);
        }
    }

    public void ExWriteStringValues(String serviceUuid, String characteristicUuid, boolean utf16, List<String> values) {
        if (this.inner != null) {
            this.inner.WriteStringValues(serviceUuid, characteristicUuid, utf16, values);
        }
    }

    public void ExWriteStringValues(String serviceUuid, String characteristicUuid, boolean utf16, String value) {
        this.ExWriteStringValues(serviceUuid, characteristicUuid, utf16, Collections.singletonList(value));
    }

    public void ExWriteStringValuesWithResponse(String serviceUuid, String characteristicUuid, boolean utf16, List<String> values, BLEResponseHandler<String> callback) {
        if (this.inner != null) {
            this.inner.WriteStringValuesWithResponse(serviceUuid, characteristicUuid, utf16, values, callback);
        }
    }

    public void ExWriteStringValuesWithResponse(String serviceUuid, String characteristicUuid, boolean utf16, String value, BLEResponseHandler<String> callback) {
        this.ExWriteStringValuesWithResponse(serviceUuid, characteristicUuid, utf16, Collections.singletonList(value), callback);
    }

    public void ExUnregisterForValues(String serviceUuid, String characteristicUuid, BLEResponseHandler<?> callback) {
        if (this.inner != null) {
            this.inner.UnregisterForValues(serviceUuid, characteristicUuid, callback);
        }
    }

    public boolean isServicePublished(String serviceUuid) {
        if (this.inner != null) {
            return this.inner.isServicePublished(serviceUuid);
        }
        return false;
    }

    public boolean isCharacteristicPublished(String serviceUuid, String characteristicUuid) {
        if (this.inner != null) {
            return this.inner.isCharacteristicPublished(serviceUuid, characteristicUuid);
        }
        return false;
    }

    private static <T> List<T> toList(Class<T> tClass, Object value, int size) {
        if (tClass.isAssignableFrom(value.getClass())) {
            return Collections.singletonList(tClass.cast(value));
        }
        if (value instanceof YailList) {
            Iterator i = ((YailList)value).iterator();
            i.next();
            return BluetoothLE.listFromIterator(tClass, i);
        }
        if (value instanceof FString) {
            return BluetoothLE.toList(tClass, value.toString(), size);
        }
        if (value instanceof List) {
            return BluetoothLE.listFromIterator(tClass, ((List)value).iterator());
        }
        if (value instanceof Collection) {
            return BluetoothLE.listFromIterator(tClass, ((Collection)value).iterator());
        }
        if (value instanceof String) {
            try {
                byte[] content = ((String)value).getBytes(size == 1 ? "UTF-8" : "UTF-16LE");
                if (tClass.equals(Integer.class)) {
                    return BluetoothLE.checkedCast(tClass, BluetoothLE.toIntList(content));
                }
                return Collections.emptyList();
            }
            catch (UnsupportedEncodingException e) {
                Log.wtf((String)LOG_TAG, (String)"No support for UTF-8 or UTF-16", (Throwable)e);
                return Collections.emptyList();
            }
        }
        throw new ClassCastException("Unable to convert " + value + " to list");
    }

    private static <T> List<T> listFromIterator(Class<T> tClass, Iterator<?> i) {
        if (tClass.equals(Integer.class)) {
            return BluetoothLE.toIntList(Lists.newArrayList(i));
        }
        if (tClass.equals(Long.class)) {
            return BluetoothLE.toLongList(Lists.newArrayList(i));
        }
        if (tClass.equals(Float.class)) {
            return BluetoothLE.toFloatList(Lists.newArrayList(i));
        }
        ArrayList<T> result = new ArrayList<T>();
        while (i.hasNext()) {
            Object o = i.next();
            if (!tClass.isInstance(o) && !tClass.isAssignableFrom(o.getClass())) {
                throw new ClassCastException("Unable to convert " + o + " of type " + o.getClass().getName() + " to type " + tClass.getName());
            }
            result.add(tClass.cast(o));
        }
        return result;
    }

    private static <T> List<T> checkedCast(Class<T> tClass, List<?> list) {
        for (Object o : list) {
            if (tClass.isInstance(o) || tClass.isAssignableFrom(o.getClass())) continue;
            throw new ClassCastException("Unable to convert " + o + " to type " + tClass.getName());
        }
        return list;
    }

    private static <T extends Number> List<Float> toFloatList(List<T> value) {
        ArrayList<Float> result = new ArrayList<Float>(value.size());
        for (Number o : value) {
            result.add(Float.valueOf(o.floatValue()));
        }
        return result;
    }

    private static <T extends Number> List<Long> toLongList(List<T> value) {
        ArrayList<Long> result = new ArrayList<Long>(value.size());
        for (Number o : value) {
            result.add(o.longValue());
        }
        return result;
    }

    private static <T extends Number> List<Integer> toIntList(List<T> value) {
        ArrayList<Integer> result = new ArrayList<Integer>(value.size());
        for (Number o : value) {
            result.add(o.intValue());
        }
        return result;
    }

    private static List<Integer> toIntList(byte[] values) {
        ArrayList<Integer> result = new ArrayList<Integer>(values.length);
        for (byte b : values) {
            result.add(Integer.valueOf(b));
        }
        return result;
    }

    public static interface BluetoothConnectionListener {
        public void onConnected(BluetoothLE var1);

        public void onDisconnected(BluetoothLE var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BLEResponseHandler<T> {
        public void onReceive(String serviceUuid, String characteristicUuid, List<T> values) {
        }

        public void onWrite(String serviceUuid, String characteristicUuid, List<T> values) {
        }
    }
}

