/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.appinventor.ble;

import android.os.ParcelUuid;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BLEUtil {
    private static final Pattern UUID_FORMAT = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");
    private static final Pattern INVALID_UUID_CHARS = Pattern.compile("[^0-9a-fA-F-]");

    BLEUtil() {
    }

    static boolean hasValidUUIDFormat(String UUID) {
        return UUID_FORMAT.matcher(UUID).find();
    }

    static boolean hasInvalidUUIDChars(String UUID) {
        return INVALID_UUID_CHARS.matcher(UUID).find();
    }

    static List<String> stringifyParcelUuids(List<ParcelUuid> serviceUUIDs) {
        ArrayList<String> deviceServices = new ArrayList<String>();
        for (ParcelUuid serviceUuid : serviceUUIDs) {
            deviceServices.add(serviceUuid.toString());
        }
        return deviceServices;
    }
}

