/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import edu.xtec.util.db.ConnectionBean;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JNDIConnectionBeanProvider
extends ConnectionBeanProvider {
    public static final String DB_CONTEXT = "dbContext";
    public static final String JNDI = "JNDI";
    protected DataSource ds;
    protected String dbContext;
    private int totalCBRequests;
    private Date started;
    private Date lastUse;
    private String logFileString;
    private PrintWriter log;
    private int debugLevel;
    private int totalStatements;
    private String lastRequest;

    protected void setUp(Map map) throws Exception {
        Object object;
        super.setUp(map);
        this.started = new Date();
        this.dbDriver = JNDI;
        if (this.dbServer == null) {
            throw new Exception("JNDI datasource name not specified!");
        }
        this.dbContext = this.getValue(map, DB_CONTEXT, null);
        this.debugLevel = Integer.parseInt(this.getValue(map, "dbDebugLevel", "2"));
        if (this.debugLevel > 0) {
            try {
                this.logFileString = this.getValue(map, "dbLogFile", null);
                if (this.logFileString != null) {
                    object = new File(this.logFileString);
                    if (!((File)object).isAbsolute()) {
                        object = new File(System.getProperty("user.home"));
                        object = new File((File)object, this.logFileString);
                        this.logFileString = ((File)object).getAbsolutePath();
                    }
                    boolean bl = new Boolean(this.getValue(map, "dbLogAppend", "true"));
                    this.log = new PrintWriter(new FileOutputStream(this.logFileString, bl), true);
                }
            }
            catch (IOException iOException) {
                System.err.println(new Date().toString() + " - Error creating log file for JNDIConnectionProvider - " + iOException);
            }
        }
        object = new InitialContext();
        if (this.dbContext != null && this.dbContext.trim().length() > 0) {
            object = (Context)object.lookup(this.dbContext);
        }
        this.ds = (DataSource)object.lookup(this.dbServer);
        if (this.log != null) {
            this.log.println("-----------------------------------------");
            this.log.println(this.started);
            this.log.println("Starting JNDIConnectionBeanProvider");
            this.log.println("dbContext = " + this.dbContext);
            this.log.println("dbServer = " + this.dbServer);
            this.log.println("Context = " + object);
            this.log.println("Datasource = " + this.ds);
            this.log.println("-----------------------------------------");
        }
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>JNDIConnectionBeanProvider ").append(this.hashCode()).append("</b><br>\n");
        stringBuffer.append(super.getInfo());
        stringBuffer.append("started: ").append(this.started).append("<br>\n");
        stringBuffer.append("dbContext: ").append(this.dbContext).append("<br>\n");
        stringBuffer.append("Total requests: ").append(this.totalCBRequests).append("<br>\n");
        stringBuffer.append("Total statements: ").append(this.totalStatements).append("<br>\n");
        stringBuffer.append("Last use: ").append(this.lastUse).append("<br>\n");
        stringBuffer.append("Last request: ").append(this.lastRequest).append("<br>\n");
        return stringBuffer.toString();
    }

    protected void destroy() {
    }

    public String freeConnectionBean(ConnectionBean connectionBean) {
        block3: {
            if (connectionBean != null) {
                try {
                    this.lastRequest = connectionBean.getLastStatement();
                    this.totalStatements += connectionBean.getNumStatements();
                    connectionBean.closeConnection();
                }
                catch (Exception exception) {
                    if (this.log == null) break block3;
                    this.log.println(new Date().toString() + " Unable to close DB connection: " + exception);
                }
            }
        }
        return "";
    }

    public ConnectionBean getConnectionBean() {
        ConnectionBean connectionBean;
        block4: {
            connectionBean = null;
            try {
                if (this.ds != null) {
                    Connection connection = this.ds.getConnection();
                    connectionBean = new ConnectionBean(connection, this.mapStatements);
                    ++this.totalCBRequests;
                    this.lastUse = new Date();
                }
                if (this.log != null && this.debugLevel > 2) {
                    this.log.println(new Date().toString() + " - connection request");
                }
            }
            catch (Exception exception) {
                if (this.log == null) break block4;
                this.log.println(new Date().toString() + " Unable to get DB connection: " + exception.getMessage());
            }
        }
        return connectionBean;
    }
}

