/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import javax.swing.JOptionPane;

public class BrowserLauncher {
    private static String preferredBrowser;
    public static final String BROWSER = "browser";
    private static final String errMsg = "Error attempting to launch web browser";

    public static void openURL(URL uRL, Component component) {
        BrowserLauncher.openURL(uRL.toExternalForm(), component);
    }

    public static void openURL(String string, Component component) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getDeclaredMethod("getDesktop", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getDeclaredMethod("browse", URI.class);
            URI uRI = new URI(string);
            method2.invoke(object, uRI);
            return;
        }
        catch (Exception exception) {
            String string2 = System.getProperty("os.name");
            try {
                if (string2.startsWith("Mac OS")) {
                    Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                    Method method = clazz.getDeclaredMethod("openURL", String.class);
                    method.invoke(null, string);
                    return;
                }
                String[] stringArray = null;
                if (string2.startsWith("Windows")) {
                    stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", string};
                } else {
                    String[] stringArray2 = new String[]{preferredBrowser, "xdg-open", "sensible-browser", "chromium", "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String string3 = null;
                    for (int i = 0; i < stringArray2.length && string3 == null; ++i) {
                        if (stringArray2[i] == null || stringArray2[i].length() <= 0 || Runtime.getRuntime().exec(new String[]{"which", stringArray2[i]}).waitFor() != 0) continue;
                        string3 = stringArray2[i];
                    }
                    if (string3 == null) {
                        throw new Exception("Could not find web browser");
                    }
                    stringArray = new String[]{string3, string};
                }
                if (Runtime.getRuntime().exec(stringArray).waitFor() != 0) {
                    throw new Exception("Error opening page: " + string);
                }
            }
            catch (Exception exception2) {
                JOptionPane.showMessageDialog(component, "Error attempting to launch web browser:\n" + exception2.getLocalizedMessage());
            }
            return;
        }
    }

    public static void openURL(URL uRL) {
        BrowserLauncher.openURL(uRL, null);
    }

    public static void openURL(String string) {
        BrowserLauncher.openURL(string, null);
    }

    public static void setPreferredBrowser(String string) {
        preferredBrowser = StrUtils.nullableString(string);
    }

    public static String getPreferredBrowser(String string) {
        return StrUtils.secureString(preferredBrowser, string);
    }
}

