/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.util.JDomUtility;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.StringTokenizer;
import org.jdom.Element;

public class ShapeData
implements Cloneable {
    public static final int CAPACITY_BLOCK = 6;
    protected double[] points = new double[12];
    protected int pointsIndex = 0;
    protected int[] descriptors = new int[6];
    protected int descriptorsIndex = 0;
    protected int windingRule = 1;
    protected int primitiveType = -1;
    protected double[] primitivePoints = null;
    public String comment = null;
    public static final String ELEMENT_NAME = "shape";
    public static final String COMMENT = "comment";
    public static final int RECTANGLE = 0;
    public static final int ELLIPSE = 1;
    public static final int ROUND_RECT = 2;
    public static final int ARC = 3;
    public static final int NUM_PRIMITIVES = 4;
    public static final String[] PRIMITIVES = new String[]{"rectangle", "ellipse", "roundRectangle", "pie"};
    public static final String RULE = "rule";
    public static final String MOVE_TO = "M";
    public static final String LINE_TO = "L";
    public static final String QUAD_TO = "Q";
    public static final String CUBIC_TO = "B";
    public static final String CLOSE = "X";
    public static final String DELIMS = "|:,";
    public static final char[] DELIM_CHAR = "|:,".toCharArray();
    private static DecimalFormat DF;

    public Element getJDomElement(double d, double d2) {
        Element element = new Element(ELEMENT_NAME);
        if (this.comment != null && this.comment.length() > 0) {
            element.setAttribute(COMMENT, this.comment);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.primitiveType >= 0 && this.primitivePoints != null) {
            this.writeToSb(stringBuffer, PRIMITIVES[this.primitiveType], this.primitivePoints, n, this.primitivePoints.length, d, d2);
        } else {
            if (this.windingRule != 1) {
                element.setAttribute(RULE, Integer.toString(this.windingRule));
            }
            for (int i = 0; i < this.descriptorsIndex; ++i) {
                String string = CLOSE;
                int n2 = 0;
                if (i > 0) {
                    stringBuffer.append(DELIM_CHAR[0]);
                }
                switch (this.descriptors[i]) {
                    case 0: {
                        string = MOVE_TO;
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        string = LINE_TO;
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        string = QUAD_TO;
                        n2 = 4;
                        break;
                    }
                    case 3: {
                        string = CUBIC_TO;
                        n2 = 6;
                        break;
                    }
                }
                this.writeToSb(stringBuffer, string, this.points, n, n2, d, d2);
                n += n2;
            }
        }
        element.addContent(stringBuffer.substring(0));
        return element;
    }

    public static ShapeData getShapeData(Element element, double d, double d2) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        ShapeData shapeData = new ShapeData();
        shapeData.comment = JDomUtility.getStringAttr(element, COMMENT, shapeData.comment, false);
        shapeData.setWindingRule(JDomUtility.getIntAttr(element, RULE, shapeData.windingRule));
        StringTokenizer stringTokenizer = new StringTokenizer(element.getText(), DELIMS);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            for (int i = 0; i < 4; ++i) {
                if (!string.equals(PRIMITIVES[i])) continue;
                double[] dArray = ShapeData.decodeData(stringTokenizer, i >= 2 ? 6 : 4, d, d2);
                RectangularShape rectangularShape = null;
                switch (i) {
                    case 0: {
                        rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 1: {
                        rectangularShape = new Ellipse2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 2: {
                        rectangularShape = new RoundRectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        break;
                    }
                    case 3: {
                        rectangularShape = new Arc2D.Double(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4] * d, dArray[5] * d2, 2);
                        break;
                    }
                    default: {
                        throw new Exception("unknown primitive shape!");
                    }
                }
                if (rectangularShape == null) continue;
                return ShapeData.getShapeData(rectangularShape, shapeData.comment);
            }
            if (string.equals(MOVE_TO)) {
                shapeData.addDescriptor(0);
                shapeData.addData(ShapeData.decodeData(stringTokenizer, 2, d, d2));
                continue;
            }
            if (string.equals(LINE_TO)) {
                shapeData.addDescriptor(1);
                shapeData.addData(ShapeData.decodeData(stringTokenizer, 2, d, d2));
                continue;
            }
            if (string.equals(QUAD_TO)) {
                shapeData.addDescriptor(2);
                shapeData.addData(ShapeData.decodeData(stringTokenizer, 4, d, d2));
                continue;
            }
            if (string.equals(CUBIC_TO)) {
                shapeData.addDescriptor(3);
                shapeData.addData(ShapeData.decodeData(stringTokenizer, 6, d, d2));
                continue;
            }
            if (string.equals(CLOSE)) {
                shapeData.addDescriptor(4);
                continue;
            }
            throw new IllegalArgumentException("Unknown ShapeData type: " + string);
        }
        return shapeData;
    }

    private void writeToSb(StringBuffer stringBuffer, String string, double[] dArray, int n, int n2, double d, double d2) {
        stringBuffer.append(string);
        if (n2 > 0) {
            if (DF == null) {
                DF = new DecimalFormat("0.0#####");
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                decimalFormatSymbols.setDecimalSeparator('.');
                DF.setDecimalFormatSymbols(decimalFormatSymbols);
            }
            stringBuffer.append(DELIM_CHAR[1]);
            for (int i = 0; i < n2; ++i) {
                String string2;
                if ((string2 = DF.format(dArray[n++] * ((n & 1) != 0 ? d : d2))).endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                if (i > 0) {
                    stringBuffer.append(DELIM_CHAR[2]);
                }
                stringBuffer.append(string2);
            }
        }
    }

    private void addDescriptor(int n) {
        if (this.descriptorsIndex + 1 >= this.descriptors.length) {
            int[] nArray = new int[this.descriptors.length + 6];
            for (int i = 0; i < this.descriptorsIndex; ++i) {
                nArray[i] = this.descriptors[i];
            }
            this.descriptors = nArray;
        }
        this.descriptors[this.descriptorsIndex++] = n;
    }

    private void addData(double[] dArray) {
        if (dArray == null) {
            return;
        }
        if (this.pointsIndex + dArray.length >= this.points.length) {
            double[] dArray2 = new double[this.points.length + 12];
            for (int i = 0; i < this.pointsIndex; ++i) {
                dArray2[i] = this.points[i];
            }
            this.points = dArray2;
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.points[this.pointsIndex++] = dArray[i];
        }
    }

    private static double[] decodeData(StringTokenizer stringTokenizer, int n, double d, double d2) throws Exception {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Double.parseDouble(stringTokenizer.nextToken()) / ((i & 1) == 0 ? d : d2);
        }
        return dArray;
    }

    protected void add(int n, double[] dArray) {
        this.addDescriptor(n);
        if (dArray != null) {
            this.addData(dArray);
        }
    }

    public void moveTo(double d, double d2) {
        this.add(0, new double[]{d, d2});
    }

    public void lineTo(double d, double d2) {
        this.add(1, new double[]{d, d2});
    }

    public void quadTo(double d, double d2, double d3, double d4) {
        this.add(2, new double[]{d, d2, d3, d4});
    }

    public void cubicTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.add(3, new double[]{d, d2, d3, d4, d5, d6});
    }

    public void closePath() {
        this.add(4, null);
    }

    public void setWindingRule(int n) {
        this.windingRule = n;
    }

    public void scaleTo(double d, double d2) {
        int n;
        if (this.points != null) {
            for (n = 0; n < this.points.length; n += 2) {
                int n2 = n;
                this.points[n2] = this.points[n2] / d;
                int n3 = n + 1;
                this.points[n3] = this.points[n3] / d2;
            }
        }
        if (this.primitivePoints != null) {
            for (n = 0; n < this.primitivePoints.length; n += 2) {
                int n4 = n;
                this.primitivePoints[n4] = this.primitivePoints[n4] / d;
                int n5 = n + 1;
                this.primitivePoints[n5] = this.primitivePoints[n5] / d2;
            }
        }
    }

    public Shape getShape(Rectangle2D rectangle2D) {
        return this.getShape(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Shape getShape(double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath(this.windingRule, this.pointsIndex + 1);
        int n = 0;
        block6: for (int i = 0; i < this.descriptorsIndex; ++i) {
            switch (this.descriptors[i]) {
                case 0: {
                    generalPath.moveTo((float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]));
                    continue block6;
                }
                case 1: {
                    generalPath.lineTo((float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]));
                    continue block6;
                }
                case 2: {
                    generalPath.quadTo((float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]), (float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]));
                    continue block6;
                }
                case 3: {
                    generalPath.curveTo((float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]), (float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]), (float)(d + d3 * this.points[n++]), (float)(d2 + d4 * this.points[n++]));
                    continue block6;
                }
                default: {
                    generalPath.closePath();
                }
            }
        }
        return generalPath;
    }

    public static ShapeData getShapeData(Shape shape, String string) {
        return ShapeData.getShapeData(shape, string, true);
    }

    public static ShapeData getShapeData(Shape shape, String string, boolean bl) {
        Object object;
        Object object2;
        ShapeData shapeData = new ShapeData();
        shapeData.comment = string;
        if (shape instanceof RectangularShape) {
            object2 = (RectangularShape)shape;
            if (shape instanceof Rectangle2D) {
                shapeData.primitiveType = 0;
                shapeData.primitivePoints = new double[]{((RectangularShape)object2).getX(), ((RectangularShape)object2).getY(), ((RectangularShape)object2).getWidth(), ((RectangularShape)object2).getHeight()};
            } else if (shape instanceof Ellipse2D) {
                shapeData.primitiveType = 1;
                shapeData.primitivePoints = new double[]{((RectangularShape)object2).getX(), ((RectangularShape)object2).getY(), ((RectangularShape)object2).getWidth(), ((RectangularShape)object2).getHeight()};
            } else if (shape instanceof RoundRectangle2D) {
                shapeData.primitiveType = 2;
                object = (RoundRectangle2D)shape;
                shapeData.primitivePoints = new double[]{((RectangularShape)object2).getX(), ((RectangularShape)object2).getY(), ((RectangularShape)object2).getWidth(), ((RectangularShape)object2).getHeight(), ((RoundRectangle2D)object).getArcWidth(), ((RoundRectangle2D)object).getArcHeight()};
            } else if (shape instanceof Arc2D && ((Arc2D)(object = (Object)((Arc2D)shape))).getArcType() == 2) {
                shapeData.primitiveType = 3;
                shapeData.primitivePoints = new double[]{((RectangularShape)object2).getX(), ((RectangularShape)object2).getY(), ((RectangularShape)object2).getWidth(), ((RectangularShape)object2).getHeight(), ((Arc2D)object).getAngleStart(), ((Arc2D)object).getAngleExtent()};
            }
        }
        object2 = shape.getPathIterator(null);
        object = new double[6];
        shapeData.setWindingRule(object2.getWindingRule());
        while (!object2.isDone()) {
            switch (object2.currentSegment((double[])object)) {
                case 0: {
                    shapeData.moveTo((double)object[0], (double)object[1]);
                    break;
                }
                case 1: {
                    shapeData.lineTo((double)object[0], (double)object[1]);
                    break;
                }
                case 2: {
                    shapeData.quadTo((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
                    break;
                }
                case 3: {
                    shapeData.cubicTo((double)object[0], (double)object[1], (double)object[2], (double)object[3], (double)object[4], (double)object[5]);
                    break;
                }
                case 4: {
                    if (!bl) break;
                    shapeData.closePath();
                    break;
                }
                default: {
                    System.err.println("ShapeData error: Unknown PathIterator!");
                }
            }
            object2.next();
        }
        return shapeData;
    }

    public Object clone() throws CloneNotSupportedException {
        ShapeData shapeData = (ShapeData)super.clone();
        if (this.points != null) {
            shapeData.points = (double[])this.points.clone();
        }
        if (this.descriptors != null) {
            shapeData.descriptors = (int[])this.descriptors.clone();
        }
        if (this.primitivePoints != null) {
            shapeData.primitivePoints = (double[])this.primitivePoints.clone();
        }
        return shapeData;
    }
}

