/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectInstaller
implements Domable {
    public static final String SEP = ";";
    public static final String ITEM_SEP = ",";
    public static final String EQUAL_SEP = ":";
    public static final String FILES = "files";
    public static final String ITEM_NAMES = "itemNames";
    public static final String ITEM_PROJECTS = "itemProjects";
    public static final String ITEM_ICONS = "itemIcons";
    public static final String ITEM_DESCRIPTIONS = "itemDescriptions";
    public static final String ELEMENT_NAME = "JClicInstall";
    public static final String TITLE = "title";
    public static final String AUTHORS = "authors";
    public static final String FROM = "from";
    public static final String FILE = "file";
    public static final String SRC = "src";
    public static final String FOLDER = "folder";
    public static final String SHORTCUT = "shortcut";
    public static final String ICON = "icon";
    public static final String PROJECT = "project";
    public static final String TEXT = "text";
    public static final String DESCRIPTION = "description";
    public static final String INSTALLER_EXTENSION = ".jclic.inst";
    public String fName;
    public String from;
    public String baseFolder;
    public String projectTitle;
    public String authors;
    public Vector files = new Vector();
    public Vector iconItems = new Vector();

    public Element getJDomElement() {
        return this.getJDomElement(true);
    }

    public Element getJDomElement(boolean bl) {
        int n;
        Element element = null;
        Element element2 = new Element(ELEMENT_NAME);
        JDomUtility.setStringAttr(element2, TITLE, this.projectTitle, false);
        JDomUtility.setStringAttr(element2, AUTHORS, this.authors, false);
        JDomUtility.setStringAttr(element2, FOLDER, this.baseFolder, false);
        if (bl) {
            JDomUtility.setStringAttr(element2, FROM, this.from, false);
        }
        if (this.files != null) {
            for (n = 0; n < this.files.size(); ++n) {
                element = new Element(FILE);
                element.setAttribute(SRC, this.getFile(n));
                element2.addContent(element);
            }
        }
        if (this.iconItems != null) {
            for (n = 0; n < this.iconItems.size(); ++n) {
                IconItem iconItem = this.getIconItem(n);
                element = new Element(SHORTCUT);
                JDomUtility.setStringAttr(element, PROJECT, iconItem.project, false);
                JDomUtility.setStringAttr(element, TEXT, iconItem.text, false);
                JDomUtility.setStringAttr(element, DESCRIPTION, iconItem.description, false);
                JDomUtility.setStringAttr(element, ICON, iconItem.icon, false);
                element2.addContent(element);
            }
        }
        return element2;
    }

    public static ProjectInstaller getProjectInstaller(String string) throws Exception {
        InputStream inputStream = null;
        boolean bl = FileSystem.isStrUrl(string);
        URL uRL = null;
        File file = null;
        if (bl) {
            uRL = new URL(string);
            inputStream = uRL.openStream();
        } else {
            file = new File(string);
            inputStream = new FileInputStream(file);
        }
        Document document = JDomUtility.getSAXBuilder().build(inputStream);
        JDomUtility.clearNewLineElements(document.getRootElement());
        inputStream.close();
        ProjectInstaller projectInstaller = ProjectInstaller.getProjectInstaller(document.getRootElement());
        String string2 = null;
        String string3 = null;
        if (bl) {
            String string4 = uRL.toExternalForm();
            int n = string4.lastIndexOf(47);
            if (n < 0) {
                throw new Exception("Unable to get install store path from " + string4);
            }
            string2 = string4.substring(0, n);
            string3 = string4.substring(n + 1);
        } else {
            string2 = file.getParent();
            string3 = file.getName();
        }
        if (string2 != null) {
            projectInstaller.from = string2;
        }
        if (string3 != null) {
            projectInstaller.fName = string3;
        }
        return projectInstaller;
    }

    public static ProjectInstaller getProjectInstaller(Element element) throws Exception {
        ProjectInstaller projectInstaller = new ProjectInstaller();
        projectInstaller.setProperties(element, null);
        return projectInstaller;
    }

    public void setProperties(Element element, Object object) throws Exception {
        Iterator iterator = null;
        Element element2 = null;
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.projectTitle = JDomUtility.getStringAttr(element, TITLE, this.projectTitle, false);
        this.authors = JDomUtility.getStringAttr(element, AUTHORS, this.authors, false);
        this.baseFolder = JDomUtility.getStringAttr(element, FOLDER, this.baseFolder, false);
        this.from = JDomUtility.getStringAttr(element, FROM, this.from, false);
        iterator = element.getChildren(FILE).iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            this.addFile(JDomUtility.getStringAttr(element2, SRC, null, false));
        }
        iterator = element.getChildren(SHORTCUT).iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            IconItem iconItem = this.createIconItem();
            iconItem.project = JDomUtility.getStringAttr(element2, PROJECT, iconItem.project, false);
            iconItem.text = JDomUtility.getStringAttr(element2, TEXT, iconItem.text, false);
            iconItem.description = JDomUtility.getStringAttr(element2, DESCRIPTION, iconItem.description, false);
            iconItem.icon = JDomUtility.getStringAttr(element2, ICON, iconItem.icon, false);
        }
    }

    public void addFile(String string) {
        if (string != null && !this.files.contains(string)) {
            this.files.add(string);
        }
    }

    public String getFile(int n) {
        if (this.files != null && n < this.files.size()) {
            return (String)this.files.get(n);
        }
        return null;
    }

    public IconItem getIconItem(int n) {
        if (this.iconItems != null && n < this.iconItems.size()) {
            return (IconItem)this.iconItems.get(n);
        }
        return null;
    }

    public IconItem createIconItem() {
        IconItem iconItem = new IconItem();
        this.iconItems.add(iconItem);
        return iconItem;
    }

    public class IconItem {
        protected String text;
        protected String description;
        protected String project;
        protected String icon;

        public String toString() {
            return this.project == null ? "--" : this.project;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String string) {
            this.icon = string;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String string) {
            this.project = string;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }
    }
}

