/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.AudioBuffer;
import edu.xtec.jclic.media.ByteDataSource;
import edu.xtec.jclic.media.JavaSoundAudioBuffer;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;

public class JMFActiveMediaPlayer
extends ActiveMediaPlayer
implements ControllerListener {
    public static Sequencer sequencer = null;
    Player player = null;
    DataSource dataSource = null;
    boolean midi = false;
    ByteArrayInputStream midiIs = null;

    public JMFActiveMediaPlayer(MediaContent mediaContent, MediaBag mediaBag, PlayStation playStation) {
        super(mediaContent, mediaBag, playStation);
        if (!this.useAudioBuffer) {
            try {
                switch (mediaContent.mediaType) {
                    case 3: {
                        this.midi = true;
                        InputStream inputStream = mediaBag.getInputStream(mediaContent.mediaFileName);
                        if (inputStream instanceof ByteArrayInputStream) {
                            this.midiIs = (ByteArrayInputStream)inputStream;
                            break;
                        }
                        this.midiIs = new ExtendedByteArrayInputStream(StreamIO.readInputStream(inputStream), mediaContent.mediaFileName);
                        break;
                    }
                    default: {
                        Object object = mediaBag.getMediaDataSource(mediaContent.mediaFileName);
                        if (object instanceof ExtendedByteArrayInputStream) {
                            this.dataSource = new ByteDataSource((ExtendedByteArrayInputStream)object);
                            break;
                        }
                        if (object instanceof String) {
                            MediaLocator mediaLocator = new MediaLocator((String)object);
                            this.dataSource = Manager.createDataSource((MediaLocator)mediaLocator);
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error reading media \"" + mediaContent.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public AudioBuffer createAudioBuffer(int n) throws Exception {
        return new JavaSoundAudioBuffer(this.mc.length);
    }

    public static void closeMidiSequencer() {
        if (sequencer != null) {
            if (sequencer.isRunning()) {
                sequencer.stop();
            }
            if (sequencer.isOpen()) {
                sequencer.close();
            }
        }
    }

    public void realize() {
        if (!this.useAudioBuffer) {
            try {
                if (this.midi) {
                    if (sequencer == null) {
                        sequencer = MidiSystem.getSequencer();
                    }
                } else {
                    if (this.player == null && this.dataSource != null) {
                        this.player = Manager.createPlayer((DataSource)this.dataSource);
                        if (this.player != null) {
                            this.player.addControllerListener((ControllerListener)this);
                        }
                    }
                    if (this.player != null) {
                        if (this.player.getState() < 300) {
                            this.player.realize();
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error realizing media \"" + this.mc.mediaFileName + "\"\n" + exception);
            }
        }
    }

    protected void playNow(ActiveBox activeBox) {
        if (this.useAudioBuffer) {
            super.playNow(activeBox);
        } else {
            try {
                if (this.midi) {
                    if (sequencer == null) {
                        this.realize();
                    }
                    if (sequencer != null && this.midiIs != null) {
                        if (sequencer.isRunning()) {
                            sequencer.stop();
                        }
                        if (!sequencer.isOpen()) {
                            sequencer.open();
                        }
                        this.midiIs.reset();
                        sequencer.setSequence(this.midiIs);
                        sequencer.stop();
                        this.setTimeRanges();
                        sequencer.start();
                    }
                } else {
                    if (this.player == null && this.dataSource != null) {
                        this.realize();
                    }
                    if (this.player != null) {
                        boolean bl = false;
                        if (this.mc.mediaType == 2) {
                            this.linkTo(activeBox);
                        }
                        if (this.player.getState() >= 300) {
                            this.setTimeRanges();
                            this.attachVisualComponent();
                        } else {
                            bl = true;
                        }
                        this.player.start();
                        if (bl) {
                            if (this.player.getState() >= 300) {
                                this.attachVisualComponent();
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error playing media \"" + this.mc.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public void stop() {
        super.stop();
        if (!this.useAudioBuffer) {
            try {
                if (this.midi && sequencer != null) {
                    JMFActiveMediaPlayer.closeMidiSequencer();
                } else if (this.player != null) {
                    if (this.player.getState() == 600) {
                        this.player.stop();
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error stopping media \"" + this.mc.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public void clear() {
        super.clear();
        if (!this.useAudioBuffer) {
            try {
                if (this.midi) {
                    if (sequencer != null) {
                        sequencer.close();
                        sequencer = null;
                    }
                    if (this.midiIs != null) {
                        this.midiIs.close();
                        this.midiIs = null;
                    }
                } else if (this.player != null) {
                    this.destroyVisualComponent();
                    this.player.close();
                }
            }
            catch (Exception exception) {
                System.err.println("Error closing media \"" + this.mc.mediaFileName + "\":\n" + exception);
            }
        }
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (this.player == null) {
            return;
        }
        try {
            if (controllerEvent instanceof RealizeCompleteEvent) {
                this.setTimeRanges();
                this.attachVisualComponent();
                if (this.player != null) {
                    this.player.prefetch();
                }
            } else if (controllerEvent instanceof EndOfMediaEvent) {
                if (this.mc.loop) {
                    this.player.setMediaTime(new Time(0L));
                    this.player.start();
                }
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                this.ps.setSystemMessage(this.ps.getMsg("msg_error_playing_media"), "");
                System.err.println("Controller error event:\n" + ((ControllerErrorEvent)controllerEvent).getMessage());
                this.clear();
            } else if (controllerEvent instanceof ControllerClosedEvent) {
                this.visualComponent = null;
                this.destroyVisualComponent();
                this.player.deallocate();
                this.player = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Controller event update error for \"" + this.mc.mediaFileName + "\":\n" + exception);
        }
    }

    protected void setTimeRanges() {
        if (this.useAudioBuffer) {
            return;
        }
        try {
            if (this.midi && sequencer != null) {
                sequencer.setTickPosition(0L);
            } else if (this.player != null) {
                if (this.player.getState() >= 300) {
                    if (this.mc.from != -1) {
                        this.player.setMediaTime(new Time(1000000L * (long)this.mc.from));
                    } else {
                        this.player.setMediaTime(new Time(0L));
                    }
                    if (this.mc.to != -1) {
                        this.player.setStopTime(new Time(1000000L * (long)this.mc.to));
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error setting time ranges for \"" + this.mc.mediaFileName + "\":\n" + exception);
        }
    }

    protected Component getVisualComponent() {
        if (this.player == null || this.player.getState() < 300) {
            return null;
        }
        return this.player.getVisualComponent();
    }
}

