/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.bags.MediaBagElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.shapers.Rectangular;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Element;

public class ActiveBagContent
implements Domable {
    public Image img;
    public String imgName;
    public int ncw;
    public int nch;
    public double w;
    public double h;
    public boolean border;
    public BoxBase bb;
    protected Shaper shaper;
    protected ActiveBoxContent backgroundContent;
    protected ArrayList activeBoxContentArray = new ArrayList(12);
    public int defaultIdValue = -1;
    public static final String ELEMENT_NAME = "cells";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String COLS = "cols";
    public static final String CELL_WIDTH = "cellWidth";
    public static final String CELL_HEIGHT = "cellHeight";
    public static final String BORDER = "border";
    public static final String IMAGE = "image";
    public static final String IDS = "ids";

    private ActiveBagContent() {
    }

    public ActiveBagContent(int n, int n2) {
        this.ncw = Math.max(1, n);
        this.nch = Math.max(1, n2);
        this.w = 20.0;
        this.h = 20.0;
    }

    public static ActiveBagContent initNew(int n, int n2, int n3) {
        return ActiveBagContent.initNew(n, n2, n3, false, false, 50, 30);
    }

    public static ActiveBagContent initNew(int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5) {
        ActiveBagContent activeBagContent = new ActiveBagContent(n, n2);
        activeBagContent.w = n4;
        activeBagContent.h = n5;
        activeBagContent.setBoxBase(new BoxBase());
        activeBagContent.border = true;
        char[] cArray = null;
        if (n3 > 0) {
            cArray = new char[]{(char)n3};
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                ActiveBoxContent activeBoxContent = new ActiveBoxContent();
                if (cArray != null) {
                    activeBoxContent.setTextContent("");
                    cArray[0] = (char)(cArray[0] + '\u0001');
                } else {
                    activeBoxContent.setTextContent("");
                }
                if (bl) {
                    if (bl2) {
                        activeBoxContent.id = j;
                        activeBoxContent.item = i;
                    } else {
                        activeBoxContent.id = i * n + j;
                    }
                }
                activeBagContent.addActiveBoxContent(activeBoxContent);
            }
        }
        return activeBagContent;
    }

    public void checkCells() {
        block3: {
            int n;
            int n2;
            block2: {
                n2 = this.getShaper().getNumCells();
                n = this.activeBoxContentArray.size();
                if (n <= n2) break block2;
                while (this.activeBoxContentArray.size() > n2) {
                    this.activeBoxContentArray.remove(this.activeBoxContentArray.size() - 1);
                }
                break block3;
            }
            if (n2 <= n) break block3;
            for (int i = n; i < n2; ++i) {
                ActiveBoxContent activeBoxContent = this.getActiveBoxContent(i);
                activeBoxContent.id = this.defaultIdValue;
            }
        }
    }

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        if (this.ncw > 0 || this.nch > 0) {
            element.setAttribute(ROWS, Integer.toString(this.nch));
            element.setAttribute(COLS, Integer.toString(this.ncw));
        }
        if (this.imgName == null && (this.w != 0.0 || this.h != 0.0)) {
            element.setAttribute(CELL_WIDTH, Double.toString(this.w));
            element.setAttribute(CELL_HEIGHT, Double.toString(this.h));
        }
        element.setAttribute(BORDER, JDomUtility.boolString(this.border));
        if (this.imgName != null) {
            element.setAttribute(IMAGE, this.imgName);
        }
        if (this.bb != null) {
            element.addContent(this.bb.getJDomElement());
        }
        if (this.shaper != null) {
            element.addContent(this.shaper.getJDomElement());
        }
        switch (this.testCellContents()) {
            case 0: {
                break;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
                    stringBuffer.append(this.getActiveBoxContent((int)i).id).append(" ");
                }
                element.addContent(new Element(IDS).addContent(stringBuffer.substring(0).trim()));
                break;
            }
            default: {
                for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
                    element.addContent(this.getActiveBoxContent(i).getJDomElement());
                }
            }
        }
        return element;
    }

    public int testCellContents() {
        int n = 0;
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            int n2 = this.getActiveBoxContent(i).testCellContents();
            if (n2 <= n) continue;
            n = n2;
            if (n2 > 1) break;
        }
        return n;
    }

    public static ActiveBagContent getActiveBagContent(Element element, MediaBag mediaBag) throws Exception {
        ActiveBagContent activeBagContent = new ActiveBagContent();
        activeBagContent.setProperties(element, mediaBag);
        return activeBagContent;
    }

    public void setProperties(Element element, Object object) throws Exception {
        int n;
        int n2;
        Iterator iterator;
        JDomUtility.checkName(element, ELEMENT_NAME);
        MediaBag mediaBag = (MediaBag)object;
        int n3 = JDomUtility.getIntAttr(element, COLS, -1);
        if (n3 >= 0) {
            this.ncw = n3;
            this.nch = JDomUtility.getIntAttr(element, ROWS, this.nch);
        } else {
            this.ncw = JDomUtility.getIntAttr(element, ROWS, this.ncw);
            this.nch = JDomUtility.getIntAttr(element, COLUMNS, this.nch);
        }
        this.activeBoxContentArray.ensureCapacity(Math.max(12, this.ncw * this.nch));
        this.w = JDomUtility.getDoubleAttr(element, CELL_WIDTH, this.w);
        this.h = JDomUtility.getDoubleAttr(element, CELL_HEIGHT, this.h);
        this.border = JDomUtility.getBoolAttr(element, BORDER, this.border);
        this.imgName = FileSystem.stdFn(element.getAttributeValue(IMAGE));
        Element element2 = element.getChild("style");
        if (element2 != null) {
            this.setBoxBase(BoxBase.getBoxBase(element2));
        }
        if ((element2 = element.getChild("shaper")) != null) {
            this.setShaper(Shaper.getShaper(element2));
        }
        if ((iterator = element.getChildren("cell").iterator()).hasNext()) {
            while (iterator.hasNext()) {
                element2 = (Element)iterator.next();
                this.addActiveBoxContent(ActiveBoxContent.getActiveBoxContent(element2, mediaBag));
            }
        } else {
            int[] nArray;
            element2 = element.getChild(IDS);
            if (element2 != null && (nArray = JDomUtility.stringToIntArray(element2.getText())) != null) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    this.getActiveBoxContent((int)n2).id = nArray[n2];
                }
            }
        }
        if (this.imgName != null && mediaBag != null && mediaBag.getProject().getBridge() != null) {
            this.setImgContent(mediaBag.getImageElement(this.imgName), true);
        }
        if ((n = this.activeBoxContentArray.size()) > 0) {
            int n4;
            n2 = 1;
            for (n4 = 0; n4 < n; ++n4) {
                ActiveBoxContent activeBoxContent = this.getActiveBoxContent(n4);
                if (activeBoxContent.id == -1 && activeBoxContent.item == -1 && activeBoxContent.isEmpty()) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                for (n4 = 0; n4 < n; ++n4) {
                    this.getActiveBoxContent((int)n4).id = n4;
                }
            }
        }
    }

    public static void listReferences(Element element, HashMap hashMap) {
        String string = element.getAttributeValue(IMAGE);
        if (string != null) {
            hashMap.put(string, "media");
        }
        Iterator iterator = element.getChildren("cell").iterator();
        while (iterator.hasNext()) {
            ActiveBoxContent.listReferences((Element)iterator.next(), hashMap);
        }
    }

    public Shaper getShaper() {
        if (this.shaper == null) {
            this.setShaper(new Rectangular(this.ncw, this.nch));
        }
        return this.shaper;
    }

    public void setShaper(Shaper shaper) {
        this.shaper = shaper;
    }

    public void addActiveBoxContent(ActiveBoxContent activeBoxContent) {
        this.activeBoxContentArray.add(activeBoxContent);
        if (this.ncw == 0 || this.nch == 0) {
            this.ncw = 1;
            this.nch = 1;
        }
    }

    public ActiveBoxContent getActiveBoxContent(int n) {
        if (n >= this.activeBoxContentArray.size()) {
            for (int i = this.activeBoxContentArray.size(); i <= n; ++i) {
                this.activeBoxContentArray.add(new ActiveBoxContent());
            }
        }
        return (ActiveBoxContent)this.activeBoxContentArray.get(n);
    }

    public ActiveBoxContent getActiveBoxContentWith(int n, int n2) {
        ActiveBoxContent activeBoxContent = null;
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            ActiveBoxContent activeBoxContent2 = (ActiveBoxContent)this.activeBoxContentArray.get(i);
            if (activeBoxContent2.id != n || activeBoxContent2.item != n2) continue;
            activeBoxContent = activeBoxContent2;
            break;
        }
        return activeBoxContent;
    }

    public void deleteActiveBoxContentWith(int n, int n2) {
        ActiveBoxContent activeBoxContent = this.getActiveBoxContentWith(n, n2);
        if (activeBoxContent != null) {
            this.activeBoxContentArray.remove(activeBoxContent);
            for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
                activeBoxContent = (ActiveBoxContent)this.activeBoxContentArray.get(i);
                if (activeBoxContent.id != n || activeBoxContent.item <= n2) continue;
                --activeBoxContent.item;
            }
        }
    }

    public void insertActiveBoxContentWith(int n, int n2) {
        ActiveBoxContent activeBoxContent = this.getActiveBoxContentWith(n, n2);
        int n3 = this.activeBoxContentArray.indexOf(activeBoxContent);
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            activeBoxContent = (ActiveBoxContent)this.activeBoxContentArray.get(i);
            if (activeBoxContent.id != n || activeBoxContent.item < n2) continue;
            ++activeBoxContent.item;
        }
        activeBoxContent = new ActiveBoxContent();
        activeBoxContent.id = n;
        activeBoxContent.item = n2;
        this.activeBoxContentArray.add(n3 + 1, activeBoxContent);
    }

    public int indexOf(ActiveBoxContent activeBoxContent) {
        int n = -1;
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            if (this.activeBoxContentArray.get(i) != activeBoxContent) continue;
            n = i;
            break;
        }
        return n;
    }

    public void setActiveBoxContentAt(ActiveBoxContent activeBoxContent, int n) {
        if (n >= 0) {
            this.getActiveBoxContent(n);
            this.activeBoxContentArray.set(n, activeBoxContent);
        }
    }

    public void setImgContent(MediaBagElement mediaBagElement, boolean bl) throws Exception {
        this.setImgContent(mediaBagElement, this.getShaper(), bl);
    }

    public void setImgContent(MediaBagElement mediaBagElement, Shaper shaper) throws Exception {
        this.setImgContent(mediaBagElement, shaper, false);
    }

    public void setImgContent(MediaBagElement mediaBagElement, Shaper shaper, boolean bl) throws Exception {
        this.setShaper(shaper);
        this.ncw = this.shaper.getNumColumns();
        this.nch = this.shaper.getNumRows();
        if (mediaBagElement != null) {
            this.img = mediaBagElement.getImage();
            this.imgName = mediaBagElement.getName();
            this.w = -1.0;
            this.h = -1.0;
            while (true) {
                this.w = (double)this.img.getWidth(null) / (double)this.ncw;
                this.h = (double)this.img.getHeight(null) / (double)this.nch;
                if (this.w >= 0.0 && this.h >= 0.0) break;
                Thread.currentThread();
                Thread.sleep(50L);
            }
            if (bl) {
                this.w = (int)this.w;
                this.h = (int)this.h;
            }
            if (this.w < 1.0 || this.h < 1.0) {
                throw new Exception("Invalid image!");
            }
        } else {
            this.img = null;
            this.imgName = null;
            this.w = Math.max(this.w, 10.0);
            this.h = Math.max(this.h, 10.0);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.w * (double)this.ncw, this.h * (double)this.nch);
        this.activeBoxContentArray.ensureCapacity(this.shaper.getNumCells());
        for (int i = 0; i < this.shaper.getNumCells(); ++i) {
            this.getActiveBoxContent(i).setImgContent(this.img, this.shaper.getShape(i, double_));
        }
        if (this.shaper.hasRemainder()) {
            this.backgroundContent = new ActiveBoxContent();
            this.backgroundContent.setImgContent(this.img, this.shaper.getRemainderShape(double_));
        }
    }

    public void setTextContent(String[] stringArray, int n, int n2) {
        this.ncw = Math.max(1, n);
        this.nch = Math.max(1, n2);
        int n3 = this.ncw * this.nch;
        this.activeBoxContentArray.ensureCapacity(n3);
        for (int i = 0; i < n3; ++i) {
            this.getActiveBoxContent(i).setTextContent(i >= stringArray.length || stringArray[i] == null ? new String("") : stringArray[i]);
        }
    }

    public boolean hasImg() {
        return this.img != null;
    }

    public double getTotalWidth() {
        return this.w * (double)this.ncw;
    }

    public double getTotalHeight() {
        return this.h * (double)this.nch;
    }

    public int getNumCells() {
        return this.activeBoxContentArray.size();
    }

    public boolean isEmpty() {
        return this.activeBoxContentArray.isEmpty();
    }

    public void prepareMedia(PlayStation playStation) {
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            this.getActiveBoxContent(i).prepareMedia(playStation);
        }
        if (this.img != null && playStation.getOptions().getBoolean("preDrawImages")) {
            Graphics graphics = playStation.getComponent().getGraphics();
            graphics.drawImage(this.img, 0, 0, 0, 0, playStation.getComponent());
        }
    }

    public void setBoxBase(BoxBase boxBase) {
        this.bb = boxBase;
    }

    public void setIds(int[] nArray) {
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            if (i >= nArray.length) continue;
            this.getActiveBoxContent((int)i).id = nArray[i];
        }
    }

    public void setAllIdsTo(int n) {
        for (int i = 0; i < this.activeBoxContentArray.size(); ++i) {
            this.getActiveBoxContent((int)i).id = n;
        }
    }

    public void avoidAllIdsNull(int n) {
        int n2;
        boolean bl = true;
        int n3 = this.activeBoxContentArray.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.getActiveBoxContent((int)n2).id == -1) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = Math.max(1, n);
            for (n2 = 0; n2 < n3; ++n2) {
                this.getActiveBoxContent((int)n2).id = n2 % n;
            }
        }
    }

    public void copyStyleTo(ActiveBagContent activeBagContent) {
        if (activeBagContent != null) {
            activeBagContent.setBoxBase(this.bb);
            activeBagContent.border = this.border;
        }
    }
}

