/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TargetMarkerBag;
import edu.xtec.jclic.activities.text.TextActivityBase;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextActivityPane;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.Actions;
import edu.xtec.util.JDomUtility;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.ActionMap;
import javax.swing.text.BadLocationException;
import org.jdom.Element;

public class Identify
extends TextActivityBase {
    public static final int IDENTIFY_WORDS = 0;
    public static final int IDENTIFY_CHARS = 1;
    protected int type;
    public static final String[] TYPES = new String[]{"identifyWords", "identifyChars"};

    public Identify(JClicProject jClicProject) {
        super(jClicProject);
        this.setType(0);
        this.hasCheckButton = true;
        this.checkButtonText = "";
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        element.setAttribute("type", TYPES[this.type]);
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        this.setType(JDomUtility.getStrIndexAttr(element, "type", TYPES, this.type));
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.setType(clic3Activity.puzMode == 3 ? 0 : 1);
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n == 1 ? 1 : 0;
        this.tad.setTargetType(n == 1 ? 1 : 2);
    }

    class Panel
    extends TextActivityBase.Panel {
        TextActivityDocument playDoc;
        int nActions;
        int score;
        boolean[] validChars;
        boolean[] marks;
        boolean[] targets;

        protected Panel(PlayStation playStation) {
            super(Identify.this, playStation);
            this.playDoc = null;
            this.nActions = 0;
            this.score = 0;
            this.validChars = null;
            this.marks = null;
            this.targets = null;
        }

        protected void initDocument() throws Exception {
            if (Identify.this.tad != null) {
                this.playing = false;
                this.playDoc = new TextActivityDocument(Identify.this.styleContext);
                Identify.this.tad.cloneDoc(this.playDoc, false, false, true);
                if (!this.buildCheckArrays()) {
                    return;
                }
                this.pane.setStyledDocument(this.playDoc);
                this.playDoc.attachTo(this.pane, this);
                this.pane.setEditable(false);
                this.pane.requestFocus();
                this.nActions = 0;
                this.score = 0;
            }
        }

        private boolean buildCheckArrays() {
            if (this.playDoc == null) {
                return false;
            }
            int n = this.playDoc.getLength();
            if (n > 0) {
                int n2;
                char[] cArray = null;
                try {
                    cArray = this.playDoc.getText(0, n).toCharArray();
                }
                catch (BadLocationException badLocationException) {
                    this.playDoc = null;
                    return false;
                }
                this.validChars = new boolean[n];
                this.marks = new boolean[n];
                this.targets = new boolean[n];
                for (n2 = 0; n2 < n; ++n2) {
                    this.marks[n2] = false;
                    this.targets[n2] = false;
                    this.validChars[n2] = Character.isLetterOrDigit(cArray[n2]);
                }
                for (n2 = 0; n2 < this.playDoc.tmb.size(); ++n2) {
                    TargetMarker targetMarker = this.playDoc.tmb.getElement(n2);
                    for (int i = targetMarker.begOffset; i < targetMarker.endOffset; ++i) {
                        this.targets[i] = true;
                    }
                }
            } else {
                this.validChars = new boolean[1];
                this.marks = new boolean[1];
                this.targets = new boolean[1];
            }
            return true;
        }

        protected TextActivityPane buildPane() {
            IdentifyPane identifyPane = new IdentifyPane();
            identifyPane.setActions();
            return identifyPane;
        }

        protected boolean checkScore() {
            int n;
            this.score = 0;
            for (n = 0; n < this.playDoc.tmb.size(); ++n) {
                if (!this.marks[this.playDoc.tmb.getElement((int)n).begOffset]) continue;
                ++this.score;
            }
            for (n = 0; n < this.targets.length; ++n) {
                if (!this.marks[n] || this.targets[n]) continue;
                return false;
            }
            return this.score == this.playDoc.tmb.size();
        }

        protected void doCheck(boolean bl) {
            int n;
            if (this.playDoc == null || this.playDoc.tmb.size() == 0) {
                return;
            }
            TargetMarkerBag targetMarkerBag = this.playDoc.tmb;
            this.playDoc.setCharacterAttributes(0, this.marks.length, Identify.this.styleContext.getStyle("default"), true);
            for (n = 0; n < this.marks.length; ++n) {
                int n2;
                if (!this.marks[n]) continue;
                for (n2 = n; n2 < this.marks.length && this.marks[n2]; ++n2) {
                }
                this.playDoc.setCharacterAttributes(n, n2 - n, Identify.this.styleContext.getStyle("targetError"), true);
                n = n2;
            }
            for (n = 0; n < targetMarkerBag.size(); ++n) {
                TargetMarker targetMarker = targetMarkerBag.getElement(n);
                this.playDoc.applyStyleToTarget(targetMarker, this.marks[targetMarker.begOffset] ? "target" : "default", false, true);
            }
            boolean bl2 = this.checkScore();
            this.ps.setCounterValue(0, this.score);
            this.ps.setCounterValue(1, this.nActions);
            if (!bl2) {
                if (bl) {
                    this.playEvent(4);
                    this.pane.requestFocus();
                }
            } else {
                this.finishActivity(true);
            }
        }

        public void finishActivity(boolean bl) {
            this.pane.setEnabled(false);
            super.finishActivity(bl);
        }

        class IdentifyPane
        extends TextActivityPane {
            protected IdentifyPane() {
                super(Panel.this);
                this.enableEvents(16L);
            }

            public boolean processMouse(MouseEvent mouseEvent) {
                if (!super.processMouse(mouseEvent) || !Panel.this.playing || Panel.this.playDoc == null) {
                    return false;
                }
                if (mouseEvent.getID() == 501) {
                    this.select(this.viewToModel(mouseEvent.getPoint()));
                }
                return false;
            }

            protected void select(int n) {
                int n2;
                int n3;
                if (n < 0 || n >= Panel.this.marks.length) {
                    Panel.this.playEvent(2);
                    return;
                }
                ++Panel.this.nActions;
                boolean bl = Panel.this.marks[n];
                int n4 = 1;
                TargetMarker targetMarker = Panel.this.playDoc.tmb.getElementByOffset(n, false);
                if (targetMarker != null) {
                    n = targetMarker.begOffset;
                    n4 = targetMarker.getLength();
                } else {
                    if (!Panel.this.validChars[n]) {
                        Panel.this.playEvent(2);
                        return;
                    }
                    if (((Panel)Panel.this).Identify.this.type == 0) {
                        for (n3 = n; n3 > 0 && Panel.this.validChars[n3]; --n3) {
                        }
                        n2 = n3 + 1;
                        n3 = n;
                        n = n2;
                        while (n3 < Panel.this.validChars.length && Panel.this.validChars[n3]) {
                            ++n3;
                        }
                        n4 = n3 - n2;
                    }
                }
                Panel.this.playDoc.setCharacterAttributes(n, n4, ((Panel)Panel.this).Identify.this.styleContext.getStyle(bl ? "default" : "target"), true);
                for (n3 = 0; n3 < n4; ++n3) {
                    Panel.this.marks[n + n3] = !bl;
                }
                if (!((Panel)Panel.this).Identify.this.hasCheckButton) {
                    TargetMarkerBag targetMarkerBag = Panel.this.playDoc.tmb;
                    n2 = targetMarker != null && Panel.this.marks[n] ? 1 : 0;
                    boolean bl2 = Panel.this.checkScore();
                    try {
                        this.tabp.ps.reportNewAction(Identify.this, "SELECT", Panel.this.playDoc.getText(n, n4), bl ? "true" : "false", n2 != 0, Panel.this.score);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl2) {
                        Panel.this.finishActivity(true);
                        return;
                    }
                }
                Panel.this.playEvent(1);
            }

            protected void setActions() {
                HashMap hashMap = Actions.getActionKeys(this);
                ActionMap actionMap = new ActionMap();
                actionMap.setParent(this.getActionMap());
                this.setActionMap(actionMap);
                Actions.mapTraceAction(this, hashMap, "beep");
                Actions.mapTraceAction(this, hashMap, "requestFocus");
                Actions.mapTraceAction(this, hashMap, "toggle-componentOrientation");
                actionMap.setParent(null);
            }
        }
    }
}

