/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFileTypes;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class JorbisAudioFileReader
extends TAudioFileReader {
    private static final int INITAL_READ_LENGTH = 4096;
    private static final int MARK_LIMIT = 4097;

    public JorbisAudioFileReader() {
        super(4097, true);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        SyncState syncState = new SyncState();
        StreamState streamState = new StreamState();
        Page page = new Page();
        Packet packet = new Packet();
        int n = 0;
        syncState.init();
        int n2 = syncState.buffer(4096);
        n = inputStream.read(syncState.data, n2, 4096);
        syncState.wrote(n);
        if (syncState.pageout(page) != 1) {
            if (n < 4096) {
                throw new UnsupportedAudioFileException("not a Vorbis stream: ended prematurely");
            }
            throw new UnsupportedAudioFileException("not a Vorbis stream: not in Ogg bitstream format");
        }
        streamState.init(page.serialno());
        if (streamState.pagein(page) < 0) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: can't read first page of Ogg bitstream data");
        }
        if (streamState.packetout(packet) != 1) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: can't read initial header packet");
        }
        Buffer buffer = new Buffer();
        buffer.readinit(packet.packet_base, packet.packet, packet.bytes);
        int n3 = buffer.read(8);
        byte[] byArray = new byte[6];
        buffer.read(byArray, 6);
        if (byArray[0] != 118 || byArray[1] != 111 || byArray[2] != 114 || byArray[3] != 98 || byArray[4] != 105 || byArray[5] != 115) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: not a vorbis header packet");
        }
        if (n3 != 1) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: first packet is not the identification header");
        }
        if (packet.b_o_s == 0) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: initial packet not marked as beginning of stream");
        }
        int n4 = buffer.read(32);
        if (n4 != 0) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: wrong vorbis version");
        }
        int n5 = buffer.read(8);
        float f = buffer.read(32);
        int n6 = buffer.read(32);
        int n7 = buffer.read(32);
        int n8 = buffer.read(32);
        int[] nArray = new int[]{1 << buffer.read(4), 1 << buffer.read(4)};
        if (f < 1.0f || n5 < 1 || nArray[0] < 8 || nArray[1] < nArray[0] || buffer.read(1) != 1) {
            throw new UnsupportedAudioFileException("not a Vorbis stream: illegal values in initial header");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): channels: " + n5);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): rate: " + f);
        }
        int n9 = -1;
        if (l != -1L && l <= Integer.MAX_VALUE) {
            n9 = (int)l;
        }
        int n10 = -1;
        AudioFormat audioFormat = new AudioFormat(Encodings.getEncoding("VORBIS"), f, -1, n5, -1, -1.0f, true);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): AudioFormat: " + audioFormat);
        }
        AudioFileFormat.Type type = AudioFileTypes.getType("Ogg", "ogg");
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(type, audioFormat, n10, n9);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("JorbisAudioFileReader.getAudioFileFormat(): AudioFileFormat: " + tAudioFileFormat);
        }
        return tAudioFileFormat;
    }
}

