/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.util.Domable;
import edu.xtec.util.Html;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Messages;
import org.jdom.Element;

public class Organization
implements Domable {
    public String name = new String();
    public String mail = null;
    public String url = null;
    public String address = null;
    public String pc = null;
    public String city = null;
    public String country = null;
    public String state = null;
    public String comments = null;
    public static final String ELEMENT_NAME = "organization";
    public static final String NAME = "name";
    public static final String MAIL = "mail";
    public static final String URL = "url";
    public static final String ADDRESS = "address";
    public static final String PC = "pc";
    public static final String CITY = "city";
    public static final String COUNTRY = "country";
    public static final String STATE = "state";
    public static final String COMMENTS = "comments";

    public Element getJDomElement() {
        Element element = new Element(ELEMENT_NAME);
        element.setAttribute(NAME, this.name);
        if (this.mail != null) {
            element.setAttribute(MAIL, this.mail);
        }
        if (this.url != null) {
            element.setAttribute(URL, this.url);
        }
        if (this.address != null) {
            element.setAttribute(ADDRESS, this.address);
        }
        if (this.pc != null) {
            element.setAttribute(PC, this.pc);
        }
        if (this.city != null) {
            element.setAttribute(CITY, this.city);
        }
        if (this.country != null) {
            element.setAttribute(COUNTRY, this.country);
        }
        if (this.state != null) {
            element.setAttribute(STATE, this.state);
        }
        if (this.comments != null) {
            JDomUtility.addParagraphs(element, COMMENTS, this.comments);
        }
        return element;
    }

    public static Organization getOrganization(Element element) throws Exception {
        Organization organization = new Organization();
        organization.setProperties(element, null);
        return organization;
    }

    public void setProperties(Element element, Object object) throws Exception {
        JDomUtility.checkName(element, ELEMENT_NAME);
        this.name = JDomUtility.getStringAttr(element, NAME, this.name, true);
        this.mail = JDomUtility.getStringAttr(element, MAIL, this.mail, false);
        this.url = JDomUtility.getStringAttr(element, URL, this.url, false);
        this.address = JDomUtility.getStringAttr(element, ADDRESS, this.address, false);
        this.pc = JDomUtility.getStringAttr(element, PC, this.pc, false);
        this.city = JDomUtility.getStringAttr(element, CITY, this.city, false);
        this.state = JDomUtility.getStringAttr(element, STATE, this.state, false);
        this.country = JDomUtility.getStringAttr(element, COUNTRY, this.country, false);
        this.comments = JDomUtility.getParagraphs(element.getChild(COMMENTS));
    }

    public String toHtmlString(Messages messages) {
        Html html = new Html(300);
        html.append(this.name);
        if (this.mail != null && this.mail.length() > 0) {
            html.sp().mailTo(this.mail, true);
        }
        if (this.url != null && this.url.length() > 0) {
            html.br().linkTo(this.url, null);
        }
        if (this.address != null) {
            html.br().appendParagraphs(this.address);
        }
        if (this.pc != null || this.city != null) {
            html.br();
            if (this.pc != null) {
                html.append(this.pc).nbsp();
            }
            if (this.city != null) {
                html.appendParagraphs(this.city);
            }
        }
        if (this.state != null) {
            html.br().appendParagraphs(this.state);
        }
        if (this.country != null) {
            html.br().appendParagraphs(this.country);
        }
        if (this.comments != null) {
            html.br().appendParagraphs(this.comments);
        }
        return html.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        if (this.city != null && this.city.length() > 0) {
            stringBuffer.append(" (").append(this.city).append(")");
        }
        return stringBuffer.toString();
    }
}

