/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.clic3.Clic3;
import edu.xtec.jclic.fileSystem.FilePCC;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.fileSystem.UrlPCC;
import edu.xtec.util.ResourceBridge;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class PCCFileSystem
extends FileSystem {
    String pccName;
    public String pccVersion;
    public String pccDescription;
    public int numFiles;
    public int baseOffset;
    PCCFileEntry[] fe;

    public PCCFileSystem(ResourceBridge resourceBridge) {
        super("", resourceBridge);
    }

    public PCCFileSystem(String string, String string2, ResourceBridge resourceBridge) {
        super(string, resourceBridge);
        this.pccName = this.getCanonicalNameOf(string2);
    }

    public static final PCCFileSystem createPCCFileSystem(String string, String string2, ResourceBridge resourceBridge) throws Exception {
        if (PCCFileSystem.isStrUrl(string)) {
            return new UrlPCC(string, string2, resourceBridge);
        }
        return new FilePCC(string, string2, resourceBridge);
    }

    public String getFullRoot() {
        return this.root + this.pccName;
    }

    void initPCC(DataInputStream dataInputStream) throws Exception {
        this.pccVersion = this.extractLineFromDIS(dataInputStream);
        if (this.pccVersion != null && this.pccVersion.compareTo("PCC00") == 0) {
            this.pccDescription = this.extractLineFromDIS(dataInputStream);
            this.numFiles = this.extractShortInt(dataInputStream);
            this.baseOffset = (int)this.extractShortLong(dataInputStream);
            this.fe = new PCCFileEntry[this.numFiles];
            for (int i = 0; i < this.numFiles; ++i) {
                this.fe[i] = new PCCFileEntry(Clic3.validFileName(this.extractSzString(dataInputStream)), this.extractShortLong(dataInputStream), this.extractShortLong(dataInputStream));
                if (this.fe[i].fileName.length() == 0) break;
            }
        }
    }

    public String getEntryInfo(int n) {
        return n < 0 || n >= this.numFiles ? "OUT OF INDEX!" : this.fe[n].toString();
    }

    public String getEntryName(int n) {
        return n < 0 || n >= this.numFiles ? "OUT OF INDEX!" : this.fe[n].fileName;
    }

    public int getEntryNum(String string) {
        int n = -1;
        String string2 = PCCFileSystem.stdFn(string);
        if (this.numFiles > 0) {
            for (n = 0; n < this.numFiles && !this.fe[n].fileName.equals(string2); ++n) {
            }
        }
        if (n == this.numFiles && altFileNames.get(string) != null) {
            string2 = PCCFileSystem.stdFn((String)altFileNames.get(string));
            for (n = 0; n < this.numFiles && !this.fe[n].fileName.equals(string2); ++n) {
            }
        }
        return n == this.numFiles ? -1 : n;
    }

    protected abstract byte[] getBytes(int var1) throws IOException;

    public byte[] getBytes(String string) throws IOException {
        int n = this.getEntryNum(string);
        if (n == -1) {
            return super.getBytes(string);
        }
        return this.getBytes(n);
    }

    public long getFileLength(String string) throws IOException {
        int n = this.getEntryNum(string);
        return n == -1 ? super.getFileLength(string) : this.fe[n].size;
    }

    public Image getImageFile(String string) throws Exception {
        int n = this.getEntryNum(string);
        return n == -1 ? super.getImageFile(string) : Toolkit.getDefaultToolkit().createImage(this.getBytes(n));
    }

    public DataInputStream getDataInputStream(String string) throws IOException {
        return new DataInputStream(super.getInputStream(string));
    }

    public String extractLine(BufferedReader bufferedReader) throws IOException {
        return bufferedReader.readLine();
    }

    public String extractLineFromDIS(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            byte by = dataInputStream.readByte();
            if (bl) break;
            if (by == 13) {
                bl = true;
                continue;
            }
            stringBuffer.append((char)by);
        }
        return stringBuffer.substring(0);
    }

    public String extractSzString(BufferedReader bufferedReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1];
        while (true) {
            bufferedReader.read(cArray, 0, 1);
            if (cArray[0] == '\u0000') break;
            stringBuffer.append(cArray[0]);
        }
        return stringBuffer.substring(0);
    }

    public String extractSzString(DataInputStream dataInputStream) throws IOException {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        while ((by = dataInputStream.readByte()) != 0) {
            stringBuffer.append((char)by);
        }
        return stringBuffer.substring(0);
    }

    public int extractShortInt(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = n = dataInputStream.readUnsignedByte();
        n = dataInputStream.readUnsignedByte();
        return n2 += n << 8;
    }

    public long extractShortLong(DataInputStream dataInputStream) throws IOException {
        long l;
        long l2 = l = (long)dataInputStream.readUnsignedByte();
        l = dataInputStream.readUnsignedByte();
        l2 += l << 8;
        l = dataInputStream.readUnsignedByte();
        l2 += l << 16;
        l = dataInputStream.readUnsignedByte();
        return l2 += l << 24;
    }

    public void close() {
        this.fe = null;
        super.close();
    }

    protected class PCCFileEntry {
        String fileName;
        long size;
        long offset;

        public PCCFileEntry(String string, long l, long l2) {
            this.fileName = FileSystem.stdFn(string);
            this.size = l2;
            this.offset = l;
        }
    }
}

