/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.LFUtil;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class PlayerSettingsDlg
extends ExtendedJDialog {
    PlayerSettings settings;
    public boolean result;
    Component parent;
    LibraryManager libraryManager;
    Messages msg;
    HashMap reporterOptions;
    private JCheckBox autoRunLibChk;
    private JTextField browserField;
    private JTextField countryField;
    private JPanel editLibPanel;
    private JRadioButton jdbcBtn;
    private JComboBox langCombo;
    private JComboBox lookCombo;
    private JRadioButton mDefaultBtn;
    private JRadioButton mJMFbtn;
    private JRadioButton mQTbtn;
    private JRadioButton otherBtn;
    private JCheckBox pwdCheck;
    private JPasswordField pwdField1;
    private JPasswordField pwdField2;
    private JCheckBox reportChk;
    private JTextField rpAddressTxt;
    private JTextField rpClassTxt;
    private JTextField rpDriverTxt;
    private JTextField rpParamsTxt;
    private JPasswordField rpPwdTxt;
    private JTextField rpUrlTxt;
    private JTextField rpUserTxt;
    private JComboBox skinCombo;
    private JCheckBox soundEnabledChk;
    private JCheckBox systemSoundsChk;
    private JRadioButton tcpBtn;
    private JTextField variantField;

    public PlayerSettingsDlg(PlayerSettings playerSettings, Component component) {
        super(component, "", true);
        this.parent = component;
        this.settings = playerSettings;
        this.msg = playerSettings.getMessages();
        this.setTitle(this.msg.get("settings_title"));
        try {
            this.libraryManager = LibraryManager.getLibraryManager(playerSettings, playerSettings.libraryManager.getJDomElement());
        }
        catch (Exception exception) {
            this.msg.showErrorWarning(this, "library_error_clone", exception);
            this.libraryManager = playerSettings.libraryManager;
        }
        this.result = false;
        this.reporterOptions = new HashMap();
        Options.strToMap(playerSettings.reporterParams, this.reporterOptions, ";", '=', false);
        this.initComponents();
        this.checkEnabled(null);
        this.centerOver(component);
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        this.pwdCheck = new JCheckBox();
        JLabel jLabel = new JLabel();
        this.pwdField1 = new JPasswordField(this.settings.password, 20);
        JLabel jLabel2 = new JLabel();
        this.pwdField2 = new JPasswordField(this.settings.password, 20);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.lookCombo = new JComboBox<String>(LFUtil.VALUES);
        JLabel jLabel4 = new JLabel();
        this.skinCombo = new JComboBox<String>(Skin.getSystemSkinList(false));
        JLabel jLabel5 = new JLabel();
        this.langCombo = new JComboBox<String>(Messages.getDescriptiveLanguageCodes(this.msg.getLocale()));
        JLabel jLabel6 = new JLabel();
        this.countryField = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.variantField = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.browserField = new JTextField();
        JPanel jPanel3 = new JPanel();
        this.reportChk = new JCheckBox();
        JPanel jPanel4 = new JPanel();
        this.tcpBtn = new JRadioButton();
        JLabel jLabel9 = new JLabel();
        this.rpAddressTxt = new JTextField();
        this.jdbcBtn = new JRadioButton();
        JLabel jLabel10 = new JLabel();
        this.rpDriverTxt = new JTextField();
        JLabel jLabel11 = new JLabel();
        this.rpUrlTxt = new JTextField();
        JLabel jLabel12 = new JLabel();
        this.rpUserTxt = new JTextField();
        JLabel jLabel13 = new JLabel();
        this.rpPwdTxt = new JPasswordField();
        this.otherBtn = new JRadioButton();
        JLabel jLabel14 = new JLabel();
        this.rpClassTxt = new JTextField();
        JLabel jLabel15 = new JLabel();
        this.rpParamsTxt = new JTextField();
        JPanel jPanel5 = new JPanel();
        this.soundEnabledChk = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        this.mDefaultBtn = new JRadioButton();
        this.mJMFbtn = new JRadioButton();
        this.mQTbtn = new JRadioButton();
        this.systemSoundsChk = new JCheckBox();
        JPanel jPanel7 = new JPanel();
        this.autoRunLibChk = new JCheckBox();
        this.editLibPanel = this.libraryManager.getLibraryPane(true, true);
        JPanel jPanel8 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlayerSettingsDlg.this.closeDialog(windowEvent);
            }
        });
        jTabbedPane.setToolTipText(this.msg.get("settings_report_tooltip"));
        jTabbedPane.setPreferredSize(new Dimension(500, 400));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setToolTipText(this.msg.get("settings_security_tooltip"));
        this.pwdCheck.setSelected(this.settings.password != null);
        this.pwdCheck.setText(this.msg.get("settings_password_protect"));
        this.pwdCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.pwdCheckActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.pwdCheck, gridBagConstraints);
        jLabel.setText(this.msg.get("settings_new_password"));
        jLabel.setLabelFor(this.pwdField1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.pwdField1.setEnabled(this.settings.password != null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.pwdField1, gridBagConstraints);
        jLabel2.setText(this.msg.get("settings_new_password_confirm"));
        jLabel2.setLabelFor(this.pwdField2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.pwdField2.setEnabled(this.settings.password != null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.pwdField2, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_security"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/security.gif")), jPanel, "");
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setToolTipText(this.msg.get("settings_general_tooltip"));
        jLabel3.setLabelFor(this.lookCombo);
        jLabel3.setText(this.msg.get("settings_look"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.lookCombo.setSelectedItem(this.settings.lookAndFeel);
        this.lookCombo.setToolTipText(this.msg.get("settings_look_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.lookCombo, gridBagConstraints);
        jLabel4.setLabelFor(this.skinCombo);
        jLabel4.setText(this.msg.get("settings_skin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        this.skinCombo.setEditable(true);
        this.skinCombo.setSelectedItem(this.settings.skin);
        this.skinCombo.setToolTipText(this.msg.get("settings_skin_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.skinCombo, gridBagConstraints);
        jLabel5.setLabelFor(this.langCombo);
        jLabel5.setText(this.msg.get("settings_language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        this.langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(this.settings.language));
        this.langCombo.setToolTipText(this.msg.get("settings_language_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.langCombo, gridBagConstraints);
        jLabel6.setLabelFor(this.countryField);
        jLabel6.setText(this.msg.get("settings_country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        this.countryField.setText(this.settings.country);
        this.countryField.setToolTipText(this.msg.get("settings_country_tooltip"));
        this.countryField.setMinimumSize(new Dimension(75, 21));
        this.countryField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.countryField, gridBagConstraints);
        jLabel7.setLabelFor(this.variantField);
        jLabel7.setText(this.msg.get("settings_variant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel7, gridBagConstraints);
        this.variantField.setText(this.settings.variant);
        this.variantField.setToolTipText(this.msg.get("settings_variant_tooltip"));
        this.variantField.setMinimumSize(new Dimension(75, 21));
        this.variantField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.variantField, gridBagConstraints);
        jLabel8.setText(this.msg.get("settings_browser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)jLabel8, gridBagConstraints);
        this.browserField.setText(this.settings.preferredBrowser);
        this.browserField.setToolTipText(this.msg.get("settings_browser_tooltip"));
        this.browserField.setMinimumSize(new Dimension(75, 21));
        this.browserField.setPreferredSize(new Dimension(200, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this.browserField, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_general"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/settings.gif")), jPanel2, "");
        jPanel3.setLayout(new GridBagLayout());
        this.reportChk.setToolTipText(this.msg.get("settings_report_use_tooltip"));
        this.reportChk.setSelected(this.settings.reporterEnabled);
        this.reportChk.setText(this.msg.get("settings_report_use"));
        this.reportChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.reportChkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel3.add((Component)this.reportChk, gridBagConstraints);
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(this.msg.get("settings_report_type")));
        this.tcpBtn.setSelected(this.settings.reporterClass.equals("TCPReporter") && (this.settings.reporterParams == null || this.settings.reporterParams.indexOf(";") < 0));
        this.tcpBtn.setText(this.msg.get("settings_report_tcp"));
        this.tcpBtn.setToolTipText(this.msg.get("settings_report_tcp_tooltip"));
        buttonGroup.add(this.tcpBtn);
        this.tcpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.tcpBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.tcpBtn, gridBagConstraints);
        jLabel9.setText(this.msg.get("settings_report_address"));
        jLabel9.setLabelFor(this.rpAddressTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel9, gridBagConstraints);
        this.rpAddressTxt.setText(Options.getString(this.reporterOptions, "path", "localhost:9000"));
        this.rpAddressTxt.setToolTipText(this.msg.get("settings_report_address_tooltip"));
        this.rpAddressTxt.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpAddressTxt, gridBagConstraints);
        this.jdbcBtn.setSelected(this.settings.reporterClass.equals("JDBCReporter"));
        this.jdbcBtn.setText(this.msg.get("settings_report_jdbc"));
        this.jdbcBtn.setToolTipText(this.msg.get("settings_report_jdbc_tooltip"));
        buttonGroup.add(this.jdbcBtn);
        this.jdbcBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.jdbcBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.jdbcBtn, gridBagConstraints);
        jLabel10.setText(this.msg.get("settings_report_driver"));
        jLabel10.setLabelFor(this.rpDriverTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel10, gridBagConstraints);
        this.rpDriverTxt.setText(Options.getString(this.reporterOptions, "driver", "sun.jdbc.odbc.JdbcOdbcDriver"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpDriverTxt, gridBagConstraints);
        jLabel11.setText(this.msg.get("settings_report_url"));
        jLabel11.setLabelFor(this.rpUrlTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel11, gridBagConstraints);
        this.rpUrlTxt.setText(Options.getString(this.reporterOptions, "url", "jdbc:odbc:JClic"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpUrlTxt, gridBagConstraints);
        jLabel12.setText(this.msg.get("settings_report_user"));
        jLabel12.setLabelFor(this.rpUserTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel12, gridBagConstraints);
        this.rpUserTxt.setText(Options.getString(this.reporterOptions, "system_user", null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpUserTxt, gridBagConstraints);
        jLabel13.setText(this.msg.get("settings_report_pwd"));
        jLabel13.setLabelFor(this.rpPwdTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel13, gridBagConstraints);
        this.rpPwdTxt.setText(Options.getString(this.reporterOptions, "system_pwd", null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpPwdTxt, gridBagConstraints);
        this.otherBtn.setSelected(!this.tcpBtn.isSelected() && !this.jdbcBtn.isSelected());
        this.otherBtn.setText(this.msg.get("settings_report_other"));
        this.otherBtn.setToolTipText(this.msg.get("settings_report_other_tooltip"));
        buttonGroup.add(this.otherBtn);
        this.otherBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.otherBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.otherBtn, gridBagConstraints);
        jLabel14.setText(this.msg.get("settings_report_engine"));
        jLabel14.setLabelFor(this.rpClassTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel14, gridBagConstraints);
        this.rpClassTxt.setText(this.otherBtn.isSelected() ? this.settings.reporterClass : null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpClassTxt, gridBagConstraints);
        jLabel15.setText(this.msg.get("settings_report_params"));
        jLabel15.setLabelFor(this.rpParamsTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        jPanel4.add((Component)jLabel15, gridBagConstraints);
        this.rpParamsTxt.setText(this.otherBtn.isSelected() ? this.settings.reporterParams : null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel4.add((Component)this.rpParamsTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_reports"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/report_small.gif")), jPanel3, "");
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.setToolTipText(this.msg.get("settings_media_tooltip"));
        this.soundEnabledChk.setSelected(this.settings.soundEnabled);
        this.soundEnabledChk.setText(this.msg.get("settings_media_enabled"));
        this.soundEnabledChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.soundEnabledChkActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)this.soundEnabledChk, gridBagConstraints);
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.setBorder(new TitledBorder(this.msg.get("settings_media_system")));
        this.mDefaultBtn.setSelected("default".equals(this.settings.mediaSystem));
        this.mDefaultBtn.setText(this.msg.get("settings_media_default"));
        buttonGroup2.add(this.mDefaultBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        jPanel6.add((Component)this.mDefaultBtn, gridBagConstraints);
        this.mJMFbtn.setSelected("Java Media Framework".equals(this.settings.mediaSystem));
        this.mJMFbtn.setText(this.msg.get("settings_media_jmf"));
        buttonGroup2.add(this.mJMFbtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel6.add((Component)this.mJMFbtn, gridBagConstraints);
        this.mQTbtn.setSelected("QuickTime".equals(this.settings.mediaSystem));
        this.mQTbtn.setText(this.msg.get("settings_media_qt"));
        buttonGroup2.add(this.mQTbtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel6.add((Component)this.mQTbtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)jPanel6, gridBagConstraints);
        this.systemSoundsChk.setSelected(this.settings.systemSounds);
        this.systemSoundsChk.setText(this.msg.get("settings_media_event_sounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel5.add((Component)this.systemSoundsChk, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_media"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/audio_on.gif")), jPanel5, "");
        jPanel7.setLayout(new GridBagLayout());
        jPanel7.setToolTipText(this.msg.get("settings_library_tooltip"));
        this.autoRunLibChk.setSelected(this.libraryManager.autoRun);
        this.autoRunLibChk.setText(this.msg.get("settings_library_autorun"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel7.add((Component)this.autoRunLibChk, gridBagConstraints);
        this.editLibPanel.setBorder(new TitledBorder(this.msg.get("settings_library")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel7.add((Component)this.editLibPanel, gridBagConstraints);
        jTabbedPane.addTab(this.msg.get("settings_library"), new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/database.gif")), jPanel7, "");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        jButton.setText(this.msg.get("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.okButtonActionPerformed(actionEvent);
            }
        });
        jPanel8.add(jButton);
        jButton2.setText(this.msg.get("CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerSettingsDlg.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        jPanel8.add(jButton2);
        this.getContentPane().add((Component)jPanel8, "South");
        this.pack();
    }

    private void soundEnabledChkActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled(this.soundEnabledChk);
    }

    private void otherBtnActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled(this.reportChk);
    }

    private void jdbcBtnActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled(this.reportChk);
    }

    private void tcpBtnActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled(this.reportChk);
    }

    private void reportChkActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled(this.reportChk);
    }

    private void pwdCheckActionPerformed(ActionEvent actionEvent) {
        this.checkEnabled(this.pwdCheck);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.result = false;
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.accept()) {
            this.result = true;
            this.closeDialog(null);
        }
    }

    public boolean accept() {
        String string;
        String string2 = null;
        if (this.pwdCheck.isSelected()) {
            string2 = StrUtils.nullableString(String.copyValueOf(this.pwdField1.getPassword()));
            string = StrUtils.nullableString(String.copyValueOf(this.pwdField2.getPassword()));
            if (string2 == null || string == null || !string2.equals(string)) {
                this.msg.showAlert((Component)this, "PASSWORD_INCORRECT");
                return false;
            }
        } else {
            this.settings.password = null;
        }
        if (this.tcpBtn.isSelected()) {
            string = this.rpAddressTxt.getText();
            if (string == null || string.length() < 1) {
                this.msg.showAlert((Component)this, "settings_report_err_server");
                return false;
            }
            this.settings.reporterClass = "TCPReporter";
            this.settings.reporterParams = new StringBuffer("path").append("=").append(string).substring(0);
        } else if (this.jdbcBtn.isSelected()) {
            string = StrUtils.nullableString(this.rpDriverTxt.getText());
            String string3 = StrUtils.nullableString(this.rpUrlTxt.getText());
            String string4 = this.rpUserTxt.getText();
            String string5 = String.copyValueOf(this.rpPwdTxt.getPassword());
            if (string == null || string3 == null) {
                this.msg.showAlert((Component)this, "settings_report_err");
                return false;
            }
            this.settings.reporterClass = "JDBCReporter";
            StringBuffer stringBuffer = new StringBuffer("driver=").append(string);
            stringBuffer.append(";url=").append(string3);
            if (string4 != null) {
                stringBuffer.append(";system_user=").append(string4);
                if (string5 != null) {
                    stringBuffer.append(";system_pwd=").append(string5);
                }
            }
            this.settings.reporterParams = stringBuffer.substring(0);
        } else {
            this.settings.reporterClass = this.rpClassTxt.getText();
            this.settings.reporterParams = this.rpParamsTxt.getText();
        }
        this.settings.password = string2;
        this.settings.passwordConfirmed = false;
        this.settings.lookAndFeel = (String)this.lookCombo.getSelectedItem();
        this.settings.preferredBrowser = this.browserField.getText();
        this.settings.skin = (String)this.skinCombo.getSelectedItem();
        this.settings.language = Messages.getLanguageFromDescriptive((String)this.langCombo.getSelectedItem());
        this.settings.country = StrUtils.nullableString(this.countryField.getText());
        this.settings.variant = StrUtils.nullableString(this.variantField.getText());
        this.settings.reporterEnabled = this.reportChk.isSelected();
        this.settings.soundEnabled = this.soundEnabledChk.isSelected();
        this.settings.mediaSystem = this.mJMFbtn.isSelected() ? "Java Media Framework" : (this.mQTbtn.isSelected() ? "QuickTime" : "default");
        this.settings.systemSounds = this.systemSoundsChk.isSelected();
        this.libraryManager.autoRun = this.autoRunLibChk.isSelected();
        this.settings.libraryManager = this.libraryManager;
        return true;
    }

    private void checkEnabled(JComponent jComponent) {
        if (jComponent == null || jComponent == this.reportChk) {
            this.enable(this.tcpBtn, this.reportChk, null);
            this.enable(this.rpAddressTxt, this.tcpBtn, this.reportChk);
            this.enable(this.jdbcBtn, this.reportChk, null);
            this.enable(this.rpDriverTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.rpUrlTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.rpUserTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.rpPwdTxt, this.jdbcBtn, this.reportChk);
            this.enable(this.otherBtn, this.reportChk, null);
            this.enable(this.rpClassTxt, this.otherBtn, this.reportChk);
            this.enable(this.rpParamsTxt, this.otherBtn, this.reportChk);
        }
        if (jComponent == null || jComponent == this.pwdCheck) {
            this.enable(this.pwdField1, this.pwdCheck, null);
            this.enable(this.pwdField2, this.pwdCheck, null);
        }
        if (jComponent == null || jComponent == this.soundEnabledChk) {
            this.enable(this.mDefaultBtn, this.soundEnabledChk, null);
            this.enable(this.mJMFbtn, this.soundEnabledChk, null);
            this.enable(this.mQTbtn, this.soundEnabledChk, null);
            this.enable(this.systemSoundsChk, this.soundEnabledChk, null);
        }
    }

    private void enable(JComponent jComponent, JToggleButton jToggleButton, JToggleButton jToggleButton2) {
        boolean bl;
        boolean bl2;
        if (jComponent != null && jToggleButton != null && (bl2 = jToggleButton.isSelected() && (jToggleButton2 == null || jToggleButton2.isSelected())) != (bl = jComponent.isEnabled())) {
            jComponent.setEnabled(bl2);
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

