/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file.mpeg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFileTypes;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    private static final int SYNC = -2097152;
    private static final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{Encodings.getEncoding("MPEG2DOT5L3"), Encodings.getEncoding("MPEG2DOT5L2"), Encodings.getEncoding("MPEG2DOT5L1")}, {null, null, null}, {Encodings.getEncoding("MPEG2L3"), Encodings.getEncoding("MPEG2L2"), Encodings.getEncoding("MPEG2L1")}, {Encodings.getEncoding("MPEG1L3"), Encodings.getEncoding("MPEG1L2"), Encodings.getEncoding("MPEG1L1")}};
    private static final float[][] sm_afSamplingRates = new float[][]{{11025.0f, 12000.0f, 8000.0f}, {0.0f, 0.0f, 0.0f}, {22050.0f, 24000.0f, 16000.0f}, {44100.0f, 48000.0f, 32000.0f}};
    private static final int MARK_LIMIT = 4;

    public MpegAudioFileReader() {
        super(4, true);
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("MpegAudioFileReader.getAudioFileFormat(): begin");
        }
        if (((n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        int n5 = (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        if ((n5 & 0xFFE00000) != -2097152) {
            throw new UnsupportedAudioFileException("not a MPEG stream: no sync bits");
        }
        int n6 = n5 >> 19 & 3;
        if (n6 == 1) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int n7 = n5 >> 17 & 3;
        if (n7 == 0) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong layer");
        }
        AudioFormat.Encoding encoding = sm_aEncodings[n6][n7 - 1];
        int n8 = n5 >> 10 & 3;
        if (n8 == 3) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        float f = sm_afSamplingRates[n6][n8];
        int n9 = n5 >> 6 & 3;
        int n10 = n9 == 3 ? 1 : 2;
        AudioFormat audioFormat = new AudioFormat(encoding, f, -1, n10, -1, -1.0f, true);
        AudioFileFormat.Type type = AudioFileTypes.getType("MPEG", "mpeg");
        if (encoding.equals(Encodings.getEncoding("MPEG1L3"))) {
            type = AudioFileTypes.getType("MP3", "mp3");
        }
        int n11 = -1;
        int n12 = -1;
        if (l != -1L && l <= Integer.MAX_VALUE) {
            n11 = (int)l;
        }
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(type, audioFormat, n12, n11);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("MpegAudioFileReader.getAudioFileFormat(): end");
        }
        return tAudioFileFormat;
    }
}

