/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.jclic.report.ActionReg;
import edu.xtec.jclic.report.ActivityReg;
import edu.xtec.jclic.report.BasicJDBCBridge;
import edu.xtec.jclic.report.GroupData;
import edu.xtec.jclic.report.Reporter;
import edu.xtec.jclic.report.UserData;
import edu.xtec.util.Messages;
import edu.xtec.util.db.ConnectionBeanProvider;
import java.awt.Component;
import java.util.HashMap;
import java.util.Vector;

public class JDBCReporter
extends Reporter {
    protected String currentSessionId = null;
    protected int actCount = 0;
    protected ActivityReg lastActivity = null;
    protected BasicJDBCBridge bridge = null;
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String SYSTEM_USER = "system_user";
    public static final String SYSTEM_PWD = "system_pwd";

    public void end() {
        super.end();
        this.reportActivity();
        if (this.bridge != null) {
            this.bridge.end();
            this.bridge = null;
        }
    }

    public void init(HashMap hashMap, Component component, Messages messages) throws Exception {
        super.init(hashMap, component, messages);
        boolean bl = false;
        try {
            this.bridge = null;
            String string = (String)hashMap.get(DRIVER);
            String string2 = (String)hashMap.get(URL);
            this.description = "JDBC " + string2;
            String string3 = (String)hashMap.get(SYSTEM_USER);
            String string4 = (String)hashMap.get(SYSTEM_PWD);
            String string5 = (String)hashMap.get("tablePrefix");
            boolean bl2 = !"false".equalsIgnoreCase((String)hashMap.get("createTables"));
            ConnectionBeanProvider connectionBeanProvider = ConnectionBeanProvider.getConnectionBeanProvider(false, string, string2, string3, string4, true);
            this.bridge = new BasicJDBCBridge(connectionBeanProvider, bl2, string5);
            if (this.userId == null) {
                this.userId = this.promptUserId(component, messages);
            }
            if (this.userId == null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            messages.showErrorWarning(component, "report_err_init", this.description, exception, null);
        }
        if (!bl) {
            if (this.bridge != null) {
                this.bridge.end();
                this.bridge = null;
            }
            this.description = this.description + " (" + messages.get("report_not_connected") + ")";
            this.initiated = false;
        }
    }

    public String getProperty(String string, String string2) throws Exception {
        this.checkBridge();
        return this.bridge.getProperty(string, string2);
    }

    public Vector getGroups() throws Exception {
        this.checkBridge();
        return this.bridge.getGroups();
    }

    public Vector getUsers(String string) throws Exception {
        this.checkBridge();
        return this.bridge.getUsers(string);
    }

    public String newGroup(GroupData groupData) throws Exception {
        this.checkBridge();
        return this.bridge.newGroup(groupData);
    }

    public String newUser(UserData userData) throws Exception {
        this.checkBridge();
        return this.bridge.newUser(userData);
    }

    public UserData getUserData(String string) throws Exception {
        this.checkBridge();
        return this.bridge.getUserData(string);
    }

    public GroupData getGroupData(String string) throws Exception {
        this.checkBridge();
        return this.bridge.getGroupData(string);
    }

    protected void checkBridge() throws Exception {
        if (this.bridge == null) {
            throw new Exception("Not connected!");
        }
    }

    public void newSession(JClicProject jClicProject, Component component, Messages messages) {
        super.newSession(jClicProject, component, messages);
        if (this.bridge == null || this.userId == null) {
            return;
        }
        this.reportActivity();
        this.currentSessionId = null;
    }

    public void createDBSession() {
        if (this.bridge == null || this.userId == null) {
            return;
        }
        try {
            this.actCount = 0;
            this.currentSessionId = this.bridge.addSession(this.userId, this.currentSession.timeMillis, this.currentSession.projectName, this.currentSession.code, this.sessionKey, this.sessionContext);
        }
        catch (Exception exception) {
            this.currentSessionId = null;
            this.bridge.end();
            this.bridge = null;
            this.initiated = false;
            System.err.println("Error creating report of session:\n" + exception);
        }
    }

    protected void reportActivity() {
        if (this.lastActivity != null && this.bridge != null) {
            if (!this.lastActivity.closed) {
                this.lastActivity.closeActivity();
            }
            if (this.currentSessionId == null) {
                this.createDBSession();
            }
            if (this.currentSessionId != null) {
                try {
                    int n = this.actCount;
                    ActionReg actionReg = null;
                    n = this.bridge.addActivity(this.actCount++, this.currentSessionId, this.lastActivity.name, this.lastActivity.numActions, this.lastActivity.score, this.lastActivity.solved, this.lastActivity.getPrecision(), (int)(this.lastActivity.totalTime / 1000L), this.lastActivity.code);
                    int n2 = 0;
                    while ((actionReg = this.lastActivity.getActionReg(n2)) != null) {
                        this.bridge.addAction(n, this.currentSessionId, n2, actionReg.type, actionReg.source, actionReg.dest, actionReg.isOk);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    this.bridge.end();
                    this.bridge = null;
                    this.initiated = false;
                    System.err.println("Error reporting activity:\n" + exception);
                }
            }
        }
        this.lastActivity = this.currentSession != null && this.currentSession.currentSequence != null && this.currentSession.currentSequence.currentActivity != this.lastActivity ? this.currentSession.currentSequence.currentActivity : null;
    }

    public void newActivity(Activity activity) {
        super.newActivity(activity);
        this.reportActivity();
    }
}

