/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.textGrid;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.SimpleBox;
import edu.xtec.jclic.boxes.TextGrid;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.jdom.Element;

public class CrossWord
extends Activity
implements ActiveBagContentKit.Compatible {
    public static final int NO_ADVANCE = 0;
    public static final int ADVANCE_RIGHT = 1;
    public static final int ADVANCE_DOWN = 2;
    public static final int LABEL_WIDTH = 40;
    public boolean wildTransparent;
    public boolean upperCase;
    public boolean checkCase;
    public static final String ACROSS_CLUES = "acrossClues";
    public static final String DOWN_CLUES = "downClues";
    public static final String WILD_TRANSPARENT = "wildTransparent";
    public static final String UPPERCASE = "upperCase";
    public static final String CHECK_CASE = "checkCase";

    public CrossWord(JClicProject jClicProject) {
        super(jClicProject);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[2];
        this.wildTransparent = false;
        this.upperCase = true;
        this.checkCase = true;
    }

    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 1, -1, true, true, 200, 60);
        this.abc[1] = ActiveBagContent.initNew(3, 1, -1, true, true, 200, 60);
        this.tgc = TextGridContent.initNew(3, 3, 'A');
    }

    public Element getJDomElement() {
        if (this.tgc == null || this.abc[0] == null || this.abc[1] == null) {
            return null;
        }
        Element element = super.getJDomElement();
        element.addContent(this.tgc.getJDomElement());
        element.addContent(this.abc[0].getJDomElement().setAttribute("id", ACROSS_CLUES));
        element.addContent(this.abc[1].getJDomElement().setAttribute("id", DOWN_CLUES));
        Element element2 = new Element("layout");
        element2.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
        if (this.wildTransparent) {
            element2.setAttribute(WILD_TRANSPARENT, JDomUtility.boolString(this.wildTransparent));
        }
        if (!this.upperCase) {
            element2.setAttribute(UPPERCASE, JDomUtility.boolString(this.upperCase));
        }
        if (!this.checkCase) {
            element2.setAttribute(CHECK_CASE, JDomUtility.boolString(this.checkCase));
        }
        element.addContent(element2);
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        Element element2 = element.getChild("textGrid");
        if (element2 == null) {
            throw new IllegalArgumentException("CrossWord without TextGrid");
        }
        this.tgc = TextGridContent.getTextGridContent(element2);
        Iterator iterator = element.getChildren("cells").iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            ActiveBagContent activeBagContent = ActiveBagContent.getActiveBagContent(element2, this.project.mediaBag);
            String string = JDomUtility.getStringAttr(element2, "id", null, false);
            if (ACROSS_CLUES.equals(string)) {
                this.abc[0] = activeBagContent;
                continue;
            }
            if (DOWN_CLUES.equals(string)) {
                this.abc[1] = activeBagContent;
                continue;
            }
            throw new IllegalArgumentException("Unknown clues: " + string);
        }
        if (this.abc[0] == null || this.abc[1] == null) {
            throw new IllegalArgumentException("CrossWord without H or V clues!");
        }
        element2 = element.getChild("layout");
        if (element2 != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(element2, "position", LAYOUT_NAMES, this.boxGridPos);
            this.wildTransparent = JDomUtility.getBoolAttr(element2, WILD_TRANSPARENT, this.wildTransparent);
            this.upperCase = JDomUtility.getBoolAttr(element2, UPPERCASE, this.upperCase);
            this.checkCase = JDomUtility.getBoolAttr(element2, CHECK_CASE, this.checkCase);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.boxGridPos = clic3Activity.graPos;
        this.tgc = new TextGridContent();
        this.tgc.nch = clic3Activity.nctxh;
        this.tgc.ncw = clic3Activity.nctxw;
        this.tgc.w = clic3Activity.txtCW;
        this.tgc.h = clic3Activity.txtCH;
        this.tgc.border = true;
        this.tgc.text = clic3Activity.graTxt;
        this.tgc.bb = clic3Activity.getBoxBase(0);
        for (int i = 0; i < 2; ++i) {
            int n;
            this.abc[i] = new ActiveBagContent(1, 1);
            int n2 = 0;
            for (n = 0; n < clic3Activity.tags[i].length; ++n) {
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(clic3Activity.tags[i][n], ";");
                while (stringTokenizer.hasMoreElements()) {
                    ActiveBoxContent activeBoxContent = this.abc[i].getActiveBoxContent(n2++);
                    clic3Activity.setActiveBoxTextContent(activeBoxContent, stringTokenizer.nextToken());
                    activeBoxContent.id = n;
                    activeBoxContent.item = n3++;
                }
            }
            this.abc[i].bb = clic3Activity.getBoxBase(1);
            this.abc[i].ncw = 1;
            this.abc[i].nch = n;
            this.abc[i].w = 200.0;
            this.abc[i].h = 75.0;
        }
    }

    public int getMinNumActions() {
        return this.tgc == null ? 0 : this.tgc.getNumChars() - this.tgc.countWildChars();
    }

    public boolean helpSolutionAllowed() {
        return false;
    }

    public boolean needsKeyboard() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends Activity.Panel
    implements ActionListener,
    FocusListener {
        TextGrid grid;
        BoxBag bb;
        int advance;
        int numLetters;
        ActiveBox hClue;
        ActiveBox vClue;
        JToggleButton hClueBtn;
        JToggleButton vClueBtn;

        protected Panel(PlayStation playStation) {
            super(playStation);
            this.grid = null;
            this.bb = null;
            this.advance = 0;
            this.numLetters = 0;
            this.addFocusListener(this);
        }

        public void clear() {
            if (this.grid != null) {
                this.grid.end();
                this.grid = null;
            }
            if (this.bb != null) {
                this.bb.end();
                this.bb = null;
            }
        }

        private BoxBag createBoxBag(int n) {
            BoxBag boxBag = new BoxBag(null, this, null);
            SimpleBox simpleBox = new SimpleBox(boxBag, null, null);
            simpleBox.setBounds(0.0, 0.0, 40.0, CrossWord.this.abc[n].h);
            simpleBox.setBorder(true);
            JToggleButton jToggleButton = new JToggleButton(ResourceManager.getImageIcon(n == 0 ? "buttons/textright.png" : "buttons/textdown.png"));
            jToggleButton.addActionListener(this);
            Border border = jToggleButton.getBorder();
            simpleBox.setHostedComponent(jToggleButton);
            jToggleButton.setBorder(border);
            boxBag.addBox(simpleBox);
            ActiveBox activeBox = new ActiveBox(boxBag, null, n, new Rectangle2D.Double(40.0, 0.0, CrossWord.this.abc[n].w, CrossWord.this.abc[n].h), null);
            boxBag.addBox(activeBox);
            boxBag.setBoxBase(CrossWord.this.abc[n].bb);
            if (n == 0) {
                this.hClue = activeBox;
                this.hClueBtn = jToggleButton;
            } else {
                this.vClue = activeBox;
                this.vClueBtn = jToggleButton;
            }
            return boxBag;
        }

        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (CrossWord.this.acp != null && CrossWord.this.abc != null) {
                CrossWord.this.acp.generateContent(new ActiveBagContentKit(0, 0, CrossWord.this.abc, false), this.ps);
            }
            if (CrossWord.this.tgc != null) {
                this.grid = TextGrid.createEmptyGrid(null, this, CrossWord.this.margin, CrossWord.this.margin, CrossWord.this.tgc, CrossWord.this.wildTransparent);
                this.bb = new BoxBag(null, this, null);
                BoxBag boxBag = this.createBoxBag(0);
                BoxBag boxBag2 = this.createBoxBag(1);
                if (CrossWord.this.boxGridPos == 2 || CrossWord.this.boxGridPos == 3) {
                    boxBag2.setLocation(boxBag.getWidth() + (double)CrossWord.this.margin, 0.0);
                } else {
                    boxBag2.setLocation(0.0, boxBag.getHeight() + (double)CrossWord.this.margin);
                }
                this.bb.addBox(boxBag);
                this.bb.addBox(boxBag2);
                this.grid.setVisible(true);
                this.bb.setVisible(true);
                this.invalidate();
            }
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.grid != null) {
                this.grid.setChars(CrossWord.this.tgc.text);
                this.numLetters = CrossWord.this.getMinNumActions();
                this.grid.setCellAttributes(true, true);
                this.grid.setCursorEnabled(true);
                this.setCursorAt(0, 0);
                this.advance = 1;
                this.hClueBtn.setSelected(true);
                this.requestFocus();
                this.playing = true;
            }
        }

        public int getCurrentScore() {
            return this.grid == null ? 0 : this.grid.countCoincidences(CrossWord.this.checkCase);
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
            if (this.grid != null) {
                this.grid.update(graphics2D, rectangle, this);
            }
            if (this.bb != null) {
                this.bb.update(graphics2D, rectangle, this);
            }
        }

        public Dimension setDimension(Dimension dimension) {
            if (this.grid == null || this.bb == null || this.getSize().equals(dimension)) {
                return dimension;
            }
            return BoxBag.layoutDouble(dimension, this.grid, this.bb, CrossWord.this.boxGridPos, CrossWord.this.margin);
        }

        public void processMouse(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (this.playing) {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.grid.contains(point)) {
                            Point point2 = this.grid.getLogicalCoords(point);
                            if (point2 == null) break;
                            this.setCursorAt(point2.x, point2.y);
                            break;
                        }
                        if (this.hClue.contains(point)) {
                            this.hClue.playMedia(this.ps);
                            break;
                        }
                        if (!this.vClue.contains(point)) break;
                        this.vClue.playMedia(this.ps);
                    }
                }
            }
        }

        protected void moveCursor(int n, int n2) {
            if (this.grid != null) {
                this.grid.moveCursor(n, n2, true);
                this.cursorPosChanged();
            }
        }

        protected void setCursorAt(int n, int n2) {
            this.grid.setCursorAt(n, n2, true);
            this.cursorPosChanged();
        }

        protected void cursorPosChanged() {
            Point point;
            Point point2 = this.grid.getCursor();
            if (point2 != null && this.bb != null && (point = this.grid.getItemFor(point2.x, point2.y)) != null) {
                this.hClue.setContent(CrossWord.this.abc[0].getActiveBoxContentWith(point2.y, point.x));
                this.vClue.setContent(CrossWord.this.abc[1].getActiveBoxContentWith(point2.x, point.y));
            }
        }

        public void processKey(KeyEvent keyEvent) {
            if (this.playing && this.grid != null) {
                switch (keyEvent.getID()) {
                    case 400: {
                        Point point = this.grid.getCursor();
                        char c = keyEvent.getKeyChar();
                        if (c < '\u0000' || point == null) break;
                        if (CrossWord.this.upperCase) {
                            c = Character.toUpperCase(c);
                        }
                        this.grid.setCharAt(point.x, point.y, c);
                        boolean bl = this.grid.isCellOk(point.x, point.y, CrossWord.this.checkCase);
                        int n = this.getCurrentScore();
                        new String();
                        this.ps.reportNewAction(this.getActivity(), "WRITE", String.copyValueOf(new char[]{c}), "X:" + point.x + " Y:" + point.y, bl, n);
                        if (n == this.numLetters) {
                            this.grid.setCursorEnabled(false);
                            this.grid.stopCursorBlink();
                            this.finishActivity(true);
                            break;
                        }
                        this.playEvent(1);
                        if (this.advance == 1) {
                            this.moveCursor(1, 0);
                            break;
                        }
                        if (this.advance != 2) break;
                        this.moveCursor(0, 1);
                        break;
                    }
                    case 401: {
                        int n = 0;
                        int n2 = 0;
                        switch (keyEvent.getKeyCode()) {
                            case 39: {
                                n = 1;
                                break;
                            }
                            case 37: {
                                n = -1;
                                break;
                            }
                            case 40: {
                                n2 = 1;
                                break;
                            }
                            case 38: {
                                n2 = -1;
                            }
                        }
                        if (n == 0 && n2 == 0) break;
                        this.moveCursor(n, n2);
                    }
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.playing && this.grid != null) {
                this.grid.startCursorBlink();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.grid != null) {
                this.grid.stopCursorBlink();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.advance = 0;
            if (actionEvent.getSource().equals(this.hClueBtn)) {
                if (this.hClueBtn.isSelected()) {
                    this.advance = 1;
                }
                this.vClueBtn.setSelected(false);
            } else if (actionEvent.getSource().equals(this.vClueBtn)) {
                if (this.vClueBtn.isSelected()) {
                    this.advance = 2;
                }
                this.hClueBtn.setSelected(false);
            }
            this.requestFocus();
        }
    }
}

