/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.input.BuilderErrorHandler;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: SAXBuilder.java,v $ $Revision: 1.89 $ $Date: 2004/09/03 18:24:28 $ $Name: jdom_1_0 $";
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private boolean expand = true;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    private JDOMFactory factory = new DefaultJDOMFactory();
    private boolean ignoringWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);
    private boolean reuseParser = true;
    private XMLReader saxParser = null;

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean bl) {
        this.validate = bl;
    }

    public SAXBuilder(String string) {
        this(string, false);
    }

    public SAXBuilder(String string, boolean bl) {
        this.saxDriverClass = string;
        this.validate = bl;
    }

    public String getDriverClass() {
        return this.saxDriverClass;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public boolean getValidation() {
        return this.validate;
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public ErrorHandler getErrorHandler() {
        return this.saxErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.saxEntityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public DTDHandler getDTDHandler() {
        return this.saxDTDHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.saxDTDHandler = dTDHandler;
    }

    public XMLFilter getXMLFilter() {
        return this.saxXMLFilter;
    }

    public void setXMLFilter(XMLFilter xMLFilter) {
        this.saxXMLFilter = xMLFilter;
    }

    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringWhite = bl;
    }

    public boolean getReuseParser() {
        return this.reuseParser;
    }

    public void setReuseParser(boolean bl) {
        this.reuseParser = bl;
        this.saxParser = null;
    }

    public void setFeature(String string, boolean bl) {
        this.features.put(string, new Boolean(bl));
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Document build(InputSource inputSource) throws JDOMException, IOException {
        SAXHandler sAXHandler = null;
        try {
            Object object;
            sAXHandler = this.createContentHandler();
            this.configureContentHandler(sAXHandler);
            XMLReader xMLReader = this.saxParser;
            if (xMLReader == null) {
                xMLReader = this.createParser();
                if (this.saxXMLFilter != null) {
                    object = this.saxXMLFilter;
                    while (object.getParent() instanceof XMLFilter) {
                        object = (XMLFilter)object.getParent();
                    }
                    object.setParent(xMLReader);
                    xMLReader = this.saxXMLFilter;
                }
                this.configureParser(xMLReader, sAXHandler);
                if (this.reuseParser) {
                    this.saxParser = xMLReader;
                }
            } else {
                this.configureParser(xMLReader, sAXHandler);
            }
            xMLReader.parse(inputSource);
            object = sAXHandler.getDocument();
            return object;
        }
        catch (SAXParseException sAXParseException) {
            String string;
            Document document = sAXHandler.getDocument();
            if (!document.hasRootElement()) {
                document = null;
            }
            if ((string = sAXParseException.getSystemId()) != null) {
                throw new JDOMParseException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, sAXParseException, document);
            }
            throw new JDOMParseException("Error on line " + sAXParseException.getLineNumber(), sAXParseException, document);
        }
        catch (SAXException sAXException) {
            throw new JDOMParseException("Error in building: " + sAXException.getMessage(), sAXException, sAXHandler.getDocument());
        }
        finally {
            sAXHandler = null;
        }
    }

    protected SAXHandler createContentHandler() {
        SAXHandler sAXHandler = new SAXHandler(this.factory);
        return sAXHandler;
    }

    protected void configureContentHandler(SAXHandler sAXHandler) {
        sAXHandler.setExpandEntities(this.expand);
        sAXHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
    }

    protected XMLReader createParser() throws JDOMException {
        XMLReader xMLReader = null;
        if (this.saxDriverClass != null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                this.setFeaturesAndProperties(xMLReader, true);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Could not load " + this.saxDriverClass, sAXException);
            }
        }
        try {
            Class<?> clazz = Class.forName("org.jdom.input.JAXPParserFactory");
            Method method = clazz.getMethod("createParser", Boolean.TYPE, Map.class, Map.class);
            xMLReader = (XMLReader)method.invoke(null, new Boolean(this.validate), this.features, this.properties);
            this.setFeaturesAndProperties(xMLReader, false);
        }
        catch (JDOMException jDOMException) {
            throw jDOMException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xMLReader == null) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_SAX_DRIVER);
                this.saxDriverClass = xMLReader.getClass().getName();
                this.setFeaturesAndProperties(xMLReader, true);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Could not load default SAX parser: org.apache.xerces.parsers.SAXParser", sAXException);
            }
        }
        return xMLReader;
    }

    protected void configureParser(XMLReader xMLReader, SAXHandler sAXHandler) throws JDOMException {
        xMLReader.setContentHandler(sAXHandler);
        if (this.saxEntityResolver != null) {
            xMLReader.setEntityResolver(this.saxEntityResolver);
        }
        if (this.saxDTDHandler != null) {
            xMLReader.setDTDHandler(this.saxDTDHandler);
        } else {
            xMLReader.setDTDHandler(sAXHandler);
        }
        if (this.saxErrorHandler != null) {
            xMLReader.setErrorHandler(this.saxErrorHandler);
        } else {
            xMLReader.setErrorHandler(new BuilderErrorHandler());
        }
        boolean bl = false;
        try {
            xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
            bl = true;
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        if (!bl) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
                bl = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        if (!this.expand) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXHandler);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
    }

    private void setFeaturesAndProperties(XMLReader xMLReader, boolean bl) throws JDOMException {
        String string;
        Iterator iterator = this.features.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            Boolean bl2 = (Boolean)this.features.get(string);
            this.internalSetFeature(xMLReader, string, bl2, string);
        }
        iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.internalSetProperty(xMLReader, string, this.properties.get(string), string);
        }
        if (bl) {
            block9: {
                try {
                    this.internalSetFeature(xMLReader, "http://xml.org/sax/features/validation", this.validate, "Validation");
                }
                catch (JDOMException jDOMException) {
                    if (!this.validate) break block9;
                    throw jDOMException;
                }
            }
            this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespaces", true, "Namespaces");
            this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", true, "Namespace prefixes");
        }
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    private void internalSetFeature(XMLReader xMLReader, String string, boolean bl, String string2) throws JDOMException {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " feature not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " feature not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader xMLReader, String string, Object object, String string2) throws JDOMException {
        try {
            xMLReader.setProperty(string, object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " property not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " property not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public Document build(InputStream inputStream) throws JDOMException, IOException {
        return this.build(new InputSource(inputStream));
    }

    public Document build(File file) throws JDOMException, IOException {
        try {
            URL uRL = SAXBuilder.fileToURL(file);
            return this.build(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JDOMException("Error in building", malformedURLException);
        }
    }

    public Document build(URL uRL) throws JDOMException, IOException {
        String string = uRL.toExternalForm();
        return this.build(new InputSource(string));
    }

    public Document build(InputStream inputStream, String string) throws JDOMException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(Reader reader) throws JDOMException, IOException {
        return this.build(new InputSource(reader));
    }

    public Document build(Reader reader, String string) throws JDOMException, IOException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(String string) throws JDOMException, IOException {
        return this.build(new InputSource(string));
    }

    private static URL fileToURL(File file) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            stringBuffer.append('/');
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            if (c == '#') {
                stringBuffer.append("%23");
                continue;
            }
            if (c == '%') {
                stringBuffer.append("%25");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("%26");
                continue;
            }
            if (c == ';') {
                stringBuffer.append("%3B");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("%3C");
                continue;
            }
            if (c == '=') {
                stringBuffer.append("%3D");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("%3E");
                continue;
            }
            if (c == '?') {
                stringBuffer.append("%3F");
                continue;
            }
            if (c == '~') {
                stringBuffer.append("%7E");
                continue;
            }
            stringBuffer.append(c);
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            stringBuffer.append('/');
        }
        return new URL("file", "", stringBuffer.substring(0));
    }

    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }
}

