/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.ShapeData;
import edu.xtec.jclic.shapers.Shaper;
import edu.xtec.util.JDomUtility;
import org.jdom.Element;

public class JigSaw
extends Shaper {
    protected double baseWidthFactor = this.getDefaultBaseWidthFactor();
    protected double toothHeightFactor = this.getDefaultToothHeightFactor();
    protected boolean randomLines = false;
    protected static final String BASE_WIDTH_FACTOR = "baseWidthFactor";
    protected static final String TOOTH_HEIGHT_FACTOR = "toothHeightFactor";
    protected static final String RANDOM_LINES = "randomLines";

    public JigSaw(int n, int n2) {
        super(n, n2);
    }

    protected int getBaseFactor() {
        return 50;
    }

    public String getEditorPanelClassName() {
        return this.getClass().getPackage().getName() + ".JigSawEditorPanel";
    }

    protected double getDefaultBaseWidthFactor() {
        return 0.3333333432674408;
    }

    protected double getDefaultToothHeightFactor() {
        return 0.1666666716337204;
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        if (this.baseWidthFactor != this.getDefaultBaseWidthFactor()) {
            element.setAttribute(BASE_WIDTH_FACTOR, Double.toString(this.baseWidthFactor));
        }
        if (this.toothHeightFactor != this.getDefaultToothHeightFactor()) {
            element.setAttribute(TOOTH_HEIGHT_FACTOR, Double.toString(this.toothHeightFactor));
        }
        if (this.randomLines) {
            element.setAttribute(RANDOM_LINES, JDomUtility.boolString(this.randomLines));
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        this.initiated = false;
        this.baseWidthFactor = JDomUtility.getDoubleAttr(element, BASE_WIDTH_FACTOR, this.baseWidthFactor);
        this.toothHeightFactor = JDomUtility.getDoubleAttr(element, TOOTH_HEIGHT_FACTOR, this.toothHeightFactor);
        this.randomLines = JDomUtility.getBoolAttr(element, RANDOM_LINES, this.randomLines);
    }

    protected void buildShapes() {
        int[][] nArray = new int[this.nRows + 1][this.nCols + 1];
        int[][] nArray2 = new int[this.nRows + 1][this.nCols + 1];
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                nArray[i][j] = i == 0 ? 0 : 1 + (this.randomLines ? (int)(Math.random() * 9.0) : i + j) % 2;
                nArray2[i][j] = j == 0 ? 0 : 1 + (this.randomLines ? (int)(Math.random() * 9.0) : j + i + 1) % 2;
                if (j == this.nCols - 1) {
                    nArray2[i][j + 1] = 0;
                }
                if (i != this.nRows - 1) continue;
                nArray[i + 1][j] = 0;
            }
        }
        double d = 1.0 / (double)this.nCols;
        double d2 = 1.0 / (double)this.nRows;
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                double d3 = d * (double)j;
                double d4 = d2 * (double)i;
                ShapeData shapeData = this.shapeData[i * this.nCols + j];
                shapeData.moveTo(d3, d4);
                this.hLine(shapeData, nArray[i][j], d3 + 0.0, d4 + 0.0, d, d2, false);
                this.vLine(shapeData, nArray2[i][j + 1], d3 + d, d4 + 0.0, d, d2, false);
                this.hLine(shapeData, nArray[i + 1][j], d3 + d, d4 + d2, d, d2, true);
                this.vLine(shapeData, nArray2[i][j], d3 + 0.0, d4 + d2, d, d2, true);
                shapeData.closePath();
            }
        }
        this.initiated = true;
    }

    protected void hLine(ShapeData shapeData, int n, double d, double d2, double d3, double d4, boolean bl) {
        int n2;
        int n3 = bl ? -1 : 1;
        int n4 = n2 = n == 1 ? 1 : -1;
        if (n == 0) {
            shapeData.lineTo(d + d3 * (double)n3, d2);
        } else {
            double d5 = d + (d3 - d3 * this.baseWidthFactor) / 2.0 * (double)n3;
            double d6 = d3 * this.baseWidthFactor * (double)n3;
            shapeData.lineTo(d5, d2);
            double d7 = d4 * this.toothHeightFactor * (double)n2;
            shapeData.lineTo(d5, d2 + d7);
            shapeData.lineTo(d5 + d6, d2 + d7);
            shapeData.lineTo(d5 + d6, d2);
            shapeData.lineTo(d + d3 * (double)n3, d2);
        }
    }

    protected void vLine(ShapeData shapeData, int n, double d, double d2, double d3, double d4, boolean bl) {
        int n2;
        int n3 = bl ? -1 : 1;
        int n4 = n2 = n == 1 ? 1 : -1;
        if (n == 0) {
            shapeData.lineTo(d, d2 + d4 * (double)n3);
        } else {
            double d5 = d2 + (d4 - d4 * this.baseWidthFactor) / 2.0 * (double)n3;
            double d6 = d4 * this.baseWidthFactor * (double)n3;
            shapeData.lineTo(d, d5);
            double d7 = d3 * this.toothHeightFactor * (double)n2;
            shapeData.lineTo(d + d7, d5);
            shapeData.lineTo(d + d7, d5 + d6);
            shapeData.lineTo(d, d5 + d6);
            shapeData.lineTo(d, d2 + d4 * (double)n3);
        }
    }
}

