/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.edit.EditorTreePanel;
import edu.xtec.jclic.fileSystem.FileBackup;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Gradient;
import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.jclic.project.LibraryManagerElement;
import edu.xtec.jclic.project.ProjectInstaller;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ProgressInputStream;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StreamIO;
import edu.xtec.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectInstallerDlg
extends ExtendedJDialog
implements ProgressInputStream.ProgressInputStreamListener,
ListSelectionListener {
    public ProjectLibrary result;
    public boolean cancel;
    public boolean launchNow;
    public String pathToMainProject;
    Messages msg;
    LibraryManager lm;
    FileSystem storeFileSystem;
    ProjectInstaller pi;
    ProjectLibrary pl;
    LibraryManager.LibraryPane libraryPane;
    EditorTreePanel etp;
    File installDir;
    Options options;
    boolean workerRunning;
    SwingWorker worker;
    boolean copyComplete;
    private Font titleFont;
    private Font mainFont;
    private Font itemFont;
    private Image logo;
    private Gradient logoGp;
    private int currentStage = 0;
    private static final int STAGE_INFO = 0;
    private static final int STAGE_SELECT_LIB = 1;
    private static final int STAGE_COPY_FILES = 2;
    private static final int STAGE_SELECT_FOLDER = 3;
    private static final int STAGE_END = 4;
    private static final int NUM_STAGES = 5;
    private static final String[] STAGE_TITLES = new String[]{"install_title", "install_step_1", "install_step_2", "install_step_3", "install_step_4"};
    private static final String LOGO = "icons/install.png";
    private JButton cancelBtn;
    private JPanel card00;
    private JPanel card01;
    private JPanel card02;
    private JPanel card03;
    private JPanel card04;
    private JLabel cardTitleLb;
    private JLabel destLb;
    private JProgressBar itemProgressBar;
    private JCheckBox launchProjectChk;
    private JPanel libFolderPanel;
    private JPanel logoPanel;
    private JPanel mainPane;
    private JButton nextBtn;
    private JButton prevBtn;
    private JPanel selectLibPanel;
    private JLabel statusLb;

    private ProjectInstallerDlg(Component component, LibraryManager libraryManager, ProjectInstaller projectInstaller) throws Exception {
        super(component, null, true);
        this.lm = libraryManager;
        this.options = libraryManager.settings.rb.getOptions();
        this.msg = this.options.getMessages();
        this.setTitle(this.msg.get("install_title"));
        this.result = null;
        this.launchNow = true;
        this.pathToMainProject = null;
        this.cancel = false;
        this.titleFont = new Font("Dialog", 1, 18);
        this.mainFont = new Font("Dialog", 1, 12);
        this.itemFont = new Font("Dialog", 0, 12);
        this.pi = projectInstaller;
        if (projectInstaller.from == null) {
            throw new Exception("Path to installer data store not specified!");
        }
        this.storeFileSystem = FileSystem.createFileSystem(projectInstaller.from, null, libraryManager.settings.rb);
        this.logo = ResourceManager.getImageIcon(LOGO).getImage();
        this.logoGp = new Gradient(Color.white, Color.blue, 90, 1);
        this.initComponents();
        this.centerOver(component);
        this.getRootPane().setDefaultButton(this.nextBtn);
    }

    public static ProjectInstallerDlg getProjectInstallerDlg(Component component, LibraryManager libraryManager, String string) throws Exception {
        return new ProjectInstallerDlg(component, libraryManager, ProjectInstaller.getProjectInstaller(string));
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.cancelBtn = new JButton();
        this.prevBtn = new JButton();
        this.nextBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.mainPane = new JPanel();
        this.card00 = new JPanel();
        JLabel jLabel = new JLabel();
        JTextArea jTextArea = new JTextArea();
        JTextArea jTextArea2 = new JTextArea();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.card01 = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.selectLibPanel = this.lm.getLibraryPane(true, true);
        this.libraryPane = (LibraryManager.LibraryPane)this.selectLibPanel;
        this.libraryPane.addListSelectionListener(this);
        this.card02 = new JPanel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.destLb = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.statusLb = new JLabel();
        this.itemProgressBar = new JProgressBar();
        this.card03 = new JPanel();
        JLabel jLabel10 = new JLabel();
        this.libFolderPanel = new JPanel();
        this.card04 = new JPanel();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        JLabel jLabel13 = new JLabel();
        this.launchProjectChk = new JCheckBox();
        this.cardTitleLb = new JLabel();
        this.logoPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                Rectangle rectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
                if (ProjectInstallerDlg.this.logoGp != null) {
                    ProjectInstallerDlg.this.logoGp.paint((Graphics2D)graphics, rectangle);
                }
                if (ProjectInstallerDlg.this.logo != null) {
                    int n = (rectangle.width - ProjectInstallerDlg.this.logo.getWidth(this)) / 2;
                    int n2 = (rectangle.height - ProjectInstallerDlg.this.logo.getHeight(this)) / 2;
                    graphics.drawImage(ProjectInstallerDlg.this.logo, n, n2, this);
                }
            }
        };
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProjectInstallerDlg.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        this.cancelBtn.setToolTipText(this.msg.get("wizard_cancel_tooltip"));
        this.cancelBtn.setText(this.msg.get("wizard_cancel"));
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectInstallerDlg.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.cancelBtn, gridBagConstraints);
        this.prevBtn.setToolTipText(this.msg.get("wizard_prev_tooltip"));
        this.prevBtn.setText(this.msg.get("wizard_prev"));
        this.prevBtn.setEnabled(false);
        this.prevBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectInstallerDlg.this.prevBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.prevBtn, gridBagConstraints);
        this.nextBtn.setToolTipText(this.msg.get("wizard_next_tooltip"));
        this.nextBtn.setText(this.msg.get("wizard_next"));
        this.nextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectInstallerDlg.this.nextBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)this.nextBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(500, 300));
        this.mainPane.setLayout(new CardLayout());
        this.mainPane.setBackground(new Color(255, 255, 204));
        this.card00.setLayout(new GridBagLayout());
        this.card00.setOpaque(false);
        jLabel.setFont(this.mainFont);
        jLabel.setText(this.msg.get("install_info_info"));
        jLabel.setPreferredSize(new Dimension(300, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card00.add((Component)jLabel, gridBagConstraints);
        jTextArea.setEditable(false);
        jTextArea.setFont(this.mainFont);
        jTextArea.setLineWrap(true);
        jTextArea.setText("\"" + this.pi.projectTitle + "\"");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.card00.add((Component)jTextArea, gridBagConstraints);
        jTextArea2.setEditable(false);
        jTextArea2.setFont(this.itemFont);
        jTextArea2.setLineWrap(true);
        jTextArea2.setText(this.pi.authors != null ? this.pi.authors : "");
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.card00.add((Component)jTextArea2, gridBagConstraints);
        jLabel2.setText(this.msg.get("install_info_from"));
        jLabel2.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(12, 3, 3, 3);
        this.card00.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText(this.storeFileSystem.getFullRoot());
        jLabel3.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.card00.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText(this.msg.get("wizard_info"));
        jLabel4.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 3, 3, 3);
        this.card00.add((Component)jLabel4, gridBagConstraints);
        this.mainPane.add((Component)this.card00, "card00");
        this.card01.setLayout(new GridBagLayout());
        this.card01.setOpaque(false);
        jLabel5.setText(this.msg.get("install_select_library"));
        jLabel5.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card01.add((Component)jLabel5, gridBagConstraints);
        this.selectLibPanel.setBorder(new TitledBorder(this.msg.get("library_caption")));
        this.selectLibPanel.setPreferredSize(new Dimension(300, 200));
        this.selectLibPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card01.add((Component)this.selectLibPanel, gridBagConstraints);
        this.mainPane.add((Component)this.card01, "card01");
        this.card02.setLayout(new GridBagLayout());
        this.card02.setPreferredSize(new Dimension(400, 300));
        this.card02.setOpaque(false);
        jLabel6.setText(this.msg.get("install_source"));
        jLabel6.setFont(this.mainFont);
        jLabel6.setLabelFor(jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setText(this.storeFileSystem.getFullRoot());
        jLabel7.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)jLabel7, gridBagConstraints);
        jLabel8.setText(this.msg.get("install_dest"));
        jLabel8.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)jLabel8, gridBagConstraints);
        this.destLb.setText(this.pi.baseFolder);
        this.destLb.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)this.destLb, gridBagConstraints);
        jLabel9.setText(this.msg.get("install_status"));
        jLabel9.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 6, 3);
        this.card02.add((Component)jLabel9, gridBagConstraints);
        this.statusLb.setText(this.msg.get("install_msg_waiting"));
        this.statusLb.setFont(this.itemFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 3, 6, 3);
        this.card02.add((Component)this.statusLb, gridBagConstraints);
        this.itemProgressBar.setToolTipText(this.msg.get("install_progress_tooltip"));
        this.itemProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card02.add((Component)this.itemProgressBar, gridBagConstraints);
        this.mainPane.add((Component)this.card02, "card02");
        this.card03.setLayout(new GridBagLayout());
        this.card03.setOpaque(false);
        jLabel10.setText(this.msg.get("install_select_folder"));
        jLabel10.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card03.add((Component)jLabel10, gridBagConstraints);
        this.libFolderPanel.setLayout(new BorderLayout());
        this.libFolderPanel.setBorder(new TitledBorder(this.msg.get("install_library_folders")));
        this.libFolderPanel.setPreferredSize(new Dimension(300, 200));
        this.libFolderPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.card03.add((Component)this.libFolderPanel, gridBagConstraints);
        this.mainPane.add((Component)this.card03, "card03");
        this.card04.setLayout(new GridBagLayout());
        this.card04.setOpaque(false);
        jLabel11.setText(this.msg.get("install_success_1"));
        jLabel11.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 13, 3);
        this.card04.add((Component)jLabel11, gridBagConstraints);
        jLabel12.setText(this.msg.get("install_success_2"));
        jLabel12.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.card04.add((Component)jLabel12, gridBagConstraints);
        jLabel13.setText(this.msg.get("install_success_3"));
        jLabel13.setFont(this.mainFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.card04.add((Component)jLabel13, gridBagConstraints);
        this.launchProjectChk.setSelected(true);
        this.launchProjectChk.setText(this.msg.get("install_launchProject"));
        this.launchProjectChk.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(13, 3, 3, 3);
        this.card04.add((Component)this.launchProjectChk, gridBagConstraints);
        this.mainPane.add((Component)this.card04, "card04");
        jPanel2.add((Component)this.mainPane, "Center");
        this.cardTitleLb.setText(this.msg.get("install_title"));
        this.cardTitleLb.setForeground(new Color(255, 255, 255));
        this.cardTitleLb.setBackground(new Color(255, 153, 51));
        this.cardTitleLb.setFont(new Font("SansSerif", 1, 18));
        this.cardTitleLb.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardTitleLb.setOpaque(true);
        jPanel2.add((Component)this.cardTitleLb, "North");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.logoPanel.setPreferredSize(new Dimension(75, 230));
        this.getContentPane().add((Component)this.logoPanel, "West");
        this.pack();
    }

    private void nextBtnActionPerformed(ActionEvent actionEvent) {
        if (this.currentStage != 2 || this.copyComplete) {
            this.goToStage(this.currentStage + 1);
        }
    }

    private void goToStage(int n) {
        if (n >= 0 && n <= 5) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            this.currentStage = n;
            switch (this.currentStage) {
                case 0: {
                    bl = true;
                    bl2 = false;
                    bl3 = true;
                    break;
                }
                case 1: {
                    bl = this.libraryPane.getCurrentSelected() != null;
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 2: {
                    this.initCopyStage();
                    this.copyFiles();
                    bl2 = false;
                    bl = false;
                    bl3 = true;
                    break;
                }
                case 3: {
                    bl = this.etp != null && this.etp.currentItem != null && this.etp.currentItem instanceof MenuEditor;
                    bl2 = false;
                    bl3 = true;
                    break;
                }
                case 4: {
                    this.initEndStage();
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    break;
                }
                case 5: {
                    this.result = this.pl;
                    this.launchNow = this.launchProjectChk.isSelected();
                    this.closeDialog(null);
                    return;
                }
            }
            StringBuffer stringBuffer = new StringBuffer("wizard_").append(this.currentStage < 4 ? "next" : "finish");
            this.nextBtn.setText(this.msg.get(stringBuffer.substring(0)));
            this.nextBtn.setToolTipText(this.msg.get(stringBuffer.append("_tooltip").substring(0)));
            this.nextBtn.setEnabled(bl);
            this.prevBtn.setEnabled(bl2);
            this.cancelBtn.setEnabled(bl3);
            if (this.currentStage < 5) {
                CardLayout cardLayout = (CardLayout)this.mainPane.getLayout();
                String string = Integer.toString(n);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                cardLayout.show(this.mainPane, "card" + string);
                this.cardTitleLb.setText(this.msg.get(STAGE_TITLES[n]));
            }
        }
    }

    private void initCopyStage() {
        LibraryManagerElement libraryManagerElement = this.libraryPane.getCurrentSelected();
        if (this.pl == null || !this.pl.getFullPath().equals(libraryManagerElement.path)) {
            try {
                this.pl = ProjectLibrary.loadProjectLibrary(libraryManagerElement.path, this.lm.settings.rb);
                if (this.etp != null) {
                    this.libFolderPanel.remove(this.etp);
                }
                this.etp = new EditorTreePanel(this.pl.getEditor(null), this.options, true, Menu.class){

                    protected void currentItemChanged() {
                        if (ProjectInstallerDlg.this.currentStage == 3) {
                            ProjectInstallerDlg.this.nextBtn.setEnabled(this.currentItem != null && this.currentItem instanceof MenuEditor);
                        }
                        super.currentItemChanged();
                    }
                };
                this.etp.getTree().setSelectionRow(1);
                this.libFolderPanel.add((Component)this.etp, "Center");
                this.card03.revalidate();
                File file = new File(this.pl.getFileSystem().getFullRoot());
                this.installDir = new File(file, this.pi.baseFolder);
                this.destLb.setText(this.installDir.getAbsolutePath());
            }
            catch (Exception exception) {
                this.msg.showErrorWarning(this, "library_error_reading", exception);
                this.closeDialog(null);
            }
        }
    }

    private void initEndStage() {
        try {
            Menu menu = ((MenuEditor)this.etp.currentItem).getMenu();
            for (int i = 0; i < this.pi.iconItems.size() && !this.cancel; ++i) {
                ProjectInstaller.IconItem iconItem = (ProjectInstaller.IconItem)this.pi.iconItems.get(i);
                MenuElement menuElement = new MenuElement();
                menuElement.caption = iconItem.text;
                menuElement.projectPath = this.pi.baseFolder + File.separator + iconItem.project;
                menuElement.icon = iconItem.icon != null ? (!iconItem.icon.startsWith("@") ? this.pi.baseFolder + File.separator + iconItem.icon : iconItem.icon) : "@ico00.png";
                if (iconItem.description != null) {
                    menuElement.description = iconItem.description;
                }
                menu.addMenuElement(menuElement);
                if (this.pathToMainProject != null) continue;
                this.pathToMainProject = this.pl.getFileSystem().getFullFileNamePath(menuElement.projectPath);
            }
            this.pl.activityBag.addActivity(menu);
            this.pl.save(null);
            this.launchProjectChk.setEnabled(this.pathToMainProject != null);
        }
        catch (Exception exception) {
            this.msg.showErrorWarning(this, "library_error_creating_icons", exception);
            this.closeDialog(null);
        }
    }

    private void prevBtnActionPerformed(ActionEvent actionEvent) {
        this.goToStage(this.currentStage - 1);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null && !listSelectionEvent.getValueIsAdjusting() && this.currentStage == 1) {
            this.nextBtn.setEnabled(this.libraryPane.getCurrentSelected() != null);
        }
    }

    private void copyFiles() {
        final ProjectInstallerDlg projectInstallerDlg = this;
        this.prevBtn.setEnabled(false);
        this.nextBtn.setEnabled(false);
        this.statusLb.setText(this.msg.get("install_msg_waiting"));
        this.worker = new SwingWorker(){

            public Object construct() {
                String string;
                ProjectInstallerDlg.this.workerRunning = true;
                Vector<FileBackup> vector = new Vector<FileBackup>();
                Exception exception = null;
                String string2 = FileSystem.stdFn(ProjectInstallerDlg.this.storeFileSystem.getFullFileNamePath(null));
                if (string2.equalsIgnoreCase(string = FileSystem.stdFn(ProjectInstallerDlg.this.installDir.getAbsolutePath()))) {
                    ProjectInstallerDlg.this.itemProgressBar.setValue(ProjectInstallerDlg.this.itemProgressBar.getMaximum());
                    ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_toSourceFolder"));
                } else {
                    try {
                        if (ProjectInstallerDlg.this.msg.confirmOverwriteFile(projectInstallerDlg, ProjectInstallerDlg.this.installDir, "yn") != 1) {
                            return "PAUSED";
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        for (int i = 0; i < ProjectInstallerDlg.this.pi.files.size() && !ProjectInstallerDlg.this.cancel; ++i) {
                            String string3 = ProjectInstallerDlg.this.pi.getFile(i).replace('/', File.separatorChar);
                            File file = new File(ProjectInstallerDlg.this.installDir, string3);
                            ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_copying") + " " + string3);
                            if (file.exists()) {
                                if (bl2) continue;
                                if (!bl) {
                                    boolean bl3 = false;
                                    switch (ProjectInstallerDlg.this.msg.confirmOverwriteFile(projectInstallerDlg, file, "yYnNc")) {
                                        case 6: {
                                            bl = true;
                                        }
                                        case 1: {
                                            break;
                                        }
                                        case 7: {
                                            bl2 = true;
                                        }
                                        case 3: {
                                            bl3 = true;
                                            break;
                                        }
                                        default: {
                                            ProjectInstallerDlg.this.cancel = true;
                                        }
                                    }
                                    if (bl3) continue;
                                    if (ProjectInstallerDlg.this.cancel) break;
                                }
                            }
                            InputStream inputStream = ProjectInstallerDlg.this.storeFileSystem.getInputStream(ProjectInstallerDlg.this.pi.getFile(i));
                            ProgressInputStream progressInputStream = null;
                            progressInputStream = inputStream instanceof ProgressInputStream ? (ProgressInputStream)inputStream : new ProgressInputStream(inputStream, -1, string3);
                            progressInputStream.addProgressInputStreamListener(projectInstallerDlg);
                            vector.add(new FileBackup(file));
                            StreamIO.writeStreamTo(progressInputStream, new FileOutputStream(file));
                        }
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                    if (!vector.isEmpty()) {
                        ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_cleanup"));
                        for (int i = vector.size() - 1; i >= 0; --i) {
                            FileBackup fileBackup = (FileBackup)vector.get(i);
                            if (ProjectInstallerDlg.this.cancel || exception != null) {
                                try {
                                    fileBackup.rollback();
                                }
                                catch (Exception exception3) {
                                    ProjectInstallerDlg.this.msg.showErrorWarning((Component)projectInstallerDlg, "FILE_ERR_RESTORING", fileBackup.getFile().getAbsolutePath(), exception3, null);
                                }
                                continue;
                            }
                            try {
                                fileBackup.cleanup();
                                continue;
                            }
                            catch (Exception exception4) {
                                ProjectInstallerDlg.this.msg.showErrorWarning((Component)projectInstallerDlg, "FILE_ERR_DELETING", fileBackup.getBackup().getAbsolutePath(), exception4, null);
                            }
                        }
                    }
                }
                ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_end"));
                if (exception != null) {
                    return exception;
                }
                return ProjectInstallerDlg.this.cancel ? "CANCEL" : "OK";
            }

            public void finished() {
                Object object = this.get();
                ProjectInstallerDlg.this.workerRunning = false;
                ProjectInstallerDlg.this.worker = null;
                if (object != null) {
                    if (ProjectInstallerDlg.this.cancel) {
                        ProjectInstallerDlg.this.msg.showAlert((Component)projectInstallerDlg, "install_msg_cancel");
                        ProjectInstallerDlg.this.closeDialog(null);
                    } else if (object instanceof Exception) {
                        ProjectInstallerDlg.this.msg.showErrorWarning(projectInstallerDlg, "install_error", (Exception)object);
                        ProjectInstallerDlg.this.closeDialog(null);
                    } else if (object.equals("PAUSED")) {
                        ProjectInstallerDlg.this.statusLb.setText(ProjectInstallerDlg.this.msg.get("install_msg_waiting"));
                        ProjectInstallerDlg.this.prevBtn.setEnabled(true);
                        ProjectInstallerDlg.this.nextBtn.setEnabled(true);
                    } else if (object.equals("OK")) {
                        ProjectInstallerDlg.this.nextBtn.setEnabled(true);
                        ProjectInstallerDlg.this.copyComplete = true;
                        ProjectInstallerDlg.this.nextBtnActionPerformed(null);
                    }
                }
            }
        };
        this.worker.start();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.cancel = true;
        StreamIO.setCancel(true);
        if (!this.workerRunning) {
            this.msg.showAlert((Component)this, "install_msg_cancel");
            this.closeDialog(null);
        } else {
            this.worker.interrupt();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void setProgressMax(int n) {
        this.itemProgressBar.setMaximum(n);
    }

    public void setProgressValue(int n) {
        this.itemProgressBar.setValue(n);
    }

    public void startProgress(String string) {
        this.itemProgressBar.setValue(0);
    }

    public void endProgress() {
    }
}

