/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Evaluator;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import org.jdom.Element;

public class BasicEvaluator
extends Evaluator {
    public static final String CHECK_CASE = "checkCase";
    public static final String CHECK_ACCENTS = "checkAccents";
    public static final String CHECK_PUNCTUATION = "checkPunctuation";
    public static final String CHECK_DOUBLE_SPACES = "checkDoubleSpaces";
    public static final String PUNCTUATION = ".,;:";
    protected boolean checkCase = false;
    protected boolean checkAccents = true;
    protected boolean checkPunctuation = true;
    protected boolean checkDoubleSpaces = false;
    int strength;

    public BasicEvaluator(JClicProject jClicProject) {
        super(jClicProject);
        this.init();
    }

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        if (this.checkCase) {
            element.setAttribute(CHECK_CASE, JDomUtility.boolString(this.checkCase));
        }
        if (!this.checkAccents) {
            element.setAttribute(CHECK_ACCENTS, JDomUtility.boolString(this.checkAccents));
        }
        if (!this.checkPunctuation) {
            element.setAttribute(CHECK_PUNCTUATION, JDomUtility.boolString(this.checkPunctuation));
        }
        if (this.checkDoubleSpaces) {
            element.setAttribute(CHECK_DOUBLE_SPACES, JDomUtility.boolString(this.checkDoubleSpaces));
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        this.checkCase = JDomUtility.getBoolAttr(element, CHECK_CASE, false);
        this.checkAccents = JDomUtility.getBoolAttr(element, CHECK_ACCENTS, true);
        this.checkPunctuation = JDomUtility.getBoolAttr(element, CHECK_PUNCTUATION, true);
        this.checkDoubleSpaces = JDomUtility.getBoolAttr(element, CHECK_DOUBLE_SPACES, false);
    }

    public void setProperties(Clic3Activity clic3Activity) {
        this.checkCase = clic3Activity.avMaj;
        this.checkAccents = clic3Activity.avAcc;
        this.checkPunctuation = clic3Activity.avPunt;
        this.checkDoubleSpaces = clic3Activity.avDblSpc;
    }

    protected void init() {
        super.init();
        this.strength = this.checkAccents ? (this.checkCase ? 2 : 1) : 0;
        this.collator.setStrength(this.strength);
    }

    public boolean checkText(String string, String string2) {
        return this.collator.equals(this.getClearedText(string), this.getClearedText(string2));
    }

    public byte[] evalText(String string, String[] stringArray) {
        byte[] byArray = new byte[string.length()];
        boolean bl = this.checkText(string, stringArray);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = bl ? (byte)0 : 1;
        }
        return byArray;
    }

    protected String getClearedText(String string) {
        return this.getClearedText(string, null);
    }

    protected String getClearedText(String string, boolean[] blArray) {
        if (blArray == null) {
            blArray = new boolean[string.length()];
        }
        for (int i = 0; i < string.length(); ++i) {
            blArray[i] = false;
        }
        if (this.checkPunctuation && this.checkDoubleSpaces) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (PUNCTUATION.indexOf(c) >= 0 && !this.checkPunctuation) {
                if (!bl) {
                    stringBuffer.append(' ');
                } else {
                    blArray[i] = true;
                }
                bl = true;
                continue;
            }
            if (c == ' ') {
                if (this.checkDoubleSpaces || !bl) {
                    stringBuffer.append(c);
                } else {
                    blArray[i] = true;
                }
                bl = true;
                continue;
            }
            bl = false;
            stringBuffer.append(c);
        }
        return stringBuffer.substring(0);
    }
}

