/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.accessibility;

import edu.xtec.jclic.accessibility.FressaFunctions;
import edu.xtec.util.Options;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TFormKeyboard
extends JFrame {
    JPanel panelPlaphoons;
    public static final int CELLS_X = 15;
    public static final int CELLS_Y = 5;
    public static final int DEFAULT_POS_X = 100;
    public static final int DEFAULT_POS_Y = 100;
    public static final int DEFAULT_WIDTH = 445;
    public static final int DEFAULT_HEIGHT = 160;
    public static final float FONT_SIZE_INCREMENT = 4.0f;
    int cellWidth;
    int cellHeight;
    JLabel[][] keys = new JLabel[15][5];
    boolean[][] full = new boolean[15][5];
    int frameBorder = 1;
    int frameSpan;
    int span = this.frameSpan = 2;
    boolean isShiftLock = false;
    boolean isShift = false;
    int iIsShift;
    int nIsShift;
    boolean isHorizontalScanning = false;
    int xPos = 0;
    int yPos = 0;
    FressaFunctions fressa;
    Font font;
    Font boldFont;

    public TFormKeyboard(Options options, FressaFunctions fressaFunctions) {
        this.fressa = fressaFunctions;
        this.setResizable(true);
        this.setLocation(100, 100);
        this.setTitle(options.getMsg("acc_keyboardTitle"));
        this.setDefaultCloseOperation(2);
        this.panelPlaphoons = new JPanel();
        this.panelPlaphoons.setBackground(Color.white);
        this.panelPlaphoons.setBorder(BorderFactory.createBevelBorder(1));
        this.add((Component)this.panelPlaphoons, "Center");
        this.panelPlaphoons.setLayout(null);
        this.setSize(445, 160);
        this.font = new JLabel().getFont();
        this.font = this.font.deriveFont(this.font.getSize2D() + 4.0f);
        this.boldFont = this.font.deriveFont(1);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    TFormKeyboard.this.plafonsOnClick(mouseEvent);
                }
            }
        };
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.full[i][j] = false;
                this.keys[i][j] = new JLabel();
                if (i > 0) {
                    this.keys[i][j].setBorder(BorderFactory.createLineBorder(Color.black, this.frameBorder));
                }
                this.keys[i][j].setHorizontalAlignment(0);
                this.keys[i][j].setFont(this.font);
                this.panelPlaphoons.add(this.keys[i][j]);
                this.keys[i][j].addMouseListener(mouseAdapter);
            }
        }
        this.lowercase();
        this.setAlwaysOnTop(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, dimension.height - dimension2.height);
        this.calcFrameSize();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TFormKeyboard.this.calcFrameSize();
            }
        });
    }

    void sendKey(int n) {
        if (this.fressa.robot != null) {
            this.fressa.robot.keyPress(n);
            this.fressa.robot.keyRelease(n);
        }
        this.isShiftFalse();
    }

    void sendShiftKey(int n) {
        if (this.fressa.robot != null) {
            this.fressa.robot.keyPress(16);
            this.fressa.robot.keyPress(n);
            this.fressa.robot.keyRelease(n);
            this.fressa.robot.keyRelease(16);
        }
        this.isShiftFalse();
    }

    void isShiftFalse() {
        if (this.isShift) {
            this.isShift = false;
            this.keys[this.iIsShift][this.nIsShift].setForeground(Color.black);
            if (this.isShiftLock) {
                this.uppercase();
            } else {
                this.lowercase();
            }
        }
    }

    public void changeScanningPosition() {
        if (this.isHorizontalScanning) {
            ++this.xPos;
            if (this.xPos >= 15) {
                this.isHorizontalScanning = false;
                this.xPos = 0;
                this.yPos = 0;
            } else {
                while (this.keys[this.xPos][this.yPos].getText().equals("") && !this.full[this.xPos][this.yPos]) {
                    ++this.xPos;
                    if (this.xPos < 15) continue;
                    this.isHorizontalScanning = false;
                    this.xPos = 0;
                    this.yPos = 0;
                    break;
                }
            }
        } else {
            this.yPos = (this.yPos + 1) % 5;
        }
        int n = this.keys[this.xPos][this.yPos].getLocationOnScreen().x + this.cellWidth / 2;
        int n2 = this.keys[this.xPos][this.yPos].getLocationOnScreen().y + this.cellHeight / 2;
        this.mouseMove(n, n2);
        if (this.fressa.readLabels && !this.keys[this.xPos][this.yPos].getText().equals("")) {
            this.fressa.readText(this.keys[this.xPos][this.yPos].getText());
        }
    }

    public void doClick() {
        if (this.fressa.robot != null) {
            this.fressa.robot.mousePress(16);
            this.fressa.robot.mouseRelease(16);
        }
    }

    public void mouseMove(int n, int n2) {
        if (this.fressa.robot != null) {
            this.fressa.robot.mouseMove(n, n2);
        }
    }

    public void plafonsOnClick(MouseEvent mouseEvent) {
        int n = -1;
        int n2 = -1;
        if (this.fressa.actPanel == null) {
            return;
        }
        this.fressa.actPanel.requestFocus();
        int n3 = 0;
        int n4 = 10;
        while (!this.fressa.actPanel.hasFocus() && ++n3 <= n4) {
            try {
                Thread.currentThread();
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Error while waiting to transfer focus. " + interruptedException.getMessage());
                break;
            }
        }
        if (!this.fressa.actPanel.hasFocus()) {
            System.err.println("Accessible keyboard: Error transferring focus!");
            return;
        }
        block3: for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!mouseEvent.getComponent().equals(this.keys[i][j])) continue;
                n = i;
                n2 = j;
                continue block3;
            }
        }
        if (n == -1 && n2 == -1) {
            return;
        }
        this.fressa.mustDisableScanTimer = true;
        if (n == 0) {
            this.isHorizontalScanning = true;
            this.xPos = 0;
            this.changeScanningPosition();
            return;
        }
        this.isHorizontalScanning = false;
        this.xPos = 0;
        this.yPos = -1;
        if (n2 == 0 && n == 14) {
            this.sendKey(8);
        } else if (this.keys[n][n2].getText().equals("tab")) {
            if (this.isShift) {
                this.sendShiftKey(9);
            } else {
                this.sendKey(9);
            }
        } else if ((n2 == 1 || n2 == 2) && n == 14 || n2 == 0 && n == 1) {
            this.sendKey(10);
        } else if (n2 == 4 && n == 1) {
            this.sendKey(32);
        } else if (n2 == 4 && n == 2) {
            this.sendKey(127);
        } else if (n2 == 4 && n == 3) {
            this.sendKey(37);
        } else if (n2 == 4 && n == 4) {
            this.sendKey(39);
        } else if (n2 == 4 && n == 5) {
            this.sendKey(40);
        } else if (n2 == 4 && n == 6) {
            this.sendKey(38);
        } else if (!this.keys[n][n2].getText().equals("\u00ba")) {
            if (this.keys[n][n2].getText().equals("1")) {
                this.sendKey(49);
            } else if (this.keys[n][n2].getText().equals("2")) {
                this.sendKey(50);
            } else if (this.keys[n][n2].getText().equals("3")) {
                this.sendKey(51);
            } else if (this.keys[n][n2].getText().equals("4")) {
                this.sendKey(52);
            } else if (this.keys[n][n2].getText().equals("5")) {
                this.sendKey(53);
            } else if (this.keys[n][n2].getText().equals("6")) {
                this.sendKey(54);
            } else if (this.keys[n][n2].getText().equals("7")) {
                this.sendKey(55);
            } else if (this.keys[n][n2].getText().equals("8")) {
                this.sendKey(56);
            } else if (this.keys[n][n2].getText().equals("9")) {
                this.sendKey(57);
            } else if (this.keys[n][n2].getText().equals("0")) {
                this.sendKey(48);
            } else if (this.keys[n][n2].getText().equals("'")) {
                this.sendKey(222);
            } else if (this.keys[n][n2].getText().equals("\u00a1")) {
                this.sendKey(518);
            } else if (this.keys[n][n2].getText().equals("`")) {
                this.sendKey(128);
            } else if (this.keys[n][n2].getText().equals("+")) {
                this.sendKey(521);
            } else if (this.keys[n][n2].getText().equals("\u00f1")) {
                if (this.fressa.robot != null) {
                    this.fressa.robot.keyPress(18);
                    this.fressa.robot.keyPress(97);
                    this.fressa.robot.keyRelease(97);
                    this.fressa.robot.keyPress(102);
                    this.fressa.robot.keyRelease(102);
                    this.fressa.robot.keyPress(100);
                    this.fressa.robot.keyRelease(100);
                    this.fressa.robot.keyRelease(18);
                }
                this.isShiftFalse();
            } else if (this.keys[n][n2].getText().equals("\u00b4")) {
                this.sendKey(129);
            } else if (this.keys[n][n2].getText().equals("\u00e7")) {
                if (this.fressa.robot != null) {
                    this.fressa.robot.keyPress(18);
                    this.fressa.robot.keyPress(97);
                    this.fressa.robot.keyRelease(97);
                    this.fressa.robot.keyPress(99);
                    this.fressa.robot.keyRelease(99);
                    this.fressa.robot.keyPress(101);
                    this.fressa.robot.keyRelease(101);
                    this.fressa.robot.keyRelease(18);
                }
                this.isShiftFalse();
            } else if (this.keys[n][n2].getText().equals(",")) {
                this.sendKey(44);
            } else if (this.keys[n][n2].getText().equals(".")) {
                this.sendKey(this.keys[n][n2].getText().codePointAt(0));
            } else if (this.keys[n][n2].getText().equals("-")) {
                this.sendKey(45);
            } else if (this.keys[n][n2].getText().equals("<")) {
                this.sendKey(153);
            } else if (!this.keys[n][n2].getText().equals("\u00aa")) {
                if (this.keys[n][n2].getText().equals("!")) {
                    this.sendShiftKey(49);
                } else if (this.keys[n][n2].getText().equals("\"")) {
                    this.sendShiftKey(50);
                } else if (this.keys[n][n2].getText().equals("\u00b7")) {
                    this.sendShiftKey(51);
                } else if (this.keys[n][n2].getText().equals("$")) {
                    this.sendShiftKey(52);
                } else if (this.keys[n][n2].getText().equals("%")) {
                    this.sendShiftKey(53);
                } else if (this.keys[n][n2].getText().equals("&")) {
                    this.sendShiftKey(54);
                } else if (this.keys[n][n2].getText().equals("/")) {
                    this.sendKey(111);
                } else if (this.keys[n][n2].getText().equals("(")) {
                    this.sendShiftKey(56);
                } else if (this.keys[n][n2].getText().equals(")")) {
                    this.sendShiftKey(57);
                } else if (this.keys[n][n2].getText().equals("=")) {
                    this.sendShiftKey(48);
                } else if (this.keys[n][n2].getText().equals("?")) {
                    this.sendShiftKey(222);
                } else if (this.keys[n][n2].getText().equals("\u00bf")) {
                    this.sendShiftKey(518);
                } else if (this.keys[n][n2].getText().equals("^")) {
                    this.sendShiftKey(128);
                } else if (this.keys[n][n2].getText().equals("*")) {
                    this.sendShiftKey(521);
                } else if (this.keys[n][n2].getText().equals("\u00a8")) {
                    this.sendShiftKey(129);
                } else if (this.keys[n][n2].getText().equals("\u00c7")) {
                    if (this.fressa.robot != null) {
                        this.fressa.robot.keyPress(18);
                        this.fressa.robot.keyPress(97);
                        this.fressa.robot.keyRelease(97);
                        this.fressa.robot.keyPress(98);
                        this.fressa.robot.keyRelease(98);
                        this.fressa.robot.keyPress(104);
                        this.fressa.robot.keyRelease(104);
                        this.fressa.robot.keyRelease(18);
                    }
                    this.isShiftFalse();
                } else if (this.keys[n][n2].getText().equals("\u00d1")) {
                    if (this.fressa.robot != null) {
                        this.fressa.robot.keyPress(18);
                        this.fressa.robot.keyPress(97);
                        this.fressa.robot.keyRelease(97);
                        this.fressa.robot.keyPress(102);
                        this.fressa.robot.keyRelease(102);
                        this.fressa.robot.keyPress(101);
                        this.fressa.robot.keyRelease(101);
                        this.fressa.robot.keyRelease(18);
                    }
                    this.isShiftFalse();
                } else if (this.keys[n][n2].getText().equals(">")) {
                    this.sendShiftKey(153);
                } else if (this.keys[n][n2].getText().equals(";")) {
                    this.sendShiftKey(44);
                } else if (this.keys[n][n2].getText().equals(":")) {
                    this.sendShiftKey(".".codePointAt(0));
                } else if (this.keys[n][n2].getText().equals("_")) {
                    this.sendShiftKey(45);
                } else if (this.keys[n][n2].getText().equals("co")) {
                    if (this.fressa.robot != null && this.fressa.actPanelRectangleMiddleBottom != null) {
                        this.mouseMove(this.fressa.actPanelRectangleMiddleBottom.x, this.fressa.actPanelRectangleMiddleBottom.y);
                        this.doClick();
                    }
                } else if (this.keys[n][n2].getText().equals("<>")) {
                    this.fressa.currentZone = 0;
                    this.fressa.place = 0;
                } else if (this.keys[n][n2].getText().equals("BM")) {
                    boolean bl = this.isShiftLock = !this.isShiftLock;
                    if (this.isShift) {
                        this.isShift = false;
                        this.keys[this.iIsShift][this.nIsShift].setForeground(new Color(0, 0, 0));
                    }
                    if (this.isShiftLock) {
                        this.uppercase();
                        this.keys[n][n2].setForeground(new Color(127, 127, 127));
                    } else {
                        this.lowercase();
                        this.keys[n][n2].setForeground(new Color(0, 0, 0));
                    }
                } else if (this.keys[n][n2].getText().equals("shi")) {
                    this.isShift = !this.isShift;
                    this.iIsShift = n;
                    this.nIsShift = n2;
                    if (this.isShift) {
                        if (this.isShiftLock) {
                            this.lowercase();
                        } else {
                            this.uppercase();
                        }
                        this.keys[n][n2].setForeground(new Color(127, 127, 127));
                    } else {
                        if (this.isShiftLock) {
                            this.uppercase();
                        } else {
                            this.lowercase();
                        }
                        this.keys[n][n2].setForeground(new Color(0, 0, 0));
                    }
                } else if (!this.keys[n][n2].getText().equals("")) {
                    if (!this.keys[n][n2].getText().equals(this.keys[n][n2].getText().toUpperCase())) {
                        this.sendKey(this.keys[n][n2].getText().toUpperCase().codePointAt(0));
                    } else {
                        this.sendShiftKey(this.keys[n][n2].getText().toUpperCase().codePointAt(0));
                    }
                }
            }
        }
        this.fressa.mustDisableScanTimer = false;
    }

    public void calcFrameSize() {
        this.cellWidth = this.panelPlaphoons.getWidth() / 15;
        this.cellHeight = this.panelPlaphoons.getHeight() / 5;
        this.span = this.frameBorder + this.frameSpan;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.keys[i][j].setVisible(false);
                this.keys[i][j].setBounds(this.frameSpan + this.cellWidth * i, this.frameSpan + this.cellHeight * j, this.cellWidth - this.frameSpan, this.cellHeight - this.frameSpan);
                this.keys[i][j].setVisible(true);
            }
        }
    }

    void lowercase() {
        int n = 1;
        int n2 = 0;
        this.keys[n][n2].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("1");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("2");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("3");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("4");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("5");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("6");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("7");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("8");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("9");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("0");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("'");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00a1");
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("bacspace.gif")));
        this.full[n][n2] = true;
        ++n;
        n = 1;
        this.keys[n][++n2].setText("tab");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("q");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("w");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("e");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("r");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("t");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("y");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("u");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("i");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("o");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("p");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("`");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("+");
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[n][n2] = true;
        ++n;
        n = 1;
        this.keys[n][++n2].setText("BM");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("a");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("s");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("d");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("f");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("g");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("h");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("j");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("k");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("l");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00f1");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00b4");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00e7");
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[n][n2] = true;
        ++n;
        n = 1;
        this.keys[n][++n2].setText("shi");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("<");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("z");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("x");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("c");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("v");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("b");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("n");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("m");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText(",");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText(".");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("-");
        this.full[n][n2] = true;
        ++n;
        ++n;
        n = 1;
        this.keys[n][++n2].setIcon(new ImageIcon(this.getClass().getResource("espai.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("delete.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("esquerra.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("dreta.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("baixa.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("puja.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("<>");
        this.full[n][n2] = true;
        Font font = this.keys[n][n2].getFont();
        this.keys[n][n2].setFont(new Font(font.getFontName(), 1, font.getSize()));
        this.keys[++n][n2].setText("co");
        this.full[n][n2] = true;
        font = this.keys[n][n2].getFont();
        this.keys[n][n2].setFont(new Font(font.getFontName(), 1, font.getSize()));
        this.keys[++n][n2].setText("");
        font = this.keys[n][n2].getFont();
        this.keys[n][n2].setFont(new Font(font.getFontName(), 1, font.getSize()));
        ++n;
    }

    void uppercase() {
        int n = 1;
        int n2 = 0;
        this.keys[n][n2].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("!");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\"");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00b7");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("$");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("%");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("&");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("/");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("(");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText(")");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("=");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("?");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00bf");
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("bacspace.gif")));
        this.full[n][n2] = true;
        ++n;
        n = 1;
        this.keys[n][++n2].setText("tab");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("Q");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("W");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("E");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("R");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("T");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("Y");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("U");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("I");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("O");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("P");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("^");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("*");
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[n][n2] = true;
        ++n;
        n = 1;
        this.keys[n][++n2].setText("BM");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("A");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("S");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("D");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("F");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("G");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("H");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("J");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("K");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("L");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00d1");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00a8");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("\u00c7");
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("return.gif")));
        this.full[n][n2] = true;
        ++n;
        n = 1;
        this.keys[n][++n2].setText("shi");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText(">");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("Z");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("X");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("C");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("V");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("B");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("N");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("M");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText(";");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText(":");
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("_");
        this.full[n][n2] = true;
        ++n;
        ++n;
        n = 1;
        this.keys[n][++n2].setIcon(new ImageIcon(this.getClass().getResource("espai.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("delete.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("esquerra.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("dreta.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("baixa.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setIcon(new ImageIcon(this.getClass().getResource("puja.gif")));
        this.full[n][n2] = true;
        this.keys[++n][n2].setText("<>");
        this.full[n][n2] = true;
        Font font = this.keys[n][n2].getFont();
        this.keys[n][n2].setFont(this.boldFont);
        this.keys[++n][n2].setText("co");
        this.full[n][n2] = true;
        font = this.keys[n][n2].getFont();
        this.keys[n][n2].setFont(this.boldFont);
        this.keys[++n][n2].setText("");
        font = this.keys[n][n2].getFont();
        this.keys[n][n2].setFont(this.boldFont);
        ++n;
    }
}

