' Copyright (C) 2013 Intergraph Security, Government & Infrastructure
' File:           Setup.vbs
' Purpose:        This is a wrapper VB script checks for .NET Framework install
'                 status prior to starting the Intergraph Setup Manager.  
'                 If .NET Framework found missing this script first starts 
'                 .NET Framework installer and then automatically proceed to
'                 the Intergraph Setup Manager.
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
option explicit
main()
const E_MISSINGFILE = "Error: Missing file: "
const I_CANCELED_BY_USER = "-2147023673"
const DOT_NET_REG_KEY_INSTALL_VALUE_NAME = "HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full\Install"
const DOT_NET_REG_KEY_VERSION_VALUE_NAME = "HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full\Version"
const DOT_NET_VER = "4.0"
const DOT_NET_INSTALLER = "dotNetFx40_Full_x86_x64.exe"
const SETUP_MANAGER = "Setup.exe"

dim m_oShell, m_oExec, m_oFS

Sub main()
  Err.Clear
  On Error Resume Next
  Dim iInstall, sCmdLine, sVer, bVer
  
  Set m_oShell = CreateObject("Wscript.Shell")
  Set m_oFS = CreateObject("Scripting.FileSystemObject")
  bVer = false

  iInstall = m_oShell.RegRead(DOT_NET_REG_KEY_INSTALL_VALUE_NAME)
  sVer = m_oShell.RegRead(DOT_NET_REG_KEY_VERSION_VALUE_NAME)

  sVer = Left(sVer,3)
  If CLng(sVer) >= CLng(DOT_NET_VER) Then
    bVer = true
  End If 

  If (Err <> 0 or iInstall <> 1 or bVer = false) Then
    Err.Clear
    sCmdLine = m_oShell.CurrentDirectory & "\" & DOT_NET_INSTALLER
    RunCmdLine sCmdLine, true : CheckError
  End If 

  sCmdLine = m_oShell.CurrentDirectory & "\" & SETUP_MANAGER
  RunCmdLine sCmdLine, false : CheckError

End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub RunCmdLine(sCmdLine, bWait)

  If m_oFS.FileExists(sCmdLine) Then
    sCmdLine = Chr(34) & sCmdLine & Chr(34)
    m_oShell.Run sCmdLine, 1, bWait
  Else
    Fail E_MISSINGFILE & sCmdLine
  End If
End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub CheckError
  Dim message, errRec
  If Err = 0 Then Exit Sub
  If Err = CLng(I_CANCELED_BY_USER) Then Wscript.Quit
  message = Err.Source & " " & Hex(Err) & ": " & Err.Description 
  Fail message
End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub Fail(message)
  Log message
  Wscript.Quit -1
End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub Log (message)
  m_oShell.LogEvent 4, message
  Wscript.Echo message
End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'' SIG '' Begin signature block
'' SIG '' MIIZYQYJKoZIhvcNAQcCoIIZUjCCGU4CAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFBJ0XURhkWz+
'' SIG '' 4O92QNiWXM/ge72poIIUWzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFsDCCBJigAwIBAgIQH/H8APNGIVhjawKV
'' SIG '' XzsPQjANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
'' SIG '' VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
'' SIG '' dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
'' SIG '' VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
'' SIG '' MCBDQTAeFw0xMzAxMjkwMDAwMDBaFw0xNDAyMjgyMzU5
'' SIG '' NTlaMIHzMQswCQYDVQQGEwJVUzEQMA4GA1UECBMHQWxh
'' SIG '' YmFtYTETMBEGA1UEBxMKSHVudHN2aWxsZTEfMB0GA1UE
'' SIG '' ChQWSW50ZXJncmFwaCBDb3Jwb3JhdGlvbjE+MDwGA1UE
'' SIG '' CxM1RGlnaXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0
'' SIG '' IFNvZnR3YXJlIFZhbGlkYXRpb24gdjIxOzA5BgNVBAsU
'' SIG '' MkludGVyZ3JhcGggU2VjdXJpdHksIEdvdmVybm1lbnQg
'' SIG '' YW5kIEluZnJhc3RydWN0dXJlMR8wHQYDVQQDFBZJbnRl
'' SIG '' cmdyYXBoIENvcnBvcmF0aW9uMIIBIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAQ8AMIIBCgKCAQEApK37wdZp0B9tc/HWkNXI
'' SIG '' sWk0zPLdxDgw/3bOklW+ruBsPIDPxGUw/5EK/M5q+dH+
'' SIG '' WrhZzL3EfGN4PXUcsLCUea+gsvgt0WlGoPpC8uYMXTGJ
'' SIG '' gQwKjnRUb9LAvx20vKZ2L6W+5/HBlH7LYVWv5ZDu7izG
'' SIG '' dJE5aXnAbZHXd9+8nlxJj+38iVOoMMdLVFPTiTjoNJh5
'' SIG '' ipvOnyAniuZBnZmfdC7xP4YxBEkya1bouem1Y2cFGeBm
'' SIG '' phiuk1aIlA6+NKIY30L7Jz/yEVkf2dWvUihIzCGG5z35
'' SIG '' uUvk4ep9EUS+k0DA335jLkn3B+ufpAp75hp8dBaWNa93
'' SIG '' WKOw6FpJ22Wj8wIDAQABo4IBezCCAXcwCQYDVR0TBAIw
'' SIG '' ADAOBgNVHQ8BAf8EBAMCB4AwQAYDVR0fBDkwNzA1oDOg
'' SIG '' MYYvaHR0cDovL2NzYzMtMjAxMC1jcmwudmVyaXNpZ24u
'' SIG '' Y29tL0NTQzMtMjAxMC5jcmwwRAYDVR0gBD0wOzA5Bgtg
'' SIG '' hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
'' SIG '' L3d3dy52ZXJpc2lnbi5jb20vcnBhMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMDMHEGCCsGAQUFBwEBBGUwYzAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29tMDsG
'' SIG '' CCsGAQUFBzAChi9odHRwOi8vY3NjMy0yMDEwLWFpYS52
'' SIG '' ZXJpc2lnbi5jb20vQ1NDMy0yMDEwLmNlcjAfBgNVHSME
'' SIG '' GDAWgBTPmanqeyb0S8mOj9fwBSbv49KnnTARBglghkgB
'' SIG '' hvhCAQEEBAMCBBAwFgYKKwYBBAGCNwIBGwQIMAYBAQAB
'' SIG '' Af8wDQYJKoZIhvcNAQEFBQADggEBADR7SJXaOSGYcy/L
'' SIG '' YNwlJrHWZLVn4qIkPxsFAcqR+rQShOZGdE0QgpgTV0mX
'' SIG '' c2vofS4k1qWCyj+vaz2964SRjaF3XJUueHtNuHT5fywe
'' SIG '' 8wuOi2fYXDdTYrwo6RPzTsRs4CUEaa0ZkIY7b7CZrSfu
'' SIG '' u3F1EpLaWpdjQHB+RxL8VZyo70oXp2TXVsKoDRGfNXMa
'' SIG '' oJfXJp2wmQHZ1LjzIc4P6qWhl7Lp2Yz2hRE/F49q0ve8
'' SIG '' g6tTrhk8ne1PjmKbOFghaSlbFFc0/LH0RE1IArR1uqJO
'' SIG '' gRAwIlF3Ous7W9FqTn5NpwhSNmEO6x7sy8IfYXFzMv1q
'' SIG '' E9pW3KM5RRbAca8cA5EwggYKMIIE8qADAgECAhBSAOWq
'' SIG '' JVb8GobtlsnUSzPHMA0GCSqGSIb3DQEBBQUAMIHKMQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
'' SIG '' Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
'' SIG '' cmsxOjA4BgNVBAsTMShjKSAyMDA2IFZlcmlTaWduLCBJ
'' SIG '' bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBD
'' SIG '' BgNVBAMTPFZlcmlTaWduIENsYXNzIDMgUHVibGljIFBy
'' SIG '' aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBH
'' SIG '' NTAeFw0xMDAyMDgwMDAwMDBaFw0yMDAyMDcyMzU5NTla
'' SIG '' MIG0MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
'' SIG '' Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
'' SIG '' IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
'' SIG '' dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
'' SIG '' KTEwMS4wLAYDVQQDEyVWZXJpU2lnbiBDbGFzcyAzIENv
'' SIG '' ZGUgU2lnbmluZyAyMDEwIENBMIIBIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAQ8AMIIBCgKCAQEA9SNLXqXXirsy6dRX9+/k
'' SIG '' xyZ+rRmY/qidfZT2NmsQ13WBMH8EaH/LK3UezR0IjN9p
'' SIG '' lKc3o5x7gOCZ4e43TV/OOxTuhtTQ9Sc1vCULOKeMY50X
'' SIG '' owilq7D7zWpigkzVIdob2fHjhDuKKk+FW5ABT8mndhB/
'' SIG '' JwN8vq5+fcHd+QW8G0icaefApDw8QQA+35blxeSUcdZV
'' SIG '' AccAJkpAPLWhJqkMp22AjpAle8+/PxzrL5b65Yd3xrVW
'' SIG '' sno7VDBTG99iNP8e0fRakyiF5UwXTn5b/aSTmX/fze+k
'' SIG '' de/vFfZH5/gZctguNBqmtKdMfr27Tww9V/Ew1qY2jtaA
'' SIG '' dtcZLqXNfjQtiQIDAQABo4IB/jCCAfowEgYDVR0TAQH/
'' SIG '' BAgwBgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUB
'' SIG '' BxcDMFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZl
'' SIG '' cmlzaWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0
'' SIG '' cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8B
'' SIG '' Af8EBAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcw
'' SIG '' VRYJaW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoas
'' SIG '' jY5rw8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVy
'' SIG '' aXNpZ24uY29tL3ZzbG9nby5naWYwNAYDVR0fBC0wKzAp
'' SIG '' oCegJYYjaHR0cDovL2NybC52ZXJpc2lnbi5jb20vcGNh
'' SIG '' My1nNS5jcmwwNAYIKwYBBQUHAQEEKDAmMCQGCCsGAQUF
'' SIG '' BzABhhhodHRwOi8vb2NzcC52ZXJpc2lnbi5jb20wHQYD
'' SIG '' VR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMDMCgGA1Ud
'' SIG '' EQQhMB+kHTAbMRkwFwYDVQQDExBWZXJpU2lnbk1QS0kt
'' SIG '' Mi04MB0GA1UdDgQWBBTPmanqeyb0S8mOj9fwBSbv49Kn
'' SIG '' nTAfBgNVHSMEGDAWgBR/02Wnwt3su/AwCfNDOfoCrzMx
'' SIG '' MzANBgkqhkiG9w0BAQUFAAOCAQEAViLmNKTEYctIuQGt
'' SIG '' VqhkD9mMkcS7zAzlrXqgIn/fRzhKLWzRf3EafOxwqbHw
'' SIG '' T+QPDFP6FV7+dJhJJIWBJhyRFEewTGOMu6E01MZF6A2F
'' SIG '' JnMD0KmMZG3ccZLmRQVgFVlROfxYFGv+1KTteWsIDEFy
'' SIG '' 5zciBgm+I+k/RJoe6WGdzLGQXPw90o2sQj1lNtS0PUAo
'' SIG '' j5sQzyMmzEsgy5AfXYxMNMo82OU31m+lIL006ybZrg3n
'' SIG '' xZr3obQhkTNvhuhYuyV8dA5Y/nUbYz/OMXybjxuWnsVT
'' SIG '' doRbnK2R+qztk7pdyCFTwoJTY68SDVCHERs9VFKWiiyc
'' SIG '' PZIaCJoFLseTpUiR0zGCBHIwggRuAgEBMIHJMIG0MQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIElu
'' SIG '' Yy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
'' SIG '' cmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRw
'' SIG '' czovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTEwMS4w
'' SIG '' LAYDVQQDEyVWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2ln
'' SIG '' bmluZyAyMDEwIENBAhAf8fwA80YhWGNrApVfOw9CMAkG
'' SIG '' BSsOAwIaBQCgcDAQBgorBgEEAYI3AgEMMQIwADAZBgkq
'' SIG '' hkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3
'' SIG '' AgELMQ4wDAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQx
'' SIG '' FgQUYB7HMzd8BNC6OU4Qz+SS5T/66OowDQYJKoZIhvcN
'' SIG '' AQEBBQAEggEAl4P2GqfUBcwq522GFF0Y3WS/9/PrTwpX
'' SIG '' Hg1XrgBngN1qdaIyAUoUuloT1aCiNGwiVEY30BvH7388
'' SIG '' CRdHtIN6SJTaN3zGMXXGv/PRn+iD+qN3kyETOAzZYGkc
'' SIG '' GP506L1mkN9o44wbYtdyKRvTcixo8N32y/kB613t3C4M
'' SIG '' p+1uJhUNdPSZ684TjHnnW4Q6rkcUsPmMAi6/MyFDuC0X
'' SIG '' mBxme4RPcmAXw9QLR04KZaGDG/8i6rr8rNfkxAh54g8e
'' SIG '' NE8JqHjGMecNzqiyI3+x+V0DXXf91OT99W1oOGqt+TqE
'' SIG '' nQNOK6FY5KyfpEhj4L7mmmnmIcQYtoI9Soufjge5WsHs
'' SIG '' paGCAgswggIHBgkqhkiG9w0BCQYxggH4MIIB9AIBATBy
'' SIG '' MF4xCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEwMC4GA1UEAxMnU3ltYW50ZWMg
'' SIG '' VGltZSBTdGFtcGluZyBTZXJ2aWNlcyBDQSAtIEcyAhAO
'' SIG '' z/Q4yP6/NW4E2GqYGxpQMAkGBSsOAwIaBQCgXTAYBgkq
'' SIG '' hkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJ
'' SIG '' BTEPFw0xMzA3MDgxMzI0NDhaMCMGCSqGSIb3DQEJBDEW
'' SIG '' BBQ7XFmkzOQTXKgJsn4eNa1QxsSMhDANBgkqhkiG9w0B
'' SIG '' AQEFAASCAQAjnlJ3fRcFgA+ZMoQHhgKGON3Xf5PCNurL
'' SIG '' BE2msikVQJenhwbo/jENfATXlJQGNNDPT5Q40WJcZi48
'' SIG '' r4q87Mkpd2RWEtzIkBa4gaPPBZHtP08KlMMln8ZiFazV
'' SIG '' rRuDGuaKEOUHHZ54ySTgH9p7OfrSFp24KgIzrpIrXs7E
'' SIG '' xFZg6qWQcXUz2qQE6D8ATh0lRd+C2con3mfQ8wYHb6v/
'' SIG '' 40uF7WAq+HRQocr+lsi1HAJZGMcOqZefZdFvKJ1ZjVXD
'' SIG '' ENOMO5G3WQca1EM2uYzvRhezKZOGzaKW6oe7NhwDVc/+
'' SIG '' ZxerTCbf0CaXyBQbfNVBcjvKRNp0EtRmsghk50BPOsJw
'' SIG '' End signature block
