//////////////////////////
// Common stuff

uniform sampler2D BorderSampler;
uniform vec4   Color;
uniform float  Width;
uniform float  PixelSize;

vec4 CalcColor(float d)
{
	vec2 borderTc = vec2(0.0, 1.0 + d/Width);
	vec4 tex = texture2D(BorderSampler, borderTc) * Color * vec4(2, 2, 2, 1);
	vec4 InsideColor = Color;
	
	d = -d; // Invert, so that d is the depth into the body
	
	if (d < Width*0.5) // Outside-fade
		return vec4(tex.rgb, tex.a * smoothstep(-PixelSize, PixelSize, d));
	else // Inside fade
		return mix(tex, InsideColor, smoothstep(-PixelSize, PixelSize, d-Width));
}

//////////////////////////

uniform sampler2D DistSampler;
uniform float DistScale;

void main()
{
	vec2 tc = gl_TexCoord[0].st;
	float d = texture2D(DistSampler, tc).a;
	d = (d*2.0 - 1.0) * DistScale;	
	gl_FragColor = CalcColor(d);
}
